/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsDependencyCollection;
import com.android.tools.idea.gradle.structure.model.PsJarDependency;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsLibraryKey;
import com.android.tools.idea.gradle.structure.model.PsLibraryKeyKt;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsModuleDependency;
import com.google.common.collect.LinkedListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\b\b\u0003\u0010\u0007*\u00020\b2\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\tB\u000f\u0012\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00030\u001a2\u0006\u0010\"\u001a\u00020\u0015H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00020\u001a2\u0006\u0010$\u001a\u00020\u0015H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00010\u001a2\u0006\u0010&\u001a\u00020\u0015H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020(H\u0016J \u0010%\u001a\b\u0012\u0004\u0012\u00028\u00010\u001a2\b\u0010,\u001a\u0004\u0018\u00010\u00152\u0006\u0010-\u001a\u00020\u0015H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00010\u001a2\u0006\u0010.\u001a\u00020\u0012H\u0016J\u0015\u0010/\u001a\u00020(2\u0006\u0010)\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u00100J\u0015\u00101\u001a\u00020(2\u0006\u0010)\u001a\u00028\u0002H\u0004\u00a2\u0006\u0002\u00102J\u0015\u00103\u001a\u00020(2\u0006\u0010)\u001a\u00028\u0003H\u0004\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u00020(H\u0004J\u0006\u00106\u001a\u00020(R\u0016\u0010\n\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR*\u0010\u0010\u001a\u001e\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00018\u00018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00150\u0015\u0012\f\u0012\n \u0013*\u0004\u0018\u00018\u00028\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00150\u0015\u0012\f\u0012\n \u0013*\u0004\u0018\u00018\u00038\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00010\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00030\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001c\u00a8\u00067"}, d2={"Lcom/android/tools/idea/gradle/structure/model/PsDependencyCollectionBase;", "ModuleT", "Lcom/android/tools/idea/gradle/structure/model/PsModule;", "LibraryDependencyT", "Lcom/android/tools/idea/gradle/structure/model/PsLibraryDependency;", "JarDependencyT", "Lcom/android/tools/idea/gradle/structure/model/PsJarDependency;", "ModuleDependencyT", "Lcom/android/tools/idea/gradle/structure/model/PsModuleDependency;", "Lcom/android/tools/idea/gradle/structure/model/PsDependencyCollection;", "parent", "<init>", "(Lcom/android/tools/idea/gradle/structure/model/PsModule;)V", "getParent", "()Lcom/android/tools/idea/gradle/structure/model/PsModule;", "Lcom/android/tools/idea/gradle/structure/model/PsModule;", "libraryDependenciesBySpec", "Lcom/google/common/collect/LinkedListMultimap;", "Lcom/android/tools/idea/gradle/structure/model/PsLibraryKey;", "kotlin.jvm.PlatformType", "jarDependenciesByPath", "", "moduleDependenciesByGradlePath", "isEmpty", "", "libraries", "", "getLibraries", "()Ljava/util/List;", "jars", "getJars", "modules", "getModules", "findModuleDependencies", "gradlePath", "findJarDependencies", "filePath", "findLibraryDependencies", "compactNotation", "onDependencyAdded", "", "dependency", "Lcom/android/tools/idea/gradle/structure/model/PsBaseDependency;", "onCleared", "group", "name", "libraryKey", "addLibraryDependency", "(Lcom/android/tools/idea/gradle/structure/model/PsLibraryDependency;)V", "addJarDependency", "(Lcom/android/tools/idea/gradle/structure/model/PsJarDependency;)V", "addModuleDependency", "(Lcom/android/tools/idea/gradle/structure/model/PsModuleDependency;)V", "clear", "reindex", "intellij.android.projectSystem.gradle.psd"})
@SourceDebugExtension(value={"SMAP\nPsDependencyCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsDependencyCollection.kt\ncom/android/tools/idea/gradle/structure/model/PsDependencyCollectionBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n774#2:253\n865#2,2:254\n1863#2,2:256\n1863#2,2:258\n1863#2,2:260\n*S KotlinDebug\n*F\n+ 1 PsDependencyCollection.kt\ncom/android/tools/idea/gradle/structure/model/PsDependencyCollectionBase\n*L\n80#1:253\n80#1:254,2\n121#1:256,2\n124#1:258,2\n127#1:260,2\n*E\n"})
public abstract class PsDependencyCollectionBase<ModuleT extends PsModule, LibraryDependencyT extends PsLibraryDependency, JarDependencyT extends PsJarDependency, ModuleDependencyT extends PsModuleDependency>
implements PsDependencyCollection<ModuleT, LibraryDependencyT, JarDependencyT, ModuleDependencyT> {
    @NotNull
    private final ModuleT parent;
    @NotNull
    private final LinkedListMultimap<PsLibraryKey, LibraryDependencyT> libraryDependenciesBySpec;
    @NotNull
    private final LinkedListMultimap<String, JarDependencyT> jarDependenciesByPath;
    @NotNull
    private final LinkedListMultimap<String, ModuleDependencyT> moduleDependenciesByGradlePath;

    public PsDependencyCollectionBase(@NotNull ModuleT parent) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        this.parent = parent;
        LinkedListMultimap linkedListMultimap = LinkedListMultimap.create();
        Intrinsics.checkNotNull((Object)linkedListMultimap);
        this.libraryDependenciesBySpec = linkedListMultimap;
        LinkedListMultimap linkedListMultimap2 = LinkedListMultimap.create();
        Intrinsics.checkNotNull((Object)linkedListMultimap2);
        this.jarDependenciesByPath = linkedListMultimap2;
        LinkedListMultimap linkedListMultimap3 = LinkedListMultimap.create();
        Intrinsics.checkNotNull((Object)linkedListMultimap3);
        this.moduleDependenciesByGradlePath = linkedListMultimap3;
    }

    @Override
    @NotNull
    public ModuleT getParent() {
        return this.parent;
    }

    @Override
    public boolean isEmpty() {
        return this.moduleDependenciesByGradlePath.isEmpty() && this.libraryDependenciesBySpec.isEmpty() && this.jarDependenciesByPath.isEmpty();
    }

    @Override
    @NotNull
    public List<LibraryDependencyT> getLibraries() {
        List list = this.libraryDependenciesBySpec.values();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"values(...)");
        return list;
    }

    @Override
    @NotNull
    public List<JarDependencyT> getJars() {
        List list = this.jarDependenciesByPath.values();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"values(...)");
        return list;
    }

    @Override
    @NotNull
    public List<ModuleDependencyT> getModules() {
        List list = this.moduleDependenciesByGradlePath.values();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"values(...)");
        return list;
    }

    @Override
    @NotNull
    public List<ModuleDependencyT> findModuleDependencies(@NotNull String gradlePath) {
        Intrinsics.checkNotNullParameter((Object)gradlePath, (String)"gradlePath");
        List list = this.moduleDependenciesByGradlePath.get((Object)gradlePath);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"get(...)");
        return CollectionsKt.toList((Iterable)list);
    }

    @Override
    @NotNull
    public List<JarDependencyT> findJarDependencies(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        List list = this.jarDependenciesByPath.get((Object)filePath);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"get(...)");
        return CollectionsKt.toList((Iterable)list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LibraryDependencyT> findLibraryDependencies(@NotNull String compactNotation) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)compactNotation, (String)"compactNotation");
        PsArtifactDependencySpec psArtifactDependencySpec = PsArtifactDependencySpec.Companion.create(compactNotation);
        if (psArtifactDependencySpec == null) {
            return CollectionsKt.emptyList();
        }
        PsArtifactDependencySpec spec = psArtifactDependencySpec;
        String string = spec.getGroup();
        if (string == null) {
            string = "";
        }
        List list = this.libraryDependenciesBySpec.get((Object)new PsLibraryKey(string, spec.getName()));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"get(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsLibraryDependency it = (PsLibraryDependency)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getSpec(), (Object)spec)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    public void onDependencyAdded(@NotNull PsBaseDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
    }

    public void onCleared() {
    }

    @Override
    @NotNull
    public List<LibraryDependencyT> findLibraryDependencies(@Nullable String group2, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String string = group2;
        if (string == null) {
            string = "";
        }
        List list = this.libraryDependenciesBySpec.get((Object)new PsLibraryKey(string, name2));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"get(...)");
        return CollectionsKt.toList((Iterable)list);
    }

    @Override
    @NotNull
    public List<LibraryDependencyT> findLibraryDependencies(@NotNull PsLibraryKey libraryKey) {
        Intrinsics.checkNotNullParameter((Object)libraryKey, (String)"libraryKey");
        List list = this.libraryDependenciesBySpec.get((Object)libraryKey);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"get(...)");
        return CollectionsKt.toList((Iterable)list);
    }

    protected final void addLibraryDependency(@NotNull LibraryDependencyT dependency) {
        Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
        this.libraryDependenciesBySpec.put((Object)PsLibraryKeyKt.toLibraryKey(dependency.getSpec()), dependency);
        this.onDependencyAdded((PsBaseDependency)dependency);
    }

    protected final void addJarDependency(@NotNull JarDependencyT dependency) {
        Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
        this.jarDependenciesByPath.put((Object)dependency.getFilePath(), dependency);
        this.onDependencyAdded((PsBaseDependency)dependency);
    }

    protected final void addModuleDependency(@NotNull ModuleDependencyT dependency) {
        Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
        this.moduleDependenciesByGradlePath.put((Object)dependency.getGradlePath(), dependency);
        this.onDependencyAdded((PsBaseDependency)dependency);
    }

    protected final void clear() {
        this.libraryDependenciesBySpec.clear();
        this.moduleDependenciesByGradlePath.clear();
        this.jarDependenciesByPath.clear();
        this.onCleared();
    }

    public final void reindex() {
        PsBaseDependency it;
        List list = this.libraryDependenciesBySpec.values();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"values(...)");
        List libraryDependencies = CollectionsKt.toList((Iterable)list);
        List list2 = this.jarDependenciesByPath.values();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"values(...)");
        List jarDependencies = CollectionsKt.toList((Iterable)list2);
        List list3 = this.moduleDependenciesByGradlePath.values();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"values(...)");
        List moduleDependencies = CollectionsKt.toList((Iterable)list3);
        this.libraryDependenciesBySpec.clear();
        Iterable $this$forEach$iv = libraryDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PsLibraryDependency)element$iv;
            boolean bl = false;
            this.libraryDependenciesBySpec.put((Object)PsLibraryKeyKt.toLibraryKey(it.getSpec()), (Object)it);
        }
        this.jarDependenciesByPath.clear();
        $this$forEach$iv = jarDependencies;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PsJarDependency)element$iv;
            boolean bl = false;
            this.jarDependenciesByPath.put((Object)it.getFilePath(), (Object)it);
        }
        this.moduleDependenciesByGradlePath.clear();
        $this$forEach$iv = moduleDependencies;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PsModuleDependency)element$iv;
            boolean bl = false;
            this.moduleDependenciesByGradlePath.put((Object)it.getGradlePath(), (Object)it);
        }
    }

    @Override
    @NotNull
    public List<PsBaseDependency> getItems() {
        return PsDependencyCollection.super.getItems();
    }

    @Override
    public void forEachModuleDependency(@NotNull Function1<? super ModuleDependencyT, Unit> consumer2) {
        PsDependencyCollection.super.forEachModuleDependency(consumer2);
    }

    @Override
    public void forEachLibraryDependency(@NotNull Function1<? super LibraryDependencyT, Unit> consumer2) {
        PsDependencyCollection.super.forEachLibraryDependency(consumer2);
    }

    @Override
    public void forEachJarDependency(@NotNull Function1<? super JarDependencyT, Unit> consumer2) {
        PsDependencyCollection.super.forEachJarDependency(consumer2);
    }
}

