/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.util.PropertiesFiles;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0006\u0010\u0015\u001a\u00020\u0016J,\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001e\u001a\u00020\u001aH\u0002R*\u0010\n\u001a\u0004\u0018\u00010\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u00038F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u0005R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/gradle/util/GradleConfigProperties;", "", "projectFolderPath", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "externalProjectSettings", "Lcom/intellij/openapi/externalSystem/settings/ExternalProjectSettings;", "(Lcom/intellij/openapi/externalSystem/settings/ExternalProjectSettings;)V", "value", "javaHome", "getJavaHome", "()Ljava/io/File;", "setJavaHome", "propertiesFilePath", "getPropertiesFilePath", "isJavaHomeModified", "", "properties", "Ljava/util/Properties;", "Lorg/jetbrains/annotations/NotNull;", "save", "", "setPathIfApplicable", "pathModified", "propertyName", "", "currentPath", "newPath", "getPath", "property", "intellij.android.projectSystem.gradle"})
public final class GradleConfigProperties {
    @Nullable
    private File javaHome;
    @NotNull
    private final File propertiesFilePath;
    private boolean isJavaHomeModified;
    @NotNull
    private final Properties properties;

    public GradleConfigProperties(@NotNull File projectFolderPath) {
        Intrinsics.checkNotNullParameter((Object)projectFolderPath, (String)"projectFolderPath");
        String[] stringArray = new String[]{"config.properties"};
        this.propertiesFilePath = FilesKt.resolve((File)projectFolderPath, (String)((Object)Paths.get(".gradle", stringArray)).toString());
        Properties properties = PropertiesFiles.getProperties(this.propertiesFilePath);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getProperties(...)");
        this.properties = properties;
    }

    public GradleConfigProperties(@NotNull ExternalProjectSettings externalProjectSettings) {
        Intrinsics.checkNotNullParameter((Object)externalProjectSettings, (String)"externalProjectSettings");
        this(new File(externalProjectSettings.getExternalProjectPath()));
    }

    @Nullable
    public final File getJavaHome() {
        return this.isJavaHomeModified ? this.javaHome : this.getPath("java.home");
    }

    public final void setJavaHome(@Nullable File value2) {
        this.isJavaHomeModified = true;
        this.javaHome = value2;
    }

    @NotNull
    public final File getPropertiesFilePath() {
        return this.propertiesFilePath;
    }

    public final void save() {
        this.setPathIfApplicable(this.isJavaHomeModified, "java.home", this.getPath("java.home"), this.getJavaHome());
        if (this.isJavaHomeModified) {
            PropertiesFiles.savePropertiesToFile(this.properties, this.propertiesFilePath, null);
        }
        this.setJavaHome(null);
        this.isJavaHomeModified = false;
    }

    private final void setPathIfApplicable(boolean pathModified, String propertyName, File currentPath, File newPath) {
        if (pathModified && !FileUtil.filesEqual((File)currentPath, (File)newPath)) {
            File file = newPath;
            Object object = (file != null ? file.getPath() : null) != null ? this.properties.setProperty(propertyName, newPath.getPath()) : this.properties.remove(propertyName);
        }
    }

    private final File getPath(String property2) {
        String string = this.properties.getProperty(property2);
        if (string == null) {
            return null;
        }
        String path = string;
        return new File(path);
    }
}

