/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncListenerWithRoot;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.conflict.ConflictSetKt;
import com.android.tools.idea.gradle.variant.view.AbiItem;
import com.android.tools.idea.gradle.variant.view.BuildVariantItem;
import com.android.tools.idea.gradle.variant.view.BuildVariantTableModel;
import com.android.tools.idea.gradle.variant.view.BuildVariantTableRow;
import com.android.tools.idea.gradle.variant.view.BuildVariantUpdater;
import com.android.tools.idea.projectsystem.gradle.AndroidIconProviderProjectGradleToken;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;

public class BuildVariantView {
    private static final int MODULE_COLUMN_INDEX = 0;
    private static final int VARIANT_COLUMN_INDEX = 1;
    private static final int ABI_COLUMN_INDEX = 2;
    public static final Color CONFLICT_CELL_BACKGROUND = MessageType.WARNING.getPopupBackground();
    private final Project myProject;
    private JPanel myToolWindowPanel;
    private JBTable myVariantsTable;
    private JPanel myNotificationPanel;
    private JButton myImportDefaultsButton;
    @NotNull
    private final List<Conflict> myConflicts = new ArrayList<Conflict>();

    @NotNull
    public static BuildVariantView getInstance(@NotNull Project project) {
        return (BuildVariantView)project.getService(BuildVariantView.class);
    }

    private BuildVariantView(@NotNull Project project) {
        this.myProject = project;
        this.setupUI();
        ((JComponent)this.myVariantsTable.getParent().getParent()).setBorder((Border)JBUI.Borders.empty());
    }

    private void setupUI() {
        this.createUIComponents();
        this.myToolWindowPanel = new JPanel();
        this.myToolWindowPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        JBScrollPane jBScrollPane1 = new JBScrollPane();
        this.myToolWindowPanel.add((Component)jBScrollPane1, new GridConstraints(1, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        this.myVariantsTable.setCellSelectionEnabled(true);
        jBScrollPane1.setViewportView((Component)this.myVariantsTable);
        this.myToolWindowPanel.add((Component)this.myNotificationPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myToolWindowPanel.add((Component)panel1, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel1.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.myImportDefaultsButton.setText("Re-import with defaults");
        this.myImportDefaultsButton.setVerticalTextPosition(0);
        panel1.add((Component)this.myImportDefaultsButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
    }

    private void createUIComponents() {
        this.myVariantsTable = new BuildVariantTable();
        TableSpeedSearch.installOn((JTable)this.myVariantsTable);
        this.myNotificationPanel = new NotificationPanel();
        this.myNotificationPanel.setVisible(false);
        this.myImportDefaultsButton = new JButton();
        this.myImportDefaultsButton.setToolTipText("Resets variant selection to the default variants (automatically selected if not specified in Gradle build files)");
        this.myImportDefaultsButton.addActionListener(event -> BuildVariantUpdater.requestGradleSync(this.myProject, null, true));
    }

    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        ContentFactory contentFactory = ContentFactory.getInstance();
        Content content2 = contentFactory.createContent((JComponent)this.myToolWindowPanel, "", false);
        toolWindow.getContentManager().addContent(content2);
    }

    private void updateContents() {
        BuildVariantTableModel model = BuildVariantTableModel.create(this.myProject);
        boolean allDefault = true;
        for (BuildVariantTableRow row : model.getRows()) {
            if (row.variantItem().isDefault()) continue;
            allDefault = false;
            break;
        }
        this.myImportDefaultsButton.setEnabled(!allDefault);
        this.getVariantsTable().setBuildVariantTableModel(model);
    }

    private void projectImportStarted() {
        this.getVariantsTable().setLoading();
    }

    private void projectImportFinished() {
        ConflictSet.findConflicts(this.myProject).showSelectionConflicts();
    }

    @NotNull
    private BuildVariantTable getVariantsTable() {
        return (BuildVariantTable)this.myVariantsTable;
    }

    public void updateContents(@NotNull List<Conflict> conflicts) {
        this.myNotificationPanel.setVisible(!conflicts.isEmpty());
        ((NotificationPanel)this.myNotificationPanel).myCurrentConflictIndex = -1;
        this.myConflicts.clear();
        this.myConflicts.addAll(conflicts);
        this.updateContents();
    }

    public void selectModule(int row) {
        this.select(row, 0);
    }

    public void select(int row, int col) {
        this.myVariantsTable.getSelectionModel().setSelectionInterval(row, row);
        this.myVariantsTable.getColumnModel().getSelectionModel().setSelectionInterval(col, col);
        TableUtil.scrollSelectionToVisible((JTable)this.myVariantsTable);
        this.myVariantsTable.requestFocusInWindow();
    }

    public void findAndSelectVariantEditor(@NotNull Module module) {
        this.findAndSelect(module, 1);
    }

    private void findAndSelect(@NotNull Module module, int columnIndex) {
        int rowCount = this.myVariantsTable.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            if (!module.equals(this.myVariantsTable.getValueAt(row, 0))) continue;
            this.select(row, columnIndex);
            break;
        }
    }

    private class BuildVariantTable
    extends JBTable {
        private boolean myLoading;
        private final ModuleTableCell myModuleCellEditor;
        private final ModuleTableCell myModuleCellRenderer;
        private final VariantsCellRenderer myVariantsCellRenderer;
        private final AbisCellRenderer myAbisCellRenderer;

        BuildVariantTable() {
            super((TableModel)BuildVariantTableModel.createEmpty());
            this.myModuleCellEditor = new ModuleTableCell();
            this.myModuleCellRenderer = new ModuleTableCell();
            this.myVariantsCellRenderer = new VariantsCellRenderer();
            this.myAbisCellRenderer = new AbisCellRenderer();
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    Component editorComponent;
                    int column2 = BuildVariantTable.this.getSelectedColumn();
                    int row = BuildVariantTable.this.getSelectedRow();
                    if ((column2 == 1 || column2 == 2) && row >= 0 && e.getKeyCode() == 113 && BuildVariantTable.this.editCellAt(row, column2) && (editorComponent = BuildVariantTable.this.getEditorComponent()) instanceof ComboBox) {
                        editorComponent.requestFocusInWindow();
                        ((ComboBox)editorComponent).showPopup();
                    }
                }
            });
            this.setExpandableItemsEnabled(false);
        }

        @NotNull
        ImmutableList<Conflict> findConflict(int row) {
            Object module = this.getValueAt(row, 0);
            if (!(module instanceof Module)) {
                return ImmutableList.of();
            }
            List conflicts = BuildVariantView.this.myConflicts.stream().filter(conflict -> conflict.hasAffectedModule((Module)module)).collect(Collectors.toList());
            return new ImmutableList.Builder().addAll(conflicts).build();
        }

        boolean hasConflict(int row) {
            return !this.findConflict(row).isEmpty();
        }

        @Nullable
        Module findModule(int row) {
            Object module = this.getValueAt(row, 0);
            return module instanceof Module ? (Module)module : null;
        }

        public boolean isCellEditable(int row, int column2) {
            return true;
        }

        void updateLoadingStatus(boolean loading) {
            this.myLoading = loading;
            this.setPaintBusy(this.myLoading);
            String text2 = this.myLoading ? "Loading..." : "Nothing to Show";
            this.getEmptyText().setText(text2);
        }

        void setLoading() {
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.nonModal(), () -> {
                this.updateLoadingStatus(true);
                this.setModel(BuildVariantTableModel.createEmpty());
            });
        }

        private void setBuildVariantTableModel(@NotNull BuildVariantTableModel model) {
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.nonModal(), () -> {
                this.updateLoadingStatus(false);
                this.setModel(model);
            });
        }

        @Nullable
        private DefaultCellEditor createCellEditor(BuildVariantTableRow tableRow) {
            Object[] items = tableRow.buildVariantsAsArray();
            if (items == null) {
                return null;
            }
            BuildVariantItem selected = tableRow.variantItem();
            ComboBox editor = new ComboBox(items);
            editor.setSelectedItem((Object)selected);
            editor.setSwingPopup(false);
            editor.setBorder((Border)JBUI.Borders.empty());
            editor.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    BuildVariantItem selectedVariant = (BuildVariantItem)e.getItem();
                    BuildVariantUpdater.getInstance(BuildVariantView.this.myProject).updateSelectedBuildVariant(tableRow.getModule(), selectedVariant.getBuildVariantName());
                }
            });
            final DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JComboBox<?>)editor);
            editor.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        defaultCellEditor.cancelCellEditing();
                    }
                }
            });
            return defaultCellEditor;
        }

        @Nullable
        private DefaultCellEditor createAbiCellEditor(BuildVariantTableRow tableRow) {
            Object[] items = tableRow.abisAsArray();
            if (items == null) {
                return null;
            }
            AbiItem selected = tableRow.abiItem();
            ComboBox editor = new ComboBox(items);
            if (selected != null) {
                editor.setSelectedItem((Object)selected);
            }
            editor.setBorder((Border)JBUI.Borders.empty());
            editor.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    AbiItem selectedAbi = (AbiItem)e.getItem();
                    BuildVariantUpdater.getInstance(BuildVariantView.this.myProject).updateSelectedAbi(tableRow.getModule(), selectedAbi.getAbiName());
                }
            });
            final DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JComboBox<?>)editor);
            editor.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        defaultCellEditor.cancelCellEditing();
                    }
                }
            });
            return defaultCellEditor;
        }

        public TableCellRenderer getCellRenderer(int row, int column2) {
            if (column2 == 0) {
                return this.myModuleCellRenderer;
            }
            BuildVariantTableRow tableRow = ((BuildVariantTableModel)this.getModel()).getRows().get(row);
            if (column2 == 1) {
                this.myVariantsCellRenderer.setTableRow(tableRow);
                return this.myVariantsCellRenderer;
            }
            this.myAbisCellRenderer.setTableRow(tableRow);
            return this.myAbisCellRenderer;
        }

        public TableCellEditor getCellEditor(int row, int column2) {
            BuildVariantTableRow tableRow = ((BuildVariantTableModel)this.getModel()).getRows().get(row);
            if (column2 == 1) {
                return this.createCellEditor(tableRow);
            }
            if (column2 == 2) {
                return this.createAbiCellEditor(tableRow);
            }
            return this.myModuleCellEditor;
        }
    }

    private class NotificationPanel
    extends JPanel {
        int myCurrentConflictIndex;

        NotificationPanel() {
            super(new BorderLayout());
            this.myCurrentConflictIndex = -1;
            this.setBorder((Border)JBUI.Borders.empty((int)1, (int)15));
            this.setPreferredSize(new Dimension(-1, JBUI.scale((int)24)));
            JLabel textLabel = new JLabel("Variant selection conflicts found");
            textLabel.setOpaque(false);
            this.add((Component)textLabel, "Center");
            DefaultActionGroup group2 = new DefaultActionGroup();
            ActionManager actionManager = ActionManager.getInstance();
            AnAction nextConflictAction = new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    NotificationPanel.this.navigateConflicts(true);
                }
            };
            ActionUtil.copyFrom((AnAction)nextConflictAction, (String)"NextOccurence");
            group2.add(nextConflictAction);
            AnAction prevConflictAction = new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    NotificationPanel.this.navigateConflicts(false);
                }
            };
            ActionUtil.copyFrom((AnAction)prevConflictAction, (String)"PreviousOccurence");
            group2.add(prevConflictAction);
            ActionToolbar toolbar = actionManager.createActionToolbar("AndroidBuildVariantViewNotifications", (ActionGroup)group2, true);
            toolbar.setReservePlaceAutoPopupIcon(false);
            toolbar.setMinimumButtonSize((Dimension)JBUI.size((int)23, (int)23));
            JComponent toolbarComponent = toolbar.getComponent();
            toolbarComponent.setBorder(null);
            toolbarComponent.setOpaque(false);
            this.add((Component)toolbarComponent, "East");
        }

        @Override
        public void setBackground(Color bg) {
        }

        @Override
        public Color getBackground() {
            return (Color)ObjectUtils.notNull((Object)EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.NOTIFICATION_BACKGROUND), (Object)UIUtil.getToolTipBackground());
        }

        private int nextConflictModule(Function<Integer, Integer> getNextIndex) {
            int index = getNextIndex.apply(this.myCurrentConflictIndex);
            for (int i = 0; i < BuildVariantView.this.getVariantsTable().getRowCount(); ++i) {
                if (BuildVariantView.this.getVariantsTable().hasConflict(index)) {
                    return index;
                }
                index = getNextIndex.apply(index);
            }
            return this.myCurrentConflictIndex;
        }

        private int findConflictModuleForward() {
            return this.nextConflictModule(index -> (index + 1) % BuildVariantView.this.getVariantsTable().getRowCount());
        }

        private int findConflictModuleBackwards() {
            return this.nextConflictModule(index -> index <= 0 ? BuildVariantView.this.getVariantsTable().getRowCount() - 1 : index - 1);
        }

        private void navigateConflicts(boolean forward) {
            int conflictCount = BuildVariantView.this.myConflicts.size();
            if (conflictCount == 0) {
                return;
            }
            this.myCurrentConflictIndex = forward ? this.findConflictModuleForward() : this.findConflictModuleBackwards();
            BuildVariantView.this.selectModule(this.myCurrentConflictIndex);
        }
    }

    static class SyncListener
    implements GradleSyncListenerWithRoot {
        SyncListener() {
        }

        @Override
        public void syncStarted(@NotNull Project project, @SystemIndependent String rootProjectPath) {
            BuildVariantView.getInstance(project).projectImportStarted();
        }

        @Override
        public void syncFailed(@NotNull Project project, @NotNull String errorMessage, @SystemIndependent String rootProjectPath) {
            BuildVariantView.getInstance(project).projectImportFinished();
        }

        @Override
        public void syncSucceeded(@NotNull Project project, @SystemIndependent String rootProjectPath) {
            BuildVariantView.getInstance(project).projectImportFinished();
        }

        @Override
        public void syncSkipped(@NotNull Project project) {
            BuildVariantView.getInstance(project).projectImportFinished();
        }

        @Override
        public void syncCancelled(@NotNull Project project, @SystemIndependent String rootProjectPath) {
            BuildVariantView.getInstance(project).getVariantsTable().updateLoadingStatus(false);
        }
    }

    private static class ModuleTableCell
    extends AbstractTableCellEditor
    implements TableCellRenderer {
        private static final Border EMPTY_BORDER = JBUI.Borders.empty((int)1);
        @NotNull
        private ImmutableList<Conflict> myConflicts = ImmutableList.of();
        private JPanel myPanel;
        private JLabel myModuleNameLabel = new JLabel();
        private JPanel myButtonsPanel;
        private Module myValue;

        ModuleTableCell() {
            this.myModuleNameLabel.setOpaque(false);
            this.myButtonsPanel = new JPanel();
            this.myButtonsPanel.setOpaque(false);
            this.myPanel = new JPanel(new BorderLayout()){

                @Override
                public String getToolTipText(MouseEvent e) {
                    String toolTip = ModuleTableCell.getToolTipTextIfUnderX(myModuleNameLabel, e.getX());
                    if (toolTip != null) {
                        return toolTip;
                    }
                    return super.getToolTipText(e);
                }
            };
            this.myPanel.add((Component)this.myModuleNameLabel, "Center");
            this.myPanel.add((Component)this.myButtonsPanel, "East");
        }

        @Nullable
        private static String getToolTipTextIfUnderX(@NotNull JComponent c, int x) {
            if (c.isVisible() && x >= c.getX() && x <= c.getX() + c.getWidth()) {
                return c.getToolTipText();
            }
            return null;
        }

        public Component getTableCellEditorComponent(JTable table2, Object value2, boolean isSelected, int row, int column2) {
            this.setUpComponent(table2, value2, true, true, row);
            return this.myPanel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column2) {
            this.setUpComponent(table2, value2, isSelected, hasFocus, row);
            return this.myPanel;
        }

        private void setUpComponent(@NotNull JTable table2, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row) {
            Color background;
            String moduleName = null;
            Icon moduleIcon = null;
            boolean isAndroidGradleModule = false;
            Module module = null;
            if (value2 != null) {
                this.myValue = module = (Module)value2;
                if (!module.isDisposed()) {
                    String modulePath = GradleProjectResolverUtil.getGradleIdentityPathOrNull((Module)module);
                    moduleName = modulePath != null ? modulePath : module.getName();
                    moduleIcon = AndroidIconProviderProjectGradleToken.getModuleIcon(module);
                    isAndroidGradleModule = GradleAndroidModel.get(module) != null;
                }
            }
            this.myModuleNameLabel.setForeground(AdtUiUtils.DEFAULT_FONT_COLOR);
            this.myModuleNameLabel.setFont(StartupUiUtil.getLabelFont());
            this.myModuleNameLabel.setText(moduleName == null ? "" : moduleName);
            this.myModuleNameLabel.setIcon(moduleIcon);
            Color color = background = isSelected ? table2.getSelectionBackground() : table2.getBackground();
            if (isAndroidGradleModule) {
                this.myConflicts = ((BuildVariantTable)((Object)table2)).findConflict(row);
                boolean hasConflicts = !this.myConflicts.isEmpty();
                this.myModuleNameLabel.setToolTipText(hasConflicts ? ConflictSetKt.variantConflictMessage(module, this.myConflicts) : null);
                if (hasConflicts) {
                    background = CONFLICT_CELL_BACKGROUND;
                }
            }
            this.myPanel.setBackground(background);
            Border border = hasFocus ? UIUtil.getTableFocusCellHighlightBorder() : EMPTY_BORDER;
            this.myPanel.setBorder(border);
        }

        public Object getCellEditorValue() {
            return this.myValue;
        }
    }

    private static class AbisCellRenderer
    extends JComboBox
    implements TableCellRenderer {
        private static final String abisCellHelpTooltipText = "For NDK modules, determines the ABI that will be used by the editor";
        private BuildVariantTableRow tableRow;

        private AbisCellRenderer() {
        }

        public void setTableRow(BuildVariantTableRow tableRow) {
            this.tableRow = tableRow;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column2) {
            if (this.tableRow == null) {
                return this;
            }
            Object[] items = this.tableRow.abisAsArray();
            AbiItem selected = this.tableRow.abiItem();
            if (items == null || selected == null) {
                this.dataModel.setSelectedItem(new AbiItem("\u2014"));
                this.setBackground(table2.getBackground());
                return this;
            }
            ComboBox editor = new ComboBox(items);
            Color background = isSelected ? table2.getSelectionBackground() : table2.getBackground();
            editor.setBackground(background);
            editor.setFont(StartupUiUtil.getLabelFont());
            editor.setToolTipText(abisCellHelpTooltipText);
            editor.setBorder((Border)BorderFactory.createCompoundBorder(editor.getBorder(), (Border)JBUI.Borders.empty((int)3, (int)2, (int)4, (int)2)));
            editor.setSelectedItem((Object)selected);
            this.setModel(editor.getModel());
            return editor;
        }
    }

    private static class VariantsCellRenderer
    extends JComboBox
    implements TableCellRenderer {
        private static final String variantsCellHelpTooltipText = "Determines the build variant that will be deployed to device and used by the editor";
        private BuildVariantTableRow tableRow;

        private VariantsCellRenderer() {
        }

        public void setTableRow(BuildVariantTableRow tableRow) {
            this.tableRow = tableRow;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column2) {
            boolean hasConflicts;
            if (this.tableRow == null) {
                return this;
            }
            Object[] items = this.tableRow.buildVariantsAsArray();
            if (items == null) {
                return this;
            }
            BuildVariantItem selected = this.tableRow.variantItem();
            ComboBox editor = new ComboBox(items);
            Color background = isSelected ? table2.getSelectionBackground() : table2.getBackground();
            ImmutableList<Conflict> conflictFound = ((BuildVariantTable)((Object)table2)).findConflict(row);
            boolean bl = hasConflicts = !conflictFound.isEmpty();
            if (hasConflicts) {
                background = CONFLICT_CELL_BACKGROUND;
            }
            editor.setBackground(background);
            editor.setFont(StartupUiUtil.getLabelFont());
            Module module = ((BuildVariantTable)((Object)table2)).findModule(row);
            String toolTip = hasConflicts && module != null ? ConflictSetKt.variantConflictMessage(module, conflictFound) : variantsCellHelpTooltipText;
            editor.setToolTipText(toolTip);
            editor.setBorder((Border)BorderFactory.createCompoundBorder(editor.getBorder(), (Border)JBUI.Borders.empty((int)3, (int)2, (int)4, (int)2)));
            editor.setSelectedItem((Object)selected);
            this.setModel(editor.getModel());
            return editor;
        }
    }
}

