/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gservices;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gservices.DevServicesDeprecationData;
import com.android.tools.idea.gservices.DevServicesDeprecationDataProvider;
import com.android.tools.idea.gservices.DevServicesDeprecationStatus;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DevServiceDeprecationInfo;
import com.google.wireless.android.sdk.stats.StudioDeprecationNotificationEvent;
import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import javax.swing.Icon;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001:\u00011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0013H\u0002J\f\u0010\u0016\u001a\u00020\u0015*\u00020\u0013H\u0002J\u0012\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001f\u001a\n !*\u0004\u0018\u00010 0 H\u0002J\u0011\u0010\"\u001a\u00070#\u00a2\u0006\u0002\b$*\u00020\u0013H\u0002J\f\u0010%\u001a\u00020&*\u00020\u0013H\u0002J\f\u0010'\u001a\u00020\u001e*\u00020\u000bH\u0002JE\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020\u001eH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/tools/idea/gservices/StudioDeprecationChecker;", "Lcom/intellij/openapi/Disposable;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "getNotificationGroup", "()Lcom/intellij/notification/NotificationGroup;", "value", "Lcom/intellij/notification/Notification;", "notification", "setNotification", "(Lcom/intellij/notification/Notification;)V", "userClickedUpdateAction", "", "createNotification", "deprecationData", "Lcom/android/tools/idea/gservices/DevServicesDeprecationData;", "getHeader", "", "getDescription", "shouldShowNotificationForData", "date", "Ljava/time/LocalDate;", "checkDateDiff", "deprecationDate", "hasShownForDate", "maybeStoreDeprecationDate", "", "createDateFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getNotificationIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getNotificationType", "Lcom/intellij/notification/NotificationType;", "showNotification", "trackEvent", "deprStatus", "Lcom/android/tools/idea/gservices/DevServicesDeprecationStatus;", "userNotified", "moreInfoClicked", "updateClicked", "notificationDismissed", "(Lcom/android/tools/idea/gservices/DevServicesDeprecationStatus;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "dispose", "Initializer", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nStudioDeprecationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StudioDeprecationChecker.kt\ncom/android/tools/idea/gservices/StudioDeprecationChecker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n25#2:279\n25#2:280\n25#2:281\n1#3:282\n*S KotlinDebug\n*F\n+ 1 StudioDeprecationChecker.kt\ncom/android/tools/idea/gservices/StudioDeprecationChecker\n*L\n162#1:279\n166#1:280\n173#1:281\n*E\n"})
public final class StudioDeprecationChecker
implements Disposable {
    @Nullable
    private Notification notification;
    private boolean userClickedUpdateAction;

    public StudioDeprecationChecker(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ StudioDeprecationChecker this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean $i$f$service = false;
                        Class<DevServicesDeprecationDataProvider> serviceClass$iv = DevServicesDeprecationDataProvider.class;
                        Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv);
                        if (object3 == null) {
                            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                        }
                        this.label = 1;
                        Object object4 = ((DevServicesDeprecationDataProvider)object3).registerServiceForChange("studio", "", (Disposable)this.this$0).collect(new FlowCollector(){

                            /*
                             * WARNING - void declaration
                             */
                            public final Object emit(DevServicesDeprecationData deprecationData, Continuation<? super Unit> $completion) {
                                void $this$emit_u24lambda_u240;
                                LocalDate date;
                                this$0.setNotification(null);
                                if (deprecationData.isSupported()) {
                                    return Unit.INSTANCE;
                                }
                                if (deprecationData.isDeprecated() && !this$0.shouldShowNotificationForData(date = deprecationData.getDate())) {
                                    return Unit.INSTANCE;
                                }
                                Notification notification = this$0.createNotification(deprecationData);
                                StudioDeprecationChecker studioDeprecationChecker = this$0;
                                Notification notification2 = notification;
                                StudioDeprecationChecker studioDeprecationChecker2 = this$0;
                                boolean bl = false;
                                studioDeprecationChecker.showNotification((Notification)$this$emit_u24lambda_u240);
                                StudioDeprecationChecker.trackEvent$default(studioDeprecationChecker, deprecationData.getStatus(), Boxing.boxBoolean((boolean)true), null, null, null, 28, null);
                                studioDeprecationChecker2.setNotification(notification);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object4 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final NotificationGroup getNotificationGroup() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("StudioDeprecationNotification");
        if (notificationGroup == null) {
            throw new RuntimeException("NotificationGroup not found");
        }
        return notificationGroup;
    }

    private final void setNotification(Notification value2) {
        block0: {
            Notification oldField = this.notification;
            this.notification = value2;
            Notification notification = oldField;
            if (notification == null) break block0;
            notification.expire();
        }
    }

    private final Notification createNotification(DevServicesDeprecationData deprecationData) {
        Notification notification;
        Notification $this$createNotification_u24lambda_u243 = notification = this.getNotificationGroup().createNotification(this.getHeader(deprecationData), this.getDescription(deprecationData), this.getNotificationType(deprecationData));
        boolean bl = false;
        if (deprecationData.getShowUpdateAction()) {
            $this$createNotification_u24lambda_u243.setSuggestionType(true);
            $this$createNotification_u24lambda_u243.addAction((AnAction)NotificationAction.createSimpleExpiring((String)"Update Android Studio", () -> StudioDeprecationChecker.createNotification$lambda$3$lambda$0(this, deprecationData)));
        }
        if (((CharSequence)deprecationData.getMoreInfoUrl()).length() > 0) {
            $this$createNotification_u24lambda_u243.addAction((AnAction)NotificationAction.createSimple((String)"More info", () -> StudioDeprecationChecker.createNotification$lambda$3$lambda$1(deprecationData, this)));
        }
        $this$createNotification_u24lambda_u243.setImportant(true);
        $this$createNotification_u24lambda_u243.setIcon(this.getNotificationIcon(deprecationData));
        $this$createNotification_u24lambda_u243.whenExpired(() -> StudioDeprecationChecker.createNotification$lambda$3$lambda$2(this, $this$createNotification_u24lambda_u243, deprecationData));
        return notification;
    }

    private final String getHeader(DevServicesDeprecationData $this$getHeader) {
        Object object;
        if ($this$getHeader.isDeprecated()) {
            object = "Cloud services won't be accessible after " + $this$getHeader.formattedDate();
        } else if ($this$getHeader.isUnsupported()) {
            object = "Unsupported Android Studio version";
        } else {
            throw new IllegalStateException("Cannot request header for " + $this$getHeader);
        }
        return object;
    }

    private final String getDescription(DevServicesDeprecationData $this$getDescription) {
        String string;
        if ($this$getDescription.isDeprecated()) {
            string = "Please update Android Studio to ensure uninterrupted access to cloud services.";
        } else if ($this$getDescription.isUnsupported()) {
            string = "This version of Android Studio is no longer compatible with cloud services.";
        } else {
            throw new IllegalStateException("Cannot request description for " + $this$getDescription);
        }
        return string;
    }

    private final boolean shouldShowNotificationForData(LocalDate date) {
        if (date == null) {
            StudioDeprecationChecker $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(StudioDeprecationChecker.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Deprecation date not provided");
            return false;
        }
        if (this.checkDateDiff(date)) {
            StudioDeprecationChecker $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(StudioDeprecationChecker.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Skip showing deprecation notification because diff is more than 30 days");
            return false;
        }
        if (this.hasShownForDate(date)) {
            StudioDeprecationChecker $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(StudioDeprecationChecker.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Skip showing deprecation notification because notification already shown");
            return false;
        }
        return true;
    }

    private final boolean checkDateDiff(LocalDate deprecationDate) {
        return ChronoUnit.DAYS.between(LocalDate.now(), deprecationDate) > 30L;
    }

    private final boolean hasShownForDate(LocalDate deprecationDate) {
        DateTimeFormatter formatter;
        LocalDate lastCheckedDate;
        String string = PropertiesComponent.getInstance().getValue("com.android.tools.idea.gservices.deprecation.last.date.checked", "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        String lastCheckedDateProp = string;
        return ((CharSequence)lastCheckedDateProp).length() > 0 && (lastCheckedDate = LocalDate.parse(lastCheckedDateProp, formatter = this.createDateFormatter())).equals(deprecationDate);
    }

    private final void maybeStoreDeprecationDate(DevServicesDeprecationData deprecationData) {
        if (deprecationData.isUnsupported()) {
            return;
        }
        DateTimeFormatter formatter = this.createDateFormatter();
        Object object = deprecationData.getDate();
        if (object == null || (object = ((LocalDate)object).format(formatter)) == null) {
            return;
        }
        Object date = object;
        PropertiesComponent.getInstance().setValue("com.android.tools.idea.gservices.deprecation.last.date.checked", (String)date);
    }

    private final DateTimeFormatter createDateFormatter() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd");
    }

    private final Icon getNotificationIcon(DevServicesDeprecationData $this$getNotificationIcon) {
        Icon icon;
        if ($this$getNotificationIcon.isUnsupported()) {
            icon = AllIcons.General.Error;
        } else if ($this$getNotificationIcon.isDeprecated()) {
            icon = AllIcons.General.Warning;
        } else {
            throw new IllegalStateException("Cannot request notification icon for " + $this$getNotificationIcon);
        }
        Icon icon2 = icon;
        Intrinsics.checkNotNull((Object)icon2);
        return icon2;
    }

    private final NotificationType getNotificationType(DevServicesDeprecationData $this$getNotificationType) {
        NotificationType notificationType;
        if ($this$getNotificationType.isUnsupported()) {
            notificationType = NotificationType.ERROR;
        } else if ($this$getNotificationType.isDeprecated()) {
            notificationType = NotificationType.WARNING;
        } else {
            throw new IllegalStateException("Cannot request notification type for " + $this$getNotificationType);
        }
        return notificationType;
    }

    private final void showNotification(Notification $this$showNotification) {
        ActionsKt.invokeLater$default(null, () -> StudioDeprecationChecker.showNotification$lambda$4($this$showNotification, this), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void trackEvent(DevServicesDeprecationStatus deprStatus, Boolean userNotified, Boolean moreInfoClicked, Boolean updateClicked, Boolean notificationDismissed) {
        boolean it;
        void $this$trackEvent_u24lambda_u2411_u24lambda_u2410_u24lambda_u249;
        void $this$trackEvent_u24lambda_u2411_u24lambda_u2410;
        DevServiceDeprecationInfo.Builder builder;
        StudioDeprecationNotificationEvent.Builder builder2;
        AndroidStudioEvent.Builder builder3;
        AndroidStudioEvent.Builder $this$trackEvent_u24lambda_u2411 = builder3 = AndroidStudioEvent.newBuilder();
        boolean bl = false;
        $this$trackEvent_u24lambda_u2411.setKind(AndroidStudioEvent.EventKind.STUDIO_DEPRECATION_NOTIFICATION_EVENT);
        StudioDeprecationNotificationEvent.Builder builder4 = builder2 = StudioDeprecationNotificationEvent.newBuilder();
        AndroidStudioEvent.Builder builder5 = $this$trackEvent_u24lambda_u2411;
        boolean bl2 = false;
        DevServiceDeprecationInfo.Builder builder6 = builder = DevServiceDeprecationInfo.newBuilder();
        void var15_15 = $this$trackEvent_u24lambda_u2411_u24lambda_u2410;
        boolean bl3 = false;
        $this$trackEvent_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setDeprecationStatus(switch (WhenMappings.$EnumSwitchMapping$0[deprStatus.ordinal()]) {
            case 1 -> DevServiceDeprecationInfo.DeprecationStatus.DEPRECATED;
            case 2 -> DevServiceDeprecationInfo.DeprecationStatus.UNSUPPORTED;
            default -> throw new IllegalArgumentException("SUPPORTED state should not log event");
        });
        $this$trackEvent_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setDeliveryType(DevServiceDeprecationInfo.DeliveryType.NOTIFICATION);
        Boolean bl4 = userNotified;
        if (bl4 != null) {
            it = bl4;
            boolean bl5 = false;
            $this$trackEvent_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setUserNotified(it);
        }
        Boolean bl6 = moreInfoClicked;
        if (bl6 != null) {
            it = bl6;
            boolean bl7 = false;
            $this$trackEvent_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setMoreInfoClicked(it);
        }
        Boolean bl8 = updateClicked;
        if (bl8 != null) {
            it = bl8;
            boolean bl9 = false;
            $this$trackEvent_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setUpdateClicked(it);
        }
        Boolean bl10 = notificationDismissed;
        if (bl10 != null) {
            it = bl10;
            boolean bl11 = false;
            $this$trackEvent_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setDeliveryDismissed(it);
        }
        var15_15.setDevServiceDeprecationInfo(builder.build());
        builder5.setStudioDeprecationNotificationEvent(builder2.build());
        AndroidStudioEvent.Builder builder7 = builder3;
        Intrinsics.checkNotNullExpressionValue((Object)builder7, (String)"apply(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder7);
    }

    static /* synthetic */ void trackEvent$default(StudioDeprecationChecker studioDeprecationChecker, DevServicesDeprecationStatus devServicesDeprecationStatus, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, int n, Object object) {
        if ((n & 2) != 0) {
            bl = null;
        }
        if ((n & 4) != 0) {
            bl2 = null;
        }
        if ((n & 8) != 0) {
            bl3 = null;
        }
        if ((n & 0x10) != 0) {
            bl4 = null;
        }
        studioDeprecationChecker.trackEvent(devServicesDeprecationStatus, bl, bl2, bl3, bl4);
    }

    public void dispose() {
        this.setNotification(null);
    }

    private static final void createNotification$lambda$3$lambda$0(StudioDeprecationChecker this$0, DevServicesDeprecationData $deprecationData) {
        this$0.userClickedUpdateAction = true;
        UpdateChecker.updateAndShowResult$default(null, null, (int)2, null);
        StudioDeprecationChecker.trackEvent$default(this$0, $deprecationData.getStatus(), null, null, true, null, 22, null);
    }

    private static final void createNotification$lambda$3$lambda$1(DevServicesDeprecationData $deprecationData, StudioDeprecationChecker this$0) {
        BrowserUtil.browse((String)$deprecationData.getMoreInfoUrl());
        StudioDeprecationChecker.trackEvent$default(this$0, $deprecationData.getStatus(), null, true, null, null, 26, null);
    }

    private static final void createNotification$lambda$3$lambda$2(StudioDeprecationChecker this$0, Notification $this_apply, DevServicesDeprecationData $deprecationData) {
        if (Intrinsics.areEqual((Object)this$0.notification, (Object)$this_apply)) {
            if (!this$0.userClickedUpdateAction) {
                StudioDeprecationChecker.trackEvent$default(this$0, $deprecationData.getStatus(), null, null, null, true, 14, null);
            }
            this$0.maybeStoreDeprecationDate($deprecationData);
            this$0.setNotification(null);
        }
    }

    private static final Unit showNotification$lambda$4(Notification $this_showNotification, StudioDeprecationChecker this$0) {
        block0: {
            $this_showNotification.notify(null);
            this$0.userClickedUpdateAction = false;
            Balloon balloon = $this_showNotification.getBalloon();
            if (balloon == null) break block0;
            balloon.addListener(new JBPopupListener($this_showNotification){
                final /* synthetic */ Notification $this_showNotification;
                {
                    this.$this_showNotification = $receiver;
                }

                public void onClosed(LightweightWindowEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    super.onClosed(event);
                    this.$this_showNotification.expire();
                }
            });
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/gservices/StudioDeprecationChecker$Initializer;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nStudioDeprecationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StudioDeprecationChecker.kt\ncom/android/tools/idea/gservices/StudioDeprecationChecker$Initializer\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,278:1\n40#2,3:279\n*S KotlinDebug\n*F\n+ 1 StudioDeprecationChecker.kt\ncom/android/tools/idea/gservices/StudioDeprecationChecker$Initializer\n*L\n274#1:279,3\n*E\n"})
    public static final class Initializer
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            boolean $i$f$service = false;
            Class<StudioDeprecationChecker> serviceClass$iv = StudioDeprecationChecker.class;
            if (ApplicationManager.getApplication().getService(serviceClass$iv) == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DevServicesDeprecationStatus.values().length];
            try {
                nArray[DevServicesDeprecationStatus.DEPRECATED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevServicesDeprecationStatus.UNSUPPORTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

