/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights.events.actions;

import com.android.tools.idea.insights.events.actions.Action;
import com.android.tools.idea.insights.events.actions.ActionDispatcher;
import com.android.tools.idea.insights.events.actions.CancellationToken;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/insights/events/actions/JobCancellationToken;", "Lcom/android/tools/idea/insights/events/actions/CancellationToken;", "job", "Lkotlinx/coroutines/Job;", "action", "Lcom/android/tools/idea/insights/events/actions/Action$Single;", "<init>", "(Lkotlinx/coroutines/Job;Lcom/android/tools/idea/insights/events/actions/Action$Single;)V", "getAction", "()Lcom/android/tools/idea/insights/events/actions/Action$Single;", "cancel", "reason", "Lcom/android/tools/idea/insights/events/actions/Action;", "intellij.android.app-quality-insights.api"})
public final class JobCancellationToken
implements CancellationToken {
    @NotNull
    private final Job job;
    @NotNull
    private final Action.Single action;

    public JobCancellationToken(@NotNull Job job2, @NotNull Action.Single action2) {
        Intrinsics.checkNotNullParameter((Object)job2, (String)"job");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        this.job = job2;
        this.action = action2;
    }

    @Override
    @NotNull
    public Action.Single getAction() {
        return this.action;
    }

    @Override
    @Nullable
    public JobCancellationToken cancel(@NotNull Action reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (this.job.isCompleted()) {
            return null;
        }
        if (this.getAction().maybeCancel(reason) != null) {
            Logger.getInstance(ActionDispatcher.class).debug("Not cancelling job \"" + this.getAction() + "\"");
            return this;
        }
        Logger.getInstance(ActionDispatcher.class).debug("Cancelling job \"" + this.getAction() + "\"");
        Job.DefaultImpls.cancel$default((Job)this.job, null, (int)1, null);
        return null;
    }

    @Override
    @NotNull
    public CancellationToken and(@Nullable CancellationToken other) {
        return CancellationToken.super.and(other);
    }
}

