/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights.ui;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.idea.insights.AppInsightsIssue;
import com.android.tools.idea.insights.FailureType;
import com.android.tools.idea.insights.IssueState;
import com.android.tools.idea.insights.SignalType;
import com.android.tools.idea.insights.ui.AppInsightsTableCellRenderer;
import com.android.tools.idea.insights.ui.UiUtilKt;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J \u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/insights/ui/AppInsightsIssuesTableCellRenderer;", "Lcom/android/tools/idea/insights/ui/AppInsightsTableCellRenderer;", "<init>", "()V", "renderer", "Lcom/intellij/ui/SimpleColoredComponent;", "leftPanel", "Ljavax/swing/JPanel;", "signalPanel", "rendererPanel", "updateRenderer", "", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "focused", "viewRowIndex", "", "viewColumnIndex", "renderClassText", "className", "", "style", "availableWidth", "", "intellij.android.app-quality-insights.ui"})
@SourceDebugExtension(value={"SMAP\nAppInsightsIssuesTableCellRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppInsightsIssuesTableCellRenderer.kt\ncom/android/tools/idea/insights/ui/AppInsightsIssuesTableCellRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1863#2,2:153\n1#3:155\n*S KotlinDebug\n*F\n+ 1 AppInsightsIssuesTableCellRenderer.kt\ncom/android/tools/idea/insights/ui/AppInsightsIssuesTableCellRenderer\n*L\n94#1:153,2\n*E\n"})
public final class AppInsightsIssuesTableCellRenderer
implements AppInsightsTableCellRenderer {
    @NotNull
    public static final AppInsightsIssuesTableCellRenderer INSTANCE;
    @NotNull
    private static final SimpleColoredComponent renderer;
    @NotNull
    private static final JPanel leftPanel;
    @NotNull
    private static final JPanel signalPanel;
    @NotNull
    private static final JPanel rendererPanel;

    private AppInsightsIssuesTableCellRenderer() {
    }

    @Override
    public void updateRenderer() {
        renderer.setFont(StartupUiUtil.getLabelFont());
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean selected, boolean focused, int viewRowIndex, int viewColumnIndex) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        AppInsightsIssue issue2 = (AppInsightsIssue)value2;
        renderer.removeAll();
        renderer.clear();
        Color foreground = selected ? table2.getSelectionForeground() : table2.getForeground();
        FailureType failureType = issue2.getIssueDetails().getFatality();
        Intrinsics.checkNotNull((Object)foreground);
        renderer.setIcon(UiUtilKt.getFatalityIcon(failureType, selected, foreground, issue2.getIssueDetails().getNotesCount() > 0L));
        float availableWidth = 0.0f;
        availableWidth = (float)table2.getColumnModel().getColumn(0).getWidth() - (float)JBUI.scale((int)30);
        signalPanel.removeAll();
        Iterable $this$forEach$iv = issue2.getIssueDetails().getSignals();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SimpleColoredComponent simpleColoredComponent;
            SignalType it = (SignalType)((Object)element$iv);
            boolean bl = false;
            SimpleColoredComponent $this$getTableCellRendererComponent_u24lambda_u247_u24lambda_u246 = simpleColoredComponent = new SimpleColoredComponent();
            boolean bl2 = false;
            $this$getTableCellRendererComponent_u24lambda_u247_u24lambda_u246.setIcon(it.getIcon());
            $this$getTableCellRendererComponent_u24lambda_u247_u24lambda_u246.setIconTextGap(0);
            $this$getTableCellRendererComponent_u24lambda_u247_u24lambda_u246.setBorder((Border)JBUI.Borders.empty());
            $this$getTableCellRendererComponent_u24lambda_u247_u24lambda_u246.setOpaque(false);
            SimpleColoredComponent iconLabel = simpleColoredComponent;
            signalPanel.add((Component)iconLabel);
            availableWidth -= (float)JBUIScale.scale((int)24);
        }
        Pair<String, String> pair = UiUtilKt.getDisplayTitle(issue2.getIssueDetails());
        String className = (String)pair.component1();
        String methodName = (String)pair.component2();
        renderer.setForeground(foreground);
        int style = switch (WhenMappings.$EnumSwitchMapping$0[issue2.getState().ordinal()]) {
            case 1, 2 -> 0;
            case 3, 4 -> 4;
            default -> throw new NoWhenBranchMatchedException();
        };
        if (((CharSequence)methodName).length() == 0) {
            this.renderClassText(className, style, availableWidth);
        } else {
            SimpleTextAttributes methodAttrs = new SimpleTextAttributes(style | 1, null);
            Font methodFont = renderer.getFont().deriveFont(methodAttrs.getStyle());
            FontMetrics methodFontMetrics = rendererPanel.getFontMetrics(methodFont);
            Intrinsics.checkNotNull((Object)methodFontMetrics);
            String methodText = AdtUiUtils.shrinkToFit((String)methodName, (FontMetrics)methodFontMetrics, (float)availableWidth, (AdtUiUtils.ShrinkDirection)AdtUiUtils.ShrinkDirection.TRUNCATE_START);
            availableWidth -= (float)methodFontMetrics.stringWidth(methodText);
            if (Intrinsics.areEqual((Object)methodText, (Object)methodName)) {
                this.renderClassText(className, style, availableWidth);
            }
            renderer.append(methodText, methodAttrs);
        }
        rendererPanel.setToolTipText("<html>" + issue2.getIssueDetails().getTitle() + "<br>" + issue2.getIssueDetails().getSubtitle() + "</html>");
        rendererPanel.setBackground(selected ? table2.getSelectionBackground() : table2.getBackground());
        renderer.setBorder((Border)JBUI.Borders.empty());
        return rendererPanel;
    }

    private final void renderClassText(String className, int style, float availableWidth) {
        SimpleTextAttributes classAttrs = new SimpleTextAttributes(style, null);
        Font classFont = renderer.getFont().deriveFont(classAttrs.getStyle());
        String classText = className + ".";
        FontMetrics fontMetrics = rendererPanel.getFontMetrics(classFont);
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
        renderer.append(AdtUiUtils.shrinkToFit((String)classText, (FontMetrics)fontMetrics, (float)availableWidth, (AdtUiUtils.ShrinkDirection)AdtUiUtils.ShrinkDirection.TRUNCATE_START), classAttrs);
    }

    static {
        GridBagConstraints gridBagConstraints;
        INSTANCE = new AppInsightsIssuesTableCellRenderer();
        Object object = new SimpleColoredComponent();
        SimpleColoredComponent $this$renderer_u24lambda_u240 = object;
        boolean bl = false;
        $this$renderer_u24lambda_u240.setOpaque(false);
        renderer = object;
        Object $this$leftPanel_u24lambda_u241 = object = new JPanel(new FlowLayout(1, 0, 0));
        boolean bl2 = false;
        ((JComponent)$this$leftPanel_u24lambda_u241).setOpaque(false);
        ((JComponent)$this$leftPanel_u24lambda_u241).setBorder((Border)JBUI.Borders.empty());
        ((Container)$this$leftPanel_u24lambda_u241).add((Component)renderer);
        leftPanel = object;
        Object $this$signalPanel_u24lambda_u242 = object = new JPanel(new FlowLayout(1, 0, 0));
        boolean bl3 = false;
        ((JComponent)$this$signalPanel_u24lambda_u242).setOpaque(false);
        ((JComponent)$this$signalPanel_u24lambda_u242).setBorder((Border)JBUI.Borders.empty());
        signalPanel = object;
        Object $this$rendererPanel_u24lambda_u245 = object = new JPanel(new GridBagLayout());
        boolean bl4 = false;
        ((JComponent)$this$rendererPanel_u24lambda_u245).setBorder((Border)JBUI.Borders.empty());
        GridBagConstraints $this$rendererPanel_u24lambda_u245_u24lambda_u243 = gridBagConstraints = new GridBagConstraints();
        boolean bl5 = false;
        $this$rendererPanel_u24lambda_u245_u24lambda_u243.anchor = 21;
        $this$rendererPanel_u24lambda_u245_u24lambda_u243.weightx = 0.8;
        $this$rendererPanel_u24lambda_u245_u24lambda_u243.weighty = 0.1;
        $this$rendererPanel_u24lambda_u245_u24lambda_u243.gridx = 0;
        $this$rendererPanel_u24lambda_u245_u24lambda_u243.gridy = 0;
        GridBagConstraints gridBagConstraint = gridBagConstraints;
        ((Container)$this$rendererPanel_u24lambda_u245).add((Component)leftPanel, gridBagConstraint);
        GridBagConstraints $this$rendererPanel_u24lambda_u245_u24lambda_u244 = gridBagConstraints = gridBagConstraint;
        boolean bl6 = false;
        $this$rendererPanel_u24lambda_u245_u24lambda_u244.anchor = 22;
        $this$rendererPanel_u24lambda_u245_u24lambda_u244.weightx = 0.2;
        $this$rendererPanel_u24lambda_u245_u24lambda_u244.gridx = 1;
        ((Container)$this$rendererPanel_u24lambda_u245).add((Component)signalPanel, gridBagConstraint);
        rendererPanel = object;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IssueState.values().length];
            try {
                nArray[IssueState.OPEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueState.CLOSING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueState.CLOSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueState.OPENING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

