/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.androidSql.room;

import com.android.tools.idea.lang.androidSql.parser.AndroidSqlParserDefinition;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlBooleanLiteral;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlLiteralExpression;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlPragmaValue;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlPsiTypes;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlVisitor;
import com.android.tools.idea.lang.androidSql.room.RoomSqlBooleanLiteralInspection;
import com.android.tools.idea.lang.androidSql.room.RoomSqlBooleanLiteralInspection$RoomSqlBooleanLiteralFix$applyFix$;
import com.android.tools.idea.lang.androidSql.room.RoomSqlKnownContextInspection;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/lang/androidSql/room/RoomSqlBooleanLiteralInspection;", "Lcom/android/tools/idea/lang/androidSql/room/RoomSqlKnownContextInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "RoomSqlBooleanLiteralFix", "intellij.android.lang"})
public final class RoomSqlBooleanLiteralInspection
extends RoomSqlKnownContextInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new AndroidSqlVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitBooleanLiteral(AndroidSqlBooleanLiteral literal) {
                AndroidFacet androidFacet;
                block12: {
                    block11: {
                        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
                        if (literal.getParent() instanceof AndroidSqlPragmaValue) {
                            return;
                        }
                        androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)literal);
                        if (androidFacet == null) break block11;
                        AndroidFacet it = androidFacet;
                        boolean bl = false;
                        AndroidModel androidModel = AndroidModel.Companion.get(it);
                        Integer n = androidModel != null && (androidModel = androidModel.getMinSdkVersion()) != null ? Integer.valueOf(androidModel.getApiLevel()) : null;
                        androidFacet = n;
                        if (n != null) break block12;
                    }
                    return;
                }
                int minSdk = androidFacet.intValue();
                if (minSdk < 30) {
                    Boolean bl;
                    IElementType iElementType;
                    PsiElement psiElement = literal.getFirstChild();
                    IElementType iElementType2 = psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : (iElementType = null);
                    if (Intrinsics.areEqual((Object)iElementType, (Object)AndroidSqlPsiTypes.TRUE)) {
                        bl = true;
                    } else if (Intrinsics.areEqual((Object)iElementType, (Object)AndroidSqlPsiTypes.FALSE)) {
                        bl = false;
                    } else {
                        buildVisitor.1 $this$thisLogger$iv = this;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(buildVisitor.1.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        PsiElement psiElement2 = literal.getFirstChild();
                        logger.error("Unexpected element type: " + (psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null));
                        bl = null;
                    }
                    Boolean literalValue = bl;
                    String problemDescription = "Boolean literals require API level 30 (current min is " + minSdk + ").";
                    if (literalValue != null) {
                        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RoomSqlBooleanLiteralFix(literalValue)};
                        this.$holder.registerProblem((PsiElement)literal, problemDescription, ProblemHighlightType.WARNING, localQuickFixArray);
                    } else {
                        this.$holder.registerProblem((PsiElement)literal, problemDescription, ProblemHighlightType.WARNING, new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/lang/androidSql/room/RoomSqlBooleanLiteralInspection$RoomSqlBooleanLiteralFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "literalValue", "", "<init>", "(Z)V", "getName", "", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.android.lang"})
    @SourceDebugExtension(value={"SMAP\nInspections.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Inspections.kt\ncom/android/tools/idea/lang/androidSql/room/RoomSqlBooleanLiteralInspection$RoomSqlBooleanLiteralFix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,125:1\n394#2,11:126\n417#2:137\n*S KotlinDebug\n*F\n+ 1 Inspections.kt\ncom/android/tools/idea/lang/androidSql/room/RoomSqlBooleanLiteralInspection$RoomSqlBooleanLiteralFix\n*L\n119#1:126,11\n119#1:137\n*E\n"})
    private static final class RoomSqlBooleanLiteralFix
    implements LocalQuickFix {
        private final boolean literalValue;

        public RoomSqlBooleanLiteralFix(boolean literalValue) {
            this.literalValue = literalValue;
        }

        @NotNull
        public String getName() {
            return this.literalValue ? "Replace Boolean literal 'TRUE' with '1'" : "Replace Boolean literal 'FALSE' with '0'";
        }

        @NotNull
        public String getFamilyName() {
            return "Replace Boolean literal";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            String replacementText = this.literalValue ? "1" : "0";
            PsiFile psiFile = AndroidSqlParserDefinition.Companion.parseSqlQuery(project, "SELECT " + replacementText);
            PsiElement $this$findDescendantOfType_u24default$iv = (PsiElement)psiFile;
            Function1 predicate$iv = RoomSqlBooleanLiteralFix$applyFix$$inlined$findDescendantOfType$default$1.INSTANCE;
            boolean $i$f$findDescendantOfType = false;
            PsiElement $this$findDescendantOfType$iv$iv = $this$findDescendantOfType_u24default$iv;
            boolean $i$f$findDescendantOfType2 = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv);
            Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
            $this$findDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Ref.ObjectRef $result;
                {
                    this.$predicate = $predicate;
                    this.$result = $result;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (element instanceof AndroidSqlLiteralExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                        this.$result.element = element;
                        this.stopWalking();
                        return;
                    }
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                }
            });
            PsiElement psiElement = (PsiElement)result$iv$iv.element;
            if (psiElement == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            AndroidSqlLiteralExpression numericLiteral = (AndroidSqlLiteralExpression)psiElement;
            descriptor2.getPsiElement().replace((PsiElement)numericLiteral);
        }
    }
}

