/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.model;

import com.android.tools.idea.layoutinspector.model.StatusNotification;
import com.android.tools.idea.layoutinspector.model.StatusNotificationAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorNotificationPanel;
import com.jetbrains.rd.util.AtomicReference;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\b\b\u0002\u0010#\u001a\u00020$2\u000e\b\u0002\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\b\b\u0002\u0010&\u001a\u00020\u001dJ\u000e\u0010'\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!J\u000e\u0010(\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!J\u0006\u0010)\u001a\u00020\u0014J\b\u0010*\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00118F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001e\u00a8\u0006+"}, d2={"Lcom/android/tools/idea/layoutinspector/model/NotificationModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "dismissAction", "Lcom/android/tools/idea/layoutinspector/model/StatusNotificationAction;", "getDismissAction", "()Lcom/android/tools/idea/layoutinspector/model/StatusNotificationAction;", "notificationData", "", "Lcom/android/tools/idea/layoutinspector/model/StatusNotification;", "notificationList", "Lcom/jetbrains/rd/util/AtomicReference;", "", "notificationListeners", "Lkotlin/Function0;", "", "getNotificationListeners", "()Ljava/util/List;", "value", "notifications", "getNotifications", "setNotifications", "(Ljava/util/List;)V", "isDisposed", "", "()Z", "addNotification", "id", "", "text", "status", "Lcom/intellij/ui/EditorNotificationPanel$Status;", "actions", "sticky", "hasNotification", "removeNotification", "clear", "notifyChanges", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nNotificationModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationModel.kt\ncom/android/tools/idea/layoutinspector/model/NotificationModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1#2:109\n1863#3,2:110\n*S KotlinDebug\n*F\n+ 1 NotificationModel.kt\ncom/android/tools/idea/layoutinspector/model/NotificationModel\n*L\n105#1:110,2\n*E\n"})
public final class NotificationModel {
    @NotNull
    private final Project project;
    @NotNull
    private final StatusNotificationAction dismissAction;
    @NotNull
    private final List<StatusNotification> notificationData;
    @NotNull
    private final AtomicReference<List<StatusNotification>> notificationList;
    @NotNull
    private final List<Function0<Unit>> notificationListeners;

    public NotificationModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.dismissAction = new StatusNotificationAction("Dismiss", (Function1<? super StatusNotification, Unit>)((Function1)arg_0 -> NotificationModel.dismissAction$lambda$0(this, arg_0)));
        this.notificationData = new ArrayList();
        this.notificationList = new AtomicReference((Object)CollectionsKt.emptyList());
        this.notificationListeners = new ArrayList();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final StatusNotificationAction getDismissAction() {
        return this.dismissAction;
    }

    @NotNull
    public final List<Function0<Unit>> getNotificationListeners() {
        return this.notificationListeners;
    }

    @NotNull
    public final List<StatusNotification> getNotifications() {
        return !this.isDisposed() ? (List)this.notificationList.get() : CollectionsKt.emptyList();
    }

    private final void setNotifications(List<StatusNotification> value2) {
        this.notificationList.getAndSet((Object)CollectionsKt.toList((Iterable)value2));
    }

    private final boolean isDisposed() {
        return this.project.isDisposed();
    }

    public final void addNotification(@NotNull String id2, @NotNull String text2, @NotNull EditorNotificationPanel.Status status2, @NotNull List<StatusNotificationAction> actions2, boolean sticky) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        if (this.isDisposed()) {
            return;
        }
        this.notificationData.removeIf(arg_0 -> NotificationModel.addNotification$lambda$2(arg_0 -> NotificationModel.addNotification$lambda$1(id2, arg_0), arg_0));
        this.notificationData.add(new StatusNotification(status2, id2, text2, sticky, actions2));
        this.notifyChanges();
    }

    public static /* synthetic */ void addNotification$default(NotificationModel notificationModel, String string, String string2, EditorNotificationPanel.Status status2, List list, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            status2 = EditorNotificationPanel.Status.Warning;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.listOf((Object)notificationModel.dismissAction);
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        notificationModel.addNotification(string, string2, status2, list, bl);
    }

    public final boolean hasNotification(@NotNull String id2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Iterable iterable = this.getNotifications();
            for (Object t : iterable) {
                StatusNotification it = (StatusNotification)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id2)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    public final void removeNotification(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        if (this.isDisposed()) {
            return;
        }
        if (this.notificationData.removeIf(arg_0 -> NotificationModel.removeNotification$lambda$5(arg_0 -> NotificationModel.removeNotification$lambda$4(id2, arg_0), arg_0))) {
            this.notifyChanges();
        }
    }

    public final void clear() {
        this.notificationData.removeIf(arg_0 -> NotificationModel.clear$lambda$7(NotificationModel::clear$lambda$6, arg_0));
        this.notifyChanges();
    }

    private final void notifyChanges() {
        if (this.isDisposed()) {
            return;
        }
        this.setNotifications(this.notificationData);
        Iterable $this$forEach$iv = this.notificationListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    private static final Unit dismissAction$lambda$0(NotificationModel this$0, StatusNotification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        this$0.removeNotification(notification.getId());
        return Unit.INSTANCE;
    }

    private static final boolean addNotification$lambda$1(String $id, StatusNotification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getId(), (Object)$id);
    }

    private static final boolean addNotification$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeNotification$lambda$4(String $id, StatusNotification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getId(), (Object)$id);
    }

    private static final boolean removeNotification$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean clear$lambda$6(StatusNotification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.getSticky();
    }

    private static final boolean clear$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

