/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline;

import com.android.tools.idea.appinspection.api.process.ProcessesModel;
import com.android.tools.idea.appinspection.inspector.api.process.ProcessDescriptor;
import com.android.tools.idea.concurrency.AndroidExecutors;
import com.android.tools.idea.layoutinspector.metrics.LayoutInspectorSessionMetrics;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.NotificationModel;
import com.android.tools.idea.layoutinspector.model.StatusNotification;
import com.android.tools.idea.layoutinspector.pipeline.ClientFactory;
import com.android.tools.idea.layoutinspector.pipeline.DisconnectedClient;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClientSettings;
import com.android.tools.idea.layoutinspector.pipeline.appinspection.AppInspectionInspectorClient;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyClient;
import com.android.tools.idea.layoutinspector.settings.LayoutInspectorSettings;
import com.android.tools.idea.layoutinspector.tree.TreeSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.rd.util.PlatformDependentKt;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ?2\u00020\u0001:\u0002?@BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\n\b\u0003\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001c\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0012\u0010 \u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\b\u0010!\u001a\u00020\u001dH\u0002J\u001a\u00108\u001a\u00020\u001d2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u001d07J\u001c\u0010:\u001a\u00020\u001d2\b\b\u0002\u0010;\u001a\u00020<2\b\b\u0002\u0010=\u001a\u00020>H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0019j\b\u0012\u0004\u0012\u00020\u0017`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\"\u001a\u0004\u0018\u00010#8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b%\u0010&\u001a\u0004\b'\u0010(R$\u0010*\u001a\u00020)2\u0006\u0010\"\u001a\u00020)@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R$\u00100\u001a\u00020/2\u0006\u0010\"\u001a\u00020/@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R \u00105\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u001d0706X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher;", "", "processes", "Lcom/android/tools/idea/appinspection/api/process/ProcessesModel;", "clientFactories", "", "Lcom/android/tools/idea/layoutinspector/pipeline/ClientFactory;", "project", "Lcom/intellij/openapi/project/Project;", "notificationModel", "Lcom/android/tools/idea/layoutinspector/model/NotificationModel;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "metrics", "Lcom/android/tools/idea/layoutinspector/metrics/LayoutInspectorSessionMetrics;", "executor", "Ljava/util/concurrent/Executor;", "<init>", "(Lcom/android/tools/idea/appinspection/api/process/ProcessesModel;Ljava/util/List;Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/layoutinspector/model/NotificationModel;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/layoutinspector/metrics/LayoutInspectorSessionMetrics;Ljava/util/concurrent/Executor;)V", "sequenceNumberLock", "sequenceNumber", "", "threadSequenceNumber", "Ljava/lang/ThreadLocal;", "Lcom/jetbrains/rd/util/ThreadLocal;", "workerExecutor", "handleProcessInWorkerThread", "", "process", "Lcom/android/tools/idea/appinspection/inspector/api/process/ProcessDescriptor;", "handleProcess", "checkCancelled", "value", "Lkotlinx/coroutines/Job;", "launchJob", "getLaunchJob$annotations", "()V", "getLaunchJob", "()Lkotlinx/coroutines/Job;", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;", "activeClient", "getActiveClient", "()Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;", "setActiveClient", "(Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;)V", "", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "clientChangedCallbacks", "", "Lkotlin/Function1;", "addClientChangedListener", "callback", "disconnectActiveClient", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "Companion", "Params", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nInspectorClientLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectorClientLauncher.kt\ncom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,379:1\n1863#2,2:380\n1863#2,2:382\n295#2,2:385\n1#3:384\n*S KotlinDebug\n*F\n+ 1 InspectorClientLauncher.kt\ncom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher\n*L\n282#1:380,2\n317#1:382,2\n343#1:385,2\n*E\n"})
public final class InspectorClientLauncher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProcessesModel processes;
    @NotNull
    private final List<ClientFactory> clientFactories;
    @NotNull
    private final Project project;
    @NotNull
    private final NotificationModel notificationModel;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final LayoutInspectorSessionMetrics metrics;
    @NotNull
    private final Object sequenceNumberLock;
    private int sequenceNumber;
    @NotNull
    private final ThreadLocal<Integer> threadSequenceNumber;
    @NotNull
    private final Executor workerExecutor;
    @Nullable
    private Job launchJob;
    @NotNull
    private InspectorClient activeClient;
    private boolean enabled;
    @NotNull
    private final List<Function1<InspectorClient, Unit>> clientChangedCallbacks;

    public InspectorClientLauncher(@NotNull ProcessesModel processes, @NotNull List<? extends ClientFactory> clientFactories, @NotNull Project project, @NotNull NotificationModel notificationModel, @NotNull CoroutineScope scope, @NotNull Disposable parentDisposable, @NotNull LayoutInspectorSessionMetrics metrics, @VisibleForTesting @Nullable Executor executor) {
        Intrinsics.checkNotNullParameter((Object)processes, (String)"processes");
        Intrinsics.checkNotNullParameter(clientFactories, (String)"clientFactories");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notificationModel, (String)"notificationModel");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        this.processes = processes;
        this.clientFactories = clientFactories;
        this.project = project;
        this.notificationModel = notificationModel;
        this.scope = scope;
        this.parentDisposable = parentDisposable;
        this.metrics = metrics;
        this.sequenceNumberLock = new Object();
        this.threadSequenceNumber = PlatformDependentKt.threadLocalWithInitial(InspectorClientLauncher::threadSequenceNumber$lambda$0);
        this.workerExecutor = AndroidExecutors.Companion.getInstance().getWorkerThreadExecutor();
        Executor executor2 = executor;
        if (executor2 == null) {
            executor2 = new Executor(this){
                private final ExecutorService singleThreadExecutor;
                final /* synthetic */ InspectorClientLauncher this$0;
                {
                    this.this$0 = $receiver;
                    this.singleThreadExecutor = Executors.newSingleThreadExecutor();
                }

                public void execute(Runnable command) {
                    Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                    if (((Number)InspectorClientLauncher.access$getThreadSequenceNumber$p(this.this$0).get()).intValue() > 0) {
                        command.run();
                    } else {
                        this.singleThreadExecutor.execute(command);
                    }
                }
            };
        }
        Executor realExecutor2 = executor2;
        this.processes.addSelectedProcessListeners(realExecutor2, (Function0<Unit>)((Function0)() -> InspectorClientLauncher._init_$lambda$1(this, executor)));
        Disposer.register((Disposable)this.parentDisposable, () -> InspectorClientLauncher._init_$lambda$2(this));
        this.activeClient = DisconnectedClient.INSTANCE;
        this.enabled = true;
        this.clientChangedCallbacks = new ArrayList();
    }

    public /* synthetic */ InspectorClientLauncher(ProcessesModel processesModel, List list, Project project, NotificationModel notificationModel, CoroutineScope coroutineScope, Disposable disposable, LayoutInspectorSessionMetrics layoutInspectorSessionMetrics, Executor executor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            executor = null;
        }
        this(processesModel, list, project, notificationModel, coroutineScope, disposable, layoutInspectorSessionMetrics, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleProcessInWorkerThread(Executor executor, ProcessDescriptor process2) {
        if (!this.project.isDisposed()) {
            Function0 processHandler = () -> InspectorClientLauncher.handleProcessInWorkerThread$lambda$3(this, process2);
            Integer n = this.threadSequenceNumber.get();
            int n2 = this.sequenceNumber;
            if (n != null && n == n2) {
                processHandler.invoke();
            } else if (((Number)this.threadSequenceNumber.get()).intValue() < 0) {
                Object object = this.sequenceNumberLock;
                synchronized (object) {
                    boolean bl = false;
                    CountDownLatch threadStartedLatch = new CountDownLatch(1);
                    Executor executor2 = executor;
                    if (executor2 == null) {
                        executor2 = this.workerExecutor;
                    }
                    executor2.execute(() -> InspectorClientLauncher.handleProcessInWorkerThread$lambda$5$lambda$4(this, threadStartedLatch, processHandler));
                    threadStartedLatch.await();
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
    }

    private final void handleProcess(ProcessDescriptor process2) {
        Ref.BooleanRef validClientConnected;
        block10: {
            validClientConnected = new Ref.BooleanRef();
            if (process2 == null || !process2.isRunning() || !this.enabled) break block10;
            Params params2 = new Params(process2, this){
                private final ProcessDescriptor process;
                private final Disposable disposable;
                {
                    this.process = $process;
                    this.disposable = InspectorClientLauncher.access$getParentDisposable$p($receiver);
                }

                public ProcessDescriptor getProcess() {
                    return this.process;
                }

                public Disposable getDisposable() {
                    return this.disposable;
                }
            };
            this.metrics.setProcess(process2);
            for (ClientFactory clientFactory : this.clientFactories) {
                this.checkCancelled();
                InspectorClient client = clientFactory.createClient(params2);
                if (client == null) continue;
                try {
                    block12: {
                        block11: {
                            CountDownLatch latch = new CountDownLatch(1);
                            client.registerStateCallback((Function1<? super InspectorClient.State, Unit>)((Function1)arg_0 -> InspectorClientLauncher.handleProcess$lambda$6(validClientConnected, latch, arg_0)));
                            this.setActiveClient(client);
                            latch.await();
                            ProcessDescriptor processDescriptor2 = this.processes.getSelectedProcess();
                            boolean bl = processDescriptor2 != null ? processDescriptor2.isRunning() : false;
                            if (!bl) break block11;
                            ProcessDescriptor processDescriptor3 = this.processes.getSelectedProcess();
                            if (processDescriptor3 != null ? processDescriptor3.getPid() == process2.getPid() : false) break block12;
                        }
                        LayoutInspectorSessionMetrics.logEvent$default(this.metrics, DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.ATTACH_CANCELLED, client.getStats(), null, null, 12, null);
                        return;
                    }
                    if (validClientConnected.element) break;
                    client.disconnect();
                }
                catch (CancellationException cancellationException) {
                    client.disconnect();
                    LayoutInspectorSessionMetrics.logEvent$default(this.metrics, DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.ATTACH_CANCELLED, client.getStats(), null, null, 12, null);
                    throw cancellationException;
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
            }
        }
        if (!validClientConnected.element) {
            List<StatusNotification> notifications = this.notificationModel.getNotifications();
            this.setActiveClient(DisconnectedClient.INSTANCE);
            if (this.enabled) {
                this.processes.setSelectedProcess(null);
            }
            Iterable $this$forEach$iv = notifications;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StatusNotification it = (StatusNotification)element$iv;
                boolean bl = false;
                this.notificationModel.addNotification(it.getId(), it.getMessage(), it.getStatus(), it.getActions(), it.getSticky());
            }
        }
    }

    private final void checkCancelled() {
        if (((Number)this.threadSequenceNumber.get()).intValue() < this.sequenceNumber) {
            throw new CancellationException("Launch thread preempted");
        }
    }

    @Nullable
    public final Job getLaunchJob() {
        return this.launchJob;
    }

    @VisibleForTesting
    public static /* synthetic */ void getLaunchJob$annotations() {
    }

    @NotNull
    public final InspectorClient getActiveClient() {
        return this.activeClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setActiveClient(InspectorClient value2) {
        InspectorClient $i$a$-synchronized-InspectorClientLauncher$activeClient$oldClient$22;
        if (Intrinsics.areEqual((Object)this.activeClient, (Object)value2)) {
            return;
        }
        Object object = this.sequenceNumberLock;
        synchronized (object) {
            boolean $i$a$-synchronized-InspectorClientLauncher$activeClient$oldClient$22 = false;
            this.checkCancelled();
            $i$a$-synchronized-InspectorClientLauncher$activeClient$oldClient$22 = this.activeClient;
        }
        InspectorClient oldClient = $i$a$-synchronized-InspectorClientLauncher$activeClient$oldClient$22;
        oldClient.disconnect();
        Disposer.dispose((Disposable)oldClient);
        object = this.sequenceNumberLock;
        synchronized (object) {
            boolean bl = false;
            this.checkCancelled();
            this.activeClient = value2;
            Unit unit = Unit.INSTANCE;
        }
        Iterable $this$forEach$iv = this.clientChangedCallbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 callback2 = (Function1)element$iv;
            boolean bl = false;
            callback2.invoke((Object)value2);
        }
        Job job2 = this.launchJob;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.launchJob = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(value2, this, null){
            int label;
            final /* synthetic */ InspectorClient $value;
            final /* synthetic */ InspectorClientLauncher this$0;
            {
                this.$value = $value;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$value.connect(InspectorClientLauncher.access$getProject$p(this.this$0), (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean value2) {
        block6: {
            if (this.enabled == value2) break block6;
            this.enabled = value2;
            if (!this.activeClient.isConnected() && value2) {
                ProcessDescriptor processDescriptor2 = this.processes.getSelectedProcess();
                if (processDescriptor2 != null) {
                    ProcessDescriptor runningProcess;
                    ProcessDescriptor processDescriptor3;
                    ProcessDescriptor process2 = processDescriptor2;
                    boolean bl = false;
                    ProcessDescriptor it = processDescriptor3 = process2;
                    boolean bl2 = false;
                    ProcessDescriptor processDescriptor4 = it.isRunning() ? processDescriptor3 : null;
                    if (processDescriptor4 == null) {
                        Object v2;
                        block5: {
                            Iterable $this$firstOrNull$iv = this.processes.getProcesses();
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                ProcessDescriptor it2 = (ProcessDescriptor)element$iv;
                                boolean bl3 = false;
                                if (!(it2.getPid() == process2.getPid() && it2.isRunning())) continue;
                                v2 = element$iv;
                                break block5;
                            }
                            v2 = null;
                        }
                        processDescriptor4 = v2;
                    }
                    if ((runningProcess = processDescriptor4) != null) {
                        this.processes.setSelectedProcess(null);
                        this.processes.setSelectedProcess(runningProcess);
                    }
                }
            }
        }
    }

    public final void addClientChangedListener(@NotNull Function1<? super InspectorClient, Unit> callback2) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        this.clientChangedCallbacks.add(callback2);
    }

    @TestOnly
    public final void disconnectActiveClient(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (this.activeClient.isConnected()) {
            CountDownLatch latch = new CountDownLatch(1);
            this.activeClient.registerStateCallback((Function1<? super InspectorClient.State, Unit>)((Function1)arg_0 -> InspectorClientLauncher.disconnectActiveClient$lambda$14(latch, arg_0)));
            this.activeClient.disconnect();
            latch.await(timeout, unit);
        }
    }

    public static /* synthetic */ void disconnectActiveClient$default(InspectorClientLauncher inspectorClientLauncher, long l, TimeUnit timeUnit, int n, Object object) {
        if ((n & 1) != 0) {
            l = Long.MAX_VALUE;
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        inspectorClientLauncher.disconnectActiveClient(l, timeUnit);
    }

    private static final int threadSequenceNumber$lambda$0() {
        return -1;
    }

    private static final Unit _init_$lambda$1(InspectorClientLauncher this$0, Executor $executor) {
        this$0.handleProcessInWorkerThread($executor, this$0.processes.getSelectedProcess());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void _init_$lambda$2(InspectorClientLauncher this$0) {
        ++this$0.sequenceNumber;
        this$0.threadSequenceNumber.set(this$0.sequenceNumber);
        try {
            this$0.setActiveClient(DisconnectedClient.INSTANCE);
        }
        finally {
            this$0.threadSequenceNumber.set(-1);
        }
    }

    private static final Unit handleProcessInWorkerThread$lambda$3(InspectorClientLauncher this$0, ProcessDescriptor $process) {
        try {
            this$0.handleProcess($process);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void handleProcessInWorkerThread$lambda$5$lambda$4(InspectorClientLauncher this$0, CountDownLatch $threadStartedLatch, Function0 $processHandler) {
        ++this$0.sequenceNumber;
        this$0.threadSequenceNumber.set(this$0.sequenceNumber);
        try {
            $threadStartedLatch.countDown();
            $processHandler.invoke();
        }
        finally {
            this$0.threadSequenceNumber.set(-1);
        }
    }

    private static final Unit handleProcess$lambda$6(Ref.BooleanRef $validClientConnected, CountDownLatch $latch, InspectorClient.State state2) {
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        if (state2 == InspectorClient.State.CONNECTED || state2 == InspectorClient.State.DISCONNECTED) {
            $validClientConnected.element = state2 == InspectorClient.State.CONNECTED;
            $latch.countDown();
        }
        return Unit.INSTANCE;
    }

    private static final Unit disconnectActiveClient$lambda$14(CountDownLatch $latch, InspectorClient.State state2) {
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        if (state2 == InspectorClient.State.DISCONNECTED) {
            $latch.countDown();
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Disposable access$getParentDisposable$p(InspectorClientLauncher $this) {
        return $this.parentDisposable;
    }

    public static final /* synthetic */ Project access$getProject$p(InspectorClientLauncher $this) {
        return $this.project;
    }

    public static final /* synthetic */ ThreadLocal access$getThreadSequenceNumber$p(InspectorClientLauncher $this) {
        return $this.threadSequenceNumber;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher$Companion;", "", "<init>", "()V", "createDefaultLauncher", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher;", "processes", "Lcom/android/tools/idea/appinspection/api/process/ProcessesModel;", "model", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "notificationModel", "Lcom/android/tools/idea/layoutinspector/model/NotificationModel;", "metrics", "Lcom/android/tools/idea/layoutinspector/metrics/LayoutInspectorSessionMetrics;", "treeSettings", "Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;", "inspectorClientSettings", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientSettings;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.android.layout-inspector"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InspectorClientLauncher createDefaultLauncher(@NotNull ProcessesModel processes, @NotNull InspectorModel model, @NotNull NotificationModel notificationModel, @NotNull LayoutInspectorSessionMetrics metrics, @NotNull TreeSettings treeSettings, @NotNull InspectorClientSettings inspectorClientSettings, @NotNull CoroutineScope coroutineScope, @NotNull Disposable parentDisposable) {
            List list;
            Intrinsics.checkNotNullParameter((Object)processes, (String)"processes");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)notificationModel, (String)"notificationModel");
            Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
            Intrinsics.checkNotNullParameter((Object)treeSettings, (String)"treeSettings");
            Intrinsics.checkNotNullParameter((Object)inspectorClientSettings, (String)"inspectorClientSettings");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            ClientFactory appInspectionInspectorClientFactory = arg_0 -> Companion.createDefaultLauncher$lambda$0(model, notificationModel, metrics, treeSettings, inspectorClientSettings, coroutineScope, parentDisposable, arg_0);
            ClientFactory legacyClientFactory = arg_0 -> Companion.createDefaultLauncher$lambda$1(model, notificationModel, metrics, coroutineScope, parentDisposable, arg_0);
            if (LayoutInspectorSettings.Companion.getInstance().getEmbeddedLayoutInspectorEnabled()) {
                list = CollectionsKt.listOf((Object)appInspectionInspectorClientFactory);
            } else {
                Object[] objectArray = new ClientFactory[]{appInspectionInspectorClientFactory, legacyClientFactory};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
            List launchers = list;
            return new InspectorClientLauncher(processes, launchers, model.getProject(), notificationModel, coroutineScope, parentDisposable, metrics, null, 128, null);
        }

        private static final InspectorClient createDefaultLauncher$lambda$0(InspectorModel $model, NotificationModel $notificationModel, LayoutInspectorSessionMetrics $metrics, TreeSettings $treeSettings, InspectorClientSettings $inspectorClientSettings, CoroutineScope $coroutineScope, Disposable $parentDisposable, Params params2) {
            Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
            return params2.getProcess().getDevice().getApiLevel().getMajorVersion() >= 29 ? (InspectorClient)new AppInspectionInspectorClient(params2.getProcess(), $model, $notificationModel, $metrics, $treeSettings, $inspectorClientSettings, $coroutineScope, $parentDisposable, null, null, null, 1792, null) : null;
        }

        private static final InspectorClient createDefaultLauncher$lambda$1(InspectorModel $model, NotificationModel $notificationModel, LayoutInspectorSessionMetrics $metrics, CoroutineScope $coroutineScope, Disposable $parentDisposable, Params params2) {
            Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
            return new LegacyClient(params2.getProcess(), $model, $notificationModel, $metrics, $coroutineScope, $parentDisposable, null, 64, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher$Params;", "", "process", "Lcom/android/tools/idea/appinspection/inspector/api/process/ProcessDescriptor;", "getProcess", "()Lcom/android/tools/idea/appinspection/inspector/api/process/ProcessDescriptor;", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "intellij.android.layout-inspector"})
    public static interface Params {
        @NotNull
        public ProcessDescriptor getProcess();

        @NotNull
        public Disposable getDisposable();
    }
}

