/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection;

import com.android.tools.idea.appinspection.api.process.ProcessesModel;
import com.android.tools.idea.appinspection.api.process.SimpleProcessListener;
import com.android.tools.idea.appinspection.inspector.api.process.DeviceDescriptor;
import com.android.tools.idea.appinspection.inspector.api.process.ProcessDescriptor;
import com.android.tools.idea.layoutinspector.metrics.ForegroundProcessDetectionMetrics;
import com.android.tools.idea.layoutinspector.metrics.LayoutInspectorMetrics;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.DeviceModel;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcess;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcessDetection;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcessDetectionImpl;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcessDetectionImplKt;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcessDetectionInitializer;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcessListener;
import com.android.tools.idea.transport.TransportClient;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.idea.transport.manager.TransportStreamManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\\\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\b2\b\b\u0002\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001eR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/foregroundprocessdetection/ForegroundProcessDetectionInitializer;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getDefaultForegroundProcessListener", "Lcom/android/tools/idea/layoutinspector/pipeline/foregroundprocessdetection/ForegroundProcessListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "deviceModel", "Lcom/android/tools/idea/layoutinspector/pipeline/foregroundprocessdetection/DeviceModel;", "processModel", "Lcom/android/tools/idea/appinspection/api/process/ProcessesModel;", "getDefaultTransportClient", "Lcom/android/tools/idea/transport/TransportClient;", "initialize", "Lcom/android/tools/idea/layoutinspector/pipeline/foregroundprocessdetection/ForegroundProcessDetection;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "streamManager", "Lcom/android/tools/idea/transport/manager/TransportStreamManager;", "foregroundProcessListener", "transportClient", "metrics", "Lcom/android/tools/idea/layoutinspector/metrics/ForegroundProcessDetectionMetrics;", "layoutInspectorMetrics", "Lcom/android/tools/idea/layoutinspector/metrics/LayoutInspectorMetrics;", "intellij.android.layout-inspector"})
public final class ForegroundProcessDetectionInitializer {
    @NotNull
    public static final ForegroundProcessDetectionInitializer INSTANCE = new ForegroundProcessDetectionInitializer();
    @NotNull
    private static final Logger logger;

    private ForegroundProcessDetectionInitializer() {
    }

    @VisibleForTesting
    @NotNull
    public final ForegroundProcessListener getDefaultForegroundProcessListener(@NotNull Disposable parentDisposable, @NotNull DeviceModel deviceModel, @NotNull ProcessesModel processModel) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)deviceModel, (String)"deviceModel");
        Intrinsics.checkNotNullParameter((Object)processModel, (String)"processModel");
        Ref.ObjectRef missingForegroundProcess = new Ref.ObjectRef();
        Object lock = new Object();
        SimpleProcessListener processListener2 = new SimpleProcessListener(lock, (Ref.ObjectRef<ForegroundProcess>)missingForegroundProcess, processModel){
            final /* synthetic */ Object $lock;
            final /* synthetic */ Ref.ObjectRef<ForegroundProcess> $missingForegroundProcess;
            final /* synthetic */ ProcessesModel $processModel;
            {
                this.$lock = $lock;
                this.$missingForegroundProcess = $missingForegroundProcess;
                this.$processModel = $processModel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onProcessConnected(ProcessDescriptor process2) {
                Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
                Object object = this.$lock;
                Ref.ObjectRef<ForegroundProcess> objectRef = this.$missingForegroundProcess;
                ProcessesModel processesModel = this.$processModel;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    ForegroundProcess foregroundProcess = (ForegroundProcess)objectRef.element;
                    boolean bl2 = foregroundProcess != null ? foregroundProcess.getPid() == process2.getPid() : false;
                    if (bl2) {
                        processesModel.setSelectedProcess(process2);
                        ForegroundProcessDetectionInitializer.access$getLogger$p().info("Foreground process restored to \"" + process2.getName() + "\" on device \"" + process2.getDevice().getManufacturer() + " " + process2.getDevice().getModel() + "\" API " + process2.getDevice().getApiLevel());
                        objectRef.element = null;
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }

            public void onProcessDisconnected(ProcessDescriptor process2) {
                Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
            }
        };
        processModel.addProcessListener(processListener2);
        Disposer.register((Disposable)parentDisposable, () -> ForegroundProcessDetectionInitializer.getDefaultForegroundProcessListener$lambda$0(processModel, processListener2));
        return (arg_0, arg_1, arg_2) -> ForegroundProcessDetectionInitializer.getDefaultForegroundProcessListener$lambda$2(lock, missingForegroundProcess, processModel, arg_0, arg_1, arg_2);
    }

    private final TransportClient getDefaultTransportClient() {
        TransportService.Companion.getInstance();
        return new TransportClient(TransportService.Companion.getChannelName());
    }

    @NotNull
    public final ForegroundProcessDetection initialize(@NotNull Disposable parentDisposable, @NotNull Project project, @NotNull ProcessesModel processModel, @NotNull DeviceModel deviceModel, @NotNull CoroutineScope coroutineScope, @NotNull TransportStreamManager streamManager, @NotNull ForegroundProcessListener foregroundProcessListener, @NotNull TransportClient transportClient, @NotNull ForegroundProcessDetectionMetrics metrics, @NotNull LayoutInspectorMetrics layoutInspectorMetrics) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)processModel, (String)"processModel");
        Intrinsics.checkNotNullParameter((Object)deviceModel, (String)"deviceModel");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)streamManager, (String)"streamManager");
        Intrinsics.checkNotNullParameter((Object)foregroundProcessListener, (String)"foregroundProcessListener");
        Intrinsics.checkNotNullParameter((Object)transportClient, (String)"transportClient");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        Intrinsics.checkNotNullParameter((Object)layoutInspectorMetrics, (String)"layoutInspectorMetrics");
        ForegroundProcessDetectionImpl foregroundProcessDetection = new ForegroundProcessDetectionImpl(parentDisposable, project, deviceModel, processModel, transportClient, layoutInspectorMetrics, metrics, coroutineScope, streamManager, null, null, 0L, 3584, null);
        foregroundProcessDetection.addForegroundProcessListener(foregroundProcessListener);
        processModel.addSelectedProcessListeners((Function0<Unit>)((Function0)() -> ForegroundProcessDetectionInitializer.initialize$lambda$3(processModel, deviceModel, foregroundProcessDetection)));
        return foregroundProcessDetection;
    }

    public static /* synthetic */ ForegroundProcessDetection initialize$default(ForegroundProcessDetectionInitializer foregroundProcessDetectionInitializer, Disposable disposable, Project project, ProcessesModel processesModel, DeviceModel deviceModel, CoroutineScope coroutineScope, TransportStreamManager transportStreamManager, ForegroundProcessListener foregroundProcessListener, TransportClient transportClient, ForegroundProcessDetectionMetrics foregroundProcessDetectionMetrics, LayoutInspectorMetrics layoutInspectorMetrics, int n, Object object) {
        if ((n & 0x40) != 0) {
            foregroundProcessListener = foregroundProcessDetectionInitializer.getDefaultForegroundProcessListener(disposable, deviceModel, processesModel);
        }
        if ((n & 0x80) != 0) {
            transportClient = foregroundProcessDetectionInitializer.getDefaultTransportClient();
        }
        if ((n & 0x200) != 0) {
            layoutInspectorMetrics = LayoutInspectorMetrics.INSTANCE;
        }
        return foregroundProcessDetectionInitializer.initialize(disposable, project, processesModel, deviceModel, coroutineScope, transportStreamManager, foregroundProcessListener, transportClient, foregroundProcessDetectionMetrics, layoutInspectorMetrics);
    }

    private static final void getDefaultForegroundProcessListener$lambda$0(ProcessesModel $processModel, getDefaultForegroundProcessListener.processListener.1 $processListener) {
        $processModel.removeProcessListener($processListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void getDefaultForegroundProcessListener$lambda$2(Object $lock, Ref.ObjectRef $missingForegroundProcess, ProcessesModel $processModel, DeviceDescriptor device2, ForegroundProcess foregroundProcess, boolean isDebuggable) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)foregroundProcess, (String)"foregroundProcess");
        Object object = $lock;
        synchronized (object) {
            boolean bl = false;
            if (isDebuggable) {
                $missingForegroundProcess.element = null;
                logger.info("Process descriptor found for foreground process \"" + foregroundProcess.getProcessName() + "\" on device \"" + device2.getManufacturer() + " " + device2.getModel() + " API " + device2.getApiLevel() + "\"");
            } else {
                $missingForegroundProcess.element = foregroundProcess;
                logger.info("Process descriptor not found for foreground process \"" + foregroundProcess.getProcessName() + "\" on device \"" + device2.getManufacturer() + " " + device2.getModel() + " API " + device2.getApiLevel() + "\"");
            }
            $processModel.setSelectedProcess(ForegroundProcessDetectionImplKt.matchToProcessDescriptor(foregroundProcess, $processModel));
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final Unit initialize$lambda$3(ProcessesModel $processModel, DeviceModel $deviceModel, ForegroundProcessDetectionImpl $foregroundProcessDetection) {
        DeviceDescriptor selectedProcessDevice;
        ProcessDescriptor processDescriptor2 = $processModel.getSelectedProcess();
        DeviceDescriptor deviceDescriptor = selectedProcessDevice = processDescriptor2 != null ? processDescriptor2.getDevice() : null;
        if (selectedProcessDevice != null && !Intrinsics.areEqual((Object)selectedProcessDevice, (Object)$deviceModel.getSelectedDevice())) {
            ForegroundProcessDetection.startPollingDevice$default($foregroundProcessDetection, selectedProcessDevice, false, 2, null);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        Logger logger = Logger.getInstance(ForegroundProcessDetectionInitializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ForegroundProcessDetectionInitializer.logger = logger;
    }
}

