/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.snapshots;

import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.LayoutInspectorKt;
import com.android.tools.idea.layoutinspector.metrics.LayoutInspectorSessionMetrics;
import com.android.tools.idea.layoutinspector.metrics.statistics.SessionStatistics;
import com.android.tools.idea.layoutinspector.metrics.statistics.SessionStatisticsImpl;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.NotificationModel;
import com.android.tools.idea.layoutinspector.pipeline.DisconnectedClient;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClientSettings;
import com.android.tools.idea.layoutinspector.properties.LayoutInspectorPropertiesPanelDefinition;
import com.android.tools.idea.layoutinspector.snapshots.FileEditorInspectorClient;
import com.android.tools.idea.layoutinspector.snapshots.LayoutInspectorFileEditor;
import com.android.tools.idea.layoutinspector.snapshots.LayoutInspectorFileType;
import com.android.tools.idea.layoutinspector.snapshots.SnapshotLoader;
import com.android.tools.idea.layoutinspector.snapshots.SnapshotLoaderException;
import com.android.tools.idea.layoutinspector.snapshots.SnapshotMetadata;
import com.android.tools.idea.layoutinspector.tree.EditorTreeSettings;
import com.android.tools.idea.layoutinspector.tree.LayoutInspectorTreePanelDefinition;
import com.android.tools.idea.layoutinspector.ui.DeviceViewPanel;
import com.android.tools.idea.layoutinspector.ui.InspectorBanner;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorAttachToProcess;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorEvent;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001(B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u000f\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0016J\n\u0010&\u001a\u0004\u0018\u00010'H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/layoutinspector/snapshots/LayoutInspectorFileEditor;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "path", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "metrics", "Lcom/android/tools/idea/layoutinspector/metrics/LayoutInspectorSessionMetrics;", "stats", "Lcom/android/tools/idea/layoutinspector/metrics/statistics/SessionStatistics;", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "dispose", "", "component", "Ljavax/swing/JComponent;", "modificationCount", "", "getComponent", "getPreferredFocusedComponent", "getName", "", "setState", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "isModified", "", "isValid", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "getCurrentLocation", "Lcom/intellij/openapi/fileEditor/FileEditorLocation;", "Provider", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nLayoutInspectorFileEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutInspectorFileEditor.kt\ncom/android/tools/idea/layoutinspector/snapshots/LayoutInspectorFileEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n1#2:239\n*E\n"})
public final class LayoutInspectorFileEditor
extends UserDataHolderBase
implements FileEditor {
    @NotNull
    private final Project project;
    @NotNull
    private final Path path;
    @Nullable
    private LayoutInspectorSessionMetrics metrics;
    @NotNull
    private SessionStatistics stats;
    @Nullable
    private JComponent component;
    private long modificationCount;

    public LayoutInspectorFileEditor(@NotNull Project project, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.project = project;
        this.path = path;
        this.stats = DisconnectedClient.INSTANCE.getStats();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public VirtualFile getFile() {
        return VfsUtil.findFile((Path)this.path, (boolean)true);
    }

    public void dispose() {
        block0: {
            LayoutInspectorSessionMetrics layoutInspectorSessionMetrics = this.metrics;
            if (layoutInspectorSessionMetrics == null) break block0;
            LayoutInspectorSessionMetrics.logEvent$default(layoutInspectorSessionMetrics, DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.SESSION_DATA, this.stats, null, null, 12, null);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent;
        VirtualFile virtualFile = this.getFile();
        if (this.modificationCount < (virtualFile != null ? virtualFile.getModificationCount() : -1L)) {
            this.component = null;
        }
        if ((jComponent = this.component) != null) {
            JComponent it = jComponent;
            boolean bl = false;
            return it;
        }
        VirtualFile virtualFile2 = this.getFile();
        this.modificationCount = virtualFile2 != null ? virtualFile2.getModificationCount() : -1L;
        JPanel contentPanel = new JPanel(new BorderLayout());
        WorkBench workbench = new WorkBench(this.project, "Layout Inspector Snapshot", null, (Disposable)this);
        SnapshotLoader snapshotLoader = null;
        long startTime = System.currentTimeMillis();
        Object metadata = null;
        try {
            NotificationModel notificationModel = new NotificationModel(this.project);
            contentPanel.add((Component)new InspectorBanner((Disposable)this, notificationModel), "North");
            contentPanel.add((Component)workbench, "Center");
            snapshotLoader = SnapshotLoader.Companion.createSnapshotLoader(this.path);
            CoroutineScope layoutInspectorCoroutineScope = CoroutineUtilsKt.AndroidCoroutineScope$default((Disposable)((Disposable)this), null, (int)2, null);
            InspectorModel model = new InspectorModel(this.project, layoutInspectorCoroutineScope, null, null, 12, null);
            this.stats = new SessionStatisticsImpl(DynamicLayoutInspectorAttachToProcess.ClientType.SNAPSHOT_CLIENT, null, null, null, 14, null);
            Object object = snapshotLoader;
            if (object == null || (object = object.loadFile(this.path, model, notificationModel, this.stats)) == null) {
                throw new Exception();
            }
            metadata = object;
            FileEditorInspectorClient client = new FileEditorInspectorClient(model, snapshotLoader, this.stats);
            EditorTreeSettings treeSettings = new EditorTreeSettings(client.getCapabilities());
            InspectorClientSettings inspectorClientSettings = new InspectorClientSettings(this.project);
            LayoutInspector layoutInspector = new LayoutInspector(layoutInspectorCoroutineScope, inspectorClientSettings, client, model, notificationModel, treeSettings, null, null, null, null, 960, null);
            DeviceViewPanel deviceViewPanel = new DeviceViewPanel(layoutInspector, (Disposable)workbench);
            DataManager.registerDataProvider((JComponent)((JComponent)workbench), (DataProvider)LayoutInspectorKt.dataProviderForLayoutInspector(layoutInspector));
            Object[] objectArray = new ToolWindowDefinition[]{new LayoutInspectorTreePanelDefinition(null, null, false, false, false, false, 63, null), new LayoutInspectorPropertiesPanelDefinition(null, null, false, false, false, false, 63, null)};
            workbench.init((JComponent)deviceViewPanel, (Object)layoutInspector, CollectionsKt.listOf((Object[])objectArray), false);
            ((SnapshotMetadata)metadata).setLoadDuration(System.currentTimeMillis() - startTime);
            model.updateConnection(client);
            StartupManager.getInstance((Project)this.project).runAfterOpened(() -> LayoutInspectorFileEditor.getComponent$lambda$2(deviceViewPanel));
            LayoutInspectorSessionMetrics layoutInspectorSessionMetrics = this.metrics = new LayoutInspectorSessionMetrics(this.project, snapshotLoader.getProcessDescriptor(), (SnapshotMetadata)metadata);
            if (layoutInspectorSessionMetrics != null) {
                LayoutInspectorSessionMetrics.logEvent$default(layoutInspectorSessionMetrics, DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.SNAPSHOT_LOADED, this.stats, null, null, 12, null);
            }
        }
        catch (Exception exception) {
            Logger.getInstance(LayoutInspectorFileEditor.class).warn("Error loading snapshot", (Throwable)exception);
            SnapshotLoader snapshotLoader2 = snapshotLoader;
            LayoutInspectorSessionMetrics.logEvent$default(new LayoutInspectorSessionMetrics(this.project, snapshotLoader2 != null ? snapshotLoader2.getProcessDescriptor() : null, (SnapshotMetadata)metadata), DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.SNAPSHOT_LOAD_ERROR, this.stats, null, null, 12, null);
            StatusText status2 = new StatusText(){

                protected boolean isStatusVisible() {
                    return true;
                }
            };
            status2.appendLine("Error loading snapshot");
            Object object = exception instanceof SnapshotLoaderException ? (SnapshotLoaderException)exception : null;
            if (object != null && (object = ((Throwable)object).getMessage()) != null) {
                Object it = object;
                boolean bl = false;
                status2.appendLine((String)it);
            }
            return new JPanel(status2, this){
                final /* synthetic */ getComponent.status.1 $status;
                {
                    this.$status = $status;
                    $status.attachTo(this);
                    LayoutInspectorFileEditor.access$setComponent$p($receiver, this);
                }

                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    this.$status.paint(this, g);
                }
            };
        }
        this.component = contentPanel;
        return contentPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        return "LayoutInspectorSnapshotViewer";
    }

    public void setState(@NotNull FileEditorState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    private static final Unit getComponent$lambda$2$lambda$1(DeviceViewPanel $deviceViewPanel) {
        $deviceViewPanel.zoom(ZoomType.FIT);
        return Unit.INSTANCE;
    }

    private static final void getComponent$lambda$2(DeviceViewPanel $deviceViewPanel) {
        ActionsKt.invokeLater((ModalityState)ModalityState.any(), () -> LayoutInspectorFileEditor.getComponent$lambda$2$lambda$1($deviceViewPanel));
    }

    public static final /* synthetic */ void access$setComponent$p(LayoutInspectorFileEditor $this, JComponent jComponent) {
        $this.component = jComponent;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/layoutinspector/snapshots/LayoutInspectorFileEditor$Provider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/android/tools/idea/layoutinspector/snapshots/LayoutInspectorFileEditor;", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "intellij.android.layout-inspector"})
    public static final class Provider
    implements FileEditorProvider,
    DumbAware {
        public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
            String string = file.getExtension();
            if (string == null) {
                string = "";
            }
            return Intrinsics.areEqual((Object)fileTypeRegistry.getFileTypeByExtension(string), (Object)LayoutInspectorFileType.INSTANCE);
        }

        @NotNull
        public LayoutInspectorFileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Path path = file.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
            return new LayoutInspectorFileEditor(project, path);
        }

        @NotNull
        public String getEditorTypeId() {
            return "dynamic-layout-inspector";
        }

        @NotNull
        public FileEditorPolicy getPolicy() {
            return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        }
    }
}

