/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.inspections;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.ModCommandLintQuickFix;
import com.android.tools.idea.lint.quickFixes.AddTargetApiQuickFix;
import com.android.tools.idea.lint.quickFixes.AddTargetVersionCheckQuickFix;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.VersionChecks;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.intentions.OverrideResourceAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidLintApiInspection
extends AndroidLintInspectionBase {
    public AndroidLintApiInspection(String displayName, Issue issue2) {
        super(displayName, issue2);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull Incident incident) {
        LintFix fixData = incident.getFix();
        if (fixData != null) {
            ApiConstraint requirement = LintFix.getApiConstraint((LintFix)fixData, (String)"requiresApi", (ApiConstraint)ApiConstraint.UNKNOWN);
            if (requirement != ApiConstraint.UNKNOWN) {
                List<LintIdeQuickFix> list = AndroidLintApiInspection.getApiConstraintFixes(startElement, requirement, fixData);
                return list.toArray(LintIdeQuickFix.EMPTY_ARRAY);
            }
            LintIdeQuickFix[] fixes = AndroidLintApiInspection.getCombinedFixes(startElement, incident, fixData);
            if (fixes == null) {
                assert (false) : "Unexpected API fix data: " + fixData;
            } else {
                return fixes;
            }
        }
        return super.getQuickFixes(startElement, endElement, incident);
    }

    private static LintIdeQuickFix @Nullable [] getCombinedFixes(@NotNull PsiElement startElement, @NotNull Incident incident, @NotNull LintFix fixData) {
        if (fixData instanceof LintFix.LintFixGroup) {
            LintFix.LintFixGroup group2 = (LintFix.LintFixGroup)fixData;
            if (group2.getType() != LintFix.GroupType.ALTERNATIVES) {
                return null;
            }
            List fixes = group2.getFixes();
            if (fixes.size() != 2) {
                return null;
            }
            LintIdeQuickFix[] quickFixes = AndroidLintApiInspection.createFixes((Project)startElement.getProject(), (PsiFile)startElement.getContainingFile(), (Incident)incident, (LintFix)((LintFix)fixes.get(0)));
            ApiConstraint requirement = LintFix.getApiConstraint((LintFix)((LintFix)fixes.get(1)), (String)"requiresApi", (ApiConstraint)ApiConstraint.UNKNOWN);
            if (requirement != ApiConstraint.UNKNOWN) {
                List<LintIdeQuickFix> list = AndroidLintApiInspection.getApiConstraintFixes(startElement, requirement, fixData);
                LintIdeQuickFix[] joined = new LintIdeQuickFix[quickFixes.length + list.size()];
                System.arraycopy(quickFixes, 0, joined, 0, quickFixes.length);
                for (int i = 0; i < list.size(); ++i) {
                    joined[i + quickFixes.length] = list.get(i);
                }
                return joined;
            }
            return quickFixes;
        }
        return AndroidLintApiInspection.createFixes((Project)startElement.getProject(), (PsiFile)startElement.getContainingFile(), (Incident)incident, (LintFix)fixData);
    }

    @NotNull
    private static List<LintIdeQuickFix> getApiConstraintFixes(@NotNull PsiElement startElement, @NotNull ApiConstraint requirement, @NotNull LintFix fixData) {
        int api = requirement.min();
        ArrayList<LintIdeQuickFix> list = new ArrayList<LintIdeQuickFix>();
        PsiFile file = startElement.getContainingFile();
        boolean isXml = false;
        if (file instanceof XmlFile) {
            FolderConfiguration config;
            isXml = true;
            ResourceFolderType folderType = IdeResourcesUtil.getFolderType(file);
            if (folderType != null && (config = IdeResourcesUtil.getFolderConfiguration(file)) != null) {
                config.setVersionQualifier(new VersionQualifier(api));
                String folder = config.getFolderName(folderType);
                list.add(OverrideResourceAction.createFix(folder));
            }
        }
        boolean requireClass = LintFix.getBoolean((LintFix)fixData, (String)"requireClass", (boolean)false);
        List constraints = requirement.getConstraints();
        Project project = startElement.getProject();
        if (!requireClass && !isXml) {
            ApiConstraint minSdk = LintFix.getApiConstraint((LintFix)fixData, (String)"minSdk", (ApiConstraint)ApiConstraint.UNKNOWN);
            for (ApiConstraint constraint : constraints) {
                int version2 = constraint.fromInclusive();
                int minor = constraint.fromInclusiveMinor();
                int sdk = constraint.getSdk();
                list.add((LintIdeQuickFix)new ModCommandLintQuickFix((ModCommandAction)new AddTargetVersionCheckQuickFix(project, startElement, version2, minor, sdk, minSdk)));
            }
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ApiConstraint.SdkApiConstraint first = (ApiConstraint.SdkApiConstraint)constraints.get(0);
        if (constraints.size() > 1) {
            if (AndroidLintApiInspection.requiresExtensionAvailable(project)) {
                list.add((LintIdeQuickFix)new ModCommandLintQuickFix((ModCommandAction)new AddTargetApiQuickFix(Collections.singletonList(first), true, startElement, requireClass)));
            }
        } else {
            int sdkId = first.getSdkId();
            if (sdkId == 0) {
                if (!isXml && AndroidLintApiInspection.requiresApiAvailable(project)) {
                    list.add((LintIdeQuickFix)new ModCommandLintQuickFix((ModCommandAction)new AddTargetApiQuickFix(constraints, true, startElement, requireClass)));
                } else if (first.fromInclusiveMinor() == 0) {
                    list.add((LintIdeQuickFix)new ModCommandLintQuickFix((ModCommandAction)new AddTargetApiQuickFix(constraints, false, startElement, requireClass)));
                }
            } else if (!isXml && AndroidLintApiInspection.requiresExtensionAvailable(project)) {
                list.add((LintIdeQuickFix)new ModCommandLintQuickFix((ModCommandAction)new AddTargetApiQuickFix(constraints, true, startElement, requireClass)));
            }
        }
        return list;
    }

    public static boolean requiresApiAvailable(Project project) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        return facade.findClass(VersionChecks.REQUIRES_API_ANNOTATION.oldName(), scope) != null || facade.findClass(VersionChecks.REQUIRES_API_ANNOTATION.newName(), scope) != null;
    }

    public static boolean requiresExtensionAvailable(Project project) {
        GlobalSearchScope scope;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        return facade.findClass("androidx.annotation.RequiresExtension", scope = GlobalSearchScope.allScope((Project)project)) != null;
    }
}

