/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.util.ReformatUtil;
import com.android.tools.res.LocalResourceRepository;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.uipreview.EditorUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/lint/quickFixes/GenerateMotionSceneFix;", "Lcom/android/tools/idea/lint/common/DefaultLintQuickFix;", "url", "Lcom/android/resources/ResourceUrl;", "<init>", "(Lcom/android/resources/ResourceUrl;)V", "getUrl", "()Lcom/android/resources/ResourceUrl;", "isApplicable", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "apply", "", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "findFirstWidgetId", "", "tag", "Lcom/intellij/psi/xml/XmlTag;", "generateMotionSceneContent", "widgetId", "intellij.android.lint"})
@SourceDebugExtension(value={"SMAP\nGenerateMotionSceneFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateMotionSceneFix.kt\ncom/android/tools/idea/lint/quickFixes/GenerateMotionSceneFix\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n11158#2:129\n11493#2,3:130\n1#3:133\n*S KotlinDebug\n*F\n+ 1 GenerateMotionSceneFix.kt\ncom/android/tools/idea/lint/quickFixes/GenerateMotionSceneFix\n*L\n102#1:129\n102#1:130,3\n*E\n"})
public final class GenerateMotionSceneFix
extends DefaultLintQuickFix {
    @NotNull
    private final ResourceUrl url;

    public GenerateMotionSceneFix(@NotNull ResourceUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        super("Generate MotionScene file");
        this.url = url;
    }

    @NotNull
    public final ResourceUrl getUrl() {
        return this.url;
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)contextType, (String)"contextType");
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)startElement);
        if (androidFacet == null) {
            return false;
        }
        AndroidFacet facet = androidFacet;
        LocalResourceRepository<VirtualFile> localResourceRepository = StudioResourceRepositoryManager.getAppResources(facet);
        Intrinsics.checkNotNullExpressionValue(localResourceRepository, (String)"getAppResources(...)");
        LocalResourceRepository<VirtualFile> appResources = localResourceRepository;
        return !appResources.getResources(ResourceNamespace.TODO(), ResourceType.XML).keySet().contains(this.url.name);
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = startElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)startElement);
        if (androidFacet == null) {
            return;
        }
        AndroidFacet facet = androidFacet;
        WriteCommandAction.runWriteCommandAction((Project)project2, (String)"Create MotionScene file", null, () -> GenerateMotionSceneFix.apply$lambda$0(startElement, this, facet, project2), (PsiFile[])new PsiFile[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final String findFirstWidgetId(XmlTag tag) {
        Object object;
        block6: {
            block5: {
                Object v1;
                block4: {
                    void $this$mapTo$iv$iv;
                    object = tag;
                    if (tag == null || (object = object.getSubTags()) == null) break block5;
                    XmlTag[] $this$map$iv = object;
                    boolean $i$f$map = false;
                    Object object2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection2 = destination$iv$iv;
                        boolean bl = false;
                        collection2.add(it.getAttributeValue("id", "http://schemas.android.com/apk/res/android"));
                    }
                    object2 = (List)destination$iv$iv;
                    Iterator iterator2 = object2.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        String it = (String)t;
                        boolean bl = false;
                        CharSequence charSequence = it;
                        if (!(!(charSequence == null || charSequence.length() == 0))) continue;
                        v1 = t;
                        break block4;
                    }
                    v1 = null;
                }
                if ((object = (String)v1) != null) break block6;
            }
            return null;
        }
        Object reference = object;
        ResourceUrl resourceUrl = ResourceUrl.parse((String)reference);
        return resourceUrl != null ? resourceUrl.name : null;
    }

    @Language(value="XML")
    private final String generateMotionSceneContent(String widgetId) {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<MotionScene\n        xmlns:android=\"http://schemas.android.com/apk/res/android\"\n        xmlns:app=\"http://schemas.android.com/apk/res-auto\">\n\n  <ConstraintSet android:id=\"@+id/start\">\n      <Constraint android:id=\"@+id/" + widgetId + "\"/>\n  </ConstraintSet>\n\n  <ConstraintSet android:id=\"@+id/end\">\n      <Constraint android:id=\"@id/" + widgetId + "\"/>\n  </ConstraintSet>\n\n  <Transition\n      app:constraintSetStart=\"@+id/start\"\n      app:constraintSetEnd=\"@id/end\" />\n</MotionScene>\n";
    }

    private static final void apply$lambda$0(PsiElement $startElement, GenerateMotionSceneFix this$0, AndroidFacet $facet, Project $project) {
        try {
            Class[] classArray = new Class[]{XmlTag.class};
            XmlTag motionTag = (XmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)$startElement, (Class[])classArray);
            String string = this$0.findFirstWidgetId(motionTag);
            if (string == null) {
                string = "widget";
            }
            String widgetId = string;
            VirtualFile virtualFile = ResourceFolderManager.Companion.getInstance($facet).getPrimaryFolder();
            if (virtualFile == null) {
                return;
            }
            VirtualFile primaryResourceDir = virtualFile;
            VirtualFile xmlDir = AndroidUtils.createChildDirectoryIfNotExist($project, primaryResourceDir, "xml");
            VirtualFile virtualFile2 = xmlDir.createChildData((Object)$project, this$0.url.name + ".xml");
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createChildData(...)");
            VirtualFile resFile = virtualFile2;
            VfsUtil.saveText((VirtualFile)resFile, (String)this$0.generateMotionSceneContent(widgetId));
            ReformatUtil.reformatAndRearrange$default($project, resFile, null, false, 12, null);
            EditorUtil.openEditor($project, resFile);
            EditorUtil.selectEditor($project, resFile);
            XmlTag xmlTag = motionTag;
            if (xmlTag != null) {
                xmlTag.setAttribute("layoutDescription", "http://schemas.android.com/apk/res-auto", this$0.url.toString());
            }
        }
        catch (IOException ex) {
            String string = "Failed to create file: %1$s";
            Object[] objectArray = new Object[]{ex.getMessage()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String error = string2;
            Messages.showErrorDialog((Project)$project, (String)error, (String)"Create MotionScene");
        }
    }
}

