/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.res.LocalResourceRepository;
import com.google.common.collect.Sets;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.psi.SearchUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class MigrateDrawableToMipmapFix
extends DefaultLintQuickFix {
    private final ResourceUrl myUrl;

    public MigrateDrawableToMipmapFix(@NotNull ResourceUrl url) {
        super("Convert " + url + " to @mipmap/" + url.name);
        this.myUrl = url;
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        Project project = startElement.getProject();
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)startElement);
        if (facet == null) {
            return;
        }
        ArrayList<PsiFile> bitmaps = new ArrayList<PsiFile>();
        HashSet references = Sets.newHashSet();
        GlobalSearchScope useScope = GlobalSearchScope.projectScope((Project)project);
        LocalResourceRepository<VirtualFile> projectResources = StudioResourceRepositoryManager.getProjectResources(facet);
        List resourceItems = projectResources.getResources(ResourceNamespace.TODO(), this.myUrl.type, this.myUrl.name);
        for (ResourceItem item : resourceItems) {
            PsiFile file = IdeResourcesUtil.getItemPsiFile(project, item);
            if (file == null) continue;
            bitmaps.add(file);
            Iterable allReferences = SearchUtils.findAllReferences((PsiElement)file, (SearchScope)useScope);
            for (PsiReference next : allReferences) {
                PsiElement element = next.getElement();
                if (element == null) continue;
                references.add(element);
            }
        }
        PsiField[] resourceFields = IdeResourcesUtil.findResourceFields(facet, ResourceType.DRAWABLE.getName(), this.myUrl.name);
        if (resourceFields.length == 1) {
            Iterable allReferences = SearchUtils.findAllReferences((PsiElement)resourceFields[0], (SearchScope)useScope);
            for (PsiReference next : allReferences) {
                PsiElement element = next.getElement();
                if (element == null) continue;
                references.add(element);
            }
        }
        HashSet applicableFiles = Sets.newHashSet();
        applicableFiles.addAll(bitmaps);
        for (PsiElement element : references) {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null) continue;
            applicableFiles.add(containingFile);
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])applicableFiles.toArray(PsiFile.EMPTY_ARRAY)).withName("Migrate Drawable to Bitmap").run(() -> {
            try {
                for (PsiFile bitmap : bitmaps) {
                    FolderConfiguration configuration2;
                    VirtualFile parent;
                    VirtualFile file = bitmap.getVirtualFile();
                    if (file == null || (parent = file.getParent()) == null) continue;
                    if (file.getFileType() == XmlFileType.INSTANCE && parent.getName().startsWith("values")) {
                        XmlFile xmlFile = (XmlFile)bitmap;
                        XmlTag root = xmlFile.getRootTag();
                        if (root == null) continue;
                        for (XmlTag item : root.getSubTags()) {
                            String name2 = item.getAttributeValue("name");
                            if (!this.myUrl.name.equals(name2)) continue;
                            if (ResourceType.DRAWABLE.getName().equals(item.getName())) {
                                item.setName(ResourceType.MIPMAP.getName());
                                continue;
                            }
                            if (!ResourceType.DRAWABLE.getName().equals(item.getAttributeValue("type"))) continue;
                            item.setAttribute("type", ResourceType.MIPMAP.getName());
                        }
                        continue;
                    }
                    VirtualFile res2 = parent.getParent();
                    if (res2 == null || (configuration2 = FolderConfiguration.getConfigForFolder((String)parent.getName())) == null) continue;
                    String targetFolderName = configuration2.getFolderName(ResourceFolderType.MIPMAP);
                    VirtualFile targetFolder = res2.findChild(targetFolderName);
                    if (targetFolder == null) {
                        targetFolder = res2.createChildDirectory((Object)this, targetFolderName);
                    }
                    file.move((Object)this, targetFolder);
                }
                for (PsiElement reference : references) {
                    PsiReferenceExpression outer;
                    PsiReferenceExpression inner;
                    PsiExpression qualifier;
                    if (reference instanceof XmlAttributeValue) {
                        XmlAttributeValue value2 = (XmlAttributeValue)reference;
                        XmlAttribute attribute2 = (XmlAttribute)value2.getParent();
                        attribute2.setValue(ResourceUrl.create((ResourceType)ResourceType.MIPMAP, (String)this.myUrl.name, (boolean)false).toString());
                        continue;
                    }
                    if (!(reference instanceof PsiReferenceExpression) || !((qualifier = (inner = (PsiReferenceExpression)reference).getQualifierExpression()) instanceof PsiReferenceExpression) || !((outer = (PsiReferenceExpression)qualifier).getReferenceNameElement() instanceof PsiIdentifier)) continue;
                    PsiIdentifier identifier = (PsiIdentifier)outer.getReferenceNameElement();
                    if (!ResourceType.DRAWABLE.getName().equals(identifier.getText())) continue;
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)reference.getProject());
                    PsiIdentifier newIdentifier = elementFactory.createIdentifier(ResourceType.MIPMAP.getName());
                    identifier.replace((PsiElement)newIdentifier);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return true;
    }
}

