/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.android.refactoring.UnusedResourcesProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedResourcesQuickFix
extends DefaultLintQuickFix {
    private final String myResource;

    public UnusedResourcesQuickFix(@Nullable String resource) {
        super((String)(resource != null ? "Remove Declarations for " + resource : "Remove All Unused Resources"));
        this.myResource = resource;
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        Project project = startElement.getProject();
        MyResourcesProcessorFilter filter2 = this.myResource != null ? new MyResourcesProcessorFilter(this.myResource) : null;
        UnusedResourcesProcessor processor = new UnusedResourcesProcessor(project, filter2, true);
        processor.run();
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static class MyResourcesProcessorFilter
    implements UnusedResourcesProcessor.Filter {
        @NotNull
        private final String myResource;

        MyResourcesProcessorFilter(@NotNull String resource) {
            this.myResource = resource;
        }

        @Override
        public boolean shouldProcessFile(@NotNull PsiFile psiFile) {
            return true;
        }

        @Override
        public boolean shouldProcessResource(@Nullable String resource) {
            return this.myResource.equals(resource);
        }
    }
}

