/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.filters;

import com.android.tools.idea.logcat.filters.FieldFilter;
import com.android.tools.idea.logcat.filters.LogcatFilterField;
import com.android.tools.idea.logcat.filters.LogcatFilterParseException;
import com.android.tools.idea.logcat.filters.LogcatMessageWrapper;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.impl.source.tree.PsiErrorElementImpl;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J1\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/logcat/filters/NegatedRegexFilter;", "Lcom/android/tools/idea/logcat/filters/FieldFilter;", "string", "", "field", "Lcom/android/tools/idea/logcat/filters/LogcatFilterField;", "matchCase", "", "textRange", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Ljava/lang/String;Lcom/android/tools/idea/logcat/filters/LogcatFilterField;ZLcom/intellij/openapi/util/TextRange;)V", "getString", "()Ljava/lang/String;", "getField", "()Lcom/android/tools/idea/logcat/filters/LogcatFilterField;", "getMatchCase", "()Z", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "regex", "Lkotlin/text/Regex;", "matches", "message", "Lcom/android/tools/idea/logcat/filters/LogcatMessageWrapper;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.android.logcat"})
public final class NegatedRegexFilter
extends FieldFilter {
    @NotNull
    private final String string;
    @NotNull
    private final LogcatFilterField field;
    private final boolean matchCase;
    @NotNull
    private final TextRange textRange;
    @NotNull
    private final Regex regex;

    public NegatedRegexFilter(@NotNull String string, @NotNull LogcatFilterField field2, boolean matchCase, @NotNull TextRange textRange) {
        Regex regex;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)((Object)field2), (String)"field");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        super(string, field2, textRange, "logcat.filter.completion.hint.key.regex.negated");
        this.string = string;
        this.field = field2;
        this.matchCase = matchCase;
        this.textRange = textRange;
        NegatedRegexFilter negatedRegexFilter = this;
        try {
            NegatedRegexFilter negatedRegexFilter2 = negatedRegexFilter;
            regex = this.matchCase ? new Regex(this.string) : new Regex(this.string, RegexOption.IGNORE_CASE);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            NegatedRegexFilter negatedRegexFilter3 = negatedRegexFilter;
            throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl("Invalid regular expression: " + this.string));
        }
        negatedRegexFilter2.regex = regex;
    }

    @NotNull
    public final String getString() {
        return this.string;
    }

    @NotNull
    public final LogcatFilterField getField() {
        return this.field;
    }

    public final boolean getMatchCase() {
        return this.matchCase;
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        return this.textRange;
    }

    @Override
    public boolean matches(@NotNull LogcatMessageWrapper message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return !this.regex.containsMatchIn((CharSequence)this.field.getValue(message));
    }

    @NotNull
    public final String component1() {
        return this.string;
    }

    @NotNull
    public final LogcatFilterField component2() {
        return this.field;
    }

    public final boolean component3() {
        return this.matchCase;
    }

    @NotNull
    public final TextRange component4() {
        return this.textRange;
    }

    @NotNull
    public final NegatedRegexFilter copy(@NotNull String string, @NotNull LogcatFilterField field2, boolean matchCase, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)((Object)field2), (String)"field");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        return new NegatedRegexFilter(string, field2, matchCase, textRange);
    }

    public static /* synthetic */ NegatedRegexFilter copy$default(NegatedRegexFilter negatedRegexFilter, String string, LogcatFilterField logcatFilterField, boolean bl, TextRange textRange, int n, Object object) {
        if ((n & 1) != 0) {
            string = negatedRegexFilter.string;
        }
        if ((n & 2) != 0) {
            logcatFilterField = negatedRegexFilter.field;
        }
        if ((n & 4) != 0) {
            bl = negatedRegexFilter.matchCase;
        }
        if ((n & 8) != 0) {
            textRange = negatedRegexFilter.textRange;
        }
        return negatedRegexFilter.copy(string, logcatFilterField, bl, textRange);
    }

    @NotNull
    public String toString() {
        return "NegatedRegexFilter(string=" + this.string + ", field=" + this.field + ", matchCase=" + this.matchCase + ", textRange=" + this.textRange + ")";
    }

    public int hashCode() {
        int result2 = this.string.hashCode();
        result2 = result2 * 31 + this.field.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.matchCase);
        result2 = result2 * 31 + this.textRange.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NegatedRegexFilter)) {
            return false;
        }
        NegatedRegexFilter negatedRegexFilter = (NegatedRegexFilter)other;
        if (!Intrinsics.areEqual((Object)this.string, (Object)negatedRegexFilter.string)) {
            return false;
        }
        if (this.field != negatedRegexFilter.field) {
            return false;
        }
        if (this.matchCase != negatedRegexFilter.matchCase) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.textRange, (Object)negatedRegexFilter.textRange);
    }
}

