/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.folding;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.logcat.folding.EditorFoldingDetectorKt;
import com.android.tools.idea.logcat.folding.ExceptionFolding;
import com.android.tools.idea.logcat.folding.FoldingDetector;
import com.intellij.execution.ConsoleFolding;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0017J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J \u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0015\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\r2\u0006\u0010\u0019\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/logcat/folding/EditorFoldingDetector;", "Lcom/android/tools/idea/logcat/folding/FoldingDetector;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "consoleFoldings", "", "Lcom/intellij/execution/ConsoleFolding;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Ljava/util/List;)V", "document", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "foldingModel", "Lcom/intellij/openapi/editor/FoldingModel;", "activeConsoleFoldings", "detectFoldings", "", "startLine", "", "endLine", "findPreviousRegion", "Lcom/intellij/openapi/editor/FoldRegion;", "folding", "line", "shouldFoldLine", "", "addFoldRegion", "getLineText", "", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nEditorFoldingDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorFoldingDetector.kt\ncom/android/tools/idea/logcat/folding/EditorFoldingDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n774#2:151\n865#2,2:152\n1557#2:155\n1628#2,3:156\n1#3:154\n*S KotlinDebug\n*F\n+ 1 EditorFoldingDetector.kt\ncom/android/tools/idea/logcat/folding/EditorFoldingDetector\n*L\n80#1:151\n80#1:152,2\n134#1:155\n134#1:156,3\n*E\n"})
public final class EditorFoldingDetector
implements FoldingDetector {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Document document;
    @NotNull
    private final FoldingModel foldingModel;
    @NotNull
    private final List<ConsoleFolding> activeConsoleFoldings;

    /*
     * WARNING - void declaration
     */
    public EditorFoldingDetector(@NotNull Project project, @NotNull Editor editor, @NotNull List<? extends ConsoleFolding> consoleFoldings) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(consoleFoldings, (String)"consoleFoldings");
        this.project = project;
        this.editor = editor;
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.document = document;
        FoldingModel foldingModel = this.editor.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModel, (String)"getFoldingModel(...)");
        this.foldingModel = foldingModel;
        Iterable iterable = consoleFoldings;
        EditorFoldingDetector editorFoldingDetector = this;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConsoleFolding it = (ConsoleFolding)element$iv$iv;
            boolean bl = false;
            if (!it.isEnabledForConsole((ConsoleView)EditorFoldingDetectorKt.access$getConsoleView$p())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        editorFoldingDetector.activeConsoleFoldings = (List)destination$iv$iv;
    }

    public /* synthetic */ EditorFoldingDetector(Project project, Editor editor, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.plus((Collection)ConsoleFolding.EP_NAME.getExtensionList(), (Object)((Object)new ExceptionFolding()));
        }
        this(project, editor, list);
    }

    @Override
    @UiThread
    public void detectFoldings(int startLine, int endLine) {
        if (this.activeConsoleFoldings.isEmpty()) {
            return;
        }
        WriteAction.run(() -> EditorFoldingDetector.detectFoldings$lambda$2(this, startLine, endLine));
    }

    private final FoldRegion findPreviousRegion(ConsoleFolding folding, int line, int startLine) {
        if (line == startLine && line > 0 && this.shouldFoldLine(folding, line - 1)) {
            FoldRegion region;
            FoldRegion foldRegion;
            FoldRegion[] foldRegionArray = this.foldingModel.getAllFoldRegions();
            Intrinsics.checkNotNullExpressionValue((Object)foldRegionArray, (String)"getAllFoldRegions(...)");
            FoldRegion foldRegion2 = (FoldRegion)ArraysKt.lastOrNull((Object[])foldRegionArray);
            if (foldRegion2 == null) {
                return null;
            }
            FoldRegion it = foldRegion = (region = foldRegion2);
            boolean bl = false;
            return this.document.getLineNumber(region.getEndOffset()) == line - 1 ? foldRegion : null;
        }
        return null;
    }

    private final boolean shouldFoldLine(ConsoleFolding folding, int line) {
        return folding.shouldFoldLine(this.project, this.getLineText(line));
    }

    /*
     * WARNING - void declaration
     */
    private final void addFoldRegion(ConsoleFolding folding, int startLine, int endLine) {
        block2: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)new IntRange(startLine, endLine);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void p0;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(this.getLineText((int)p0));
            }
            List lines = (List)destination$iv$iv;
            int it = this.document.getLineStartOffset(startLine);
            boolean bl = false;
            int startOffset = folding.shouldBeAttachedToThePreviousLine() && it > 0 ? it - 1 : it;
            int endOffset = this.document.getLineEndOffset(endLine);
            String string = folding.getPlaceholderText(this.project, lines);
            if (string == null) {
                return;
            }
            String placeholder = string;
            FoldRegion foldRegion = this.editor.getFoldingModel().addFoldRegion(startOffset, endOffset, placeholder);
            if (foldRegion == null) break block2;
            FoldRegion it2 = foldRegion;
            boolean bl2 = false;
            it2.setExpanded(false);
        }
    }

    private final String getLineText(int line) {
        String string = EditorHyperlinkSupport.getLineText((Document)this.document, (int)line, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLineText(...)");
        return string;
    }

    private static final void detectFoldings$lambda$2$lambda$1(EditorFoldingDetector this$0, int $startLine, int $endLine) {
        for (ConsoleFolding folding : this$0.activeConsoleFoldings) {
            int line = $startLine;
            while (line <= $endLine) {
                int n;
                if (!this$0.shouldFoldLine(folding, line)) {
                    ++line;
                    continue;
                }
                FoldRegion previousRegion = this$0.findPreviousRegion(folding, line, $startLine);
                if (previousRegion != null) {
                    int n2;
                    this$0.foldingModel.removeFoldRegion(previousRegion);
                    boolean bl = folding.shouldBeAttachedToThePreviousLine();
                    if (bl) {
                        n2 = previousRegion.getStartOffset() + 1;
                    } else if (!bl) {
                        n2 = previousRegion.getStartOffset();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    int startOffset = n2;
                    n = this$0.document.getLineNumber(startOffset);
                } else {
                    n = line;
                }
                int foldStartLine = n;
                ++line;
                while (line <= $endLine && this$0.shouldFoldLine(folding, line)) {
                    ++line;
                }
                this$0.addFoldRegion(folding, foldStartLine, line - 1);
            }
        }
    }

    private static final void detectFoldings$lambda$2(EditorFoldingDetector this$0, int $startLine, int $endLine) {
        this$0.foldingModel.runBatchFoldingOperation(() -> EditorFoldingDetector.detectFoldings$lambda$2$lambda$1(this$0, $startLine, $endLine));
    }
}

