/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.hyperlinks;

import com.android.tools.idea.logcat.hyperlinks.SimpleFileLinkFilterKt;
import com.android.tools.idea.logcat.util.LogcatLoggerKt;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfoFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiShortNamesCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/logcat/hyperlinks/SimpleFileLinkFilter;", "Lcom/intellij/execution/filters/Filter;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "hyperlinkInfoFactory", "Lcom/intellij/execution/filters/HyperlinkInfoFactory;", "Lorg/jetbrains/annotations/NotNull;", "fileNamesCache", "Lcom/intellij/psi/search/PsiShortNamesCache;", "kotlin.jvm.PlatformType", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nSimpleFileLinkFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleFileLinkFilter.kt\ncom/android/tools/idea/logcat/hyperlinks/SimpleFileLinkFilter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1148#2:77\n1317#2:78\n1318#2:84\n1149#2:85\n11158#3:79\n11493#3,3:80\n1#4:83\n*S KotlinDebug\n*F\n+ 1 SimpleFileLinkFilter.kt\ncom/android/tools/idea/logcat/hyperlinks/SimpleFileLinkFilter\n*L\n49#1:77\n49#1:78\n49#1:84\n49#1:85\n53#1:79\n53#1:80,3\n49#1:83\n*E\n"})
public final class SimpleFileLinkFilter
implements Filter,
DumbAware {
    @NotNull
    private final Project project;
    @NotNull
    private final HyperlinkInfoFactory hyperlinkInfoFactory;
    private final PsiShortNamesCache fileNamesCache;

    public SimpleFileLinkFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        HyperlinkInfoFactory hyperlinkInfoFactory = HyperlinkInfoFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)hyperlinkInfoFactory, (String)"getInstance(...)");
        this.hyperlinkInfoFactory = hyperlinkInfoFactory;
        this.fileNamesCache = PsiShortNamesCache.getInstance((Project)this.project);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        try {
            void destination$iv;
            void $this$mapNotNullTo$iv;
            Sequence matches = Regex.findAll$default((Regex)SimpleFileLinkFilterKt.access$getFileAndLineRegex$p(), (CharSequence)line, (int)0, (int)2, null);
            int offset = entireLength - line.length();
            Sequence sequence = matches;
            Collection collection2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Filter.ResultItem resultItem;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                MatchResult match = (MatchResult)element$iv;
                boolean bl2 = false;
                IntRange range = match.getRange();
                Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"filename");
                if (object == null || (object = object.getValue()) == null) {
                    resultItem = null;
                } else {
                    Object filename = object;
                    Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"line");
                    if (object2 == null || (object2 = object2.getValue()) == null || (object2 = StringsKt.toIntOrNull((String)object2)) == null) {
                        resultItem = null;
                    } else {
                        void $this$mapTo$iv$iv;
                        int lineNumber = (Integer)object2;
                        PsiFile[] psiFileArray = this.fileNamesCache.getFilesByName((String)filename);
                        Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFilesByName(...)");
                        Object[] $this$map$iv = psiFileArray;
                        boolean $i$f$map = false;
                        Object[] objectArray = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                        boolean $i$f$mapTo = false;
                        for (void item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            PsiFile psiFile = (PsiFile)item$iv$iv;
                            Collection collection3 = destination$iv$iv;
                            boolean bl3 = false;
                            collection3.add(it.getVirtualFile());
                        }
                        List files2 = (List)destination$iv$iv;
                        resultItem = files2.isEmpty() ? null : new Filter.ResultItem(offset + range.getFirst(), offset + range.getLast() + 1, this.hyperlinkInfoFactory.createMultipleFilesHyperlinkInfo(files2, lineNumber - 1, this.project));
                    }
                }
                if (resultItem == null) continue;
                Filter.ResultItem it$iv = resultItem;
                boolean bl4 = false;
                destination$iv.add(it$iv);
            }
            List items = (List)destination$iv;
            return items.isEmpty() ? null : new Filter.Result(items);
        }
        catch (Exception e) {
            if (e instanceof CancellationException) {
                throw e;
            }
            LogcatLoggerKt.getLOGGER().warn("Error detecting hyperlinks", (Throwable)e);
            return null;
        }
    }
}

