/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.marketing.chime;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.googleapis.GoogleApiKeyProvider;
import com.android.tools.idea.marketing.chime.ChimeApi;
import com.android.tools.idea.marketing.chime.HttpChimeApiKt;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.gson.Gson;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001f B!\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c*\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/marketing/chime/HttpChimeApi;", "Lcom/android/tools/idea/marketing/chime/ChimeApi;", "transport", "Lcom/google/api/client/http/HttpTransport;", "credentialFactory", "Lkotlin/Function0;", "Lcom/google/api/client/auth/oauth2/Credential;", "<init>", "(Lcom/google/api/client/http/HttpTransport;Lkotlin/jvm/functions/Function0;)V", "factory", "Lcom/google/api/client/http/HttpRequestFactory;", "getFactory", "()Lcom/google/api/client/http/HttpRequestFactory;", "getOptInStatus", "Lcom/android/tools/idea/marketing/chime/ChimeApi$OptInStatus;", "setOptInStatus", "", "status", "", "buildPostRequest", "Lcom/google/api/client/http/HttpRequest;", "path", "", "content", "Lcom/google/api/client/http/HttpContent;", "getUrl", "Lcom/google/api/client/http/GenericUrl;", "toJsonContent", "Lcom/google/api/client/http/json/JsonHttpContent;", "", "", "ChimeResponse", "PreferenceEntry", "marketing"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nHttpChimeApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpChimeApi.kt\ncom/android/tools/idea/marketing/chime/HttpChimeApi\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,145:1\n25#2:146\n25#2:147\n25#2:148\n*S KotlinDebug\n*F\n+ 1 HttpChimeApi.kt\ncom/android/tools/idea/marketing/chime/HttpChimeApi\n*L\n71#1:146\n78#1:147\n105#1:148\n*E\n"})
public final class HttpChimeApi
implements ChimeApi {
    @NotNull
    private final HttpTransport transport;
    @NotNull
    private final Function0<Credential> credentialFactory;
    public static final int $stable = 8;

    public HttpChimeApi(@NotNull HttpTransport transport, @NotNull Function0<? extends Credential> credentialFactory) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter(credentialFactory, (String)"credentialFactory");
        this.transport = transport;
        this.credentialFactory = credentialFactory;
    }

    public /* synthetic */ HttpChimeApi(HttpTransport httpTransport, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            httpTransport = (HttpTransport)new NetHttpTransport();
        }
        this(httpTransport, (Function0<? extends Credential>)function0);
    }

    private final HttpRequestFactory getFactory() {
        HttpRequestFactory httpRequestFactory = this.transport.createRequestFactory(arg_0 -> HttpChimeApi._get_factory_$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)httpRequestFactory, (String)"createRequestFactory(...)");
        return httpRequestFactory;
    }

    @Override
    @WorkerThread
    @NotNull
    public ChimeApi.OptInStatus getOptInStatus() {
        ChimeResponse e2;
        String string;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"client_id", (Object)"android_studio"), TuplesKt.to((Object)"preference_key", (Object)HttpChimeApiKt.access$getFULL_PREFERENCE_KEY$p())};
        Map content2 = MapsKt.mapOf((Pair[])pairArray);
        HttpRequest request = this.buildPostRequest("v1/fetchuserpreferences", (HttpContent)this.toJsonContent(content2));
        try {
            string = request.execute().parseAsString();
        }
        catch (IOException e2) {
            HttpChimeApi $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(HttpChimeApi.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Error while fetching user preference: " + e2.getMessage());
            return ChimeApi.OptInStatus.UNKNOWN;
        }
        String response2 = string;
        try {
            e2 = (ChimeResponse)new Gson().fromJson(response2, ChimeResponse.class);
        }
        catch (Exception e3) {
            HttpChimeApi $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(HttpChimeApi.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Error while parsing response: " + e3.getMessage());
            return ChimeApi.OptInStatus.UNKNOWN;
        }
        ChimeResponse parser = e2;
        List<PreferenceEntry> list = parser.getPreferenceResult();
        if (list == null || (list = (PreferenceEntry)CollectionsKt.firstOrNull(list)) == null) {
            return ChimeApi.OptInStatus.UNKNOWN;
        }
        List<PreferenceEntry> entry = list;
        return ((PreferenceEntry)((Object)entry)).getOptInStatus();
    }

    @Override
    @WorkerThread
    public void setOptInStatus(boolean status2) {
        String preference = status2 ? "NOTIFY" : "DROP";
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"client_id", (Object)"android_studio");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"preference_key", (Object)HttpChimeApiKt.access$getFULL_PREFERENCE_KEY$p()), TuplesKt.to((Object)"preference", (Object)preference)};
        pairArray[1] = TuplesKt.to((Object)"preference_entry", (Object)CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])pairArray2)));
        Map content2 = MapsKt.mapOf((Pair[])pairArray);
        HttpRequest request = this.buildPostRequest("v1/setuserpreference", (HttpContent)this.toJsonContent(content2));
        try {
            request.execute();
        }
        catch (IOException e) {
            HttpChimeApi $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(HttpChimeApi.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Error while setting user preference: " + e.getMessage());
        }
    }

    private final HttpRequest buildPostRequest(String path, HttpContent content2) {
        HttpRequest httpRequest = this.getFactory().buildPostRequest(this.getUrl(path), content2);
        Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"buildPostRequest(...)");
        return httpRequest;
    }

    private final GenericUrl getUrl(String path) {
        GenericUrl genericUrl;
        GenericUrl $this$getUrl_u24lambda_u241 = genericUrl = new GenericUrl("https://" + StudioFlags.CHIME_ENDPOINT.get() + "/" + path);
        boolean bl = false;
        $this$getUrl_u24lambda_u241.put("key", (Object)GoogleApiKeyProvider.Companion.getApiKey(GoogleApiKeyProvider.GoogleApi.CHIME));
        return genericUrl;
    }

    private final JsonHttpContent toJsonContent(Map<String, ? extends Object> $this$toJsonContent) {
        return new JsonHttpContent((JsonFactory)GsonFactory.getDefaultInstance(), $this$toJsonContent);
    }

    private static final void _get_factory_$lambda$0(HttpChimeApi this$0, HttpRequest it) {
        block0: {
            Credential credential = (Credential)this$0.credentialFactory.invoke();
            if (credential == null) break block0;
            credential.initialize(it);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001b\u0010\n\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/marketing/chime/HttpChimeApi$ChimeResponse;", "", "preferenceResult", "", "Lcom/android/tools/idea/marketing/chime/HttpChimeApi$PreferenceEntry;", "<init>", "(Ljava/util/List;)V", "getPreferenceResult", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "marketing"})
    private static final class ChimeResponse {
        @Nullable
        private final List<PreferenceEntry> preferenceResult;

        public ChimeResponse(@Nullable List<PreferenceEntry> preferenceResult) {
            this.preferenceResult = preferenceResult;
        }

        @Nullable
        public final List<PreferenceEntry> getPreferenceResult() {
            return this.preferenceResult;
        }

        @Nullable
        public final List<PreferenceEntry> component1() {
            return this.preferenceResult;
        }

        @NotNull
        public final ChimeResponse copy(@Nullable List<PreferenceEntry> preferenceResult) {
            return new ChimeResponse(preferenceResult);
        }

        public static /* synthetic */ ChimeResponse copy$default(ChimeResponse chimeResponse, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = chimeResponse.preferenceResult;
            }
            return chimeResponse.copy(list);
        }

        @NotNull
        public String toString() {
            return "ChimeResponse(preferenceResult=" + this.preferenceResult + ")";
        }

        public int hashCode() {
            return this.preferenceResult == null ? 0 : ((Object)this.preferenceResult).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChimeResponse)) {
                return false;
            }
            ChimeResponse chimeResponse = (ChimeResponse)other;
            return Intrinsics.areEqual(this.preferenceResult, chimeResponse.preferenceResult);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BE\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0017\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003JQ\u0010\u0019\u001a\u00020\u00002\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0004H\u00d6\u0001R\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/marketing/chime/HttpChimeApi$PreferenceEntry;", "", "preferenceKey", "", "", "preference", "source", "preferenceVersionTimestampUsec", "consentState", "<init>", "(Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getPreferenceKey", "()Ljava/util/Map;", "getPreference", "()Ljava/lang/String;", "getSource", "getPreferenceVersionTimestampUsec", "getConsentState", "getOptInStatus", "Lcom/android/tools/idea/marketing/chime/ChimeApi$OptInStatus;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "marketing"})
    private static final class PreferenceEntry {
        @Nullable
        private final Map<String, String> preferenceKey;
        @Nullable
        private final String preference;
        @Nullable
        private final String source;
        @Nullable
        private final String preferenceVersionTimestampUsec;
        @Nullable
        private final String consentState;

        public PreferenceEntry(@Nullable Map<String, String> preferenceKey, @Nullable String preference, @Nullable String source2, @Nullable String preferenceVersionTimestampUsec, @Nullable String consentState) {
            this.preferenceKey = preferenceKey;
            this.preference = preference;
            this.source = source2;
            this.preferenceVersionTimestampUsec = preferenceVersionTimestampUsec;
            this.consentState = consentState;
        }

        @Nullable
        public final Map<String, String> getPreferenceKey() {
            return this.preferenceKey;
        }

        @Nullable
        public final String getPreference() {
            return this.preference;
        }

        @Nullable
        public final String getSource() {
            return this.source;
        }

        @Nullable
        public final String getPreferenceVersionTimestampUsec() {
            return this.preferenceVersionTimestampUsec;
        }

        @Nullable
        public final String getConsentState() {
            return this.consentState;
        }

        @NotNull
        public final ChimeApi.OptInStatus getOptInStatus() {
            String string = this.preference;
            return Intrinsics.areEqual((Object)string, (Object)"NOTIFY") ? ChimeApi.OptInStatus.OPTED_IN : (Intrinsics.areEqual((Object)string, (Object)"DROP") ? (Intrinsics.areEqual((Object)this.source, (Object)"EXPLICIT_PREFERENCE") ? ChimeApi.OptInStatus.OPTED_OUT : ChimeApi.OptInStatus.DEFAULT) : ChimeApi.OptInStatus.UNKNOWN);
        }

        @Nullable
        public final Map<String, String> component1() {
            return this.preferenceKey;
        }

        @Nullable
        public final String component2() {
            return this.preference;
        }

        @Nullable
        public final String component3() {
            return this.source;
        }

        @Nullable
        public final String component4() {
            return this.preferenceVersionTimestampUsec;
        }

        @Nullable
        public final String component5() {
            return this.consentState;
        }

        @NotNull
        public final PreferenceEntry copy(@Nullable Map<String, String> preferenceKey, @Nullable String preference, @Nullable String source2, @Nullable String preferenceVersionTimestampUsec, @Nullable String consentState) {
            return new PreferenceEntry(preferenceKey, preference, source2, preferenceVersionTimestampUsec, consentState);
        }

        public static /* synthetic */ PreferenceEntry copy$default(PreferenceEntry preferenceEntry, Map map2, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = preferenceEntry.preferenceKey;
            }
            if ((n & 2) != 0) {
                string = preferenceEntry.preference;
            }
            if ((n & 4) != 0) {
                string2 = preferenceEntry.source;
            }
            if ((n & 8) != 0) {
                string3 = preferenceEntry.preferenceVersionTimestampUsec;
            }
            if ((n & 0x10) != 0) {
                string4 = preferenceEntry.consentState;
            }
            return preferenceEntry.copy(map2, string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "PreferenceEntry(preferenceKey=" + this.preferenceKey + ", preference=" + this.preference + ", source=" + this.source + ", preferenceVersionTimestampUsec=" + this.preferenceVersionTimestampUsec + ", consentState=" + this.consentState + ")";
        }

        public int hashCode() {
            int result2 = this.preferenceKey == null ? 0 : ((Object)this.preferenceKey).hashCode();
            result2 = result2 * 31 + (this.preference == null ? 0 : this.preference.hashCode());
            result2 = result2 * 31 + (this.source == null ? 0 : this.source.hashCode());
            result2 = result2 * 31 + (this.preferenceVersionTimestampUsec == null ? 0 : this.preferenceVersionTimestampUsec.hashCode());
            result2 = result2 * 31 + (this.consentState == null ? 0 : this.consentState.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PreferenceEntry)) {
                return false;
            }
            PreferenceEntry preferenceEntry = (PreferenceEntry)other;
            if (!Intrinsics.areEqual(this.preferenceKey, preferenceEntry.preferenceKey)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.preference, (Object)preferenceEntry.preference)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.source, (Object)preferenceEntry.source)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.preferenceVersionTimestampUsec, (Object)preferenceEntry.preferenceVersionTimestampUsec)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.consentState, (Object)preferenceEntry.consentState);
        }
    }
}

