/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.importmodel;

import com.android.ide.common.repository.WellKnownMavenArtifactId;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.mlkit.MlUtils;
import com.android.tools.idea.mlkit.importmodel.MlWizardModel;
import com.android.tools.idea.npw.template.components.ModuleTemplateComboProvider;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.projectsystem.AndroidModulePaths;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.ui.WizardUtils;
import com.android.tools.mlkit.ModelInfo;
import com.android.tools.mlkit.TfliteModelException;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseMlModelStep
extends ModelWizardStep<MlWizardModel> {
    private final BindingsManager myBindings = new BindingsManager();
    @NotNull
    private final ValidatorPanel myValidatorPanel;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myModelLocation;
    private ComboBox<NamedModuleTemplate> myFlavorBox;
    private JCheckBox myBasicCheckBox;
    private JTextArea myBasicTextArea;
    private JCheckBox myGpuCheckBox;
    private JTextArea myGpuTextArea;
    private HyperlinkLabel myLearnMoreLabel;

    public ChooseMlModelStep(@NotNull MlWizardModel model, @NotNull List<NamedModuleTemplate> moduleTemplates, @NotNull Project project, @NotNull String title2) {
        super(model, title2);
        this.setupUI();
        this.myModelLocation.addBrowseFolderListener(project, FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor().withTitle("Select TensorFlow Lite Model Location").withDescription("Select existing TensorFlow Lite model to import to ml folder"));
        for (NamedModuleTemplate namedModuleTemplate : moduleTemplates) {
            this.myFlavorBox.addItem((Object)namedModuleTemplate);
        }
        this.myLearnMoreLabel.setIcon(StudioIcons.Common.INFO);
        this.myLearnMoreLabel.setHyperlinkText("This is needed to ensure ML Model Binding works correctly ", "Learn more", "");
        this.myLearnMoreLabel.setHyperlinkTarget("https://developer.android.com/studio/write/mlmodelbinding");
        this.myBindings.bindTwoWay(new TextProperty(this.myModelLocation.getTextField()), model.sourceLocation);
        this.myBindings.bindTwoWay(new SelectedProperty(this.myBasicCheckBox), model.autoAddBasicSetup);
        this.myBindings.bindTwoWay(new SelectedProperty(this.myGpuCheckBox), model.autoAddGpuSetup);
        this.myBasicTextArea.setBackground(null);
        this.myBasicTextArea.setForeground((Color)JBColor.DARK_GRAY);
        this.myGpuTextArea.setBackground(null);
        this.myGpuTextArea.setForeground((Color)JBColor.DARK_GRAY);
        String basicText = this.getBasicInformationText();
        this.myBasicTextArea.setText(basicText);
        if (basicText.isEmpty()) {
            this.myBasicCheckBox.setVisible(false);
            this.myBasicTextArea.setVisible(false);
            model.autoAddBasicSetup.set(false);
        }
        String gpuText = this.getGpuInformationText();
        this.myGpuTextArea.setText(gpuText);
        if (gpuText.isEmpty()) {
            this.myGpuCheckBox.setVisible(false);
            this.myGpuTextArea.setVisible(false);
        }
        if (basicText.isEmpty() && gpuText.isEmpty()) {
            this.myLearnMoreLabel.setVisible(false);
        }
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        SelectedItemProperty selectedFavor = new SelectedItemProperty((JComboBox)this.myFlavorBox);
        Expression<File> locationFile = model.sourceLocation.transform(File::new);
        this.myValidatorPanel.registerValidator(locationFile, value2 -> this.checkPath((File)value2), new ObservableValue[]{selectedFavor});
        this.myValidatorPanel.setBorder(WizardUtils.WIZARD_BORDER.LARGE.border);
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myValidatorPanel);
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
    }

    @NotNull
    private String getBasicInformationText() {
        StringBuilder stringBuilder = new StringBuilder();
        Module module = ((MlWizardModel)this.getModel()).getModule();
        if (!MlUtils.isMlModelBindingBuildFeatureEnabled(module)) {
            stringBuilder.append("buildFeatures {\n  mlModelBinding true\n}\n\n");
        }
        for (WellKnownMavenArtifactId id2 : MlUtils.getMissingRequiredDependencies(module)) {
            stringBuilder.append(id2).append("\n");
        }
        return stringBuilder.toString();
    }

    @NotNull
    private String getGpuInformationText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (WellKnownMavenArtifactId id2 : MlUtils.getMissingTfliteGpuDependencies(((MlWizardModel)this.getModel()).getModule())) {
            stringBuilder.append(id2).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    @Override
    protected void onProceeding() {
        super.onProceeding();
        File mlDirectory = ChooseMlModelStep.getMlDirectory(((NamedModuleTemplate)this.myFlavorBox.getSelectedItem()).component2());
        ((MlWizardModel)this.getModel()).mlDirectory.set(mlDirectory.getAbsolutePath());
    }

    @NotNull
    @VisibleForTesting
    Validator.Result checkPath(@NotNull File file) {
        VirtualFile existingFile;
        if (!file.isFile()) {
            return new Validator.Result(Validator.Severity.ERROR, "Select a TensorFlow Lite model file to import.");
        }
        if (file.length() > 0xC800000L) {
            return new Validator.Result(Validator.Severity.ERROR, "This file is larger than the maximum supported size of 200 MB.");
        }
        if (!ChooseMlModelStep.isValidTfliteModel(file)) {
            return new Validator.Result(Validator.Severity.ERROR, "This is not a valid TensorFlow Lite model file.");
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
        if (Objects.equals(virtualFile, existingFile = this.findExistingModelFile(file.getName()))) {
            return new Validator.Result(Validator.Severity.ERROR, "This model file is already part of your project.");
        }
        if (existingFile != null && existingFile.exists()) {
            return new Validator.Result(Validator.Severity.WARNING, "File already exists in your project and will be overridden. If you would like to upload it as a separate file, please rename it.");
        }
        return Validator.Result.OK;
    }

    @Nullable
    private VirtualFile findExistingModelFile(@NotNull String fileName) {
        VirtualFile directory = VfsUtil.findFileByIoFile((File)ChooseMlModelStep.getMlDirectory(((NamedModuleTemplate)this.myFlavorBox.getSelectedItem()).component2()), (boolean)false);
        if (directory == null || !directory.exists()) {
            return null;
        }
        return directory.findChild(fileName);
    }

    private void setupUI() {
        this.createUIComponents();
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(9, 4, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.setMinimumSize(new Dimension(200, 109));
        this.myModelLocation = new TextFieldWithBrowseButton();
        this.myModelLocation.setName("Location Browser Button");
        this.myPanel.add((Component)this.myModelLocation, new GridConstraints(1, 1, 1, 3, 0, 1, 5, 0, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Model location:");
        this.myPanel.add((Component)jBLabel1, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(8, 2, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Create ml directory in");
        this.myPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myPanel.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 2, 1, 3, null, new Dimension(-1, 60), new Dimension(-1, 60), 0, false));
        this.myPanel.add((Component)this.myFlavorBox, new GridConstraints(2, 2, 1, 1, 8, 0, 2, 3, null, null, null, 0, false));
        this.myBasicCheckBox = new JCheckBox();
        this.myBasicCheckBox.setSelected(true);
        this.myBasicCheckBox.setText("Automatically add build feature and dependencies to build.gradle");
        this.myPanel.add((Component)this.myBasicCheckBox, new GridConstraints(3, 0, 1, 4, 8, 0, 0, 0, null, null, null, 0, false));
        this.myBasicTextArea = new JTextArea();
        this.myBasicTextArea.setMargin(new Insets(0, 2, 0, 0));
        this.myPanel.add((Component)this.myBasicTextArea, new GridConstraints(4, 0, 1, 4, 8, 2, 0, 3, null, null, null, 2, false));
        this.myLearnMoreLabel = new HyperlinkLabel();
        this.myLearnMoreLabel.setAlignmentY(0.0f);
        this.myLearnMoreLabel.setText("");
        this.myPanel.add((Component)this.myLearnMoreLabel, new GridConstraints(7, 0, 1, 4, 9, 0, 0, 1, null, null, null, 2, false));
        this.myGpuCheckBox = new JCheckBox();
        this.myGpuCheckBox.setSelected(false);
        this.myGpuCheckBox.setText("Automatically add TensorFlow Lite GPU dependencies to build.gradle (optional)");
        this.myPanel.add((Component)this.myGpuCheckBox, new GridConstraints(5, 0, 1, 4, 8, 0, 0, 0, null, null, null, 0, false));
        this.myGpuTextArea = new JTextArea();
        this.myGpuTextArea.setMargin(new Insets(0, 2, 0, 0));
        this.myGpuTextArea.setText("");
        this.myPanel.add((Component)this.myGpuTextArea, new GridConstraints(6, 0, 1, 4, 8, 2, 0, 3, null, null, null, 2, false));
    }

    public JComponent getRootComponent() {
        return this.myPanel;
    }

    private static File getMlDirectory(AndroidModulePaths androidModulePaths) {
        List<File> mlDirectories = androidModulePaths.getMlModelsDirectories();
        if (!mlDirectories.isEmpty()) {
            return mlDirectories.get(0);
        }
        return new File(androidModulePaths.getManifestDirectory(), "ml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isValidTfliteModel(@NotNull File file) {
        if (!file.getName().endsWith(".tflite")) {
            return false;
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
        if (virtualFile == null) {
            return false;
        }
        try {
            byte[] bytes = null;
            try {
                bytes = virtualFile.contentsToByteArray();
            }
            catch (FileTooBigException e) {
                bytes = Files.readAllBytes(file.toPath());
            }
            finally {
                if (bytes == null) {
                    return false;
                }
                ModelInfo.buildFrom((ByteBuffer)ByteBuffer.wrap(bytes));
            }
        }
        catch (TfliteModelException | IOException | RuntimeException e) {
            Logger.getInstance(ChooseMlModelStep.class).warn("Exception when parsing TensorFlow Lite model: " + file.getName(), e);
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myValidatorPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myModelLocation;
    }

    private void createUIComponents() {
        this.myFlavorBox = new ModuleTemplateComboProvider(Collections.emptyList()).createComponent();
    }
}

