/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator;

import com.android.tools.idea.projectsystem.IdeaSourceProvider;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.tools.idea.projectsystem.SourceProviders;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.project.Project;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidViewNodes {
    public void refresh(@NotNull Project project) {
        ProjectView projectView = ProjectView.getInstance((Project)project);
        AbstractProjectViewPane androidViewPane = projectView.getProjectViewPaneById("AndroidView");
        assert (androidViewPane != null);
        androidViewPane.updateFromRoot(true);
    }

    @NotNull
    public static Iterable<NamedIdeaSourceProvider> getSourceProviders(@NotNull AndroidFacet facet) {
        SourceProviders sourceProviderManager = SourceProviderManager.getInstance(facet);
        return AndroidViewNodes.getSourceProviders(sourceProviderManager);
    }

    @NotNull
    public static Iterable<NamedIdeaSourceProvider> getSourceProviders(@NotNull SourceProviders sourceProviders) {
        return Iterables.concat(sourceProviders.getCurrentSourceProviders(), (Iterable)Iterables.concat(sourceProviders.getCurrentHostTestSourceProviders().values()), (Iterable)Iterables.concat(sourceProviders.getCurrentDeviceTestSourceProviders().values()), sourceProviders.getCurrentTestFixturesSourceProviders());
    }

    @NotNull
    public static Iterable<IdeaSourceProvider> getGeneratedSourceProviders(@NotNull SourceProviders sourceProviders) {
        return Iterables.concat((Iterable)ImmutableList.of((Object)sourceProviders.getGeneratedSources()), sourceProviders.getGeneratedHostTestSources().values(), sourceProviders.getGeneratedDeviceTestSources().values(), (Iterable)ImmutableList.of((Object)sourceProviders.getGeneratedTestFixturesSources()));
    }
}

