/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.Dimension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionBarIconGenerator
extends IconGenerator {
    public static final Theme DEFAULT_THEME = Theme.HOLO_LIGHT;
    public static final Color DEFAULT_CUSTOM_COLOR = new Color(3388901);
    private static final Color HOLO_LIGHT_COLOR = new Color(0x333333);
    private static final Color HOLO_DARK_COLOR = new Color(0xFFFFFF);
    private static final Dimension ICON_SIZE = new Dimension(24, 24);
    private final ObjectProperty<Theme> myTheme = new ObjectValueProperty<Theme>(DEFAULT_THEME);
    private final ObjectProperty<Color> myCustomColor = new ObjectValueProperty<Color>(DEFAULT_CUSTOM_COLOR);

    public ActionBarIconGenerator(@NotNull Project project, int minSdkVersion2, @Nullable DrawableRenderer renderer2) {
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, renderer2));
    }

    @NotNull
    public ObjectProperty<Theme> theme() {
        return this.myTheme;
    }

    @NotNull
    public ObjectProperty<Color> customColor() {
        return this.myCustomColor;
    }

    @Override
    @NotNull
    public IconGenerator.IconOptions createOptions(boolean forPreview) {
        IconGenerator.IconOptions options = new IconGenerator.IconOptions(forPreview);
        BaseAsset asset = this.sourceAsset().getValueOrNull();
        if (asset != null) {
            Color color;
            double paddingFactor = (double)((Integer)asset.paddingPercent().get()).intValue() / 100.0;
            double scaleFactor = 1.0 / (1.0 + paddingFactor * 2.0);
            asset.opacityPercent().set(switch ((Theme)((Object)this.myTheme.get())) {
                case Theme.HOLO_DARK -> {
                    color = HOLO_DARK_COLOR;
                    yield 80;
                }
                case Theme.HOLO_LIGHT -> {
                    color = HOLO_LIGHT_COLOR;
                    yield 60;
                }
                case Theme.CUSTOM -> {
                    color = (Color)this.myCustomColor.get();
                    yield 80;
                }
                default -> {
                    color = null;
                    yield 100;
                }
            });
            options.image = new TransformedImageAsset(asset, ICON_SIZE, scaleFactor, color, this.getGraphicGeneratorContext(), this.myLineSeparator);
        }
        return options;
    }

    @Override
    @NotNull
    public AnnotatedImage generateRasterImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options) {
        return this.generateRasterImage(ICON_SIZE, options);
    }

    public static enum Theme {
        HOLO_DARK,
        HOLO_LIGHT,
        CUSTOM;

    }
}

