/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.resources.Density;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.project.Project;
import com.intellij.util.ExceptionUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AdaptiveIconGenerator
extends IconGenerator {
    public static final Color DEFAULT_FOREGROUND_COLOR = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(4054148);
    private final BoolProperty myShowSafeZone = new BoolValueProperty(true);
    private final ObjectProperty<Color> myBackgroundColor = new ObjectValueProperty<Color>(DEFAULT_BACKGROUND_COLOR);
    private final OptionalProperty<ImageAsset> myBackgroundImageAsset = new OptionalValueProperty<ImageAsset>();
    private final OptionalProperty<BaseAsset> myMonochromeImageAsset = new OptionalValueProperty<BaseAsset>();
    private final StringProperty myForegroundLayerName = new StringValueProperty();
    private final StringProperty myBackgroundLayerName = new StringValueProperty();
    private final StringProperty myMonochromeLayerName = new StringValueProperty();
    private final BoolProperty myGenerateLegacyIcon = new BoolValueProperty(true);

    public AdaptiveIconGenerator(@NotNull Project project, int minSdkVersion2, @NotNull GraphicGeneratorContext context) {
        super(project, minSdkVersion2, context);
    }

    @NotNull
    public ObjectProperty<Color> backgroundColor() {
        return this.myBackgroundColor;
    }

    @NotNull
    public OptionalProperty<ImageAsset> backgroundImageAsset() {
        return this.myBackgroundImageAsset;
    }

    @NotNull
    public OptionalProperty<BaseAsset> monochromeImageAsset() {
        return this.myMonochromeImageAsset;
    }

    @NotNull
    public StringProperty foregroundLayerName() {
        return this.myForegroundLayerName;
    }

    @NotNull
    public StringProperty backgroundLayerName() {
        return this.myBackgroundLayerName;
    }

    @NotNull
    public StringProperty monochromeLayerName() {
        return this.myMonochromeLayerName;
    }

    @NotNull
    public BoolProperty generateLegacyIcon() {
        return this.myGenerateLegacyIcon;
    }

    @NotNull
    protected String getAdaptiveIconXml(@NotNull AdaptiveIconOptions options) {
        String foregroundType;
        String backgroundType = options.backgroundImage == null ? "color" : (options.backgroundImage.isDrawable() ? "drawable" : "mipmap");
        String string = foregroundType = options.foregroundImage != null && options.foregroundImage.isDrawable() ? "drawable" : "mipmap";
        if (this.isMonochromeSupported()) {
            return this.generateXmlStringWithMonochromeTag(options, foregroundType, backgroundType);
        }
        return this.generateXmlString(options, foregroundType, backgroundType);
    }

    @NotNull
    private String generateXmlStringWithMonochromeTag(@NotNull AdaptiveIconOptions options, String foregroundType, String backgroundType) {
        String monochromeLayerName = options.foregroundLayerName;
        String monochromeType = foregroundType;
        if (options.monochromeImage != null) {
            monochromeType = options.monochromeImage.isDrawable() ? "drawable" : "mipmap";
            monochromeLayerName = options.monochromeLayerName;
        }
        String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>%1$s<adaptive-icon xmlns:android=\"http://schemas.android.com/apk/res/android\">%1$s    <background android:drawable=\"@%2$s/%3$s\"/>%1$s    <foreground android:drawable=\"@%4$s/%5$s\"/>%1$s    <monochrome android:drawable=\"@%6$s/%7$s\"/>%1$s</adaptive-icon>";
        return String.format(format, this.myLineSeparator, backgroundType, options.backgroundLayerName, foregroundType, options.foregroundLayerName, monochromeType, monochromeLayerName);
    }

    @NotNull
    private String generateXmlString(@NotNull AdaptiveIconOptions options, String foregroundType, String backgroundType) {
        String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>%1$s<adaptive-icon xmlns:android=\"http://schemas.android.com/apk/res/android\">%1$s    <background android:drawable=\"@%2$s/%3$s\"/>%1$s    <foreground android:drawable=\"@%4$s/%5$s\"/>%1$s</adaptive-icon>";
        return String.format(format, this.myLineSeparator, backgroundType, options.backgroundLayerName, foregroundType, options.foregroundLayerName);
    }

    public static double getRectangleInsideScale(@NotNull Rectangle source2, @NotNull Rectangle destination) {
        double scaleWidth = destination.getWidth() / source2.getWidth();
        double scaleHeight = destination.getHeight() / source2.getHeight();
        return Math.min(scaleWidth, scaleHeight);
    }

    @NotNull
    protected static BufferedImage scaledImage(@NotNull BufferedImage image, double scale) {
        int width = AssetStudioUtils.roundToInt((double)image.getWidth() * scale);
        int height = AssetStudioUtils.roundToInt((double)image.getHeight() * scale);
        return AssetUtil.scaledImage((BufferedImage)image, (int)width, (int)height);
    }

    @NotNull
    protected static BufferedImage scaledPreviewImage(@NotNull BufferedImage image, double scale) {
        int width = AssetStudioUtils.roundToInt((double)image.getWidth() * scale);
        int height = AssetStudioUtils.roundToInt((double)image.getHeight() * scale);
        return AdaptiveIconGenerator.scaledPreviewImage(image, width, height);
    }

    @NotNull
    private static BufferedImage scaledPreviewImage(@NotNull BufferedImage source2, int width, int height) {
        if (source2.getWidth() == width && source2.getHeight() == height) {
            return source2;
        }
        BufferedImage scaledBufImage = AssetUtil.newArgbBufferedImage((int)width, (int)height);
        Graphics2D g = scaledBufImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(source2, 0, 0, width, height, null);
        g.dispose();
        return scaledBufImage;
    }

    @NotNull
    protected static AnnotatedImage mergeLayers(@NotNull Layers layers, @Nullable Color fillColor) {
        BufferedImage backgroundImage = layers.background.getImage();
        BufferedImage foregroundImage = layers.foreground.getImage();
        int width = Math.max(backgroundImage.getWidth(), foregroundImage.getWidth());
        int height = Math.max(backgroundImage.getHeight(), foregroundImage.getHeight());
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)width, (int)height);
        Graphics2D gOut = (Graphics2D)outImage.getGraphics();
        if (fillColor != null) {
            gOut.setPaint(fillColor);
            gOut.fillRect(0, 0, width, height);
        }
        gOut.drawImage((Image)backgroundImage, 0, 0, null);
        gOut.drawImage((Image)foregroundImage, 0, 0, null);
        gOut.dispose();
        String errorMessage = layers.foreground.getErrorMessage();
        if (errorMessage == null) {
            errorMessage = layers.background.getErrorMessage();
        }
        return new AnnotatedImage(outImage, errorMessage);
    }

    @NotNull
    private Layers generateIconLayers(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        AnnotatedImage backgroundImage = this.generateIconBackgroundLayer(context, options);
        AnnotatedImage foregroundImage = this.generateIconForegroundLayer(context, options);
        return new Layers(backgroundImage, foregroundImage);
    }

    @NotNull
    protected AnnotatedImage generateMergedLayers(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options, @Nullable Color fillColor) {
        Layers layers = this.generateIconLayers(context, options);
        return AdaptiveIconGenerator.mergeLayers(layers, fillColor);
    }

    @NotNull
    public BoolProperty showSafeZone() {
        return this.myShowSafeZone;
    }

    @NotNull
    protected abstract Rectangle getFullBleedRectangle(@NotNull AdaptiveIconOptions var1);

    @NotNull
    protected abstract Rectangle getViewportRectangle(@NotNull AdaptiveIconOptions var1);

    @NotNull
    protected abstract Rectangle getLegacyRectangle(@NotNull AdaptiveIconOptions var1);

    protected abstract boolean isMonochromeSupported();

    @NotNull
    protected AnnotatedImage generateIconBackgroundLayer(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        BufferedImage image;
        if (options.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        String errorMessage = null;
        Rectangle imageRect = this.getFullBleedRectangle(options);
        TransformedImageAsset imageAsset = options.backgroundImage;
        if (imageAsset == null) {
            image = AdaptiveIconGenerator.generateFlatColorRectangle(new Color(options.backgroundColor), imageRect);
        } else {
            try {
                image = this.generateIconLayer(context, imageAsset, imageRect, false, 0, !options.generateOutputIcons);
            }
            catch (RuntimeException e) {
                errorMessage = AdaptiveIconGenerator.composeErrorMessage(e, "background", imageAsset);
                image = imageAsset.createErrorImage(imageRect.getSize());
            }
        }
        return new AnnotatedImage(image, errorMessage);
    }

    @NotNull
    protected AnnotatedImage generateIconForegroundLayer(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        BufferedImage image;
        if (options.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        String errorMessage = null;
        Rectangle imageRect = this.getFullBleedRectangle(options);
        TransformedImageAsset imageAsset = options.foregroundImage;
        if (imageAsset == null) {
            image = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        } else {
            try {
                image = this.generateIconLayer(context, imageAsset, imageRect, options.useForegroundColor, options.foregroundColor, !options.generateOutputIcons);
            }
            catch (RuntimeException e) {
                errorMessage = AdaptiveIconGenerator.composeErrorMessage(e, "foreground", imageAsset);
                image = imageAsset.createErrorImage(imageRect.getSize());
            }
        }
        return new AnnotatedImage(image, errorMessage);
    }

    @NotNull
    protected AnnotatedImage generateIconMonochromeLayer(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        BufferedImage image;
        if (options.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        String errorMessage = null;
        Rectangle imageRect = this.getFullBleedRectangle(options);
        TransformedImageAsset imageAsset = options.monochromeImage;
        if (imageAsset == null) {
            image = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        } else {
            try {
                image = this.generateIconLayer(context, imageAsset, imageRect, options.useMonochromeColor, options.monochromeColor, !options.generateOutputIcons);
            }
            catch (RuntimeException e) {
                errorMessage = AdaptiveIconGenerator.composeErrorMessage(e, "monochrome", imageAsset);
                image = imageAsset.createErrorImage(imageRect.getSize());
            }
        }
        return new AnnotatedImage(image, errorMessage);
    }

    @NotNull
    private static String composeErrorMessage(@NotNull Exception e, @NotNull String role, @NotNull TransformedImageAsset imageAsset) {
        String errorMessage = imageAsset.isDrawable() ? String.format("Unable to generate image, possibly invalid %s drawable", role) : String.format("Failed to transform %s image", role);
        String exceptionMessage = e.getMessage();
        return exceptionMessage == null ? errorMessage : errorMessage + ": " + exceptionMessage;
    }

    protected BufferedImage cropImageToViewport(@NotNull AdaptiveIconOptions options, @NotNull BufferedImage image) {
        return AdaptiveIconGenerator.cropImage(image, this.getViewportRectangle(options));
    }

    private static BufferedImage cropImage(@NotNull BufferedImage image, @NotNull Rectangle targetRect) {
        int width = Math.min(targetRect.width, image.getWidth());
        int height = Math.min(targetRect.height, image.getHeight());
        BufferedImage subImage = image.getSubimage((image.getWidth() - width) / 2, (image.getHeight() - height) / 2, width, height);
        BufferedImage viewportImage = AssetUtil.newArgbBufferedImage((int)width, (int)height);
        Graphics2D gViewport = (Graphics2D)viewportImage.getGraphics();
        gViewport.drawImage((Image)subImage, 0, 0, null);
        gViewport.dispose();
        return viewportImage;
    }

    @NotNull
    private static BufferedImage generateFlatColorRectangle(@NotNull Color color, @NotNull Rectangle imageRect) {
        BufferedImage result2 = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)result2.getGraphics();
        gTemp.setPaint(color);
        gTemp.fillRect(0, 0, imageRect.width, imageRect.height);
        gTemp.dispose();
        return result2;
    }

    @NotNull
    protected static BufferedImage applyMask(@NotNull BufferedImage image, @Nullable BufferedImage mask) {
        if (mask == null) {
            return image;
        }
        Rectangle imageRect = new Rectangle(0, 0, image.getWidth(), image.getHeight());
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)tempImage.getGraphics();
        AssetUtil.drawCentered((Graphics2D)gTemp, (BufferedImage)mask, (Rectangle)imageRect);
        gTemp.setComposite(AlphaComposite.SrcIn);
        AssetUtil.drawCentered((Graphics2D)gTemp, (BufferedImage)image, (Rectangle)imageRect);
        gTemp.dispose();
        return tempImage;
    }

    @NotNull
    private BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull TransformedImageAsset sourceImage, @NotNull Rectangle imageRect, boolean useFillColor, int fillColor, boolean forPreview) {
        String scaledDrawable = sourceImage.getTransformedDrawable();
        if (scaledDrawable != null) {
            return AdaptiveIconGenerator.generateIconLayer(context, scaledDrawable, imageRect);
        }
        BufferedImage trimmedImage = sourceImage.getTrimmedImage();
        if (trimmedImage != null) {
            return this.generateIconLayer(context, trimmedImage, imageRect, sourceImage.getScaleFactor(), useFillColor, fillColor, forPreview);
        }
        return AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
    }

    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull String xmlDrawable, @NotNull Rectangle imageRect) {
        Future<BufferedImage> imageFuture = context.renderDrawable(xmlDrawable, imageRect.getSize());
        try {
            BufferedImage image = imageFuture.get();
            if (image != null) {
                return image;
            }
        }
        catch (ExecutionException e) {
            ExceptionUtil.rethrow((Throwable)e.getCause());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
    }

    @NotNull
    private BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull BufferedImage sourceImage, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int fillColor, boolean forPreview) {
        if (forPreview && (double)Math.max(sourceImage.getWidth(), sourceImage.getHeight()) > this.getMaxIconRectangle().getWidth() * 1.5) {
            sourceImage = AdaptiveIconGenerator.generateIconLayer(context, sourceImage, this.getMaxIconRectangle(), 1.0, false, 0);
        }
        return AdaptiveIconGenerator.generateIconLayer(context, sourceImage, imageRect, scaleFactor, useFillColor, fillColor);
    }

    protected abstract Rectangle getMaxIconRectangle();

    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull BufferedImage sourceImage, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int fillColor) {
        Callable<Future> generator = () -> FutureUtils.executeOnPooledThread(() -> {
            BufferedImage iconImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
            Graphics2D gIcon = (Graphics2D)iconImage.getGraphics();
            Rectangle rect = AssetStudioUtils.scaleRectangleAroundCenter(imageRect, scaleFactor);
            AssetUtil.drawCenterInside((Graphics2D)gIcon, (BufferedImage)sourceImage, (Rectangle)rect);
            gIcon.dispose();
            if (!useFillColor) {
                return iconImage;
            }
            BufferedImage effectImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
            Graphics2D gEffect = (Graphics2D)effectImage.getGraphics();
            AssetUtil.Effect[] effects = new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color(fillColor), 1.0)};
            AssetUtil.drawEffects((Graphics2D)gEffect, (BufferedImage)iconImage, (int)0, (int)0, (AssetUtil.Effect[])effects);
            gEffect.dispose();
            return effectImage;
        });
        class CacheKey {
            @NotNull
            private final Object mySource;
            @NotNull
            private final Rectangle myImageRect;
            private final int myScaleFactorTimes1000;
            private final boolean myUseFillColor;
            private final int myFillColor;

            CacheKey(@NotNull Object source2, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int fillColor) {
                this.mySource = source2;
                this.myImageRect = imageRect;
                this.myScaleFactorTimes1000 = AssetStudioUtils.roundToInt(scaleFactor * 1000.0);
                this.myUseFillColor = useFillColor;
                this.myFillColor = fillColor;
            }

            public int hashCode() {
                return Objects.hash(this.mySource, this.myImageRect, this.myScaleFactorTimes1000, this.myUseFillColor, this.myFillColor);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof CacheKey)) {
                    return false;
                }
                CacheKey other = (CacheKey)obj;
                return Objects.equals(this.mySource, other.mySource) && Objects.equals(this.myImageRect, other.myImageRect) && this.myScaleFactorTimes1000 == other.myScaleFactorTimes1000 && this.myUseFillColor == other.myUseFillColor && this.myFillColor == other.myFillColor;
            }
        }
        CacheKey cacheKey = new CacheKey(sourceImage, imageRect, scaleFactor, useFillColor, fillColor);
        Future<BufferedImage> imageFuture = context.getFromCacheOrCreate(cacheKey, generator);
        return (BufferedImage)Futures.getUnchecked(imageFuture);
    }

    public static class AdaptiveIconOptions
    extends IconGenerator.IconOptions
    implements Cloneable {
        public String foregroundLayerName;
        public String backgroundLayerName;
        public String monochromeLayerName;
        public boolean useForegroundColor = true;
        public boolean useMonochromeColor;
        public int foregroundColor = 0;
        public int monochromeColor = 0;
        @Nullable
        public TransformedImageAsset foregroundImage;
        @Nullable
        public TransformedImageAsset monochromeImage;
        public int backgroundColor = 0;
        @Nullable
        public TransformedImageAsset backgroundImage;
        public boolean generateLegacyIcon = true;
        public Density previewDensity;
        public boolean showSafeZone;

        public AdaptiveIconOptions(boolean forPreview) {
            super(forPreview);
            this.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        }

        @Override
        @NotNull
        public AdaptiveIconOptions clone() {
            return (AdaptiveIconOptions)super.clone();
        }
    }

    private static class Layers {
        @NotNull
        public AnnotatedImage background;
        @NotNull
        public AnnotatedImage foreground;

        Layers(@NotNull AnnotatedImage background, @NotNull AnnotatedImage foreground) {
            this.background = background;
            this.foreground = foreground;
        }
    }
}

