/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.AdaptiveIconGenerator;
import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.PrimitiveShapesHelper;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TvChannelIconGenerator
extends AdaptiveIconGenerator {
    private static final Rectangle IMAGE_SIZE_FULL_BLEED_DP = new Rectangle(0, 0, 120, 120);
    private static final Dimension SIZE_FULL_BLEED_DP = IMAGE_SIZE_FULL_BLEED_DP.getSize();
    private static final Rectangle IMAGE_SIZE_SAFE_ZONE_DP = new Rectangle(0, 0, 73, 73);
    private static final Rectangle IMAGE_SIZE_VIEWPORT_DP = new Rectangle(0, 0, 80, 80);
    private static final Rectangle IMAGE_SIZE_LEGACY_DP = new Rectangle(0, 0, 80, 80);
    private static final Density LEGACY_DENSITY = Density.XHIGH;
    private static final double PREVIEW_SCALE = 0.6;

    public TvChannelIconGenerator(@NotNull Project project, int minSdkVersion2, @Nullable DrawableRenderer renderer2) {
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, renderer2));
    }

    @Override
    @NotNull
    public TvChannelIconOptions createOptions(boolean forPreview) {
        ImageAsset backgroundAsset;
        double scaleFactor;
        TvChannelIconOptions options = new TvChannelIconOptions(forPreview);
        BaseAsset foregroundAsset = this.sourceAsset().getValueOrNull();
        if (foregroundAsset != null) {
            Color color;
            options.useForegroundColor = foregroundAsset.isColorable();
            Color color2 = color = foregroundAsset.isColorable() ? (Color)foregroundAsset.color().getValueOrNull() : null;
            if (color != null) {
                options.foregroundColor = color.getRGB();
            }
            scaleFactor = (double)((Integer)foregroundAsset.scalingPercent().get()).intValue() / 100.0;
            if (foregroundAsset instanceof ImageAsset && ((ImageAsset)foregroundAsset).isClipart()) {
                scaleFactor *= 0.58;
            } else if (foregroundAsset instanceof TextAsset) {
                scaleFactor *= 0.46;
            } else if (((Boolean)foregroundAsset.trimmed().get()).booleanValue()) {
                scaleFactor *= IMAGE_SIZE_SAFE_ZONE_DP.getWidth() / SIZE_FULL_BLEED_DP.getWidth();
            }
            options.foregroundImage = new TransformedImageAsset(foregroundAsset, SIZE_FULL_BLEED_DP, scaleFactor, color, this.getGraphicGeneratorContext(), this.myLineSeparator);
        }
        if ((backgroundAsset = this.backgroundImageAsset().getValueOrNull()) != null) {
            scaleFactor = (double)((Integer)backgroundAsset.scalingPercent().get()).intValue() / 100.0;
            options.backgroundImage = new TransformedImageAsset(backgroundAsset, SIZE_FULL_BLEED_DP, scaleFactor, null, this.getGraphicGeneratorContext(), this.myLineSeparator);
        }
        options.backgroundColor = ((Color)this.backgroundColor().get()).getRGB();
        options.showSafeZone = (Boolean)this.showSafeZone().get();
        options.previewDensity = LEGACY_DENSITY;
        options.foregroundLayerName = (String)this.foregroundLayerName().get();
        options.backgroundLayerName = (String)this.backgroundLayerName().get();
        options.generateLegacyIcon = (Boolean)this.generateLegacyIcon().get();
        return options;
    }

    @Override
    @NotNull
    protected List<Callable<GeneratedIcon>> createIconGenerationTasks(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options, @NotNull String name2) {
        TvChannelIconOptions launcherIconOptions = (TvChannelIconOptions)options;
        ArrayList<Callable<GeneratedIcon>> tasks = new ArrayList<Callable<GeneratedIcon>>();
        this.createOutputIconsTasks(context, name2, launcherIconOptions, tasks);
        this.createXmlDrawableResourcesTasks(name2, launcherIconOptions, tasks);
        this.createPreviewImagesTasks(context, launcherIconOptions, tasks);
        return tasks;
    }

    private void createOutputIconsTasks(@NotNull GraphicGeneratorContext context, @NotNull String name2, @NotNull TvChannelIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (!options.generateOutputIcons) {
            return;
        }
        TvChannelIconOptions localOptions = options.clone();
        localOptions.density = LEGACY_DENSITY;
        this.createOutputIconsForSingleDensityTasks(context, name2, localOptions, localOptions.density, tasks);
    }

    private void createOutputIconsForSingleDensityTasks(@NotNull GraphicGeneratorContext context, @NotNull String name2, @NotNull TvChannelIconOptions options, @NotNull Density density, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (options.foregroundImage != null && options.foregroundImage.isRasterImage()) {
            tasks.add(() -> {
                TvChannelIconOptions foregroundOptions = options.clone();
                foregroundOptions.generatePreviewIcons = false;
                foregroundOptions.generateOutputIcons = true;
                AnnotatedImage foregroundImage = this.generateIconForegroundLayer(context, foregroundOptions);
                return new GeneratedImageIcon(foregroundOptions.foregroundLayerName, new PathString(this.getIconPath(foregroundOptions, options.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, density, foregroundImage);
            });
        }
        if (options.backgroundImage != null && options.backgroundImage.isRasterImage()) {
            tasks.add(() -> {
                TvChannelIconOptions backgroundOptions = options.clone();
                backgroundOptions.generatePreviewIcons = false;
                backgroundOptions.generateOutputIcons = true;
                AnnotatedImage backgroundImage = this.generateIconBackgroundLayer(context, backgroundOptions);
                return new GeneratedImageIcon(backgroundOptions.backgroundLayerName, new PathString(this.getIconPath(backgroundOptions, options.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, density, backgroundImage);
            });
        }
        if (options.generateLegacyIcon) {
            tasks.add(() -> {
                TvChannelIconOptions legacyOptions = options.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                AnnotatedImage legacy = this.generateLegacyImage(context, legacyOptions);
                return new GeneratedImageIcon(name2, new PathString(this.getIconPath(legacyOptions, name2)), IconCategory.LEGACY, density, legacy);
            });
        }
    }

    private void createXmlDrawableResourcesTasks(@NotNull String name2, @NotNull TvChannelIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        TransformedImageAsset image;
        if (!options.generateOutputIcons) {
            return;
        }
        TvChannelIconOptions iconOptions = options.clone();
        iconOptions.density = Density.ANYDPI;
        iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        iconOptions.apiVersion = 26;
        tasks.add(() -> {
            String xmlAdaptiveIcon = this.getAdaptiveIconXml(iconOptions);
            return new GeneratedXmlResource(name2, new PathString(this.getIconPath(iconOptions, name2)), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        if (options.foregroundImage != null && options.foregroundImage.isDrawable()) {
            image = options.foregroundImage;
            tasks.add(() -> {
                String xmlDrawableText;
                TvChannelIconOptions iconOptions = options.clone();
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                if (!image.isDrawable()) {
                    TvChannelIconGenerator.getLog().error("Background image is not drawable!", new Throwable());
                }
                if ((xmlDrawableText = image.getTransformedDrawable()) == null) {
                    TvChannelIconGenerator.getLog().error("Transformed foreground drawable is null" + (image.isDrawable() ? " but the image is drawable" : ""), new Throwable());
                    xmlDrawableText = "<vector/>";
                }
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name2, new PathString(this.getIconPath(iconOptions, iconOptions.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, xmlDrawableText);
            });
        }
        if (options.backgroundImage != null && options.backgroundImage.isDrawable()) {
            image = options.backgroundImage;
            tasks.add(() -> {
                String xmlDrawableText;
                TvChannelIconOptions iconOptions = options.clone();
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                if (!image.isDrawable()) {
                    TvChannelIconGenerator.getLog().error("Background image is not drawable!", new Throwable());
                }
                if ((xmlDrawableText = image.getTransformedDrawable()) == null) {
                    TvChannelIconGenerator.getLog().error("Transformed background drawable is null" + (image.isDrawable() ? " but the image is drawable" : ""), new Throwable());
                    xmlDrawableText = "<vector/>";
                }
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name2, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, xmlDrawableText);
            });
        } else if (options.backgroundImage == null) {
            tasks.add(() -> {
                TvChannelIconOptions iconOptions = options.clone();
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.VALUES;
                String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>%1$s<resources>%1$s    <color name=\"%2$s\">#%3$06X</color>%1$s</resources>";
                String xmlColor = String.format(format, this.myLineSeparator, iconOptions.backgroundLayerName, iconOptions.backgroundColor & 0xFFFFFF);
                return new GeneratedXmlResource(name2, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.XML_RESOURCE, xmlColor);
            });
        }
    }

    private void createPreviewImagesTasks(@NotNull GraphicGeneratorContext context, @NotNull TvChannelIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (!options.generatePreviewIcons) {
            return;
        }
        ArrayList<PreviewShape> previewShapes = new ArrayList<PreviewShape>(2);
        previewShapes.add(PreviewShape.ADAPTIVE);
        if (options.generateLegacyIcon) {
            previewShapes.add(PreviewShape.LEGACY);
        }
        for (PreviewShape previewShape : previewShapes) {
            tasks.add(() -> {
                AnnotatedImage image;
                TvChannelIconOptions localOptions = options.clone();
                localOptions.density = options.previewDensity;
                localOptions.previewShape = previewShape;
                localOptions.generateLegacyIcon = previewShape == PreviewShape.LEGACY;
                try {
                    image = this.generatePreviewImage(context, localOptions);
                }
                catch (Throwable e) {
                    TvChannelIconGenerator.getLog().error(e);
                    image = TvChannelIconGenerator.createPlaceholderErrorImage(e, localOptions);
                }
                return new GeneratedImageIcon(previewShape.id, null, IconCategory.PREVIEW, localOptions.density, image);
            });
        }
    }

    @Override
    public void generateRasterImage(@Nullable String category, @NotNull Map<String, Map<String, AnnotatedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options, @NotNull String name2) {
        TvChannelIconOptions launcherIconOptions = (TvChannelIconOptions)options;
        TvChannelIconOptions localOptions = launcherIconOptions.clone();
        Collection<GeneratedIcon> icons = this.generateIcons(context, options, name2);
        icons.stream().filter(icon -> icon instanceof GeneratedImageIcon).map(icon -> (GeneratedImageIcon)icon).filter(icon -> icon.getOutputPath() != null).forEach(icon -> {
            assert (icon.getOutputPath() != null);
            Map imageMap = categoryMap.computeIfAbsent(icon.getCategory().toString(), k -> new LinkedHashMap());
            TvChannelIconOptions iconOptions = localOptions.clone();
            iconOptions.density = icon.getDensity();
            iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
            imageMap.put(icon.getOutputPath().toString(), new AnnotatedImage(icon.getImage(), icon.getErrorMessage()));
        });
    }

    @Override
    @NotNull
    public AnnotatedImage generateRasterImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options) {
        if (options.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        return this.generatePreviewImage(context, (TvChannelIconOptions)options);
    }

    @NotNull
    private AnnotatedImage generatePreviewImage(@NotNull GraphicGeneratorContext context, @NotNull TvChannelIconOptions options) {
        switch (options.previewShape) {
            case ADAPTIVE: {
                return this.generateViewportPreviewImage(context, options);
            }
            case LEGACY: {
                return this.generateLegacyImage(context, options);
            }
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    private AnnotatedImage generateLegacyImage(@NotNull GraphicGeneratorContext context, @NotNull TvChannelIconOptions options) {
        AnnotatedImage mergedImage = this.generateMergedLayers(context, options, null);
        BufferedImage image = this.cropImageToViewport(options, mergedImage.getImage());
        if (options.generatePreviewIcons && options.showSafeZone) {
            TvChannelIconGenerator.drawSafeZone(image);
        }
        return new AnnotatedImage(image, mergedImage.getErrorMessage());
    }

    @NotNull
    private AnnotatedImage generateViewportPreviewImage(@NotNull GraphicGeneratorContext context, @NotNull TvChannelIconOptions options) {
        AnnotatedImage mergedImage = this.generateMergedLayers(context, options, null);
        BufferedImage image = this.cropImageToViewport(options, mergedImage.getImage());
        if (options.showSafeZone) {
            TvChannelIconGenerator.drawSafeZone(image);
        }
        return new AnnotatedImage(image, mergedImage.getErrorMessage());
    }

    private static void drawSafeZone(@NotNull BufferedImage image) {
        Graphics2D gOut = (Graphics2D)image.getGraphics();
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        gOut.setColor(c);
        gOut.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(gOut, 1.0);
        g.drawCenteredCircle(image.getWidth() / 2, image.getHeight() / 2, AssetStudioUtils.roundToInt((double)image.getWidth() * 0.4583333333333333));
        gOut.dispose();
    }

    @Override
    @NotNull
    protected Rectangle getFullBleedRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options) {
        return AssetStudioUtils.scaleRectangle(IMAGE_SIZE_FULL_BLEED_DP, TvChannelIconGenerator.computeScaleFactor(options));
    }

    @Override
    @NotNull
    protected Rectangle getViewportRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options) {
        return AssetStudioUtils.scaleRectangle(IMAGE_SIZE_VIEWPORT_DP, TvChannelIconGenerator.computeScaleFactor(options));
    }

    @Override
    @NotNull
    protected Rectangle getLegacyRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options) {
        return AssetStudioUtils.scaleRectangle(IMAGE_SIZE_LEGACY_DP, TvChannelIconGenerator.computeScaleFactor(options));
    }

    @Override
    protected boolean isMonochromeSupported() {
        return false;
    }

    private static double computeScaleFactor(@NotNull IconGenerator.IconOptions options) {
        double scaleFactor = TvChannelIconGenerator.getMdpiScaleFactor(TvChannelIconGenerator.getDensity(options));
        if (((TvChannelIconOptions)options).generatePreviewIcons) {
            scaleFactor *= 0.6;
        }
        return scaleFactor;
    }

    @NotNull
    private static Density getDensity(@NotNull IconGenerator.IconOptions options) {
        return ((TvChannelIconOptions)options).previewShape == PreviewShape.LEGACY ? options.density : Density.XXXHIGH;
    }

    @Override
    protected Rectangle getMaxIconRectangle() {
        return IMAGE_SIZE_FULL_BLEED_DP;
    }

    @Override
    protected boolean includeDensity(@NotNull Density density) {
        return density == LEGACY_DENSITY;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(TvChannelIconGenerator.class);
    }

    public static class TvChannelIconOptions
    extends AdaptiveIconGenerator.AdaptiveIconOptions
    implements Cloneable {
        public PreviewShape previewShape = PreviewShape.NONE;

        public TvChannelIconOptions(boolean forPreview) {
            super(forPreview);
            this.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        }

        @Override
        @NotNull
        public TvChannelIconOptions clone() {
            return (TvChannelIconOptions)super.clone();
        }
    }

    public static enum PreviewShape {
        NONE("none", "none"),
        ADAPTIVE("adaptive", "Adaptive (anydpi)"),
        LEGACY("legacy", "Legacy (xhdpi)");

        public final String id;
        public final String displayName;

        private PreviewShape(String id2, String displayName) {
            this.id = id2;
            this.displayName = displayName;
        }
    }
}

