/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.npw.assetstudio.TextRenderUtil;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.VectorTextRenderer;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextAsset
extends BaseAsset {
    private static final String TEXT_PROPERTY = "text";
    private static final String FONT_FAMILY_PROPERTY = "fontFamily";
    private static final String DEFAULT_TEXT = "Aa";
    private static final String PREFERRED_FONT_FAMILY = "Roboto";
    private static final int FONT_SIZE = 144;
    private final StringProperty myText = new StringValueProperty("Aa");
    private final StringProperty myFontFamily = new StringValueProperty();
    private final List<String> myAllFontFamilies;
    @NotNull
    private String myDefaultText = "Aa";
    @NotNull
    private String myDefaultFontFamily;
    @NotNull
    private final Object myLock = new Object();
    @Nullable
    private ListenableFuture<String> myXmlDrawableFuture;

    public TextAsset() {
        this.myAllFontFamilies = ImmutableList.copyOf((Object[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.myDefaultFontFamily = this.normalizeFontFamily(PREFERRED_FONT_FAMILY);
        if (!this.myDefaultFontFamily.isEmpty()) {
            this.myFontFamily.set(this.myDefaultFontFamily);
        }
        InvalidationListener listener2 = () -> {
            Object object = this.myLock;
            synchronized (object) {
                this.myXmlDrawableFuture = null;
            }
        };
        this.myText.addListener(listener2);
        this.myFontFamily.addListener(listener2);
        this.color().setValue(Color.BLACK);
        this.color().addListener(listener2);
    }

    @UiThread
    public void setDefaultText(@NotNull String text2) {
        boolean wasDefault = ((String)this.myText.get()).equals(this.myDefaultText);
        this.myDefaultText = text2;
        if (wasDefault) {
            this.myText.set(this.myDefaultText);
        }
    }

    @UiThread
    public void setDefaultFontFamily(@NotNull String fontFamily) {
        boolean wasDefault = ((String)this.myFontFamily.get()).equals(this.myDefaultFontFamily);
        this.myDefaultFontFamily = this.normalizeFontFamily(fontFamily);
        if (wasDefault) {
            this.selectFontFamily(this.myDefaultFontFamily);
        }
    }

    private void selectFontFamily(@NotNull String fontFamily) {
        String family = this.normalizeFontFamily(fontFamily);
        if (!family.isEmpty()) {
            this.myFontFamily.set(family);
        }
    }

    @NotNull
    private String normalizeFontFamily(@NotNull String fontFamily) {
        return this.myAllFontFamilies.contains(fontFamily) ? fontFamily : (this.myAllFontFamilies.isEmpty() ? "" : this.myAllFontFamilies.get(0));
    }

    @NotNull
    public static List<String> getAllFontFamilies() {
        return ImmutableList.copyOf((Object[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
    }

    @NotNull
    public StringProperty text() {
        return this.myText;
    }

    @NotNull
    public StringProperty fontFamily() {
        return this.myFontFamily;
    }

    @NotNull
    public String defaultFontFamily() {
        if (this.myAllFontFamilies.contains(PREFERRED_FONT_FAMILY)) {
            return PREFERRED_FONT_FAMILY;
        }
        return this.myAllFontFamilies.isEmpty() ? "" : this.myAllFontFamilies.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    @NotNull
    public ListenableFuture<String> getXmlDrawable() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myXmlDrawableFuture == null) {
                String text2 = (String)this.myText.get();
                String fontFamily = (String)this.myFontFamily.get();
                Color color = (Color)this.color().getValueOrNull();
                int opacityPercent = (Integer)this.opacityPercent().get();
                this.myXmlDrawableFuture = FutureUtils.executeOnPooledThread(() -> VectorTextRenderer.renderToVectorDrawable(text2, fontFamily, 144, color, (double)opacityPercent / 100.0));
            }
            return this.myXmlDrawableFuture;
        }
    }

    @Override
    @NotNull
    public ListenableFuture<BufferedImage> toImage() {
        TextRenderUtil.Options options = new TextRenderUtil.Options();
        options.font = Font.decode(this.myFontFamily + " 144");
        options.foregroundColor = this.color().getValueOr(Color.BLACK).getRGB();
        return Futures.immediateFuture((Object)TextRenderUtil.renderTextImage((String)this.myText.get(), 1, options));
    }

    @Override
    @UiThread
    public PersistentState getState() {
        PersistentState state2 = super.getState();
        state2.set(TEXT_PROPERTY, (String)this.myText.get(), this.myDefaultText);
        state2.set(FONT_FAMILY_PROPERTY, (String)this.myFontFamily.get(), this.myDefaultFontFamily);
        return state2;
    }

    @Override
    @UiThread
    public void loadState(@NotNull PersistentState state2) {
        super.loadState(state2);
        String text2 = state2.get(TEXT_PROPERTY, this.myDefaultText);
        if (!text2.isEmpty()) {
            this.myText.set(text2);
        }
        String fontFamily = state2.get(FONT_FAMILY_PROPERTY, this.myDefaultFontFamily);
        this.selectFontFamily(fontFamily);
    }
}

