/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.resources.Density;
import com.android.tools.adtui.common.ProposedFileTreeCellRenderer;
import com.android.tools.adtui.common.ProposedFileTreeModel;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.adtui.validation.validators.FalseValidator;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.LauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.wizard.DensityAwareFileComparator;
import com.android.tools.idea.npw.assetstudio.wizard.GenerateIconsModel;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.projectsystem.AndroidModulePaths;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.rendering.VectorDrawableTransformer;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.ui.CheckeredBackgroundPanel;
import com.android.tools.idea.wizard.ui.WizardUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.NamedColorUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.android.actions.widgets.SourceSetCellRenderer;
import org.jetbrains.android.actions.widgets.SourceSetItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfirmGenerateImagesStep
extends ModelWizardStep<GenerateIconsModel> {
    private final List<NamedModuleTemplate> myTemplates;
    private final ValidatorPanel myValidatorPanel;
    private final ListenerManager myListeners = new ListenerManager();
    private final JBLabel myPreviewIcon;
    private JPanel myRootPanel;
    private JComboBox<SourceSetItem> myPathsComboBox;
    private Tree myOutputPreviewTree;
    private CheckeredBackgroundPanel myPreviewPanel;
    private JTextField mySizeDpTextField;
    private JTextField myDensityTextField;
    private JTextField myFileTypeTextField;
    private JTextField mySizePxTextField;
    private JSplitPane mySplitPane;
    private Map<File, GeneratedIcon> myPathToPreviewImage;
    private JPanel myLeftPanel;
    private JPanel myRightPanel;
    private JPanel myPreviewFillPanel;
    private TitledSeparator myDetailsHeaderPanel;
    private JPanel myDetailsGridContainer;
    private JPanel myDensityRow;
    private JPanel mySizeDetailsRow;
    private JPanel mySizePxRow;
    private JPanel myDetailsPanel;
    private JPanel myImagePreviewPanel;
    private JPanel myXmlPreviewPanel;
    private JTextPane myXmlTextPane;
    private EditorEx myFilePreviewEditor;
    private EditorFactory myEditorFactory;
    private Document myXmlPreviewDocument;
    private ObjectProperty<SourceSetItem> mySelectedSourceSetItem;
    private final SourceSetItem myInitialSelectedItem;
    private final BoolProperty myFilesAlreadyExist = new BoolValueProperty();
    private ProposedFileTreeModel myProposedFileTreeModel;

    public ConfirmGenerateImagesStep(@NotNull GenerateIconsModel model, @NotNull List<NamedModuleTemplate> templates) {
        super(model, "Confirm Icon Path");
        this.setupUI();
        Preconditions.checkArgument((!templates.isEmpty() ? 1 : 0) != 0);
        this.myTemplates = templates;
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myRootPanel);
        SourceSetItem[] resDirs = (SourceSetItem[])AssetStudioUtils.orderTemplates(templates).stream().flatMap(template -> template.getPaths().getResDirectories().stream().map(folder -> SourceSetItem.create(template, folder))).filter(Objects::nonNull).toArray(SourceSetItem[]::new);
        this.myInitialSelectedItem = Arrays.stream(resDirs).filter(item -> item.getSourceSetName().equals(model.getTemplate().getName()) && item.getResDirUrl().equals(model.getResFolder().getAbsolutePath())).findFirst().orElse(null);
        DefaultComboBoxModel<SourceSetItem> moduleTemplatesModel = new DefaultComboBoxModel<SourceSetItem>(resDirs);
        this.myPathsComboBox.setModel(moduleTemplatesModel);
        this.myPathsComboBox.setRenderer((ListCellRenderer<SourceSetItem>)((Object)new SourceSetCellRenderer()));
        DefaultTreeModel emptyModel = new DefaultTreeModel(null);
        this.myOutputPreviewTree.setModel((TreeModel)emptyModel);
        this.myOutputPreviewTree.setCellRenderer((TreeCellRenderer)new ProposedFileTreeCellRenderer());
        this.myOutputPreviewTree.setBorder(BorderFactory.createLineBorder(NamedColorUtil.getBoundsColor()));
        this.myOutputPreviewTree.setRowHeight(-1);
        this.myOutputPreviewTree.getEmptyText().setText("No resource folder defined in project");
        this.myOutputPreviewTree.addTreeSelectionListener(e -> {
            TreePath newPath = e.getNewLeadSelectionPath();
            this.showSelectedNodeDetails(newPath);
        });
        String alreadyExistsError = WizardUtils.toHtmlString("Some files (shown in red) will overwrite existing files.");
        this.myValidatorPanel.registerValidator((ObservableValue)this.myFilesAlreadyExist, (Validator)new FalseValidator(Validator.Severity.WARNING, alreadyExistsError), new ObservableValue[0]);
        this.myPreviewIcon = new JBLabel();
        this.myPreviewIcon.setVisible(false);
        this.myPreviewIcon.setHorizontalAlignment(0);
        this.myPreviewIcon.setVerticalAlignment(0);
        this.myPreviewPanel.setLayout(new BorderLayout());
        this.myPreviewPanel.add((Component)this.myPreviewIcon, "Center");
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.mySplitPane);
    }

    private void showSelectedNodeDetails(@Nullable TreePath newPath) {
        if (newPath != null && newPath.getLastPathComponent() instanceof ProposedFileTreeModel.Node) {
            ProposedFileTreeModel.Node node = (ProposedFileTreeModel.Node)newPath.getLastPathComponent();
            GeneratedIcon generatedIcon = this.myPathToPreviewImage.get(node.getFile());
            if (generatedIcon instanceof GeneratedImageIcon) {
                GeneratedImageIcon generatedImageIcon = (GeneratedImageIcon)generatedIcon;
                BufferedImage image = generatedImageIcon.getImage();
                ImageIcon icon = new ImageIcon(image);
                this.myPreviewIcon.setIcon((Icon)icon);
                this.myPreviewIcon.setVisible(true);
                String extension = StringUtil.toUpperCase((String)FileUtilRt.getExtension((String)node.getFile().getName()));
                if (StringUtil.isEmpty((String)extension)) {
                    this.myFileTypeTextField.setText("N/A");
                } else {
                    this.myFileTypeTextField.setText(String.format("%s File", extension));
                }
                this.mySizePxTextField.setText(String.format(Locale.US, "%dx%d", icon.getIconWidth(), icon.getIconHeight()));
                Density density = generatedImageIcon.getDensity();
                this.myDensityTextField.setText(density.getResourceValue());
                double scaleFactor = IconGenerator.getMdpiScaleFactor(density);
                this.mySizeDpTextField.setText(String.format(Locale.US, "%dx%d", Math.round((double)icon.getIconWidth() / scaleFactor), Math.round((double)icon.getIconHeight() / scaleFactor)));
                this.mySizeDetailsRow.setVisible(true);
                this.mySizePxRow.setVisible(true);
                this.myImagePreviewPanel.setVisible(true);
                this.myXmlPreviewPanel.setVisible(false);
                return;
            }
            if (generatedIcon instanceof GeneratedXmlResource) {
                GeneratedXmlResource xml = (GeneratedXmlResource)generatedIcon;
                String xmlText = xml.getXmlText();
                BufferedImage image = this.getPreviewImage(xml);
                if (image == null) {
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (this.myEditorFactory == null) {
                            this.myEditorFactory = EditorFactory.getInstance();
                        }
                        if (this.myXmlPreviewDocument == null) {
                            this.myXmlPreviewDocument = this.myEditorFactory.createDocument((CharSequence)"");
                        }
                        this.myXmlPreviewDocument.setReadOnly(false);
                        try {
                            this.myXmlPreviewDocument.setText((CharSequence)StringUtil.convertLineSeparators((String)xmlText));
                        }
                        finally {
                            this.myXmlPreviewDocument.setReadOnly(true);
                        }
                        if (this.myFilePreviewEditor == null) {
                            this.myFilePreviewEditor = (EditorEx)this.myEditorFactory.createViewer(this.myXmlPreviewDocument);
                            this.myFilePreviewEditor.setCaretVisible(false);
                            this.myFilePreviewEditor.getSettings().setLineNumbersShown(false);
                            this.myFilePreviewEditor.getSettings().setLineMarkerAreaShown(false);
                            this.myFilePreviewEditor.getSettings().setFoldingOutlineShown(false);
                            this.myFilePreviewEditor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(null, (FileType)XmlFileType.INSTANCE));
                            this.myXmlPreviewPanel.removeAll();
                            this.myXmlPreviewPanel.add(this.myFilePreviewEditor.getComponent());
                        }
                    });
                    this.myImagePreviewPanel.setVisible(false);
                    this.myXmlPreviewPanel.setVisible(true);
                } else {
                    ImageIcon icon = new ImageIcon(image);
                    this.myPreviewIcon.setIcon((Icon)icon);
                    String drawableType = ConfirmGenerateImagesStep.getDrawableType(xmlText);
                    this.myFileTypeTextField.setText(drawableType);
                    this.myPreviewIcon.setVisible(true);
                    this.myDensityTextField.setText(Density.ANYDPI.getShortDisplayValue());
                    Dimension dpSize = ConfirmGenerateImagesStep.getDpSize(xml);
                    if (dpSize == null) {
                        this.mySizeDetailsRow.setVisible(false);
                    } else {
                        this.mySizeDpTextField.setText(String.format(Locale.US, "%dx%d", dpSize.width, dpSize.height));
                        this.mySizeDetailsRow.setVisible(true);
                    }
                    this.mySizePxRow.setVisible(false);
                    this.myImagePreviewPanel.setVisible(true);
                    this.myXmlPreviewPanel.setVisible(false);
                }
                return;
            }
        }
        this.myPreviewIcon.setVisible(false);
        this.myPreviewIcon.setIcon(null);
        this.myFileTypeTextField.setText("");
        this.mySizeDpTextField.setText("");
        this.mySizePxTextField.setText("");
        this.myDensityTextField.setText("");
        this.myImagePreviewPanel.setVisible(true);
        this.myXmlPreviewPanel.setVisible(false);
    }

    private void setupUI() {
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.mySplitPane = new JSplitPane();
        this.mySplitPane.setContinuousLayout(true);
        this.mySplitPane.setDividerLocation(500);
        this.myRootPanel.add((Component)this.mySplitPane, new GridConstraints(0, 0, 2, 3, 0, 3, 3, 3, null, null, null, 0, false));
        this.myLeftPanel = new JPanel();
        this.myLeftPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.mySplitPane.setLeftComponent(this.myLeftPanel);
        JLabel label1 = new JLabel();
        label1.setText("Source set:");
        this.myLeftPanel.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Output directories:");
        this.myLeftPanel.add((Component)label2, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null, 0, false));
        this.myPathsComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel1 = new DefaultComboBoxModel();
        this.myPathsComboBox.setModel(defaultComboBoxModel1);
        this.myLeftPanel.add(this.myPathsComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        JBScrollPane jBScrollPane1 = new JBScrollPane();
        this.myLeftPanel.add((Component)jBScrollPane1, new GridConstraints(1, 1, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        this.myOutputPreviewTree = new Tree();
        this.myOutputPreviewTree.setOpaque(false);
        this.myOutputPreviewTree.setToolTipText("A preview rendering of the output tree");
        jBScrollPane1.setViewportView((Component)this.myOutputPreviewTree);
        this.myRightPanel = new JPanel();
        this.myRightPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mySplitPane.setRightComponent(this.myRightPanel);
        this.myDetailsPanel = new JPanel();
        this.myDetailsPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myRightPanel.add((Component)this.myDetailsPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 5, 3, null, null, null, 0, false));
        this.myImagePreviewPanel = new JPanel();
        this.myImagePreviewPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myDetailsPanel.add((Component)this.myImagePreviewPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myDetailsGridContainer = new JPanel();
        this.myDetailsGridContainer.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myImagePreviewPanel.add((Component)this.myDetailsGridContainer, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myDetailsGridContainer.add((Component)panel1, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myFileTypeTextField = new JTextField();
        this.myFileTypeTextField.setEditable(false);
        panel1.add((Component)this.myFileTypeTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("File type:");
        panel1.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myDensityRow = new JPanel();
        this.myDensityRow.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myDetailsGridContainer.add((Component)this.myDensityRow, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myDensityTextField = new JTextField();
        this.myDensityTextField.setEditable(false);
        this.myDensityRow.add((Component)this.myDensityTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Density:");
        this.myDensityRow.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.mySizeDetailsRow = new JPanel();
        this.mySizeDetailsRow.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myDetailsGridContainer.add((Component)this.mySizeDetailsRow, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.mySizeDpTextField = new JTextField();
        this.mySizeDpTextField.setEditable(false);
        this.mySizeDetailsRow.add((Component)this.mySizeDpTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, null, null, 0, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Size (dp):");
        this.mySizeDetailsRow.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.mySizePxRow = new JPanel();
        this.mySizePxRow.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myDetailsGridContainer.add((Component)this.mySizePxRow, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.mySizePxTextField = new JTextField();
        this.mySizePxTextField.setEditable(false);
        this.mySizePxRow.add((Component)this.mySizePxTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, null, null, 0, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Size (px):");
        this.mySizePxRow.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        this.myImagePreviewPanel.add((Component)jBScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        this.myPreviewFillPanel = new JPanel();
        this.myPreviewFillPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        jBScrollPane2.setViewportView((Component)this.myPreviewFillPanel);
        this.myPreviewPanel = new CheckeredBackgroundPanel();
        this.myPreviewFillPanel.add((Component)this.myPreviewPanel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.myXmlPreviewPanel = new JPanel();
        this.myXmlPreviewPanel.setLayout(new BorderLayout(0, 0));
        this.myDetailsPanel.add((Component)this.myXmlPreviewPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myXmlTextPane = new JTextPane();
        this.myXmlTextPane.setText("<xml></xml>");
        this.myXmlPreviewPanel.add((Component)this.myXmlTextPane, "Center");
        this.myDetailsHeaderPanel = new TitledSeparator();
        this.myDetailsHeaderPanel.setText("Output file");
        this.myRightPanel.add((Component)this.myDetailsHeaderPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
    }

    @NotNull
    private static String getDrawableType(@NotNull String xmlText) {
        String tagName = XmlUtils.getRootTagName((String)xmlText);
        if (tagName != null) {
            switch (tagName) {
                case "vector": {
                    return "Vector Drawable";
                }
                case "shape": {
                    return "Shape Drawable";
                }
                case "bitmap": {
                    return "Bitmap Drawable";
                }
                case "layer-list": {
                    return "Layer List";
                }
            }
        }
        return "Drawable";
    }

    @Nullable
    private static Dimension getDpSize(@NotNull GeneratedXmlResource xml) {
        String xmlText = xml.getXmlText();
        Dimension size = VectorDrawableTransformer.getSizeDp(xmlText);
        if (size != null) {
            return size;
        }
        IconCategory xmlCategory = xml.getCategory();
        if (xmlCategory == IconCategory.ADAPTIVE_BACKGROUND_LAYER || xmlCategory == IconCategory.ADAPTIVE_FOREGROUND_LAYER) {
            return LauncherIconGenerator.SIZE_FULL_BLEED_DP;
        }
        return null;
    }

    @Nullable
    private BufferedImage getPreviewImage(@NotNull GeneratedXmlResource xml) {
        String xmlText = xml.getXmlText();
        IconGenerator generator = ((GenerateIconsModel)this.getModel()).getIconGenerator();
        IconCategory xmlCategory = xml.getCategory();
        if (generator != null && (xmlCategory == IconCategory.ADAPTIVE_BACKGROUND_LAYER || xmlCategory == IconCategory.ADAPTIVE_FOREGROUND_LAYER)) {
            GraphicGeneratorContext generatorContext = generator.getGraphicGeneratorContext();
            Dimension size = VectorDrawableTransformer.getSizeDp(xmlText);
            if (size == null) {
                size = LauncherIconGenerator.SIZE_FULL_BLEED_DP;
            }
            double scale = Math.max(size.width, size.height) >= 320 ? 0.7 : 0.8;
            Dimension scaledSize = AssetStudioUtils.scaleDimension(size, IconGenerator.getMdpiScaleFactor(Density.XHIGH) * scale);
            Future<BufferedImage> imageFuture = generatorContext.renderDrawable(xmlText, scaledSize.getSize());
            try {
                return imageFuture.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myValidatorPanel;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard2) {
        this.mySelectedSourceSetItem = ObjectProperty.wrap(new SelectedItemProperty(this.myPathsComboBox));
        if (this.myInitialSelectedItem != null) {
            this.mySelectedSourceSetItem.set(this.myInitialSelectedItem);
        }
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    @Override
    protected void onProceeding() {
        SourceSetItem item = (SourceSetItem)this.mySelectedSourceSetItem.get();
        NamedModuleTemplate template = this.findTemplateByName(item.getSourceSetName());
        if (template == null) {
            return;
        }
        GenerateIconsModel model = (GenerateIconsModel)this.getModel();
        model.setTemplate(template);
        model.setResFolder(new File(item.getResDirUrl()));
        model.setFilesToDelete(this.myProposedFileTreeModel.getShadowConflictedFiles());
    }

    @Override
    protected void onEntering() {
        this.myListeners.release(this.mySelectedSourceSetItem);
        this.myListeners.listenAndFire(this.mySelectedSourceSetItem, sourceSetItem -> {
            int i;
            IconGenerator iconGenerator = ((GenerateIconsModel)this.getModel()).getIconGenerator();
            NamedModuleTemplate template = this.findTemplateByName(sourceSetItem.getSourceSetName());
            File resDirectory = new File(sourceSetItem.getResDirUrl());
            if (iconGenerator == null || resDirectory.getParentFile() == null || template == null) {
                return;
            }
            AndroidModulePaths paths = template.getPaths();
            this.myFilesAlreadyExist.set(false);
            this.myPathToPreviewImage = iconGenerator.generateIntoIconMap(paths, new File(sourceSetItem.getResDirUrl()));
            Set<File> outputDirectories = this.myPathToPreviewImage.keySet().stream().flatMap(x -> {
                File root = resDirectory.getParentFile();
                ArrayList<File> directories = new ArrayList<File>();
                for (File f = x.getParentFile(); f != null && !Objects.equals(f, root); f = f.getParentFile()) {
                    directories.add(f);
                }
                return directories.stream();
            }).collect(Collectors.toSet());
            ImmutableSortedSet proposedFiles = ImmutableSortedSet.orderedBy((Comparator)new DensityAwareFileComparator(outputDirectories)).addAll(this.myPathToPreviewImage.keySet()).build();
            this.myProposedFileTreeModel = new ProposedFileTreeModel(resDirectory.getParentFile(), (Set)proposedFiles);
            this.myFilesAlreadyExist.set(this.myProposedFileTreeModel.hasConflicts());
            this.myOutputPreviewTree.setModel((TreeModel)this.myProposedFileTreeModel);
            for (i = 0; i < this.myOutputPreviewTree.getRowCount(); ++i) {
                this.myOutputPreviewTree.expandRow(i);
            }
            for (i = 0; i < this.myOutputPreviewTree.getRowCount(); ++i) {
                TreePath rowPath = this.myOutputPreviewTree.getPathForRow(i);
                if (rowPath == null || !this.myProposedFileTreeModel.isLeaf(rowPath.getLastPathComponent())) continue;
                this.myOutputPreviewTree.setSelectionRow(i);
                break;
            }
        });
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myPathsComboBox;
    }

    @Override
    public void dispose() {
        if (this.myEditorFactory != null && this.myFilePreviewEditor != null) {
            this.myEditorFactory.releaseEditor((Editor)this.myFilePreviewEditor);
        }
        this.myListeners.releaseAll();
    }

    @Nullable
    private NamedModuleTemplate findTemplateByName(@NotNull String name2) {
        return this.myTemplates.stream().filter(template -> name2.equals(template.getName())).findFirst().orElse(null);
    }
}

