/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.model;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ide.common.repository.AgpVersion;
import com.android.io.CancellableFileIo;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gemini.GeminiPluginApi;
import com.android.tools.idea.gradle.plugin.AgpVersions;
import com.android.tools.idea.gradle.project.AndroidNewProjectInitializationStartupActivity;
import com.android.tools.idea.gradle.project.importing.GradleNewProjectConfiguration;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.run.MakeBeforeRunTaskProviderUtil;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.npw.model.AgpVersionSelector;
import com.android.tools.idea.npw.model.AgpVersionSelectorKt;
import com.android.tools.idea.npw.model.MultiTemplateRenderer;
import com.android.tools.idea.npw.model.NewAndroidModuleModelKt;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.model.NewProjectModelKt;
import com.android.tools.idea.npw.model.NewTemplateRendererKt;
import com.android.tools.idea.npw.model.ProjectModelData;
import com.android.tools.idea.npw.model.ProjectRenderRunner;
import com.android.tools.idea.npw.model.ProjectSyncInvoker;
import com.android.tools.idea.npw.module.recipes.androidProject.AndroidProjectRecipeKt;
import com.android.tools.idea.npw.project.AndroidGradleModuleUtils;
import com.android.tools.idea.npw.project.DomainToPackageExpression;
import com.android.tools.idea.npw.template.ProjectTemplateDataBuilder;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.templates.recipe.DefaultRecipeExecutor;
import com.android.tools.idea.templates.recipe.FindReferencesRecipeExecutor;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.model.WizardModel;
import com.android.tools.idea.wizard.template.Language;
import com.android.tools.idea.wizard.template.ProjectTemplateData;
import com.android.tools.idea.wizard.template.RecipeExecutor;
import com.android.tools.idea.wizard.template.TemplateData;
import com.android.tools.idea.wizard.template.ViewBindingSupport;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenProjectTaskBuilder;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.projectImport.ProjectOpenedCallback;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 D2\u00020\u00012\u00020\u0002:\u0002CDB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u00107\u001a\u0002082\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002080:H\u0002J\b\u0010?\u001a\u000208H\u0002J\b\u0010@\u001a\u000208H\u0014J\b\u0010A\u001a\u0004\u0018\u00010BR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001bR\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R \u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.0)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010,R\u0014\u00101\u001a\u000202X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\fR\u0014\u0010;\u001a\u00020<X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>\u00a8\u0006E"}, d2={"Lcom/android/tools/idea/npw/model/NewProjectModel;", "Lcom/android/tools/idea/wizard/model/WizardModel;", "Lcom/android/tools/idea/npw/model/ProjectModelData;", "<init>", "()V", "projectSyncInvoker", "Lcom/android/tools/idea/npw/model/ProjectSyncInvoker;", "getProjectSyncInvoker", "()Lcom/android/tools/idea/npw/model/ProjectSyncInvoker;", "applicationName", "Lcom/android/tools/idea/observable/core/StringValueProperty;", "getApplicationName", "()Lcom/android/tools/idea/observable/core/StringValueProperty;", "packageName", "getPackageName", "projectLocation", "getProjectLocation", "useGradleKts", "Lcom/android/tools/idea/observable/core/BoolValueProperty;", "getUseGradleKts", "()Lcom/android/tools/idea/observable/core/BoolValueProperty;", "useVersionCatalog", "getUseVersionCatalog", "viewBindingSupport", "Lcom/android/tools/idea/observable/core/OptionalValueProperty;", "Lcom/android/tools/idea/wizard/template/ViewBindingSupport;", "getViewBindingSupport", "()Lcom/android/tools/idea/observable/core/OptionalValueProperty;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "isNewProject", "", "()Z", "language", "Lcom/android/tools/idea/wizard/template/Language;", "getLanguage", "agpVersionSelector", "Lcom/android/tools/idea/observable/core/ObjectValueProperty;", "Lcom/android/tools/idea/npw/model/AgpVersionSelector;", "getAgpVersionSelector", "()Lcom/android/tools/idea/observable/core/ObjectValueProperty;", "additionalMavenRepos", "", "Ljava/net/URL;", "getAdditionalMavenRepos", "multiTemplateRenderer", "Lcom/android/tools/idea/npw/model/MultiTemplateRenderer;", "getMultiTemplateRenderer", "()Lcom/android/tools/idea/npw/model/MultiTemplateRenderer;", "prompt", "getPrompt", "runRenderer", "", "renderer", "Lkotlin/Function1;", "projectTemplateDataBuilder", "Lcom/android/tools/idea/npw/template/ProjectTemplateDataBuilder;", "getProjectTemplateDataBuilder", "()Lcom/android/tools/idea/npw/template/ProjectTemplateDataBuilder;", "saveWizardState", "handleFinished", "findNewModuleRecommendedBuildSdk", "Lcom/android/sdklib/AndroidVersion;", "ProjectTemplateRenderer", "Companion", "intellij.android.newProjectWizard"})
@StabilityInferred(parameters=0)
public final class NewProjectModel
extends WizardModel
implements ProjectModelData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectSyncInvoker projectSyncInvoker = new ProjectSyncInvoker.DefaultProjectSyncInvoker();
    @NotNull
    private final StringValueProperty applicationName = new StringValueProperty("My Application");
    @NotNull
    private final StringValueProperty packageName = new StringValueProperty();
    @NotNull
    private final StringValueProperty projectLocation = new StringValueProperty();
    @NotNull
    private final BoolValueProperty useGradleKts = new BoolValueProperty();
    @NotNull
    private final BoolValueProperty useVersionCatalog = new BoolValueProperty(true);
    @NotNull
    private final OptionalValueProperty<ViewBindingSupport> viewBindingSupport = new OptionalValueProperty<ViewBindingSupport>(ViewBindingSupport.SUPPORTED_4_0_MORE);
    public Project project;
    private final boolean isNewProject;
    @NotNull
    private final OptionalValueProperty<Language> language = new OptionalValueProperty();
    @NotNull
    private final ObjectValueProperty<AgpVersionSelector> agpVersionSelector = new ObjectValueProperty<AgpVersionSelector>(AgpVersionSelectorKt.newProjectAgpVersionSelector());
    @NotNull
    private final ObjectValueProperty<List<URL>> additionalMavenRepos = new ObjectValueProperty<List>(CollectionsKt.emptyList());
    @NotNull
    private final MultiTemplateRenderer multiTemplateRenderer = new MultiTemplateRenderer(new ProjectRenderRunner(this){
        final /* synthetic */ NewProjectModel $tmp0;
        {
            this.$tmp0 = $tmp0;
        }

        public final void runRenderer(Function1<? super Project, Unit> p0) {
            Intrinsics.checkNotNullParameter(p0, (String)"p0");
            NewProjectModel.access$runRenderer(this.$tmp0, p0);
        }

        public final Function<?> getFunctionDelegate() {
            return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, NewProjectModel.class, "runRenderer", "runRenderer(Lkotlin/jvm/functions/Function1;)V", 0);
        }

        public final boolean equals(Object other) {
            return other instanceof ProjectRenderRunner ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
        }

        public final int hashCode() {
            return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
        }
    });
    @NotNull
    private final StringValueProperty prompt = new StringValueProperty("");
    @NotNull
    private final ProjectTemplateDataBuilder projectTemplateDataBuilder = new ProjectTemplateDataBuilder(true);
    public static final int $stable = 8;
    @NotNull
    public static final String PROPERTIES_ANDROID_PACKAGE_KEY = "SAVED_ANDROID_PACKAGE";
    @NotNull
    public static final String PROPERTIES_KOTLIN_SUPPORT_KEY = "SAVED_PROJECT_KOTLIN_SUPPORT";
    @NotNull
    public static final String PROPERTIES_NPW_LANGUAGE_KEY = "SAVED_ANDROID_NPW_LANGUAGE";
    @NotNull
    public static final String PROPERTIES_NPW_ASKED_LANGUAGE_KEY = "SAVED_ANDROID_NPW_ASKED_LANGUAGE";
    @NotNull
    private static final String EXAMPLE_DOMAIN = "example.com";
    private static final Pattern DISALLOWED_IN_DOMAIN = Pattern.compile("[^a-zA-Z0-9_]");
    private static final Pattern MODULE_NAME_GROUP = Pattern.compile(".*:");

    public NewProjectModel() {
        this.isNewProject = true;
        this.getApplicationName().addConstraint(NewProjectModel::_init_$trim__proxy);
        OptionalProperty optionalProperty = this.getLanguage();
        PropertiesComponent propertiesComponent = NewProjectModelKt.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"<get-properties>(...)");
        optionalProperty.set(Companion.calculateInitialLanguage(propertiesComponent));
    }

    @Override
    @NotNull
    public ProjectSyncInvoker getProjectSyncInvoker() {
        return this.projectSyncInvoker;
    }

    @Override
    @NotNull
    public StringValueProperty getApplicationName() {
        return this.applicationName;
    }

    @Override
    @NotNull
    public StringValueProperty getPackageName() {
        return this.packageName;
    }

    @Override
    @NotNull
    public StringValueProperty getProjectLocation() {
        return this.projectLocation;
    }

    @Override
    @NotNull
    public BoolValueProperty getUseGradleKts() {
        return this.useGradleKts;
    }

    @Override
    @NotNull
    public BoolValueProperty getUseVersionCatalog() {
        return this.useVersionCatalog;
    }

    @Override
    @NotNull
    public OptionalValueProperty<ViewBindingSupport> getViewBindingSupport() {
        return this.viewBindingSupport;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project != null) {
            return project;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        return null;
    }

    @Override
    public void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @Override
    public boolean isNewProject() {
        return this.isNewProject;
    }

    @NotNull
    public OptionalValueProperty<Language> getLanguage() {
        return this.language;
    }

    @Override
    @NotNull
    public ObjectValueProperty<AgpVersionSelector> getAgpVersionSelector() {
        return this.agpVersionSelector;
    }

    @Override
    @NotNull
    public ObjectValueProperty<List<URL>> getAdditionalMavenRepos() {
        return this.additionalMavenRepos;
    }

    @Override
    @NotNull
    public MultiTemplateRenderer getMultiTemplateRenderer() {
        return this.multiTemplateRenderer;
    }

    @Override
    @NotNull
    public StringValueProperty getPrompt() {
        return this.prompt;
    }

    private final void runRenderer(Function1<? super Project, Unit> renderer2) {
        String string = AndroidBundle.message("android.compile.messages.generating.r.java.content.name", new Object[0]);
        new Task.Backgroundable(this, renderer2, string){
            final /* synthetic */ NewProjectModel this$0;
            final /* synthetic */ Function1<Project, Unit> $renderer;
            {
                this.this$0 = $receiver;
                this.$renderer = $renderer;
                super(null, $super_call_param$1, false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                String string = this.this$0.getApplicationName().get();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                String projectName = string;
                File projectBaseDirectory = new File(this.this$0.getProjectLocation().get());
                Project newProject = GradleProjectImporter.Companion.getInstance().createProject(projectName, projectBaseDirectory, true);
                ComponentManager $this$service$iv = (ComponentManager)newProject;
                boolean $i$f$service = false;
                Class serviceClass$iv = ProjectSystemService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((ProjectSystemService)object).setProviderId("com.android.tools.idea.GradleProjectSystem");
                MakeBeforeRunTaskProviderUtil.ensureMakeBeforeRunTaskInConfigurationTemplate(newProject);
                this.this$0.setProject(newProject);
                $this$service$iv = (ComponentManager)newProject;
                $i$f$service = false;
                serviceClass$iv = AndroidNewProjectInitializationStartupActivity.StartupService.class;
                Object object2 = $this$service$iv.getService(serviceClass$iv);
                if (object2 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((AndroidNewProjectInitializationStartupActivity.StartupService)object2).setProjectInitializer((Function0<Unit>)((Function0)() -> runRenderer.1.run$lambda$2(this.this$0, newProject, this.$renderer)));
                boolean $i$f$OpenProjectTask = false;
                OpenProjectTaskBuilder this_$iv$iv = new OpenProjectTaskBuilder();
                boolean $i$f$build = false;
                OpenProjectTaskBuilder $this$run_u24lambda_u243 = this_$iv$iv;
                boolean bl = false;
                $this$run_u24lambda_u243.setProject(newProject);
                $this$run_u24lambda_u243.setNewProject(false);
                $this$run_u24lambda_u243.setForceOpenInNewFrame(true);
                boolean bl2 = this_$iv$iv.getForceOpenInNewFrame();
                boolean bl3 = this_$iv$iv.getForceReuseFrame();
                boolean bl4 = this_$iv$iv.getPreloadServices();
                Project project = this_$iv$iv.getProjectToClose();
                boolean bl5 = this_$iv$iv.isRefreshVfsNeeded();
                String string2 = this_$iv$iv.getProjectName();
                boolean bl6 = this_$iv$iv.isNewProject();
                Boolean bl7 = this_$iv$iv.getUseDefaultProjectAsTemplate();
                boolean bl8 = bl7 != null ? bl7.booleanValue() : this_$iv$iv.isNewProject();
                boolean bl9 = this_$iv$iv.getRunConfigurators();
                boolean bl10 = this_$iv$iv.isProjectCreatedWithWizard();
                boolean bl11 = this_$iv$iv.getRunConversionBeforeOpen();
                boolean bl12 = this_$iv$iv.getShowWelcomeScreen();
                Function2 function2 = this_$iv$iv.getBeforeOpen();
                Function1 function1 = this_$iv$iv.getBeforeInit();
                Function2 function22 = this_$iv$iv.getPreparedToOpen();
                ProjectOpenedCallback projectOpenedCallback = this_$iv$iv.getCallback();
                boolean bl13 = this_$iv$iv.getPreventIprLookup();
                Function1 function12 = this_$iv$iv.getProcessorChooser();
                String string3 = this_$iv$iv.getProjectWorkspaceId();
                Object object3 = this_$iv$iv.getImplOptions();
                int n = this_$iv$iv.getLine();
                int n2 = this_$iv$iv.getColumn();
                Project project2 = this_$iv$iv.getProject();
                OpenProjectTask openProjectTask = new OpenProjectTask(bl2, bl3, project, bl6, bl8, project2, string2, bl12, projectOpenedCallback, n, n2, bl5, bl9, bl11, string3, bl10, bl4, function1, function2, function22, bl13, function12, object3);
                ProjectManagerEx projectManagerEx = ProjectManagerEx.Companion.getInstanceEx();
                Path path = projectBaseDirectory.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                projectManagerEx.openProject(path, openProjectTask);
            }

            private static final void run$lambda$2$lambda$0(Function1 $renderer, Project $newProject) {
                $renderer.invoke((Object)$newProject);
            }

            private static final void run$lambda$2$lambda$1(Project $newProject, NewProjectModel this$0) {
                GeminiPluginApi geminiPluginApi = GeminiPluginApi.Companion.getInstance();
                String string = this$0.getPrompt().get();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                geminiPluginApi.launchNewProjectAgent($newProject, string);
            }

            private static final Unit run$lambda$2(NewProjectModel this$0, Project $newProject, Function1 $renderer) {
                NewProjectModelKt.access$getLogger().info("Rendering a new project.");
                NonProjectFileWritingAccessProvider.disableChecksDuring(() -> runRenderer.1.run$lambda$2$lambda$0($renderer, $newProject));
                if (((Boolean)StudioFlags.GEMINI_NEW_PROJECT_AGENT.get()).booleanValue() && !((Boolean)this$0.getPrompt().isEmpty().get()).booleanValue()) {
                    ToolWindowManager.Companion.getInstance($newProject).invokeLater(() -> runRenderer.1.run$lambda$2$lambda$1($newProject, this$0));
                }
                return Unit.INSTANCE;
            }
        }.queue();
    }

    @Override
    @NotNull
    public ProjectTemplateDataBuilder getProjectTemplateDataBuilder() {
        return this.projectTemplateDataBuilder;
    }

    private final void saveWizardState() {
        PropertiesComponent properties = NewProjectModelKt.getProperties();
        properties.setValue(PROPERTIES_NPW_LANGUAGE_KEY, ((Language)this.getLanguage().getValue()).toString());
        properties.setValue(PROPERTIES_NPW_ASKED_LANGUAGE_KEY, true);
        String string = this.getPackageName().get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        String androidPackage = StringsKt.substringBeforeLast$default((String)string, (char)'.', null, (int)2, null);
        if (AndroidUtils.isValidAndroidPackageName(androidPackage)) {
            properties.setValue(PROPERTIES_ANDROID_PACKAGE_KEY, androidPackage);
        }
    }

    @Override
    protected void handleFinished() {
        String string = this.getProjectLocation().get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        char[] cArray = new char[]{File.separatorChar};
        String projectLocation = StringsKt.trimEnd((String)string, (char[])cArray);
        Boolean couldEnsureLocationExists = (Boolean)WriteCommandAction.runWriteCommandAction(null, () -> NewProjectModel.handleFinished$lambda$0(projectLocation));
        if (!couldEnsureLocationExists.booleanValue()) {
            String msg = "Could not ensure the target project location exists and is accessible:\n" + projectLocation + "\nPlease try to specify another path.";
            Messages.showErrorDialog((String)msg, (String)"Error Creating Project");
            return;
        }
        this.getMultiTemplateRenderer().requestRender(new ProjectTemplateRenderer());
        Path path = Paths.get(projectLocation, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        ProjectUtil.updateLastProjectLocation((Path)path);
        this.saveWizardState();
    }

    @Nullable
    public final AndroidVersion findNewModuleRecommendedBuildSdk() {
        if (this.project != null) {
            return NewAndroidModuleModelKt.findNewModuleRecommendedBuildSdk(this.getProject());
        }
        return null;
    }

    private static final String _init_$trim__proxy(String string) {
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private static final Boolean handleFinished$lambda$0(String $projectLocation) {
        try {
            if (VfsUtil.createDirectoryIfMissing((String)$projectLocation) != null && CancellableFileIo.isWritable((Path)Paths.get($projectLocation, new String[0]))) {
                return true;
            }
        }
        catch (Exception e) {
            NewProjectModelKt.access$getLogger().error("Exception thrown when creating target project location: " + $projectLocation, (Throwable)e);
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final String getInitialDomain() {
        return Companion.getInitialDomain();
    }

    @JvmStatic
    @NotNull
    public static final String getSuggestedProjectPackage() {
        return Companion.getSuggestedProjectPackage();
    }

    @JvmStatic
    @NotNull
    public static final Optional<Language> calculateInitialLanguage(@NotNull PropertiesComponent props) {
        return Companion.calculateInitialLanguage(props);
    }

    @JvmStatic
    @NotNull
    public static final String sanitizeApplicationName(@NotNull String s) {
        return Companion.sanitizeApplicationName(s);
    }

    @JvmStatic
    @NotNull
    public static final String nameToJavaPackage(@NotNull String name2) {
        return Companion.nameToJavaPackage(name2);
    }

    public static final /* synthetic */ void access$runRenderer(NewProjectModel $this, Function1 renderer2) {
        $this.runRenderer((Function1<? super Project, Unit>)renderer2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0005H\u0007J\b\u0010\u0013\u001a\u00020\u0005H\u0007J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0007J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0007R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u0016\u0010\u0007\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\u0016\u0010\t\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0003R\u0016\u0010\u000b\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0003R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/npw/model/NewProjectModel$Companion;", "", "<init>", "()V", "PROPERTIES_ANDROID_PACKAGE_KEY", "", "getPROPERTIES_ANDROID_PACKAGE_KEY$annotations", "PROPERTIES_KOTLIN_SUPPORT_KEY", "getPROPERTIES_KOTLIN_SUPPORT_KEY$annotations", "PROPERTIES_NPW_LANGUAGE_KEY", "getPROPERTIES_NPW_LANGUAGE_KEY$annotations", "PROPERTIES_NPW_ASKED_LANGUAGE_KEY", "getPROPERTIES_NPW_ASKED_LANGUAGE_KEY$annotations", "EXAMPLE_DOMAIN", "DISALLOWED_IN_DOMAIN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "MODULE_NAME_GROUP", "getInitialDomain", "getSuggestedProjectPackage", "calculateInitialLanguage", "Ljava/util/Optional;", "Lcom/android/tools/idea/wizard/template/Language;", "props", "Lcom/intellij/ide/util/PropertiesComponent;", "sanitizeApplicationName", "s", "nameToJavaPackage", "name", "intellij.android.newProjectWizard"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getPROPERTIES_ANDROID_PACKAGE_KEY$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getPROPERTIES_KOTLIN_SUPPORT_KEY$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getPROPERTIES_NPW_LANGUAGE_KEY$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getPROPERTIES_NPW_ASKED_LANGUAGE_KEY$annotations() {
        }

        @JvmStatic
        @NotNull
        public final String getInitialDomain() {
            String androidPackage = PropertiesComponent.getInstance().getValue(NewProjectModel.PROPERTIES_ANDROID_PACKAGE_KEY);
            return androidPackage != null ? new DomainToPackageExpression(new StringValueProperty(androidPackage), new StringValueProperty("")).get() : NewProjectModel.EXAMPLE_DOMAIN;
        }

        @JvmStatic
        @NotNull
        public final String getSuggestedProjectPackage() {
            return new DomainToPackageExpression(new StringValueProperty(this.getInitialDomain()), new StringValueProperty("")).get();
        }

        @JvmStatic
        @NotNull
        public final Optional<Language> calculateInitialLanguage(@NotNull PropertiesComponent props) {
            Optional<Object> optional;
            Intrinsics.checkNotNullParameter((Object)props, (String)"props");
            Language initialLanguage = null;
            String languageValue = props.getValue(NewProjectModel.PROPERTIES_NPW_LANGUAGE_KEY);
            if (languageValue == null) {
                boolean selectedOldUseKotlin = props.getBoolean(NewProjectModel.PROPERTIES_KOTLIN_SUPPORT_KEY);
                boolean isFirstUsage = !props.isValueSet(NewProjectModel.PROPERTIES_ANDROID_PACKAGE_KEY);
                initialLanguage = selectedOldUseKotlin || isFirstUsage ? Language.Kotlin : Language.Java;
                props.setValue(NewProjectModel.PROPERTIES_NPW_LANGUAGE_KEY, initialLanguage.toString());
                props.unsetValue(NewProjectModel.PROPERTIES_KOTLIN_SUPPORT_KEY);
            } else {
                initialLanguage = Language.Companion.fromName(languageValue, Language.Kotlin);
            }
            boolean askedBefore = props.getBoolean(NewProjectModel.PROPERTIES_NPW_ASKED_LANGUAGE_KEY);
            if (initialLanguage == Language.Kotlin || askedBefore) {
                Optional<Language> optional2 = Optional.of(initialLanguage);
                optional = optional2;
                Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(...)");
            } else {
                Optional optional3 = Optional.empty();
                optional = optional3;
                Intrinsics.checkNotNullExpressionValue(optional3, (String)"empty(...)");
            }
            return optional;
        }

        @JvmStatic
        @NotNull
        public final String sanitizeApplicationName(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            String string = DISALLOWED_IN_DOMAIN.matcher(s).replaceAll("");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replaceAll(...)");
            return string;
        }

        @JvmStatic
        @NotNull
        public final String nameToJavaPackage(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            String $this$nameToJavaPackage_u24lambda_u241 = StringsKt.replace$default((String)name2, (char)'-', (char)'_', (boolean)false, (int)4, null);
            boolean bl = false;
            String $this$nameToJavaPackage_u24lambda_u241_u24lambda_u240 = MODULE_NAME_GROUP.matcher($this$nameToJavaPackage_u24lambda_u241).replaceAll("");
            boolean bl2 = false;
            String string = DISALLOWED_IN_DOMAIN.matcher($this$nameToJavaPackage_u24lambda_u241_u24lambda_u240).replaceAll("");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replaceAll(...)");
            String string2 = string;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String res2 = string3;
            if (((CharSequence)res2).length() > 0 && AndroidUtils.isReservedKeyword(res2) != null) {
                String string4 = StringUtil.fixVariableNameDerivedFromPropertyName((String)res2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"fixVariableNameDerivedFromPropertyName(...)");
                String string5 = string4;
                Locale locale2 = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"US");
                String string6 = string5.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                return string6;
            }
            return res2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\tH\u0017J\b\u0010\n\u001a\u00020\u0007H\u0017J\b\u0010\u000b\u001a\u00020\u0007H\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\tH\u0002J\b\u0010\u000e\u001a\u00020\u0007H\u0002J\b\u0010\u000f\u001a\u00020\u0007H\u0017J\b\u0010\u0010\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/npw/model/NewProjectModel$ProjectTemplateRenderer;", "Lcom/android/tools/idea/npw/model/MultiTemplateRenderer$TemplateRenderer;", "<init>", "(Lcom/android/tools/idea/npw/model/NewProjectModel;)V", "projectTemplateData", "Lcom/android/tools/idea/wizard/template/ProjectTemplateData;", "init", "", "doDryRun", "", "onSourcesCreated", "render", "performCreateProject", "dryRun", "updateDistributionUrl", "finish", "logUsage", "intellij.android.newProjectWizard"})
    public final class ProjectTemplateRenderer
    implements MultiTemplateRenderer.TemplateRenderer {
        private ProjectTemplateData projectTemplateData;

        /*
         * WARNING - void declaration
         */
        @Override
        @WorkerThread
        public void init() {
            void $this$init_u24lambda_u240;
            AgpVersion resolvedAgpVersion2 = NewProjectModel.this.getAgpVersionSelector().get().resolveVersion((Function0<? extends Set<AgpVersion>>)((Function0)new Function0<Set<? extends AgpVersion>>((Object)AgpVersions.INSTANCE){

                public final Set<AgpVersion> invoke() {
                    return ((AgpVersions)this.receiver).getAvailableVersions();
                }
            }));
            ProjectTemplateDataBuilder projectTemplateDataBuilder = NewProjectModel.this.getProjectTemplateDataBuilder();
            NewProjectModel newProjectModel = NewProjectModel.this;
            ProjectTemplateDataBuilder projectTemplateDataBuilder2 = projectTemplateDataBuilder;
            ProjectTemplateRenderer projectTemplateRenderer = this;
            boolean bl = false;
            String string = newProjectModel.getProject().getBasePath();
            if (string == null) {
                string = "";
            }
            $this$init_u24lambda_u240.setTopOut(new File(string));
            $this$init_u24lambda_u240.setAndroidXSupport(true);
            $this$init_u24lambda_u240.setProjectDefaults(newProjectModel.getProject());
            $this$init_u24lambda_u240.setLanguage((Language)newProjectModel.getLanguage().getValue());
            $this$init_u24lambda_u240.setAgpVersion(resolvedAgpVersion2);
            List<URL> list = newProjectModel.getAdditionalMavenRepos().get();
            Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
            $this$init_u24lambda_u240.setAdditionalMavenRepos(list);
            projectTemplateRenderer.projectTemplateData = projectTemplateDataBuilder.build();
        }

        @Override
        @WorkerThread
        public boolean doDryRun() {
            if (NewProjectModel.this.project == null) {
                return false;
            }
            this.performCreateProject(true);
            return true;
        }

        @Override
        @WorkerThread
        public void onSourcesCreated() {
            GradleProjectImporter.Companion.configureNewProject(NewProjectModel.this.getProject(), new GradleNewProjectConfiguration(true));
        }

        @Override
        @WorkerThread
        public void render() {
            this.performCreateProject(false);
            this.updateDistributionUrl();
            try {
                File file = VfsUtilCore.virtualToIoFile((VirtualFile)NewProjectModel.this.getProject().getBaseDir());
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
                File projectRoot = file;
                AndroidGradleModuleUtils.setGradleWrapperExecutable(projectRoot);
            }
            catch (IOException e) {
                NewProjectModelKt.access$getLogger().warn("Failed to update Gradle wrapper permissions", (Throwable)e);
            }
        }

        private final void performCreateProject(boolean dryRun) {
            Project project = NewProjectModel.this.getProject();
            ProjectTemplateData projectTemplateData = this.projectTemplateData;
            if (projectTemplateData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectTemplateData");
                projectTemplateData = null;
            }
            ProjectTemplateData projectTemplateData2 = projectTemplateData;
            RenderingContext context = new RenderingContext(project, null, "New Project", (TemplateData)projectTemplateData2, null, null, dryRun, true, 16, null);
            RecipeExecutor executor = dryRun ? (RecipeExecutor)new FindReferencesRecipeExecutor(context) : (RecipeExecutor)new DefaultRecipeExecutor(context);
            Function2 recipe = (arg_0, arg_1) -> ProjectTemplateRenderer.performCreateProject$lambda$1(NewProjectModel.this, arg_0, arg_1);
            NewTemplateRendererKt.render$default(recipe, context, executor, AndroidStudioEvent.TemplateRenderer.ANDROID_PROJECT, null, 8, null);
        }

        private final void updateDistributionUrl() {
            File rootLocation = new File(NewProjectModel.this.getProjectLocation().get());
            File file = GradleWrapper.getDefaultPropertiesFilePath(rootLocation);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDefaultPropertiesFilePath(...)");
            File wrapperPropertiesFilePath = file;
            try {
                GradleWrapper gradleWrapper = GradleWrapper.get(wrapperPropertiesFilePath, NewProjectModel.this.getProject());
                ProjectTemplateData projectTemplateData = this.projectTemplateData;
                if (projectTemplateData == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"projectTemplateData");
                    projectTemplateData = null;
                }
                gradleWrapper.updateDistributionUrl(projectTemplateData.getGradleVersion());
            }
            catch (IOException e) {
                NewProjectModelKt.access$getLogger().warn("Failed to update Gradle wrapper file", (Throwable)e);
            }
        }

        @Override
        @UiThread
        public void finish() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            ProjectTemplateRenderer.finish$performGradleImport(NewProjectModel.this);
        }

        @Override
        public void logUsage() {
        }

        private static final Unit performCreateProject$lambda$1(NewProjectModel this$0, RecipeExecutor recipeExecutor, TemplateData data2) {
            Intrinsics.checkNotNullParameter((Object)recipeExecutor, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            ProjectTemplateData projectTemplateData = (ProjectTemplateData)data2;
            String string = this$0.getApplicationName().get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            Object t = this$0.getLanguage().getValue();
            Intrinsics.checkNotNullExpressionValue(t, (String)"getValue(...)");
            Language language = (Language)t;
            Boolean bl = this$0.getUseGradleKts().get();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
            AndroidProjectRecipeKt.androidProjectRecipe$default(recipeExecutor, projectTemplateData, string, language, true, bl, false, 32, null);
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final void finish$performGradleImport(NewProjectModel this$0) {
            try {
                sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
                jdk = JavaSdk.getInstance();
                sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)jdk);
                it = var5_5 = LanguageLevel.JDK_1_7;
                $i$a$-takeIf-NewProjectModel$ProjectTemplateRenderer$finish$performGradleImport$initialLanguageLevel$1 = false;
                if (sdkData == null || sdk == null) ** GOTO lbl-1000
                v0 = jdk.getVersion(sdk);
                v1 = v0 != null ? v0.isAtLeast(JavaSdkVersion.JDK_1_7) : false;
                if (v1) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                initialLanguageLevel = v2 != false ? var5_5 : null;
                $this$finish_u24performGradleImport_u24lambda_u243 = var6_6 = new GradleProjectImporter.Request(this$0.getProject());
                $i$a$-apply-NewProjectModel$ProjectTemplateRenderer$finish$performGradleImport$request$1 = false;
                $this$finish_u24performGradleImport_u24lambda_u243.isNewProject = true;
                $this$finish_u24performGradleImport_u24lambda_u243.javaLanguageLevel = initialLanguageLevel;
                request = var6_6;
                GradleProjectImporter.Companion.getInstance().importProjectNoSync(request);
            }
            catch (IOException e) {
                Messages.showErrorDialog((String)e.getMessage(), (String)AndroidBundle.message("android.wizard.project.create.error", new Object[0]));
                NewProjectModelKt.access$getLogger().error((Throwable)e);
            }
        }
    }
}

