/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module.recipes.kotlinMultiplatformLibrary;

import com.android.ide.common.gradle.Version;
import com.android.tools.idea.npw.module.recipes.GitignoreKt;
import com.android.tools.idea.npw.module.recipes.KotlinMacrosKt;
import com.android.tools.idea.npw.module.recipes.SharedMacrosKt;
import com.android.tools.idea.npw.module.recipes.androidModule.src.ExampleUnitTestKt;
import com.android.tools.idea.npw.module.recipes.kotlinMultiplatformLibrary.BuildGradleKt;
import com.android.tools.idea.npw.module.recipes.kotlinMultiplatformLibrary.src.AndroidMainKt;
import com.android.tools.idea.npw.module.recipes.kotlinMultiplatformLibrary.src.CommonMainKt;
import com.android.tools.idea.npw.module.recipes.kotlinMultiplatformLibrary.src.IosMainKt;
import com.android.tools.idea.wizard.template.Category;
import com.android.tools.idea.wizard.template.Language;
import com.android.tools.idea.wizard.template.ModuleTemplateData;
import com.android.tools.idea.wizard.template.ProjectTemplateData;
import com.android.tools.idea.wizard.template.RecipeExecutor;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a$\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\t\u001a\u0012\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\t\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0002\u001a\"\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\"\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\"\u0010\u0015\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u001a\u0010\u0016\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0011\u001a\u0012\u0010\u0018\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\t\u00a8\u0006\u0019"}, d2={"generateMultiplatformModule", "", "Lcom/android/tools/idea/wizard/template/RecipeExecutor;", "data", "Lcom/android/tools/idea/wizard/template/ModuleTemplateData;", "useKts", "", "generateModule", "manifestXml", "", "addCommonMainDependencies", "kotlinVersion", "addCommonTestDependencies", "addInstrumentedTestDependencies", "addAndroidMain", "packageName", "outFolder", "Ljava/io/File;", "language", "Lcom/android/tools/idea/wizard/template/Language;", "addCommonMain", "addIosMain", "addMultiplatformLocalTests", "localTestOut", "addDownloadFromMavenProperty", "intellij.android.newProjectWizard"})
@SourceDebugExtension(value={"SMAP\nmultiplatformModuleRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 multiplatformModuleRecipe.kt\ncom/android/tools/idea/npw/module/recipes/kotlinMultiplatformLibrary/MultiplatformModuleRecipeKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class MultiplatformModuleRecipeKt {
    public static final void generateMultiplatformModule(@NotNull RecipeExecutor $this$generateMultiplatformModule, @NotNull ModuleTemplateData data2, boolean useKts) {
        Intrinsics.checkNotNullParameter((Object)$this$generateMultiplatformModule, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (!(data2.getCategory() != Category.Compose || data2.isCompose())) {
            boolean bl = false;
            String string = "Template in Compose category must have isCompose set";
            throw new IllegalStateException(string.toString());
        }
        MultiplatformModuleRecipeKt.generateModule($this$generateMultiplatformModule, data2, useKts, SharedMacrosKt.generateManifest$default(false, null, null, false, null, false, 63, null));
    }

    private static final void generateModule(RecipeExecutor $this$generateModule, ModuleTemplateData data2, boolean useKts, String manifestXml) {
        ProjectTemplateData projectData = data2.getProjectTemplateData();
        Language language = projectData.getLanguage();
        String packageName = data2.getPackageName();
        boolean useAndroidX2 = data2.getProjectTemplateData().getAndroidXSupport();
        $this$generateModule.createDirectory(data2.getSrcDir());
        $this$generateModule.addIncludeToSettings(data2.getName());
        String buildFile = useKts ? "build.gradle.kts" : "build.gradle";
        $this$generateModule.save(BuildGradleKt.buildKmpGradle(projectData.getAgpVersion(), data2.getName(), data2.getNamespace(), data2.getApis().getBuildApi(), data2.getApis().getMinApi()), FilesKt.resolve((File)data2.getRootDir(), (String)buildFile));
        KotlinMacrosKt.setKotlinVersion($this$generateModule, projectData.getKotlinVersion());
        $this$generateModule.addPlugin("org.jetbrains.kotlin.multiplatform", "org.jetbrains.kotlin:kotlin-gradle-plugin", projectData.getKotlinVersion());
        $this$generateModule.addPlugin("com.android.kotlin.multiplatform.library", "com.android.tools.build:gradle", projectData.getAgpVersion().toString());
        $this$generateModule.addPlugin("com.android.lint", "com.android.tools.build:gradle", projectData.getAgpVersion().toString());
        $this$generateModule.save(manifestXml, FilesKt.resolve((File)data2.getManifestDir(), (String)"AndroidManifest.xml"));
        $this$generateModule.save(GitignoreKt.gitignore(), FilesKt.resolve((File)data2.getRootDir(), (String)".gitignore"));
        MultiplatformModuleRecipeKt.addAndroidMain($this$generateModule, packageName, data2.getSrcDir(), language);
        File file = data2.getCommonSrcDir();
        if (file != null) {
            File dir = file;
            boolean bl = false;
            MultiplatformModuleRecipeKt.addCommonMain($this$generateModule, packageName, dir, language);
            MultiplatformModuleRecipeKt.addCommonMainDependencies($this$generateModule, projectData.getKotlinVersion());
            MultiplatformModuleRecipeKt.addCommonTestDependencies($this$generateModule, projectData.getKotlinVersion());
        }
        File file2 = data2.getIosSrcDir();
        if (file2 != null) {
            File it = file2;
            boolean bl = false;
            MultiplatformModuleRecipeKt.addIosMain($this$generateModule, packageName, it, language);
        }
        MultiplatformModuleRecipeKt.addMultiplatformLocalTests($this$generateModule, packageName, data2.getUnitTestDir());
        SharedMacrosKt.addInstrumentedTests($this$generateModule, packageName, useAndroidX2, true, data2.getTestDir(), language);
        MultiplatformModuleRecipeKt.addInstrumentedTestDependencies($this$generateModule);
        MultiplatformModuleRecipeKt.addDownloadFromMavenProperty($this$generateModule, projectData.getKotlinVersion());
    }

    public static final void addCommonMainDependencies(@NotNull RecipeExecutor $this$addCommonMainDependencies, @NotNull String kotlinVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$addCommonMainDependencies, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
        RecipeExecutor.addDependency$default((RecipeExecutor)$this$addCommonMainDependencies, (String)("org.jetbrains.kotlin:kotlin-stdlib:" + kotlinVersion), (String)"implementation", null, null, (boolean)false, (String)"commonMain", (int)28, null);
    }

    public static final void addCommonTestDependencies(@NotNull RecipeExecutor $this$addCommonTestDependencies, @NotNull String kotlinVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$addCommonTestDependencies, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
        RecipeExecutor.addDependency$default((RecipeExecutor)$this$addCommonTestDependencies, (String)("org.jetbrains.kotlin:kotlin-test:" + kotlinVersion), (String)"implementation", null, null, (boolean)false, (String)"commonTest", (int)28, null);
    }

    public static final void addInstrumentedTestDependencies(@NotNull RecipeExecutor $this$addInstrumentedTestDependencies) {
        Intrinsics.checkNotNullParameter((Object)$this$addInstrumentedTestDependencies, (String)"<this>");
        RecipeExecutor.addDependency$default((RecipeExecutor)$this$addInstrumentedTestDependencies, (String)"androidx.test:runner:+", (String)"implementation", null, null, (boolean)false, (String)"androidDeviceTest", (int)28, null);
        RecipeExecutor.addDependency$default((RecipeExecutor)$this$addInstrumentedTestDependencies, (String)"androidx.test:core:+", (String)"implementation", null, null, (boolean)false, (String)"androidDeviceTest", (int)28, null);
        RecipeExecutor.addDependency$default((RecipeExecutor)$this$addInstrumentedTestDependencies, (String)"androidx.test.ext:junit:+", (String)"implementation", null, null, (boolean)false, (String)"androidDeviceTest", (int)28, null);
    }

    public static final void addAndroidMain(@NotNull RecipeExecutor $this$addAndroidMain, @NotNull String packageName, @NotNull File outFolder, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)$this$addAndroidMain, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)outFolder, (String)"outFolder");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        String ext = language.getExtension();
        $this$addAndroidMain.save(AndroidMainKt.exampleAndroidMain(packageName), FilesKt.resolve((File)outFolder, (String)("Platform.android." + ext)));
    }

    public static final void addCommonMain(@NotNull RecipeExecutor $this$addCommonMain, @NotNull String packageName, @NotNull File outFolder, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)$this$addCommonMain, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)outFolder, (String)"outFolder");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        String ext = language.getExtension();
        $this$addCommonMain.save(CommonMainKt.exampleCommonMain(packageName), FilesKt.resolve((File)outFolder, (String)("Platform." + ext)));
    }

    public static final void addIosMain(@NotNull RecipeExecutor $this$addIosMain, @NotNull String packageName, @NotNull File outFolder, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)$this$addIosMain, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)outFolder, (String)"outFolder");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        String ext = language.getExtension();
        $this$addIosMain.save(IosMainKt.exampleIosMain(packageName), FilesKt.resolve((File)outFolder, (String)("Platform.ios." + ext)));
    }

    public static final void addMultiplatformLocalTests(@NotNull RecipeExecutor $this$addMultiplatformLocalTests, @NotNull String packageName, @NotNull File localTestOut) {
        Intrinsics.checkNotNullParameter((Object)$this$addMultiplatformLocalTests, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)localTestOut, (String)"localTestOut");
        $this$addMultiplatformLocalTests.save(ExampleUnitTestKt.exampleUnitTestWithKotlinTest(packageName), FilesKt.resolve((File)localTestOut, (String)"ExampleUnitTest.kt"));
    }

    public static final void addDownloadFromMavenProperty(@NotNull RecipeExecutor $this$addDownloadFromMavenProperty, @NotNull String kotlinVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$addDownloadFromMavenProperty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
        if (Version.Companion.parse(kotlinVersion).compareTo(Version.Companion.parse("2.0.0")) >= 0) {
            return;
        }
        $this$addDownloadFromMavenProperty.addProjectGradleProperty("kotlin.native.distribution.downloadFromMaven", "# Opt in to the future (Kotlin Gradle plugin 2.0.0) default behavior of downloading the\n       # Kotlin native libraries from Maven.\n      kotlin.native.distribution.downloadFromMaven=true");
    }
}

