/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.validator;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.npw.project.GradleAndroidModuleTemplate;
import com.android.tools.idea.projectsystem.gradle.GradleHolderProjectPath;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPathKt;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.google.common.base.CharMatcher;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00070\u0002\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/npw/validator/ModuleValidator;", "Lcom/android/tools/adtui/validation/Validator;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectPath", "Lorg/jetbrains/annotations/SystemIndependent;", "pathValidator", "Lcom/android/tools/idea/ui/validation/validators/PathValidator;", "ILLEGAL_CHAR_MATCHER", "Lcom/google/common/base/CharMatcher;", "kotlin.jvm.PlatformType", "validate", "Lcom/android/tools/adtui/validation/Validator$Result;", "moduleGradlePath", "intellij.android.newProjectWizard"})
@StabilityInferred(parameters=0)
public final class ModuleValidator
implements Validator<String> {
    @NotNull
    private final Project project;
    @NotNull
    private final String projectPath;
    @NotNull
    private final PathValidator pathValidator;
    private final CharMatcher ILLEGAL_CHAR_MATCHER;
    public static final int $stable = 8;

    public ModuleValidator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        Intrinsics.checkNotNull((Object)virtualFile);
        String string = virtualFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.projectPath = string;
        this.pathValidator = PathValidator.Companion.createDefault("module location");
        this.ILLEGAL_CHAR_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"_-: ")).negate();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public Validator.Result validate(@NotNull String moduleGradlePath) {
        Validator.Result result2;
        Intrinsics.checkNotNullParameter((Object)moduleGradlePath, (String)"moduleGradlePath");
        int illegalCharIdx = this.ILLEGAL_CHAR_MATCHER.indexIn((CharSequence)moduleGradlePath);
        Object rootedModuleGradlePath = StringsKt.startsWith$default((String)moduleGradlePath, (String)":", (boolean)false, (int)2, null) ? moduleGradlePath : ":" + moduleGradlePath;
        GradleHolderProjectPath gradleProjectPath = new GradleHolderProjectPath(this.projectPath, (String)rootedModuleGradlePath);
        if (((CharSequence)moduleGradlePath).length() == 0) {
            String string = AndroidBundle.message("android.wizard.validate.empty.module.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            result2 = new Validator.Result(Validator.Severity.ERROR, string, null, 4, null);
        } else if (illegalCharIdx >= 0) {
            Object[] objectArray = new Object[]{Character.valueOf(moduleGradlePath.charAt(illegalCharIdx)), moduleGradlePath};
            String string = AndroidBundle.message("android.wizard.validate.module.illegal.character", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            result2 = new Validator.Result(Validator.Severity.ERROR, string, null, 4, null);
        } else if (GradleProjectPathKt.resolveIn(gradleProjectPath, this.project) != null) {
            Object[] objectArray = new Object[]{moduleGradlePath};
            String string = AndroidBundle.message("android.wizard.validate.module.already.exists", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            result2 = new Validator.Result(Validator.Severity.ERROR, string, null, 4, null);
        } else {
            Path path = GradleAndroidModuleTemplate.getModuleRootForNewModule(this.projectPath, moduleGradlePath).toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            result2 = this.pathValidator.validate(path);
        }
        return result2;
    }
}

