/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable.expressions;

import com.android.tools.idea.observable.AbstractObservableValue;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ObservableValue;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public abstract class Expression<T>
extends AbstractObservableValue<T>
implements ObservableValue<T> {
    private final InvalidationListener myListener = () -> this.notifyInvalidated();

    protected Expression(ObservableValue<?> ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Can't create an expression without any target observables");
        }
        for (ObservableValue<?> value2 : values) {
            value2.addWeakListener(this.myListener);
        }
    }

    @NotNull
    public static <T> Expression<T> create(final @NotNull Supplier<? extends T> valueSupplier, ObservableValue<?> ... values) {
        return new Expression<T>((ObservableValue[])values){

            @Override
            @NotNull
            public T get() {
                return valueSupplier.get();
            }
        };
    }
}

