/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.capture;

import com.android.tools.idea.profilers.capture.AndroidProfilerCaptureFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryCaptureFileType
extends AndroidProfilerCaptureFileType {
    public static final String EXTENSION = "hprof";
    private static final MemoryCaptureFileType INSTANCE = new MemoryCaptureFileType();

    @NotNull
    public String getName() {
        return "AndroidProfilerMemoryCapture";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Android Profiler Memory capture (.hprof)";
    }

    @NotNull
    public String getDescription() {
        return "Android Profiler Memory capture file (.hprof)";
    }

    @NotNull
    public String getDefaultExtension() {
        return EXTENSION;
    }

    public static FileType getInstance() {
        return INSTANCE;
    }

    public static final class Detector
    implements FileTypeRegistry.FileTypeDetector {
        private static final byte[] magic = "JAVA PROFILE 1.0.3".getBytes(StandardCharsets.US_ASCII);

        @Nullable
        public FileType detect(@NotNull VirtualFile file, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
            if (!MemoryCaptureFileType.EXTENSION.equalsIgnoreCase(file.getExtension())) {
                return null;
            }
            if (firstBytes.length() < magic.length) {
                return null;
            }
            if (Arrays.equals(firstBytes.subSequence(0, magic.length).toBytes(), magic)) {
                return INSTANCE;
            }
            return null;
        }

        public int getDesiredContentPrefixLength() {
            return magic.length;
        }
    }
}

