/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.project.ProductionModuleClassFileFinderKt;
import com.android.tools.idea.projectsystem.ClassContent;
import com.android.tools.idea.projectsystem.ClassFileFinder;
import com.android.tools.idea.projectsystem.ClassFileFinderUtil;
import com.android.tools.idea.rendering.classloading.loaders.JarManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/project/ProductionModuleClassFileFinder;", "Lcom/android/tools/idea/projectsystem/ClassFileFinder;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "jarManager", "Lcom/android/tools/idea/rendering/classloading/loaders/JarManager;", "findClassFile", "Lcom/android/tools/idea/projectsystem/ClassContent;", "fqcn", "", "visited", "", "findClassFileInModuleWithLogging", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nProductionModuleClassFileFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProductionModuleClassFileFinder.kt\ncom/android/tools/idea/project/ProductionModuleClassFileFinder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n13402#2,2:97\n1#3:99\n*S KotlinDebug\n*F\n+ 1 ProductionModuleClassFileFinder.kt\ncom/android/tools/idea/project/ProductionModuleClassFileFinder\n*L\n63#1:97,2\n*E\n"})
public final class ProductionModuleClassFileFinder
implements ClassFileFinder {
    @NotNull
    private final Module module;
    @NotNull
    private final JarManager jarManager;

    public ProductionModuleClassFileFinder(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.jarManager = JarManager.Companion.getInstance(project);
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @Override
    @Nullable
    public ClassContent findClassFile(@NotNull String fqcn) {
        Intrinsics.checkNotNullParameter((Object)fqcn, (String)"fqcn");
        return this.findClassFile(this.module, fqcn, new LinkedHashSet());
    }

    private final ClassContent findClassFile(Module module, String fqcn, Set<Module> visited) {
        if (!visited.add(module) || module.isDisposed()) {
            return null;
        }
        ProductionModuleClassFileFinderKt.access$debugIfEnabled(ProductionModuleClassFileFinderKt.access$getLOG$p(), "findClassFile(module=" + module + ", fqcn=" + fqcn + ")})");
        try {
            ClassContent classFile;
            ClassContent classContent = classFile = this.findClassFileInModuleWithLogging(module, fqcn);
            if (classContent != null) {
                return classContent;
            }
            Module[] moduleArray = ModuleRootManager.getInstance((Module)module).getDependencies(false);
            Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"getDependencies(...)");
            Object[] $this$forEach$iv = moduleArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClassContent classFile2;
                Module depModule = (Module)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)depModule);
                ClassContent classContent2 = classFile2 = this.findClassFile(depModule, fqcn, visited);
                if (classContent2 == null) continue;
                return classContent2;
            }
        }
        catch (Throwable t) {
            if (module.isDisposed()) {
                return null;
            }
            throw t;
        }
        return null;
    }

    private final ClassContent findClassFileInModuleWithLogging(Module module, String fqcn) {
        ClassContent classContent;
        ProductionModuleClassFileFinderKt.access$debugIfEnabled(ProductionModuleClassFileFinderKt.access$getLOG$p(), "findClassInModule(module=" + module + ", fqcn=" + fqcn + ")");
        Object object = CompilerModuleExtension.getInstance((Module)module);
        if (object == null || (object = object.getCompilerOutputUrl()) == null) {
            return null;
        }
        Object it = object;
        boolean bl = false;
        File compilerOutput = new File(URLUtil.urlToPath((String)it));
        if (!compilerOutput.exists()) {
            return null;
        }
        String classFileRelativePath = ClassFileFinderUtil.getPathFromFqcn(fqcn);
        if (compilerOutput.isDirectory()) {
            File file = FilesKt.resolve((File)compilerOutput, (String)classFileRelativePath);
            it = file;
            boolean bl2 = false;
            File file2 = ((File)it).isFile() ? file : null;
            if (file2 == null) {
                return null;
            }
            File classFile = file2;
            classContent = ClassContent.Companion.loadFromFile(classFile);
        } else if (compilerOutput.isFile() && Intrinsics.areEqual((Object)FilesKt.getExtension((File)compilerOutput), (Object)"jar")) {
            Path path = compilerOutput.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            byte[] byArray = this.jarManager.loadFileFromJar(path, classFileRelativePath);
            if (byArray == null) {
                return null;
            }
            byte[] bytes = byArray;
            classContent = ClassContent.Companion.fromJarEntryContent(compilerOutput, bytes);
        } else {
            ProductionModuleClassFileFinderKt.access$getLOG$p().warn(compilerOutput + " is neither a directory nor a jar.");
            classContent = null;
        }
        return classContent;
    }
}

