/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleModelProvider;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.GradleVersionCatalogView;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.GradleModelFactory;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleVersionCatalogViewImpl;
import com.android.tools.idea.gradle.dsl.model.ProjectBuildModelImpl;
import com.android.tools.idea.gradle.dsl.model.SimplifiedVersionCatalogViewImpl;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.projectsystem.AndroidProjectRootUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class GradleModelSource
extends GradleModelProvider {
    private static final BuildModelContext.ResolvedConfigurationFileLocationProvider myResolvedConfigurationFileLocationProvider = new ResolvedConfigurationFileLocationProviderImpl();

    @Override
    @NotNull
    public ProjectBuildModel getProjectModel(@NotNull Project project) {
        BuildModelContext context = GradleModelSource.createContext(project);
        VirtualFile file = context.getGradleBuildFile(Projects.getBaseDirPath((Project)project));
        return new ProjectBuildModelImpl(project, file, context);
    }

    @Override
    @Nullable
    public ProjectBuildModel getProjectModel(@NotNull Project hostProject, @NotNull String compositeRoot) {
        BuildModelContext context = GradleModelSource.createContext(hostProject);
        VirtualFile file = context.getGradleBuildFile(new File(compositeRoot));
        if (file == null) {
            return null;
        }
        return new ProjectBuildModelImpl(hostProject, file, context);
    }

    @Override
    @Nullable
    public GradleBuildModel getBuildModel(@NotNull Project project) {
        BuildModelContext context = GradleModelSource.createContext(project);
        VirtualFile file = context.getGradleBuildFile(Projects.getBaseDirPath((Project)project));
        return file != null ? GradleModelSource.internalCreateBuildModel(context, file, project.getName()) : null;
    }

    @Override
    @Nullable
    public GradleBuildModel getBuildModel(@NotNull Module module) {
        BuildModelContext context = GradleModelSource.createContext(module.getProject());
        VirtualFile file = context.getGradleBuildFile(module);
        return file != null ? GradleModelSource.internalCreateBuildModel(context, file, module.getName()) : null;
    }

    @Override
    @NotNull
    public GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project) {
        return GradleModelSource.internalCreateBuildModel(GradleModelSource.createContext(project), file, "<Unknown>");
    }

    @Override
    @NotNull
    public GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        return GradleModelSource.internalCreateBuildModel(GradleModelSource.createContext(project), file, moduleName);
    }

    @Override
    @Nullable
    public GradleSettingsModel getSettingsModel(@NotNull Project project) {
        BuildModelContext context = GradleModelSource.createContext(project);
        VirtualFile file = context.getGradleSettingsFile(Projects.getBaseDirPath((Project)project));
        return file != null ? GradleModelSource.parseSettingsFile(context, file, project, "settings") : null;
    }

    @Override
    @NotNull
    public GradleSettingsModel getSettingsModel(@NotNull VirtualFile settingsFile, @NotNull Project hostProject) {
        return GradleModelSource.parseSettingsFile(GradleModelSource.createContext(hostProject), settingsFile, hostProject, "settings");
    }

    @Override
    @Nullable
    public GradleSettingsModel getSettingsModel(@NotNull Project hostProject, @NotNull String compositeRoot) {
        BuildModelContext context = GradleModelSource.createContext(hostProject);
        VirtualFile file = context.getGradleSettingsFile(new File(compositeRoot));
        return file != null ? GradleModelSource.parseSettingsFile(context, file, hostProject, "settings") : null;
    }

    @Override
    @NotNull
    public GradleVersionCatalogView getVersionCatalogView(@NotNull Project hostProject) {
        GradleSettingsModel settings = this.getSettingsModel(hostProject);
        if (settings != null) {
            return new GradleVersionCatalogViewImpl(settings);
        }
        return new SimplifiedVersionCatalogViewImpl(hostProject);
    }

    @Override
    @Nullable
    public GradleVersionCatalogView getVersionCatalogView(@NotNull Project hostProject, @NotNull String compositeRoot) {
        GradleSettingsModel settings = this.getSettingsModel(hostProject, compositeRoot);
        if (settings != null) {
            return new GradleVersionCatalogViewImpl(settings);
        }
        return new SimplifiedVersionCatalogViewImpl(compositeRoot);
    }

    @NotNull
    private static GradleBuildModel internalCreateBuildModel(@NotNull BuildModelContext context, @NotNull VirtualFile file, @NotNull String moduleName) {
        return GradleModelFactory.createGradleBuildModel(context.getOrCreateBuildFile(file, moduleName, false));
    }

    @NotNull
    private static GradleSettingsModel parseSettingsFile(@NotNull BuildModelContext context, @NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        GradleSettingsFile settingsFile = new GradleSettingsFile(file, project, moduleName, context);
        settingsFile.parse();
        return new GradleSettingsModelImpl(settingsFile);
    }

    @NotNull
    private static BuildModelContext createContext(@NotNull Project project) {
        return BuildModelContext.create(project, myResolvedConfigurationFileLocationProvider);
    }

    private static class ResolvedConfigurationFileLocationProviderImpl
    implements BuildModelContext.ResolvedConfigurationFileLocationProvider {
        private ResolvedConfigurationFileLocationProviderImpl() {
        }

        @Override
        @Nullable
        public VirtualFile getGradleBuildFile(@NotNull Module module) {
            GradleModuleModel moduleModel = GradleProjectSystemUtil.getGradleModuleModel(module);
            if (moduleModel != null) {
                return moduleModel.getBuildFile();
            }
            return null;
        }

        @Override
        @Nullable
        public @SystemIndependent String getGradleProjectRootPath(@NotNull Module module) {
            return AndroidProjectRootUtil.getModuleDirPath(module);
        }

        @Override
        @Nullable
        public @SystemIndependent String getGradleProjectRootPath(@NotNull Project project) {
            VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
            if (projectDir == null) {
                return null;
            }
            return projectDir.getPath();
        }
    }
}

