/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle;

import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.BuildSummary;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.projectsystem.ProjectSystemBuildManager;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystemBuildManagerKt;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystemBuildPublisher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/projectsystem/gradle/GradleProjectSystemBuildManager;", "Lcom/android/tools/idea/projectsystem/ProjectSystemBuildManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "compileProject", "", "getLastBuildResult", "Lcom/android/tools/idea/projectsystem/ProjectSystemBuildManager$BuildResult;", "addBuildListener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "buildListener", "Lcom/android/tools/idea/projectsystem/ProjectSystemBuildManager$BuildListener;", "isBuilding", "", "()Z", "intellij.android.projectSystem.gradle"})
public final class GradleProjectSystemBuildManager
implements ProjectSystemBuildManager {
    @NotNull
    private final Project project;

    public GradleProjectSystemBuildManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.project.getService(GradleProjectSystemBuildPublisher.class);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void compileProject() {
        Module[] modules = ModuleManager.Companion.getInstance(this.project).getModules();
        GradleBuildInvoker.Companion.getInstance(this.project).compileJava(modules);
    }

    @Override
    @NotNull
    public ProjectSystemBuildManager.BuildResult getLastBuildResult() {
        ProjectSystemBuildManager.BuildResult buildResult;
        BuildSummary buildSummary = GradleBuildState.getInstance(this.project).getLastFinishedBuildSummary();
        if (buildSummary != null) {
            BuildSummary it = buildSummary;
            boolean bl = false;
            Object object = it.getContext();
            if (object == null || (object = object.getBuildMode()) == null || (object = GradleProjectSystemBuildManagerKt.toProjectSystemBuildMode((BuildMode)object)) == null) {
                object = ProjectSystemBuildManager.BuildMode.UNKNOWN;
            }
            BuildStatus buildStatus = it.getStatus();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)buildStatus), (String)"getStatus(...)");
            buildResult = new ProjectSystemBuildManager.BuildResult((ProjectSystemBuildManager.BuildMode)((Object)object), GradleProjectSystemBuildManagerKt.toProjectSystemBuildStatus(buildStatus));
        } else {
            buildResult = ProjectSystemBuildManager.BuildResult.Companion.createUnknownBuildResult();
        }
        return buildResult;
    }

    @Override
    public void addBuildListener(@NotNull Disposable parentDisposable, @NotNull ProjectSystemBuildManager.BuildListener buildListener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)buildListener2, (String)"buildListener");
        ((GradleProjectSystemBuildPublisher)this.project.getService(GradleProjectSystemBuildPublisher.class)).addBuildListener(parentDisposable, buildListener2);
    }

    @Override
    public boolean isBuilding() {
        return ((GradleProjectSystemBuildPublisher)this.project.getService(GradleProjectSystemBuildPublisher.class)).isBuilding();
    }
}

