/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.modularize;

import com.android.tools.idea.refactoring.modularize.AndroidModularizeProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.CollectionComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/refactoring/modularize/AndroidModularizeDialog;", "Lcom/intellij/refactoring/ui/RefactoringDialog;", "project", "Lcom/intellij/openapi/project/Project;", "targetModules", "", "Lcom/intellij/openapi/module/Module;", "processor", "Lcom/android/tools/idea/refactoring/modularize/AndroidModularizeProcessor;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/android/tools/idea/refactoring/modularize/AndroidModularizeProcessor;)V", "myModuleCombo", "Lcom/intellij/openapi/ui/ComboBox;", "doAction", "", "createCenterPanel", "Ljavax/swing/JComponent;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAndroidModularizeDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidModularizeDialog.kt\ncom/android/tools/idea/refactoring/modularize/AndroidModularizeDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1053#2:68\n*S KotlinDebug\n*F\n+ 1 AndroidModularizeDialog.kt\ncom/android/tools/idea/refactoring/modularize/AndroidModularizeDialog\n*L\n61#1:68\n*E\n"})
public final class AndroidModularizeDialog
extends RefactoringDialog {
    @NotNull
    private final List<Module> targetModules;
    @NotNull
    private final AndroidModularizeProcessor processor;
    private ComboBox<Module> myModuleCombo;

    public AndroidModularizeDialog(@NotNull Project project, @NotNull List<? extends Module> targetModules, @NotNull AndroidModularizeProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(targetModules, (String)"targetModules");
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        super(project, true);
        this.targetModules = targetModules;
        this.processor = processor;
        this.setTitle("Modularize");
        this.init();
    }

    protected void doAction() {
        ComboBox<Module> comboBox2 = this.myModuleCombo;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myModuleCombo");
            comboBox2 = null;
        }
        Object object = comboBox2.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.module.Module");
        this.processor.setTargetModule((Module)object);
        this.processor.setPreviewUsages(this.isPreviewUsages());
        this.close(0);
        this.processor.run();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        Locale locale = Locale.US;
        String string = "Move %1$d classes, " + (this.processor.getKtTopLevelDeclarationsCount() != 0 ? "%2$d top-level declarations, " : "") + "and %3$d resources to:";
        Object[] objectArray = new Object[]{this.processor.getClassesCount(), this.processor.getKtTopLevelDeclarationsCount(), this.processor.getResourcesCount()};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        panel2.add((Component)new JLabel(string2), "North");
        Iterable $this$sortedBy$iv = this.targetModules;
        boolean $i$f$sortedBy = false;
        ComboBoxModel model = (ComboBoxModel)new CollectionComboBoxModel(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Module it = (Module)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Module)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        }));
        this.myModuleCombo = new ComboBox(model);
        ComboBox<Module> comboBox2 = this.myModuleCombo;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myModuleCombo");
            comboBox2 = null;
        }
        panel2.add((Component)comboBox2, "Center");
        return panel2;
    }
}

