/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.sampledata.datasource.CombinerDataSource;
import com.android.tools.idea.sampledata.datasource.DateTimeGenerator;
import com.android.tools.idea.sampledata.datasource.LoremIpsumGenerator;
import com.android.tools.idea.sampledata.datasource.NumberGenerator;
import com.android.tools.idea.sampledata.datasource.ResourceContent;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PredefinedSampleDataResourceRepository
extends AbstractResourceRepository
implements SingleNamespaceResourceRepository {
    public static final ResourceNamespace NAMESPACE = ResourceNamespace.TOOLS;
    @NotNull
    private static final PredefinedSampleDataResourceRepository INSTANCE = new PredefinedSampleDataResourceRepository();
    @NotNull
    private final ImmutableListMultimap<String, ResourceItem> myResources;

    @NotNull
    public static PredefinedSampleDataResourceRepository getInstance() {
        return INSTANCE;
    }

    private PredefinedSampleDataResourceRepository() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (SampleDataResourceItem resource : this.getPredefinedSources()) {
            builder.put((Object)resource.getName(), (Object)resource);
        }
        this.myResources = builder.build();
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        return NAMESPACE;
    }

    @Nullable
    public String getPackageName() {
        return NAMESPACE.getPackageName();
    }

    @NotNull
    protected ListMultimap<String, ResourceItem> getResourcesInternal(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType) {
        return namespace.equals((Object)NAMESPACE) && resourceType == ResourceType.SAMPLE_DATA ? this.myResources : ImmutableListMultimap.of();
    }

    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor2) {
        if (visitor2.shouldVisitNamespace(NAMESPACE) && visitor2.shouldVisitResourceType(ResourceType.SAMPLE_DATA)) {
            for (ResourceItem item : this.myResources.values()) {
                if (visitor2.visit(item) != ResourceVisitor.VisitResult.ABORT) continue;
                return ResourceVisitor.VisitResult.ABORT;
            }
        }
        return ResourceVisitor.VisitResult.CONTINUE;
    }

    @NotNull
    public Collection<ResourceItem> getPublicResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        return this.myResources.values();
    }

    private SampleDataResourceItem[] getPredefinedSources() {
        return new SampleDataResourceItem[]{SampleDataResourceItem.getFromStaticDataSource(this, "full_names", new CombinerDataSource(PredefinedSampleDataResourceRepository.getResourceAsStream("sampleData/names.txt"), PredefinedSampleDataResourceRepository.getResourceAsStream("sampleData/surnames.txt")), SampleDataResourceItem.ContentType.TEXT), SampleDataResourceItem.getFromStaticDataSource(this, "first_names", ResourceContent.fromInputStream(PredefinedSampleDataResourceRepository.getResourceAsStream("sampleData/names.txt")), SampleDataResourceItem.ContentType.TEXT), SampleDataResourceItem.getFromStaticDataSource(this, "last_names", ResourceContent.fromInputStream(PredefinedSampleDataResourceRepository.getResourceAsStream("sampleData/surnames.txt")), SampleDataResourceItem.ContentType.TEXT), SampleDataResourceItem.getFromStaticDataSource(this, "cities", ResourceContent.fromInputStream(PredefinedSampleDataResourceRepository.getResourceAsStream("sampleData/cities.txt")), SampleDataResourceItem.ContentType.TEXT), SampleDataResourceItem.getFromStaticDataSource(this, "us_zipcodes", new NumberGenerator("%05d", 20000, 99999), SampleDataResourceItem.ContentType.TEXT), SampleDataResourceItem.getFromStaticDataSource(this, "us_phones", new NumberGenerator("(800) 555-%04d", 0, 9999), SampleDataResourceItem.ContentType.TEXT), SampleDataResourceItem.getFromStaticDataSource(this, "lorem", new LoremIpsumGenerator(false), SampleDataResourceItem.ContentType.TEXT), SampleDataResourceItem.getFromStaticDataSource(this, "lorem/random", new LoremIpsumGenerator(true), SampleDataResourceItem.ContentType.TEXT), SampleDataResourceItem.getFromStaticDataSource(this, "avatars", ResourceContent.fromDirectory("avatars"), SampleDataResourceItem.ContentType.IMAGE), SampleDataResourceItem.getFromStaticDataSource(this, "backgrounds/scenic", ResourceContent.fromDirectory("backgrounds/scenic"), SampleDataResourceItem.ContentType.IMAGE), SampleDataResourceItem.getFromStaticDataSource(this, "date/day_of_week", new DateTimeGenerator(DateTimeFormatter.ofPattern("E"), ChronoUnit.DAYS), SampleDataResourceItem.ContentType.TEXT), SampleDataResourceItem.getFromStaticDataSource(this, "date/ddmmyy", new DateTimeGenerator(DateTimeFormatter.ofPattern("dd-MM-yy"), ChronoUnit.DAYS), SampleDataResourceItem.ContentType.TEXT), SampleDataResourceItem.getFromStaticDataSource(this, "date/mmddyy", new DateTimeGenerator(DateTimeFormatter.ofPattern("MM-dd-yy"), ChronoUnit.DAYS), SampleDataResourceItem.ContentType.TEXT), SampleDataResourceItem.getFromStaticDataSource(this, "date/hhmm", new DateTimeGenerator(DateTimeFormatter.ofPattern("hh:mm"), ChronoUnit.MINUTES), SampleDataResourceItem.ContentType.TEXT), SampleDataResourceItem.getFromStaticDataSource(this, "date/hhmmss", new DateTimeGenerator(DateTimeFormatter.ofPattern("hh:mm:ss"), ChronoUnit.SECONDS), SampleDataResourceItem.ContentType.TEXT)};
    }

    private static InputStream getResourceAsStream(@NotNull String name2) {
        return PredefinedSampleDataResourceRepository.class.getClassLoader().getResourceAsStream(name2);
    }
}

