/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.tools.concurrency.AndroidIoManager;
import com.android.tools.idea.model.Namespacing;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceFolderDocumentListener;
import com.android.tools.idea.res.ResourceFolderFileDocumentManagerListener;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceFolderRepositoryCachingData;
import com.android.tools.idea.res.ResourceFolderRepositoryFileCacheService;
import com.android.tools.idea.res.ResourceFolderVfsListener;
import com.android.tools.idea.res.ResourceUpdateTracer;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.utils.TraceUtils;
import com.android.utils.concurrency.CacheUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 '2\u00020\u0001:\u0002'(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0086\u0002J!\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0087\u0002J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012J$\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\u001c\u0010\u001c\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\"\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\n2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\n0!J\u001c\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\n2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#J\u0014\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J \u0010&\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rb\u0010\r\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b \u000f*\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t0\t \u000f**\u0012$\u0012\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b \u000f*\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t0\t\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/res/ResourceFolderRegistry;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "namespacedCache", "Lcom/google/common/cache/Cache;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/android/tools/idea/res/ResourceFolderRepository;", "nonNamespacedCache", "cacheList", "Lcom/google/common/collect/ImmutableList;", "kotlin.jvm.PlatformType", "get", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "dir", "namespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "getCached", "namespacing", "Lcom/android/tools/idea/model/Namespacing;", "reset", "", "cache", "removeStaleEntries", "dispose", "dispatchToRepositories", "file", "handler", "Ljava/util/function/BiConsumer;", "invokeCallback", "Lcom/intellij/util/Consumer;", "Lcom/intellij/psi/PsiTreeChangeListener;", "buildCache", "createRepository", "Companion", "PopulateCachesTask", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nResourceFolderRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceFolderRegistry.kt\ncom/android/tools/idea/res/ResourceFolderRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,412:1\n1611#2,9:413\n1863#2:422\n1864#2:425\n1620#2:426\n1863#2,2:427\n1#3:423\n1#3:424\n*S KotlinDebug\n*F\n+ 1 ResourceFolderRegistry.kt\ncom/android/tools/idea/res/ResourceFolderRegistry\n*L\n139#1:413,9\n139#1:422\n139#1:425\n139#1:426\n143#1:427,2\n139#1:424\n*E\n"})
public final class ResourceFolderRegistry
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Cache<VirtualFile, ResourceFolderRepository> namespacedCache;
    @NotNull
    private final Cache<VirtualFile, ResourceFolderRepository> nonNamespacedCache;
    private final ImmutableList<Cache<VirtualFile, ResourceFolderRepository>> cacheList;

    public ResourceFolderRegistry(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.namespacedCache = this.buildCache();
        this.nonNamespacedCache = this.buildCache();
        this.cacheList = ImmutableList.of(this.namespacedCache, this.nonNamespacedCache);
        ModuleRootListener moduleRootListener2 = new ModuleRootListener(this){
            final /* synthetic */ ResourceFolderRegistry this$0;
            {
                this.this$0 = $receiver;
            }

            public void rootsChanged(ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ResourceFolderRegistry.access$removeStaleEntries(this.this$0);
            }
        };
        ResourceFolderVfsListener vfsListener = new ResourceFolderVfsListener(this);
        ResourceFolderFileDocumentManagerListener fileDocumentManagerListener = new ResourceFolderFileDocumentManagerListener(this);
        MessageBusConnection $this$_init__u24lambda_u240 = this.project.getMessageBus().connect((Disposable)this);
        boolean bl = false;
        Topic topic = ModuleRootListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        $this$_init__u24lambda_u240.subscribe(topic, (Object)moduleRootListener2);
        Topic topic2 = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"VFS_CHANGES");
        $this$_init__u24lambda_u240.subscribe(topic2, (Object)vfsListener);
        Topic topic3 = FileDocumentManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic3, (String)"TOPIC");
        $this$_init__u24lambda_u240.subscribe(topic3, (Object)fileDocumentManagerListener);
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new ResourceFolderDocumentListener(this.project, this), (Disposable)this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ResourceFolderRepository get(@NotNull AndroidFacet facet, @NotNull VirtualFile dir) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        ResourceNamespace resourceNamespace = StudioResourceRepositoryManager.getInstance(facet).getNamespace();
        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"<get-namespace>(...)");
        return this.get(facet, dir, resourceNamespace);
    }

    @VisibleForTesting
    @NotNull
    public final ResourceFolderRepository get(@NotNull AndroidFacet facet, @NotNull VirtualFile dir, @NotNull ResourceNamespace namespace) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Cache<VirtualFile, ResourceFolderRepository> cache = namespace == ResourceNamespace.RES_AUTO ? this.nonNamespacedCache : this.namespacedCache;
        ResourceFolderRepository repository2 = (ResourceFolderRepository)CacheUtils.getAndUnwrap(cache, (Object)dir, () -> ResourceFolderRegistry.get$lambda$1(this, facet, dir, namespace));
        boolean bl = Intrinsics.areEqual((Object)repository2.getNamespace(), (Object)namespace);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ResourceFolderRepository resourceFolderRepository = repository2.ensureLoaded();
        Intrinsics.checkNotNullExpressionValue((Object)resourceFolderRepository, (String)"ensureLoaded(...)");
        return resourceFolderRepository;
    }

    @Nullable
    public final ResourceFolderRepository getCached(@NotNull VirtualFile dir, @NotNull Namespacing namespacing) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)((Object)namespacing), (String)"namespacing");
        Cache<VirtualFile, ResourceFolderRepository> cache = namespacing == Namespacing.REQUIRED ? this.namespacedCache : this.nonNamespacedCache;
        return (ResourceFolderRepository)cache.getIfPresent((Object)dir);
    }

    public final void reset(@NotNull AndroidFacet facet) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        ResourceUpdateTracer.Companion.logDirect((Function0<String>)((Function0)() -> ResourceFolderRegistry.reset$lambda$2(this)));
        this.reset(this.namespacedCache, facet);
        this.reset(this.nonNamespacedCache, facet);
    }

    /*
     * WARNING - void declaration
     */
    private final void reset(Cache<VirtualFile, ResourceFolderRepository> cache, AndroidFacet facet) {
        void $this$mapNotNullTo$iv$iv;
        ConcurrentMap cacheAsMap = cache.asMap();
        if (cacheAsMap.isEmpty()) {
            ResourceUpdateTracer.Companion.logDirect((Function0<String>)((Function0)() -> ResourceFolderRegistry.reset$lambda$3(this)));
            return;
        }
        Iterable $this$mapNotNull$iv = cacheAsMap.entrySet();
        boolean $i$f$mapNotNull = false;
        Object object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VirtualFile it$iv$iv;
            VirtualFile virtualFile;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            VirtualFile virtualFile2 = (VirtualFile)entry.getKey();
            ResourceFolderRepository repository2 = (ResourceFolderRepository)entry.getValue();
            VirtualFile it = virtualFile = virtualFile2;
            boolean bl3 = false;
            if ((Intrinsics.areEqual((Object)repository2.getFacet(), (Object)facet) ? virtualFile : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List keysToRemove = (List)destination$iv$iv;
        Iterable $this$forEach$iv = keysToRemove;
        boolean $i$f$forEach2 = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv;
            Object p0 = element$iv = object.next();
            boolean bl = false;
            cache.invalidate(p0);
        }
    }

    private final void removeStaleEntries() {
        ResourceUpdateTracer.Companion.logDirect((Function0<String>)((Function0)() -> ResourceFolderRegistry.removeStaleEntries$lambda$6(this)));
        this.removeStaleEntries(this.namespacedCache);
        this.removeStaleEntries(this.nonNamespacedCache);
    }

    private final void removeStaleEntries(Cache<VirtualFile, ResourceFolderRepository> cache) {
        ConcurrentMap cacheAsMap = cache.asMap();
        if (cacheAsMap.isEmpty()) {
            ResourceUpdateTracer.Companion.logDirect((Function0<String>)((Function0)() -> ResourceFolderRegistry.removeStaleEntries$lambda$7(this)));
            return;
        }
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)cacheAsMap.size());
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSetWithExpectedSize(...)");
        Set facets = hashSet;
        HashSet hashSet2 = Sets.newHashSetWithExpectedSize((int)cacheAsMap.size());
        Intrinsics.checkNotNullExpressionValue((Object)hashSet2, (String)"newHashSetWithExpectedSize(...)");
        Set newResourceFolders = hashSet2;
        for (ResourceFolderRepository repository2 : cacheAsMap.values()) {
            AndroidFacet facet;
            Intrinsics.checkNotNullExpressionValue((Object)repository2.getFacet(), (String)"getFacet(...)");
            if (facet.isDisposed() || !facets.add(facet)) continue;
            ResourceFolderManager folderManager = ResourceFolderManager.Companion.getInstance(facet);
            newResourceFolders.addAll((Collection)folderManager.getFolders());
        }
        ResourceUpdateTracer.Companion.logDirect((Function0<String>)((Function0)() -> ResourceFolderRegistry.removeStaleEntries$lambda$8(this, newResourceFolders)));
        cacheAsMap.keySet().retainAll(newResourceFolders);
    }

    public void dispose() {
        this.namespacedCache.invalidateAll();
        this.nonNamespacedCache.invalidateAll();
    }

    public final void dispatchToRepositories(@NotNull VirtualFile file, @NotNull BiConsumer<ResourceFolderRepository, VirtualFile> handler2) {
        VirtualFile dir;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        ResourceUpdateTracer.Companion.log((Function0<String>)((Function0)() -> ResourceFolderRegistry.dispatchToRepositories$lambda$9(file)));
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
        while (dir != null) {
            UnmodifiableIterator unmodifiableIterator;
            Intrinsics.checkNotNullExpressionValue((Object)this.cacheList.iterator(), (String)"iterator(...)");
            while (unmodifiableIterator.hasNext()) {
                ResourceFolderRepository it;
                Cache cache = (Cache)unmodifiableIterator.next();
                if ((ResourceFolderRepository)cache.getIfPresent((Object)dir) == null) continue;
                boolean bl = false;
                handler2.accept(it, file);
            }
            dir = dir.getParent();
        }
    }

    public final void dispatchToRepositories(@NotNull VirtualFile file, @NotNull Consumer<PsiTreeChangeListener> invokeCallback) {
        VirtualFile dir;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(invokeCallback, (String)"invokeCallback");
        ResourceUpdateTracer.Companion.log((Function0<String>)((Function0)() -> ResourceFolderRegistry.dispatchToRepositories$lambda$11(file)));
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
        while (dir != null) {
            UnmodifiableIterator unmodifiableIterator;
            Intrinsics.checkNotNullExpressionValue((Object)this.cacheList.iterator(), (String)"iterator(...)");
            while (unmodifiableIterator.hasNext()) {
                ResourceFolderRepository it;
                Cache cache = (Cache)unmodifiableIterator.next();
                if ((ResourceFolderRepository)cache.getIfPresent((Object)dir) == null) continue;
                boolean bl = false;
                invokeCallback.consume((Object)it.getPsiListener());
            }
            dir = dir.getParent();
        }
    }

    private final Cache<VirtualFile, ResourceFolderRepository> buildCache() {
        Cache cache = CacheBuilder.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        return cache;
    }

    private final ResourceFolderRepository createRepository(AndroidFacet facet, VirtualFile dir, ResourceNamespace namespace) {
        Executor executor = ApplicationManager.getApplication().isUnitTestMode() ? ResourceFolderRegistry::createRepository$lambda$13 : (Executor)AndroidIoManager.Companion.getInstance().getBackgroundDiskIoExecutor();
        ResourceFolderRepositoryCachingData cachingData = ResourceFolderRepositoryFileCacheService.get().getCachingData(facet.getModule().getProject(), dir, executor);
        ResourceFolderRepository resourceFolderRepository = ResourceFolderRepository.create(facet, dir, namespace, cachingData);
        Intrinsics.checkNotNullExpressionValue((Object)resourceFolderRepository, (String)"create(...)");
        return resourceFolderRepository;
    }

    private static final ResourceFolderRepository get$lambda$1(ResourceFolderRegistry this$0, AndroidFacet $facet, VirtualFile $dir, ResourceNamespace $namespace) {
        return this$0.createRepository($facet, $dir, $namespace);
    }

    private static final String reset$lambda$2(ResourceFolderRegistry this$0) {
        return TraceUtils.getSimpleId((Object)this$0) + ".reset()";
    }

    private static final String reset$lambda$3(ResourceFolderRegistry this$0) {
        return TraceUtils.getSimpleId((Object)this$0) + ".reset: cache is empty";
    }

    private static final String removeStaleEntries$lambda$6(ResourceFolderRegistry this$0) {
        return TraceUtils.getSimpleId((Object)this$0) + ".removeStaleEntries()";
    }

    private static final String removeStaleEntries$lambda$7(ResourceFolderRegistry this$0) {
        return TraceUtils.getSimpleId((Object)this$0) + ".removeStaleEntries: cache is empty";
    }

    private static final String removeStaleEntries$lambda$8(ResourceFolderRegistry this$0, Set $newResourceFolders) {
        return TraceUtils.getSimpleId((Object)this$0) + ".removeStaleEntries retained " + ResourceUpdateTracer.Companion.getInstance().pathsForLogging($newResourceFolders, this$0.project);
    }

    private static final String dispatchToRepositories$lambda$9(VirtualFile $file) {
        return "ResourceFolderRegistry.dispatchToRepositories(" + ResourceUpdateTracer.Companion.getInstance().pathForLogging($file) + ", ...) VFS change";
    }

    private static final String dispatchToRepositories$lambda$11(VirtualFile $file) {
        return "ResourceFolderRegistry.dispatchToRepositories(" + ResourceUpdateTracer.Companion.getInstance().pathForLogging($file) + ", ...) PSI change";
    }

    private static final void createRepository$lambda$13(Runnable runnable2) {
    }

    @JvmStatic
    @NotNull
    public static final ResourceFolderRegistry getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ void access$removeStaleEntries(ResourceFolderRegistry $this) {
        $this.removeStaleEntries();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/res/ResourceFolderRegistry$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/res/ResourceFolderRegistry;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nResourceFolderRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceFolderRegistry.kt\ncom/android/tools/idea/res/ResourceFolderRegistry$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,412:1\n31#2,2:413\n*S KotlinDebug\n*F\n+ 1 ResourceFolderRegistry.kt\ncom/android/tools/idea/res/ResourceFolderRegistry$Companion\n*L\n233#1:413,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ResourceFolderRegistry getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ResourceFolderRegistry> serviceClass$iv = ResourceFolderRegistry.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ResourceFolderRegistry)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/res/ResourceFolderRegistry$PopulateCachesTask;", "Lcom/intellij/openapi/project/DumbModeTask;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "tryMergeWith", "taskFromQueue", "performInDumbMode", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.android.core"})
    public static final class PopulateCachesTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;

        public PopulateCachesTask(@NotNull Project myProject) {
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            this.myProject = myProject;
        }

        @Nullable
        public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
            Intrinsics.checkNotNullParameter((Object)taskFromQueue, (String)"taskFromQueue");
            return taskFromQueue instanceof PopulateCachesTask && Intrinsics.areEqual((Object)((PopulateCachesTask)taskFromQueue).myProject, (Object)this.myProject) ? (DumbModeTask)this : null;
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            List list = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFacets(...)");
            List facets = list;
            if (facets.isEmpty()) {
                return;
            }
            indicator.setText("Indexing resources");
            indicator.setIndeterminate(false);
            Map<VirtualFile, AndroidFacet> resDirectories = IdeResourcesUtil.getResourceDirectoriesForFacets(facets);
            if (resDirectories.isEmpty()) {
                return;
            }
            try {
                ResourceFolderRepositoryFileCacheService.get().createDirForProject(this.myProject);
            }
            catch (IOException e) {
                return;
            }
            Application application = ApplicationManager.getApplication();
            boolean bl2 = bl = !application.isWriteAccessAllowed();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            int numDone = 0;
            ExecutorService parallelExecutor = AndroidIoManager.Companion.getInstance().getBackgroundDiskIoExecutor();
            List repositoryJobs = new ArrayList();
            for (Map.Entry<VirtualFile, AndroidFacet> entry : resDirectories.entrySet()) {
                VirtualFile dir = entry.getKey();
                AndroidFacet facet = entry.getValue();
                ResourceFolderRegistry registry = Companion.getInstance(this.myProject);
                Future<ResourceFolderRepository> future2 = parallelExecutor.submit(() -> PopulateCachesTask.performInDumbMode$lambda$0(registry, facet, dir));
                Intrinsics.checkNotNullExpressionValue(future2, (String)"submit(...)");
                repositoryJobs.add(future2);
            }
            for (Future job2 : repositoryJobs) {
                if (indicator.isCanceled()) break;
                indicator.setFraction((double)numDone / (double)resDirectories.size());
                try {
                    job2.get();
                }
                catch (ExecutionException facet) {
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ++numDone;
            }
        }

        private static final ResourceFolderRepository performInDumbMode$lambda$0(ResourceFolderRegistry $registry, AndroidFacet $facet, VirtualFile $dir) {
            return $registry.get($facet, $dir);
        }
    }
}

