/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.FileResourceNameValidator;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicDensityBasedFileResourceItem;
import com.android.resources.base.BasicFileResourceItem;
import com.android.resources.base.BasicResourceItem;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.LoadableResourceRepository;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.RepositoryLoader;
import com.android.resources.base.ResourceSerializationUtil;
import com.android.resources.base.ResourceSourceFile;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.module.ModuleKeyManager;
import com.android.tools.idea.res.FileRelevanceKt;
import com.android.tools.idea.res.FileTimeStampLengthHasher;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LoggingPsiTreeChangeListener;
import com.android.tools.idea.res.PsiResourceFile;
import com.android.tools.idea.res.PsiResourceItem;
import com.android.tools.idea.res.ResourceFilesUtil;
import com.android.tools.idea.res.ResourceFolderRepositoryBackgroundActions;
import com.android.tools.idea.res.ResourceFolderRepositoryCachingData;
import com.android.tools.idea.res.ResourceItemSource;
import com.android.tools.idea.res.ResourceRepositoryImplUtil;
import com.android.tools.idea.res.ResourceUpdateTracer;
import com.android.tools.idea.res.VfsDensityBasedFileResourceItem;
import com.android.tools.idea.res.VfsFileResourceItem;
import com.android.tools.idea.res.VfsResourceFile;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.res.AbstractResourceRepositoryWithLocking;
import com.android.tools.res.LocalResourceRepository;
import com.android.tools.sdk.AndroidTargetData;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.android.utils.SdkUtils;
import com.android.utils.TraceUtils;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.serviceContainer.AlreadyDisposedException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kotlin.jvm.functions.Function0;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class ResourceFolderRepository
extends LocalResourceRepository<VirtualFile>
implements LoadableResourceRepository {
    static final String CACHE_FILE_FORMAT_VERSION = "2";
    private static final byte[] CACHE_FILE_HEADER = "Resource cache".getBytes(StandardCharsets.UTF_8);
    private static final double CACHE_STALENESS_THRESHOLD = 0.05;
    private static final Comparator<ResourceItemSource<?>> SOURCE_COMPARATOR = Comparator.comparing(ResourceItemSource::getFolderConfiguration);
    private static final Logger LOG = Logger.getInstance(ResourceFolderRepository.class);
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final PsiTreeChangeListener myPsiListener;
    @NotNull
    private final VirtualFile myResourceDir;
    @NotNull
    private final ResourceNamespace myNamespace;
    @NotNull
    private final String myResourcePathPrefix;
    @NotNull
    private final PathString myResourcePathBase;
    private int myNumXmlFilesLoadedInitially;
    private int myNumXmlFilesLoadedInitiallyFromSources;
    @NotNull
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> myResourceTable = new EnumMap<ResourceType, ListMultimap<String, ResourceItem>>(ResourceType.class);
    @NotNull
    private final ConcurrentMap<VirtualFile, ResourceItemSource<?>> mySources = new ConcurrentHashMap();
    @NotNull
    private final PsiManager myPsiManager;
    @NotNull
    private final PsiNameHelper myPsiNameHelper;
    @NotNull
    private final PsiDocumentManager myPsiDocumentManager;
    @NotNull
    private final Object scanLock = new Object();
    @NotNull
    private final Set<VirtualFile> pendingScans = new HashSet<VirtualFile>();
    @NotNull
    private final HashMap<VirtualFile, ProgressIndicator> runningScans = new HashMap();
    private int fileRescans;
    private int layoutlibCacheFlushes;
    @Nullable
    private Map<ResourceType, ImmutableSet<FolderConfiguration>> myResourceTypeToFolderConfigs = null;
    private long myResourceTypeToFolderConfigsGeneration = 0L;
    private final Loader myLoader;

    @NotNull
    static ResourceFolderRepository create(@NotNull AndroidFacet facet, @NotNull VirtualFile dir, @NotNull ResourceNamespace namespace, @Nullable ResourceFolderRepositoryCachingData cachingData) {
        return new ResourceFolderRepository(facet, dir, namespace, cachingData);
    }

    private ResourceFolderRepository(@NotNull AndroidFacet facet, @NotNull VirtualFile resourceDir, @NotNull ResourceNamespace namespace, @Nullable ResourceFolderRepositoryCachingData cachingData) {
        super(resourceDir.getName());
        this.myFacet = facet;
        this.myResourceDir = resourceDir;
        this.myNamespace = namespace;
        this.myResourcePathPrefix = RepositoryLoader.portableFileName((String)this.myResourceDir.getPath()) + "/";
        this.myResourcePathBase = new PathString(this.myResourcePathPrefix);
        this.myPsiManager = PsiManager.getInstance((Project)this.getProject());
        this.myPsiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        this.myPsiNameHelper = PsiNameHelper.getInstance((Project)this.getProject());
        IncrementalUpdatePsiListener psiListener2 = new IncrementalUpdatePsiListener();
        this.myPsiListener = LOG.isDebugEnabled() ? new LoggingPsiTreeChangeListener((PsiTreeChangeListener)psiListener2, LOG) : psiListener2;
        this.myLoader = new Loader(this, cachingData);
        ResourceUpdateTracer.logDirect((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + " " + this.pathForLogging(resourceDir) + " created for module " + facet.getModule().getName()));
    }

    public ResourceFolderRepository ensureLoaded() {
        this.myLoader.ensureLoaded();
        return this;
    }

    @NotNull
    public VirtualFile getResourceDir() {
        return this.myResourceDir;
    }

    @NotNull
    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @Nullable
    public String getLibraryName() {
        return null;
    }

    @NotNull
    public Path getOrigin() {
        return Paths.get(this.myResourceDir.getPath(), new String[0]);
    }

    @NotNull
    public String getResourceUrl(@NotNull String relativeResourcePath) {
        return this.myResourcePathPrefix + relativeResourcePath;
    }

    @NotNull
    public PathString getSourceFile(@NotNull String relativeResourcePath, boolean forFileResource) {
        return this.myResourcePathBase.resolve(relativeResourcePath);
    }

    @Nullable
    public String getPackageName() {
        return ResourceRepositoryImplUtil.getPackageName(this.myNamespace, this.myFacet);
    }

    public boolean containsUserDefinedResources() {
        return true;
    }

    @Override
    @VisibleForTesting
    public int getFileRescans() {
        return this.fileRescans;
    }

    @VisibleForTesting
    public int getLayoutlibCacheFlushes() {
        return this.layoutlibCacheFlushes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSet<FolderConfiguration> getFolderConfigurations(ResourceType resourceType) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ImmutableSet folderConfigurations;
            long modificationCount = this.getModificationCount();
            if (this.myResourceTypeToFolderConfigs == null || this.myResourceTypeToFolderConfigsGeneration != modificationCount) {
                HashMap map2 = new HashMap();
                this.accept(item -> {
                    Set set2 = map2.computeIfAbsent(item.getType(), key -> new HashSet());
                    set2.add(item.getConfiguration());
                    return ResourceVisitor.VisitResult.CONTINUE;
                });
                this.myResourceTypeToFolderConfigs = new HashMap<ResourceType, ImmutableSet<FolderConfiguration>>();
                this.myResourceTypeToFolderConfigsGeneration = modificationCount;
                for (Map.Entry entry : map2.entrySet()) {
                    this.myResourceTypeToFolderConfigs.put((ResourceType)entry.getKey(), (ImmutableSet<FolderConfiguration>)ImmutableSet.copyOf((Collection)((Collection)entry.getValue())));
                }
            }
            ImmutableSet immutableSet = (folderConfigurations = this.myResourceTypeToFolderConfigs.get(resourceType)) != null ? folderConfigurations : ImmutableSet.of();
            return immutableSet;
        }
    }

    private static void addToResult(@NotNull ResourceItem item, @NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2) {
        result2.computeIfAbsent(item.getType(), t -> LinkedListMultimap.create()).put((Object)item.getName(), (Object)item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitToRepository(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> itemsByType) {
        if (!itemsByType.isEmpty()) {
            Object object = ITEM_MAP_LOCK;
            synchronized (object) {
                this.commitToRepositoryWithoutLock(itemsByType);
            }
        }
    }

    private void commitToRepositoryWithoutLock(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> itemsByType) {
        ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ".commitToRepositoryWithoutLock"));
        block0: for (Map.Entry<ResourceType, ListMultimap<String, ResourceItem>> entry : itemsByType.entrySet()) {
            if (ResourceUpdateTracer.getInstance().isTracingActive()) {
                for (ResourceItem item : entry.getValue().values()) {
                    ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ": Committing " + item.getType() + "/" + item.getName()));
                }
            }
            ListMultimap<String, ResourceItem> map2 = this.getOrCreateMap(entry.getKey());
            map2.putAll((Multimap)entry.getValue());
            if (!ResourceUpdateTracer.getInstance().isTracingActive() || entry.getKey() != ResourceType.STRING) continue;
            for (String name2 : entry.getValue().keySet()) {
                ResourceItem item;
                FolderConfiguration configuration2;
                List items = map2.get((Object)name2);
                if (items.isEmpty() || (configuration2 = (item = (ResourceItem)items.get(0)).getConfiguration()).getLocaleQualifier() == null) continue;
                ResourceUpdateTracer.getInstance().dumpTrace("Resource " + item.getReferenceToSelf().getResourceUrl() + " is missing in the default locale");
                continue block0;
            }
        }
    }

    @VisibleForTesting
    boolean hasFreshFileCache() {
        return (double)this.myNumXmlFilesLoadedInitiallyFromSources <= (double)this.myNumXmlFilesLoadedInitially * 0.05;
    }

    @TestOnly
    int getNumXmlFilesLoadedInitially() {
        return this.myNumXmlFilesLoadedInitially;
    }

    @TestOnly
    int getNumXmlFilesLoadedInitiallyFromSources() {
        return this.myNumXmlFilesLoadedInitiallyFromSources;
    }

    @Nullable
    private PsiFile ensureValid(@NotNull PsiFile psiFile) {
        if (psiFile.isValid()) {
            return psiFile;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null && virtualFile.exists() && !this.getProject().isDisposed()) {
            return this.myPsiManager.findFile(virtualFile);
        }
        return null;
    }

    private void scanFileResourceFileAsPsi(@NotNull PsiFile file, @NotNull ResourceFolderType folderType, @NotNull FolderConfiguration folderConfiguration, @NotNull ResourceType type, boolean idGenerating, @NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2) {
        String resourceName = SdkUtils.fileNameToResourceName((String)file.getName());
        if (!this.checkResourceFilename(file, folderType)) {
            return;
        }
        RepositoryConfiguration configuration2 = new RepositoryConfiguration((LoadableResourceRepository)this, folderConfiguration);
        PsiResourceItem item = PsiResourceItem.forFile(resourceName, type, this, file);
        if (idGenerating) {
            ArrayList<PsiResourceItem> items = new ArrayList<PsiResourceItem>();
            items.add(item);
            ResourceFolderRepository.addToResult(item, result2);
            this.addIds((PsiElement)file, items, result2);
            PsiResourceFile resourceFile = new PsiResourceFile(file, items, folderType, configuration2);
            this.mySources.put(file.getVirtualFile(), resourceFile);
        } else {
            PsiResourceFile resourceFile = new PsiResourceFile(file, Collections.singletonList(item), folderType, configuration2);
            this.mySources.put(file.getVirtualFile(), resourceFile);
            ResourceFolderRepository.addToResult(item, result2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor2) {
        if (visitor2.shouldVisitNamespace(this.myNamespace)) {
            Object object = ITEM_MAP_LOCK;
            synchronized (object) {
                if (ResourceFolderRepository.acceptByResources(this.myResourceTable, (ResourceVisitor)visitor2) == ResourceVisitor.VisitResult.ABORT) {
                    return ResourceVisitor.VisitResult.ABORT;
                }
            }
        }
        return ResourceVisitor.VisitResult.CONTINUE;
    }

    @Override
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (!namespace.equals((Object)this.myNamespace)) {
            return null;
        }
        return this.myResourceTable.get(type);
    }

    @NotNull
    private ListMultimap<String, ResourceItem> getOrCreateMap(@NotNull ResourceType type) {
        return this.myResourceTable.computeIfAbsent(type, k -> LinkedListMultimap.create());
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        return this.myNamespace;
    }

    private void addIds(@NotNull PsiElement element, @NotNull List<PsiResourceItem> items, @NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2) {
        if (element instanceof XmlTag) {
            this.addIds((XmlTag)element, items, result2);
        }
        Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)element, XmlTag.class);
        for (XmlTag tag : xmlTags) {
            this.addIds(tag, items, result2);
        }
    }

    private void addIds(@NotNull XmlTag tag, @NotNull List<PsiResourceItem> items, @NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2) {
        assert (tag.isValid());
        for (XmlAttribute attribute2 : tag.getAttributes()) {
            String id2 = this.createIdNameFromAttribute(attribute2);
            if (id2 == null) continue;
            PsiResourceItem item = PsiResourceItem.forXmlTag(id2, ResourceType.ID, this, attribute2.getParent());
            items.add(item);
            ResourceFolderRepository.addToResult(item, result2);
        }
    }

    @Nullable
    private String createIdNameFromAttribute(@NotNull XmlAttribute attribute2) {
        String id2;
        String attributeValue = StringUtil.notNullize((String)attribute2.getValue()).trim();
        if (attributeValue.startsWith("@+id/") && !attribute2.getNamespace().equals("http://schemas.android.com/tools") && ResourceFolderRepository.isValidValueResourceName(id2 = attributeValue.substring("@+id/".length()))) {
            return id2;
        }
        return null;
    }

    private boolean scanValueFileAsPsi(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull PsiFile file, @NotNull FolderConfiguration folderConfiguration) {
        boolean added = false;
        FileType fileType = file.getFileType();
        if (fileType == XmlFileType.INSTANCE) {
            XmlFile xmlFile = (XmlFile)file;
            assert (xmlFile.isValid());
            XmlDocument document = xmlFile.getDocument();
            if (document != null) {
                XmlTag root = document.getRootTag();
                if (root == null) {
                    return false;
                }
                if (!root.getName().equals("resources")) {
                    return false;
                }
                XmlTag[] subTags = root.getSubTags();
                ArrayList<PsiResourceItem> items = new ArrayList<PsiResourceItem>(subTags.length);
                for (XmlTag tag : subTags) {
                    XmlTag[] attrs;
                    ProgressManager.checkCanceled();
                    String name2 = tag.getAttributeValue("name");
                    ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(tag);
                    if (type == null || !ResourceFolderRepository.isValidValueResourceName(name2)) continue;
                    PsiResourceItem item = PsiResourceItem.forXmlTag(name2, type, this, tag);
                    ResourceFolderRepository.addToResult(item, result2);
                    items.add(item);
                    added = true;
                    if (type != ResourceType.STYLEABLE || (attrs = tag.getSubTags()).length <= 0) continue;
                    for (XmlTag child : attrs) {
                        String attrName = child.getAttributeValue("name");
                        if (!ResourceFolderRepository.isValidValueResourceName(attrName) || attrName.startsWith("android:") || child.getAttribute("format") == null && child.getSubTags().length <= 0) continue;
                        PsiResourceItem attrItem = PsiResourceItem.forXmlTag(attrName, ResourceType.ATTR, this, child);
                        items.add(attrItem);
                        ResourceFolderRepository.addToResult(attrItem, result2);
                    }
                }
                PsiResourceFile resourceFile = new PsiResourceFile(file, items, ResourceFolderType.VALUES, new RepositoryConfiguration((LoadableResourceRepository)this, folderConfiguration));
                this.mySources.put(file.getVirtualFile(), resourceFile);
            }
        }
        return added;
    }

    @Contract(value="null -> false")
    private static boolean isValidValueResourceName(@Nullable String name2) {
        return !StringUtil.isEmpty((String)name2) && ValueResourceNameValidator.getErrorText((String)name2, null) == null;
    }

    private boolean checkResourceFilename(@NotNull PathString file, @NotNull ResourceFolderType folderType) {
        VirtualFile virtualFile;
        if (FileResourceNameValidator.getErrorTextForFileResource((String)file.getFileName(), (ResourceFolderType)folderType) != null && (virtualFile = FileExtensions.toVirtualFile(file)) != null) {
            ResourceFolderRepositoryBackgroundActions.getInstance(this.myFacet.getModule()).runInWolfQueue(() -> WolfTheProblemSolver.getInstance((Project)this.getProject()).reportProblemsFromExternalSource(virtualFile, (Object)this));
        }
        return this.myPsiNameHelper.isIdentifier(SdkUtils.fileNameToResourceName((String)file.getFileName()));
    }

    private boolean checkResourceFilename(@NotNull PsiFile file, @NotNull ResourceFolderType folderType) {
        VirtualFile virtualFile;
        if (FileResourceNameValidator.getErrorTextForFileResource((String)file.getName(), (ResourceFolderType)folderType) != null && (virtualFile = file.getVirtualFile()) != null) {
            ResourceFolderRepositoryBackgroundActions.getInstance(this.myFacet.getModule()).runInWolfQueue(() -> WolfTheProblemSolver.getInstance((Project)this.getProject()).reportProblemsFromExternalSource(virtualFile, (Object)this));
        }
        return this.myPsiNameHelper.isIdentifier(SdkUtils.fileNameToResourceName((String)file.getName()));
    }

    private boolean isResourceFolder(@NotNull VirtualFile virtualFile) {
        VirtualFile parentDirectory;
        if (virtualFile.isDirectory() && (parentDirectory = virtualFile.getParent()) != null) {
            return parentDirectory.equals(this.myResourceDir);
        }
        return false;
    }

    private boolean isResourceFile(@NotNull VirtualFile virtualFile) {
        VirtualFile parent = virtualFile.getParent();
        return parent != null && this.isResourceFolder(parent);
    }

    private boolean isResourceFile(@NotNull PsiFile psiFile) {
        return this.isResourceFile(psiFile.getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isScanPending(@NotNull VirtualFile virtualFile) {
        Object object = this.scanLock;
        synchronized (object) {
            return this.pendingScans.contains(virtualFile);
        }
    }

    public void convertToPsiIfNeeded(@NotNull VirtualFile virtualFile) {
        VirtualFile grandparent;
        VirtualFile parent = virtualFile.getParent();
        VirtualFile virtualFile2 = grandparent = parent == null ? null : parent.getParent();
        if (this.myResourceDir.equals(grandparent)) {
            this.scheduleScan(virtualFile);
        }
    }

    private boolean convertToPsiIfNeeded(@NotNull PsiFile psiFile, @NotNull ResourceFolderType folderType) {
        VirtualFile virtualFile = psiFile.getVirtualFile();
        ResourceItemSource resourceFile = (ResourceItemSource)this.mySources.get(virtualFile);
        if (resourceFile instanceof PsiResourceFile) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Converting to PSI ", new Object[]{psiFile});
        }
        ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ".convertToPsiIfNeeded " + this.pathForLogging(psiFile) + " converting to PSI"));
        this.scheduleScan(virtualFile, folderType);
        return true;
    }

    void scheduleScan(@NotNull VirtualFile virtualFile) {
        ResourceFolderType folderType = ResourceFilesUtil.getFolderType(virtualFile);
        if (folderType != null) {
            this.scheduleScan(virtualFile, folderType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleScan(@NotNull VirtualFile virtualFile, @NotNull ResourceFolderType folderType) {
        ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ".scheduleScan " + this.pathForLogging(virtualFile)));
        Object object = this.scanLock;
        synchronized (object) {
            if (!this.pendingScans.add(virtualFile)) {
                ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ".scheduleScan " + this.pathForLogging(virtualFile) + " pending already"));
                return;
            }
        }
        this.scheduleUpdate(() -> {
            EmptyProgressIndicator runHandle;
            ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ".scheduleScan " + this.pathForLogging(virtualFile) + " preparing to scan"));
            if (!virtualFile.isValid() || !this.isScanPending(virtualFile)) {
                ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ".scheduleScan " + this.pathForLogging(virtualFile) + " pending already"));
                return;
            }
            PsiFile psiFile = this.findPsiFile(virtualFile);
            if (psiFile == null) {
                ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ".scheduleScan no PSI " + this.pathForLogging(virtualFile)));
                return;
            }
            Object object = this.scanLock;
            synchronized (object) {
                if (!this.pendingScans.remove(virtualFile)) {
                    ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ".scheduleScan " + this.pathForLogging(virtualFile) + " scanned already"));
                    return;
                }
                runHandle = new EmptyProgressIndicator();
                ProgressIndicator oldRunHandle = this.runningScans.put(virtualFile, (ProgressIndicator)runHandle);
                if (oldRunHandle != null) {
                    oldRunHandle.cancel();
                }
            }
            try {
                ProgressManager.getInstance().runProcess(() -> this.scan(psiFile, folderType), (ProgressIndicator)runHandle);
            }
            finally {
                object = this.scanLock;
                synchronized (object) {
                    this.runningScans.remove(virtualFile, runHandle);
                    ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ".scheduleScan " + this.pathForLogging(virtualFile) + " finished scanning"));
                }
            }
        });
    }

    @NotNull
    private String pathForLogging(@NotNull VirtualFile virtualFile) {
        return ResourceUpdateTracer.getInstance().pathForLogging(virtualFile, this.getProject());
    }

    @Nullable
    private String pathForLogging(@Nullable PsiFile file) {
        return file == null ? null : this.pathForLogging(file.getVirtualFile());
    }

    private void scheduleUpdate(@NotNull Runnable updateAction) {
        ResourceFolderRepositoryBackgroundActions.getInstance(this.myFacet.getModule()).runInUpdateQueue(this, updateAction);
    }

    @Override
    public void invokeAfterPendingUpdatesFinish(@NotNull Executor executor, @NotNull Runnable callback2) {
        ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ".invokeAfterPendingUpdatesFinish " + callback2));
        this.scheduleUpdate(() -> executor.execute(callback2));
    }

    @Nullable
    private PsiFile findPsiFile(@NotNull VirtualFile virtualFile) {
        try {
            return PsiManager.getInstance((Project)this.getProject()).findFile(virtualFile);
        }
        catch (AlreadyDisposedException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(@NotNull PsiFile psiFile, @NotNull ResourceFolderType folderType) {
        ProgressManager.checkCanceled();
        if (!this.isResourceFile(psiFile) || !FileRelevanceKt.isRelevantFile(psiFile) || psiFile.getProject().isDisposed()) {
            return;
        }
        ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ".scan " + this.pathForLogging(psiFile)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rescanning ", new Object[]{psiFile});
        }
        HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
        PsiFile file = psiFile;
        if (folderType == ResourceFolderType.VALUES) {
            ++this.fileRescans;
            ResourceItemSource source2 = (ResourceItemSource)this.mySources.remove(file.getVirtualFile());
            boolean removed = false;
            if (source2 != null) {
                removed = this.removeItemsFromSource(source2);
            }
            file = this.ensureValid(file);
            boolean added = false;
            if (file != null) {
                FolderConfiguration folderConfiguration;
                PsiDirectory parent = file.getParent();
                assert (parent != null);
                PsiDirectory fileParent = psiFile.getParent();
                if (fileParent != null && (folderConfiguration = FolderConfiguration.getConfigForFolder((String)fileParent.getName())) != null) {
                    ProgressManager.checkCanceled();
                    added = this.scanValueFileAsPsi(result2, file, folderConfiguration);
                }
            }
            if (added || removed) {
                this.setModificationCount(ourModificationCounter.incrementAndGet());
                this.invalidateParentCaches((SingleNamespaceResourceRepository)this, ResourceType.values());
            }
        } else if (this.checkResourceFilename(file, folderType)) {
            ResourceItemSource source3 = (ResourceItemSource)this.mySources.get(file.getVirtualFile());
            if (source3 instanceof PsiResourceFile && file.getFileType() == XmlFileType.INSTANCE) {
                PsiResourceFile psiResourceFile = (PsiResourceFile)source3;
                if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType)) {
                    ++this.fileRescans;
                    HashSet<String> idsBefore = new HashSet<String>();
                    Object parent = ITEM_MAP_LOCK;
                    synchronized (parent) {
                        ListMultimap<String, ResourceItem> idMultimap = this.myResourceTable.get(ResourceType.ID);
                        if (idMultimap != null) {
                            ArrayList<PsiResourceItem> idItems = new ArrayList<PsiResourceItem>();
                            for (PsiResourceItem item : psiResourceFile) {
                                if (item.getType() != ResourceType.ID) continue;
                                idsBefore.add(item.getName());
                                idItems.add(item);
                            }
                            for (String id2 : idsBefore) {
                                List mapItems = idMultimap.get((Object)id2);
                                if (mapItems.isEmpty()) continue;
                                ArrayList<ResourceItem> toDelete = new ArrayList<ResourceItem>(mapItems.size());
                                for (ResourceItem mapItem : mapItems) {
                                    if (!(mapItem instanceof PsiResourceItem) || ((PsiResourceItem)mapItem).getSourceFile() != psiResourceFile) continue;
                                    toDelete.add(mapItem);
                                }
                                for (ResourceItem item : toDelete) {
                                    idMultimap.remove((Object)item.getName(), (Object)item);
                                }
                            }
                            for (PsiResourceItem item : idItems) {
                                psiResourceFile.removeItem(item);
                            }
                        }
                    }
                    ArrayList<PsiResourceItem> idItems = new ArrayList<PsiResourceItem>();
                    file = this.ensureValid(file);
                    if (file != null) {
                        ProgressManager.checkCanceled();
                        this.addIds((PsiElement)file, idItems, result2);
                    }
                    if (!idItems.isEmpty()) {
                        for (PsiResourceItem item : idItems) {
                            psiResourceFile.addItem(item);
                        }
                    }
                    this.setModificationCount(ourModificationCounter.incrementAndGet());
                    this.invalidateParentCaches((SingleNamespaceResourceRepository)this, ResourceType.ID);
                }
            } else {
                if (source3 != null) {
                    this.removeItemsFromSource(source3);
                }
                ++this.fileRescans;
                PsiDirectory parent = file.getParent();
                assert (parent != null);
                ResourceType type = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)folderType);
                boolean idGeneratingFolder = FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
                ProgressManager.checkCanceled();
                this.clearLayoutlibCaches(file.getVirtualFile(), folderType);
                file = this.ensureValid(file);
                if (file != null) {
                    FolderConfiguration folderConfiguration;
                    PsiDirectory fileParent = psiFile.getParent();
                    if (fileParent != null && (folderConfiguration = FolderConfiguration.getConfigForFolder((String)fileParent.getName())) != null) {
                        boolean idGeneratingFile = idGeneratingFolder && file.getFileType() == XmlFileType.INSTANCE;
                        ProgressManager.checkCanceled();
                        this.scanFileResourceFileAsPsi(file, folderType, folderConfiguration, type, idGeneratingFile, result2);
                    }
                    this.setModificationCount(ourModificationCounter.incrementAndGet());
                    this.invalidateParentCaches((SingleNamespaceResourceRepository)this, ResourceType.values());
                }
            }
        }
        this.commitToRepository(result2);
        ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ".scan " + this.pathForLogging(psiFile) + " end"));
    }

    private void scan(@NotNull VirtualFile file) {
        ResourceFolderType folderType = ResourceFilesUtil.getFolderType(file);
        if (folderType == null || !this.isResourceFile(file) || !FileRelevanceKt.isRelevantFile(file)) {
            return;
        }
        if (!file.exists()) {
            this.removeResourcesContainedInFileOrDirectory(file);
            return;
        }
        PsiFile psiFile = this.myPsiManager.findFile(file);
        if (psiFile != null) {
            Document document = this.myPsiDocumentManager.getDocument(psiFile);
            if (document != null && this.myPsiDocumentManager.isUncommited(document)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Committing ", new Object[]{document});
                }
                ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> {
                    this.myPsiDocumentManager.commitDocument(document);
                    this.scheduleScan(file, folderType);
                });
                return;
            }
            this.scan(psiFile, folderType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeItemsForTag(@NotNull ResourceItemSource<PsiResourceItem> source2, @NotNull XmlTag xmlTag, @NotNull ResourceType resourceType) {
        boolean changed = false;
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            Iterator sourceIter = source2.iterator();
            while (sourceIter.hasNext()) {
                PsiResourceItem item = (PsiResourceItem)sourceIter.next();
                if (!item.wasTag(xmlTag)) continue;
                ListMultimap<String, ResourceItem> map2 = this.myResourceTable.get(resourceType);
                List items = map2.get((Object)item.getName());
                Iterator iter = items.iterator();
                while (iter.hasNext()) {
                    ResourceItem candidate = (ResourceItem)iter.next();
                    if (candidate != item) continue;
                    iter.remove();
                    changed = true;
                    break;
                }
                sourceIter.remove();
            }
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeItemsFromSource(@NotNull ResourceItemSource<?> source2) {
        boolean changed = false;
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (ResourceItem item : source2) {
                ListMultimap<String, ResourceItem> map2 = this.myResourceTable.get(item.getType());
                List items = map2.get((Object)item.getName());
                Iterator iter = items.iterator();
                while (iter.hasNext()) {
                    ResourceItem candidate = (ResourceItem)iter.next();
                    if (candidate != item) continue;
                    iter.remove();
                    changed = true;
                    break;
                }
                if (!items.isEmpty()) continue;
                map2.removeAll((Object)item.getName());
            }
        }
        return changed;
    }

    private void getAndroidTargetDataThenRun(@NotNull VirtualFile file, @NotNull Consumer<AndroidTargetData> consumer2) {
        ResourceFolderRepositoryBackgroundActions.runInBackground(() -> {
            if (this.myFacet.isDisposed()) {
                return;
            }
            ConfigurationManager configurationManager = ConfigurationManager.findExistingInstance(this.myFacet.getModule());
            if (configurationManager == null) {
                return;
            }
            IAndroidTarget target2 = configurationManager.getConfiguration(file).getTarget();
            if (target2 == null) {
                return;
            }
            consumer2.accept(AndroidTargetData.getTargetData(target2, AndroidPlatforms.getInstance(this.myFacet.getModule())));
        });
    }

    private void bitmapUpdated(@NotNull VirtualFile bitmap) {
        Module module = this.myFacet.getModule();
        this.getAndroidTargetDataThenRun(bitmap, targetData -> targetData.clearLayoutBitmapCache(ModuleKeyManager.INSTANCE.getKey(module)));
    }

    void clearFontCache(@NotNull VirtualFile virtualFile) {
        this.getAndroidTargetDataThenRun(virtualFile, targetData -> targetData.clearFontCache(virtualFile.getPath()));
    }

    @NotNull
    public PsiTreeChangeListener getPsiListener() {
        return this.myPsiListener;
    }

    @Override
    protected void setModificationCount(long count) {
        ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ".setModificationCount " + count));
        super.setModificationCount(count);
    }

    void onFileCreated(@NotNull VirtualFile file) {
        ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ".onFileCreated " + this.pathForLogging(file)));
        this.scheduleScan(file);
    }

    void onFileOrDirectoryRemoved(@NotNull VirtualFile file) {
        ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ".onFileOrDirectoryRemoved " + this.pathForLogging(file)));
        this.scheduleUpdate(() -> this.removeResourcesContainedInFileOrDirectory(file));
    }

    private void removeResourcesContainedInFileOrDirectory(@NotNull VirtualFile file) {
        ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ".processRemovalOfFileOrDirectory " + this.pathForLogging(file)));
        if (file.isDirectory()) {
            Iterator iterator2 = this.mySources.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                VirtualFile sourceFile = (VirtualFile)entry.getKey();
                if (!VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)sourceFile, (boolean)true)) continue;
                ResourceItemSource source2 = (ResourceItemSource)entry.getValue();
                this.removeSource(sourceFile, source2);
                iterator2.remove();
            }
        } else {
            ResourceItemSource source3 = (ResourceItemSource)this.mySources.remove(file);
            if (source3 != null) {
                this.removeSource(file, source3);
            }
            ResourceFolderRepositoryBackgroundActions.getInstance(this.myFacet.getModule()).runInWolfQueue(() -> WolfTheProblemSolver.getInstance((Project)this.getProject()).clearProblemsFromExternalSource(file, (Object)this));
        }
    }

    private void removeSource(@NotNull VirtualFile file, @NotNull ResourceItemSource<?> source2) {
        ResourceFolderType folderType;
        ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)this) + ".onSourceRemoved " + this.pathForLogging(file)));
        boolean removed = this.removeItemsFromSource(source2);
        if (removed) {
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.invalidateParentCaches((SingleNamespaceResourceRepository)this, ResourceType.values());
        }
        if ((folderType = ResourceFilesUtil.getFolderType(file)) != null) {
            this.clearLayoutlibCaches(file, folderType);
        }
    }

    @Nullable
    private XmlTag findItemElement(@NotNull XmlTag tag) {
        for (XmlTag parentTag = tag; parentTag != null; parentTag = parentTag.getParentTag()) {
            if (!ResourceFolderRepository.isItemElement(parentTag)) continue;
            return parentTag;
        }
        return null;
    }

    @NotNull
    private Project getProject() {
        return this.myFacet.getModule().getProject();
    }

    private void clearLayoutlibCaches(@NotNull VirtualFile file, @NotNull ResourceFolderType folderType) {
        if ("xml".equals(file.getExtension())) {
            return;
        }
        if (folderType == ResourceFolderType.DRAWABLE) {
            ++this.layoutlibCacheFlushes;
            this.bitmapUpdated(file);
        } else if (folderType == ResourceFolderType.FONT) {
            ++this.layoutlibCacheFlushes;
            this.clearFontCache(file);
        }
    }

    private static boolean isItemElement(@NotNull XmlTag xmlTag) {
        String tag = xmlTag.getName();
        if (tag.equals("resources")) {
            return false;
        }
        return tag.equals("item") || ResourceType.fromXmlTagName((String)tag) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ResourceItem findValueResourceItem(@NotNull XmlTag tag, @NotNull PsiFile file) {
        if (!tag.isValid()) {
            ResourceItemSource resourceFile = (ResourceItemSource)this.mySources.get(file.getVirtualFile());
            if (resourceFile != null) {
                assert (resourceFile instanceof PsiResourceFile);
                PsiResourceFile psiResourceFile = (PsiResourceFile)resourceFile;
                for (PsiResourceItem item : psiResourceFile) {
                    if (!item.wasTag(tag)) continue;
                    return item;
                }
            }
            return null;
        }
        String name2 = tag.getAttributeValue("name");
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return name2 != null ? this.findValueResourceItem(tag, file, name2) : null;
        }
    }

    @Nullable
    private ResourceItem findValueResourceItem(@NotNull XmlTag tag, @NotNull PsiFile file, @NotNull String name2) {
        ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(tag);
        return this.findResourceItem(type, file, name2, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ResourceItem findResourceItem(@Nullable ResourceType type, @NotNull PsiFile file, @Nullable String name2, @Nullable XmlTag tag) {
        if (type == null || name2 == null) {
            return null;
        }
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file.getVirtualFile());
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map2 = this.myResourceTable.get(type);
            if (map2 == null) {
                return null;
            }
            List items = map2.get((Object)name2);
            if (tag != null) {
                for (ResourceItem resourceItem : items) {
                    PsiResourceItem psiResourceItem;
                    if (!(resourceItem instanceof PsiResourceItem) || !(psiResourceItem = (PsiResourceItem)resourceItem).wasTag(tag)) continue;
                    return resourceItem;
                }
            } else {
                for (ResourceItem item : items) {
                    if (item instanceof PsiResourceItem) {
                        if (!Objects.equals(((PsiResourceItem)item).getPsiFile(), file)) continue;
                        return item;
                    }
                    ResourceFile resourceFile = (ResourceFile)((ResourceMergerItem)item).getSourceFile();
                    if (resourceFile == null || !FileUtil.filesEqual((File)resourceFile.getFile(), (File)ioFile)) continue;
                    return item;
                }
            }
        }
        return null;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.myResourceDir + ": @" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        return Collections.singleton(this.myResourceDir);
    }

    @NotNull
    public VfsResourceFile deserializeResourceSourceFile(@NotNull Base128InputStream stream, @NotNull List<RepositoryConfiguration> configurations) throws IOException {
        String relativePath = stream.readString();
        if (relativePath == null) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        int configIndex = stream.readInt();
        RepositoryConfiguration configuration2 = configurations.get(configIndex);
        VirtualFile virtualFile = ((ResourceFolderRepository)configuration2.getRepository()).getResourceDir().findFileByRelativePath(relativePath);
        if (!stream.validateContents(FileTimeStampLengthHasher.hash(virtualFile))) {
            virtualFile = null;
        }
        return new VfsResourceFile(virtualFile, configuration2);
    }

    @NotNull
    public BasicFileResourceItem deserializeFileResourceItem(@NotNull Base128InputStream stream, @NotNull ResourceType resourceType, @NotNull String name2, @NotNull ResourceVisibility visibility, @NotNull List<RepositoryConfiguration> configurations) throws IOException {
        Density density;
        String relativePath = stream.readString();
        if (relativePath == null) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        int configIndex = stream.readInt();
        RepositoryConfiguration configuration2 = configurations.get(configIndex);
        int encodedDensity = stream.readInt();
        VirtualFile virtualFile = ((ResourceFolderRepository)configuration2.getRepository()).getResourceDir().findFileByRelativePath(relativePath);
        boolean idGenerating = false;
        String folderName = new PathString(relativePath).getParentFileName();
        if (folderName != null) {
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folderName);
            boolean bl = idGenerating = folderType != null && FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
        }
        if (idGenerating) {
            if (!stream.validateContents(FileTimeStampLengthHasher.hash(virtualFile))) {
                virtualFile = null;
            }
            if (encodedDensity == 0) {
                return new VfsFileResourceItem(resourceType, name2, configuration2, visibility, relativePath, virtualFile);
            }
            density = Density.create((int)encodedDensity);
            return new VfsDensityBasedFileResourceItem(resourceType, name2, configuration2, visibility, relativePath, virtualFile, density);
        }
        if (encodedDensity == 0) {
            return new BasicFileResourceItem(resourceType, name2, configuration2, visibility, relativePath);
        }
        density = Density.create((int)encodedDensity);
        return new BasicDensityBasedFileResourceItem(resourceType, name2, configuration2, visibility, relativePath, density);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invalidateParentCaches() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            super.invalidateParentCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invalidateParentCaches(@NotNull SingleNamespaceResourceRepository repository2, ResourceType ... types) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            super.invalidateParentCaches(repository2, types);
        }
    }

    private final class IncrementalUpdatePsiListener
    extends PsiTreeChangeAdapter {
        private boolean myIgnoreChildrenChanged;

        private IncrementalUpdatePsiListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childAdded " + ResourceFolderRepository.this.pathForLogging(event.getFile())));
            try {
                PsiFile psiFile = event.getFile();
                if (psiFile != null && FileRelevanceKt.isRelevantFile(psiFile)) {
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if (this.rescheduleScanIfRunning(virtualFile)) {
                        return;
                    }
                    ResourceFolderType folderType = IdeResourcesUtil.getFolderType(psiFile);
                    if (folderType != null && ResourceFolderRepository.this.isResourceFile(psiFile)) {
                        PsiElement child = event.getChild();
                        PsiElement parent = event.getParent();
                        if (folderType == ResourceFolderType.VALUES) {
                            if (child instanceof XmlTag) {
                                XmlTag tag = (XmlTag)child;
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                    return;
                                }
                                ResourceFolderRepository.this.scheduleUpdate(() -> {
                                    ResourceItem parentItem;
                                    XmlTag parentTag;
                                    ResourceItemSource source2;
                                    if (!tag.isValid()) {
                                        ResourceFolderRepository.this.scan(psiFile, folderType);
                                        return;
                                    }
                                    if (ResourceFolderRepository.isItemElement(tag) && (source2 = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(virtualFile)) != null) {
                                        assert (source2 instanceof PsiResourceFile);
                                        PsiResourceFile psiResourceFile = (PsiResourceFile)source2;
                                        String name2 = tag.getAttributeValue("name");
                                        if (ResourceFolderRepository.isValidValueResourceName(name2)) {
                                            ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(tag);
                                            if (type == ResourceType.STYLEABLE) {
                                                ResourceFolderRepository.this.scan(psiFile, folderType);
                                                return;
                                            }
                                            if (type != null) {
                                                PsiResourceItem item = PsiResourceItem.forXmlTag(name2, type, ResourceFolderRepository.this, tag);
                                                Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                                synchronized (object) {
                                                    ResourceFolderRepository.this.getOrCreateMap(type).put((Object)name2, (Object)item);
                                                    psiResourceFile.addItem(item);
                                                    ResourceFolderRepository.this.setModificationCount(ourModificationCounter.incrementAndGet());
                                                    ResourceFolderRepository.this.invalidateParentCaches((SingleNamespaceResourceRepository)ResourceFolderRepository.this, type);
                                                }
                                                return;
                                            }
                                        }
                                    }
                                    if ((parentTag = tag.getParentTag()) != null && IdeResourcesUtil.getResourceTypeForResourceTag(parentTag) != null && (parentItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile)) instanceof PsiResourceItem) {
                                        if (((PsiResourceItem)parentItem).recomputeValue()) {
                                            ResourceFolderRepository.this.setModificationCount(ourModificationCounter.incrementAndGet());
                                        }
                                        ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childAdded " + ResourceFolderRepository.this.pathForLogging(event.getFile()) + " recomputed: " + parentItem));
                                        return;
                                    }
                                    ResourceFolderRepository.this.scan(psiFile, folderType);
                                });
                            } else if (parent instanceof XmlText) {
                                XmlText text2 = (XmlText)parent;
                                this.handleValueXmlTextEdit((PsiElement)text2.getParentTag(), psiFile);
                            } else if (child instanceof XmlText) {
                                this.handleValueXmlTextEdit(parent, psiFile);
                            } else if (!(parent instanceof XmlComment) && !(child instanceof XmlComment)) {
                                ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                            }
                            return;
                        }
                        if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile.getFileType() == XmlFileType.INSTANCE) {
                            if (parent instanceof XmlComment || child instanceof XmlComment) {
                                return;
                            }
                            if (parent instanceof XmlText || child instanceof XmlText && child.getText().trim().isEmpty()) {
                                return;
                            }
                            if (parent instanceof XmlElement && child instanceof XmlElement) {
                                if (child instanceof XmlTag) {
                                    ResourceFolderRepository.this.scheduleUpdate(() -> {
                                        if (!child.isValid()) {
                                            ResourceFolderRepository.this.scan(psiFile, folderType);
                                            return;
                                        }
                                        HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
                                        ArrayList<PsiResourceItem> items = new ArrayList<PsiResourceItem>();
                                        ResourceFolderRepository.this.addIds(child, items, result2);
                                        if (!items.isEmpty()) {
                                            ResourceItemSource resourceFile = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(psiFile.getVirtualFile());
                                            if (!(resourceFile instanceof PsiResourceFile)) {
                                                ResourceFolderRepository.this.scan(psiFile, folderType);
                                                return;
                                            }
                                            PsiResourceFile psiResourceFile = (PsiResourceFile)resourceFile;
                                            for (PsiResourceItem item : items) {
                                                psiResourceFile.addItem(item);
                                            }
                                            ResourceFolderRepository.this.commitToRepository(result2);
                                            ResourceFolderRepository.this.setModificationCount(ourModificationCounter.incrementAndGet());
                                            ResourceFolderRepository.this.invalidateParentCaches((SingleNamespaceResourceRepository)ResourceFolderRepository.this, ResourceType.ID);
                                        }
                                    });
                                    return;
                                }
                                if (child instanceof XmlAttribute || parent instanceof XmlAttribute) {
                                    XmlAttribute attribute2 = parent instanceof XmlAttribute ? (XmlAttribute)parent : (XmlAttribute)child;
                                    String id2 = ResourceFolderRepository.this.createIdNameFromAttribute(attribute2);
                                    if (id2 != null) {
                                        if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                            return;
                                        }
                                        ResourceFolderRepository.this.scheduleUpdate(() -> {
                                            if (!attribute2.isValid()) {
                                                ResourceFolderRepository.this.scan(psiFile, folderType);
                                                return;
                                            }
                                            PsiResourceItem newIdResource = PsiResourceItem.forXmlTag(id2, ResourceType.ID, ResourceFolderRepository.this, attribute2.getParent());
                                            Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                            synchronized (object) {
                                                ResourceItemSource resourceFile = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(psiFile.getVirtualFile());
                                                if (resourceFile != null) {
                                                    assert (resourceFile instanceof PsiResourceFile);
                                                    PsiResourceFile psiResourceFile = (PsiResourceFile)resourceFile;
                                                    psiResourceFile.addItem(newIdResource);
                                                    ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ": Adding id/" + newIdResource.getName()));
                                                    ResourceFolderRepository.this.getOrCreateMap(ResourceType.ID).put((Object)newIdResource.getName(), (Object)newIdResource);
                                                    ResourceFolderRepository.this.setModificationCount(ourModificationCounter.incrementAndGet());
                                                    ResourceFolderRepository.this.invalidateParentCaches((SingleNamespaceResourceRepository)ResourceFolderRepository.this, ResourceType.ID);
                                                }
                                            }
                                        });
                                        return;
                                    }
                                }
                            }
                        } else if (folderType == ResourceFolderType.FONT) {
                            ResourceFolderRepository.this.clearFontCache(psiFile.getVirtualFile());
                        }
                    }
                }
                this.myIgnoreChildrenChanged = true;
            }
            finally {
                ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childAdded " + ResourceFolderRepository.this.pathForLogging(event.getFile()) + " end"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childRemoved " + ResourceFolderRepository.this.pathForLogging(event.getFile())));
            try {
                PsiFile psiFile = event.getFile();
                if (psiFile != null && FileRelevanceKt.isRelevantFile(psiFile)) {
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if (this.rescheduleScanIfRunning(virtualFile)) {
                        return;
                    }
                    ResourceFolderType folderType = ResourceFilesUtil.getFolderType(virtualFile);
                    if (folderType != null && ResourceFolderRepository.this.isResourceFile(virtualFile)) {
                        PsiElement child = event.getChild();
                        PsiElement parent = event.getParent();
                        if (folderType == ResourceFolderType.VALUES) {
                            if (child instanceof XmlTag) {
                                XmlTag parentTag;
                                XmlTag tag = (XmlTag)child;
                                if (parent instanceof XmlTag && IdeResourcesUtil.getResourceTypeForResourceTag(parentTag = (XmlTag)parent) != null) {
                                    if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                        return;
                                    }
                                    ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                                    if (resourceItem instanceof PsiResourceItem) {
                                        ResourceItem declareStyleable;
                                        if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                            ResourceFolderRepository.this.setModificationCount(ourModificationCounter.incrementAndGet());
                                        }
                                        ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childRemoved " + ResourceFolderRepository.this.pathForLogging(event.getFile()) + " recomputed: " + resourceItem));
                                        if (resourceItem.getType() == ResourceType.ATTR && (parentTag = parentTag.getParentTag()) != null && IdeResourcesUtil.getResourceTypeForResourceTag(parentTag) == ResourceType.STYLEABLE && (declareStyleable = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile)) instanceof PsiResourceItem && ((PsiResourceItem)declareStyleable).recomputeValue()) {
                                            ResourceFolderRepository.this.setModificationCount(ourModificationCounter.incrementAndGet());
                                        }
                                        return;
                                    }
                                }
                                if (ResourceFolderRepository.isItemElement(tag)) {
                                    if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                        return;
                                    }
                                    ResourceFolderRepository.this.scheduleUpdate(() -> {
                                        ResourceType type;
                                        String name2;
                                        ResourceItemSource source2 = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(virtualFile);
                                        if (source2 == null) {
                                            ResourceFolderRepository.this.scan(psiFile, folderType);
                                            return;
                                        }
                                        PsiResourceFile resourceFile = (PsiResourceFile)source2;
                                        if (tag.isValid()) {
                                            name2 = tag.getAttributeValue("name");
                                        } else {
                                            ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(tag, psiFile);
                                            if (item == null) {
                                                ResourceFolderRepository.this.scan(psiFile, folderType);
                                                return;
                                            }
                                            name2 = item.getName();
                                        }
                                        if (name2 != null && (type = IdeResourcesUtil.getResourceTypeForResourceTag(tag)) != null) {
                                            Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                            synchronized (object) {
                                                boolean removed = ResourceFolderRepository.this.removeItemsForTag(resourceFile, tag, type);
                                                if (removed) {
                                                    ResourceFolderRepository.this.setModificationCount(ourModificationCounter.incrementAndGet());
                                                    ResourceFolderRepository.this.invalidateParentCaches((SingleNamespaceResourceRepository)ResourceFolderRepository.this, type);
                                                }
                                            }
                                        }
                                    });
                                }
                                return;
                            }
                            if (parent instanceof XmlText) {
                                XmlText text2 = (XmlText)parent;
                                this.handleValueXmlTextEdit((PsiElement)text2.getParentTag(), psiFile);
                            } else if (child instanceof XmlText) {
                                this.handleValueXmlTextEdit(parent, psiFile);
                            } else {
                                if (parent instanceof XmlComment || child instanceof XmlComment) {
                                    return;
                                }
                                ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                            }
                        } else if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile.getFileType() == XmlFileType.INSTANCE) {
                            ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                        } else if (folderType == ResourceFolderType.FONT) {
                            ResourceFolderRepository.this.clearFontCache(virtualFile);
                        }
                    }
                }
                this.myIgnoreChildrenChanged = true;
            }
            finally {
                ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childRemoved " + ResourceFolderRepository.this.pathForLogging(event.getFile()) + " end"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childReplaced " + ResourceFolderRepository.this.pathForLogging(event.getFile())));
            try {
                PsiFile psiFile = event.getFile();
                if (psiFile != null) {
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if (this.rescheduleScanIfRunning(virtualFile)) {
                        return;
                    }
                    if (FileRelevanceKt.isRelevantFile(virtualFile)) {
                        PsiElement parent;
                        ResourceFolderType folderType = ResourceFilesUtil.getFolderType(virtualFile);
                        if (folderType != null && FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile.getFileType() == XmlFileType.INSTANCE) {
                            PsiElement parent2 = event.getParent();
                            PsiElement child = event.getChild();
                            if (parent2 instanceof XmlText || child instanceof XmlText || parent2 instanceof XmlComment) {
                                return;
                            }
                            PsiElement oldChild = event.getOldChild();
                            if (child instanceof XmlComment && oldChild instanceof XmlComment) {
                                return;
                            }
                            if (parent2 instanceof XmlElement && child instanceof XmlElement) {
                                if (child instanceof XmlComment || oldChild instanceof XmlComment) {
                                    ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                                    return;
                                }
                                if (event.getOldChild() == event.getNewChild()) {
                                    ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                                    return;
                                }
                                if (child instanceof XmlAttributeValue) {
                                    assert (parent2 instanceof XmlAttribute) : parent2;
                                    XmlAttribute attribute2 = (XmlAttribute)parent2;
                                    PsiElement newChild = event.getNewChild();
                                    if (oldChild instanceof XmlAttributeValue && newChild instanceof XmlAttributeValue) {
                                        String oldText = ((XmlAttributeValue)oldChild).getValue().trim();
                                        String newText = ((XmlAttributeValue)newChild).getValue().trim();
                                        if (oldText.startsWith("@+id/") || newText.startsWith("@+id/")) {
                                            ResourceUrl newResourceUrl;
                                            ResourceItemSource resourceFile = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(psiFile.getVirtualFile());
                                            if (!(resourceFile instanceof PsiResourceFile)) {
                                                ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                                                return;
                                            }
                                            ResourceUrl oldResourceUrl = ResourceUrl.parse((String)oldText);
                                            if (Objects.equals(oldResourceUrl, newResourceUrl = ResourceUrl.parse((String)newText))) {
                                                return;
                                            }
                                            XmlTag xmlTag = attribute2.getParent();
                                            ResourceFolderRepository.this.scheduleUpdate(() -> {
                                                if (!xmlTag.isValid()) {
                                                    ResourceFolderRepository.this.scan(psiFile, folderType);
                                                    return;
                                                }
                                                HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
                                                ArrayList<PsiResourceItem> items = new ArrayList<PsiResourceItem>();
                                                ResourceFolderRepository.this.addIds(xmlTag, items, result2);
                                                Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                                synchronized (object) {
                                                    PsiResourceFile psiResourceFile = (PsiResourceFile)resourceFile;
                                                    ResourceFolderRepository.this.removeItemsForTag(psiResourceFile, xmlTag, ResourceType.ID);
                                                    for (PsiResourceItem item : items) {
                                                        psiResourceFile.addItem(item);
                                                    }
                                                    ResourceFolderRepository.this.commitToRepositoryWithoutLock(result2);
                                                    ResourceFolderRepository.this.setModificationCount(ourModificationCounter.incrementAndGet());
                                                }
                                            });
                                            return;
                                        }
                                    }
                                } else if (parent2 instanceof XmlAttributeValue) {
                                    PsiElement grandParent = parent2.getParent();
                                    if (grandParent instanceof XmlProcessingInstruction) {
                                        return;
                                    }
                                    assert (grandParent instanceof XmlAttribute) : parent2;
                                    XmlAttribute attribute3 = (XmlAttribute)grandParent;
                                    XmlTag xmlTag = attribute3.getParent();
                                    String oldText = StringUtil.notNullize((String)event.getOldChild().getText()).trim();
                                    String newText = StringUtil.notNullize((String)event.getNewChild().getText()).trim();
                                    ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childReplaced " + ResourceFolderRepository.this.pathForLogging(event.getFile()) + " oldText: \"" + oldText + "\" newText: \"" + newText + "\""));
                                    if (oldText.startsWith("@+id/") || newText.startsWith("@+id/")) {
                                        ResourceUrl newResourceUrl;
                                        ResourceItemSource resourceFile = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(psiFile.getVirtualFile());
                                        if (!(resourceFile instanceof PsiResourceFile)) {
                                            ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                                            return;
                                        }
                                        ResourceUrl oldResourceUrl = ResourceUrl.parse((String)oldText);
                                        if (Objects.equals(oldResourceUrl, newResourceUrl = ResourceUrl.parse((String)newText))) {
                                            return;
                                        }
                                        ResourceFolderRepository.this.scheduleUpdate(() -> {
                                            if (!xmlTag.isValid()) {
                                                ResourceFolderRepository.this.scan(psiFile, folderType);
                                                return;
                                            }
                                            HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
                                            ArrayList<PsiResourceItem> items = new ArrayList<PsiResourceItem>();
                                            ResourceFolderRepository.this.addIds(xmlTag, items, result2);
                                            Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                            synchronized (object) {
                                                PsiResourceFile psiResourceFile = (PsiResourceFile)resourceFile;
                                                ResourceFolderRepository.this.removeItemsForTag(psiResourceFile, xmlTag, ResourceType.ID);
                                                ResourceFolderRepository.this.commitToRepository(result2);
                                                for (PsiResourceItem item : items) {
                                                    psiResourceFile.addItem(item);
                                                }
                                                ResourceFolderRepository.this.setModificationCount(ourModificationCounter.incrementAndGet());
                                                ResourceFolderRepository.this.invalidateParentCaches((SingleNamespaceResourceRepository)ResourceFolderRepository.this, ResourceType.ID);
                                            }
                                        });
                                        return;
                                    }
                                }
                                ResourceFolderRepository.this.setModificationCount(ourModificationCounter.incrementAndGet());
                                return;
                            }
                            ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                        } else if (folderType == ResourceFolderType.VALUES) {
                            PsiElement parent3 = event.getParent();
                            if (parent3 instanceof XmlElement) {
                                if (parent3 instanceof XmlComment) {
                                    return;
                                }
                                if (parent3 instanceof XmlTag) {
                                    XmlTag parentTag = (XmlTag)parent3;
                                    if (IdeResourcesUtil.getResourceTypeForResourceTag(parentTag) != null) {
                                        if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                            return;
                                        }
                                        ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                                        if (resourceItem instanceof PsiResourceItem) {
                                            if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                                ResourceFolderRepository.this.setModificationCount(ourModificationCounter.incrementAndGet());
                                            }
                                            ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childReplaced " + ResourceFolderRepository.this.pathForLogging(event.getFile()) + " recomputed: " + resourceItem));
                                            return;
                                        }
                                    }
                                    if (parentTag.getName().equals("resources") && event.getOldChild() instanceof XmlText && event.getNewChild() instanceof XmlText) {
                                        return;
                                    }
                                }
                                if (parent3 instanceof XmlText) {
                                    XmlText text2 = (XmlText)parent3;
                                    this.handleValueXmlTextEdit((PsiElement)text2.getParentTag(), psiFile);
                                    return;
                                }
                                if (parent3 instanceof XmlAttributeValue) {
                                    PsiElement attribute4 = parent3.getParent();
                                    if (attribute4 instanceof XmlProcessingInstruction) {
                                        return;
                                    }
                                    PsiElement tag = attribute4.getParent();
                                    assert (attribute4 instanceof XmlAttribute) : attribute4;
                                    XmlAttribute xmlAttribute = (XmlAttribute)attribute4;
                                    assert (tag instanceof XmlTag) : tag;
                                    XmlTag xmlTag = (XmlTag)tag;
                                    String attributeName = xmlAttribute.getName();
                                    if (ResourceFolderRepository.isItemElement(xmlTag) && attributeName.equals("name")) {
                                        ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(xmlTag);
                                        if (type != null) {
                                            String oldName = event.getOldChild().getText();
                                            String newName = event.getNewChild().getText();
                                            ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childReplaced " + ResourceFolderRepository.this.pathForLogging(event.getFile()) + " oldName: \"" + oldName + "\" newName: \"" + newName + "\""));
                                            if (oldName.equals(newName)) {
                                                return;
                                            }
                                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                                return;
                                            }
                                            ResourceFolderRepository.this.scheduleUpdate(() -> {
                                                XmlTag parentTag;
                                                if (!xmlTag.isValid()) {
                                                    ResourceFolderRepository.this.scan(psiFile, folderType);
                                                    return;
                                                }
                                                ResourceItem item = ResourceFolderRepository.this.findResourceItem(type, psiFile, oldName, xmlTag);
                                                if (item == null && ResourceFolderRepository.isValidValueResourceName(oldName)) {
                                                    ResourceFolderRepository.this.scan(psiFile, folderType);
                                                    return;
                                                }
                                                Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                                synchronized (object) {
                                                    ListMultimap<String, ResourceItem> items = ResourceFolderRepository.this.myResourceTable.get(type);
                                                    if (items == null) {
                                                        ResourceFolderRepository.this.scan(psiFile, folderType);
                                                        return;
                                                    }
                                                    if (item != null) {
                                                        items.remove((Object)oldName, (Object)item);
                                                    }
                                                    if (ResourceFolderRepository.isValidValueResourceName(newName)) {
                                                        PsiResourceItem newItem = PsiResourceItem.forXmlTag(newName, type, ResourceFolderRepository.this, xmlTag);
                                                        items.put((Object)newName, (Object)newItem);
                                                        ResourceItemSource resourceFile = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(psiFile.getVirtualFile());
                                                        if (resourceFile != null) {
                                                            PsiResourceFile psiResourceFile = (PsiResourceFile)resourceFile;
                                                            if (item != null) {
                                                                psiResourceFile.removeItem((PsiResourceItem)item);
                                                            }
                                                            psiResourceFile.addItem(newItem);
                                                        } else assert (false) : item;
                                                    }
                                                    ResourceFolderRepository.this.setModificationCount(ourModificationCounter.incrementAndGet());
                                                    ResourceFolderRepository.this.invalidateParentCaches((SingleNamespaceResourceRepository)ResourceFolderRepository.this, type);
                                                }
                                                if (type == ResourceType.ATTR && (parentTag = xmlTag.getParentTag()) != null && IdeResourcesUtil.getResourceTypeForResourceTag(parentTag) == ResourceType.STYLEABLE) {
                                                    ResourceItem style = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                                                    if (style instanceof PsiResourceItem) {
                                                        ((PsiResourceItem)style).recomputeValue();
                                                    }
                                                    ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childReplaced " + ResourceFolderRepository.this.pathForLogging(event.getFile()) + " recomputed: " + style));
                                                }
                                            });
                                            return;
                                        }
                                        XmlTag parentTag = xmlTag.getParentTag();
                                        if (parentTag != null && IdeResourcesUtil.getResourceTypeForResourceTag(parentTag) != null) {
                                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                                return;
                                            }
                                            ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                                            if (resourceItem instanceof PsiResourceItem) {
                                                if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                                    ResourceFolderRepository.this.setModificationCount(ourModificationCounter.incrementAndGet());
                                                }
                                                ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childReplaced " + ResourceFolderRepository.this.pathForLogging(event.getFile()) + " recomputed: " + resourceItem));
                                                return;
                                            }
                                        }
                                    }
                                }
                            }
                            ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                        } else if (folderType == ResourceFolderType.COLOR) {
                            PsiElement parent4 = event.getParent();
                            if (parent4 instanceof XmlElement) {
                                PsiElement attribute5;
                                if (parent4 instanceof XmlComment) {
                                    return;
                                }
                                if (parent4 instanceof XmlAttributeValue && (attribute5 = parent4.getParent()) instanceof XmlProcessingInstruction) {
                                    return;
                                }
                                ResourceFolderRepository.this.setModificationCount(ourModificationCounter.incrementAndGet());
                                return;
                            }
                        } else if (folderType == ResourceFolderType.FONT) {
                            ResourceFolderRepository.this.clearFontCache(psiFile.getVirtualFile());
                        } else if (folderType != null && (parent = event.getParent()) instanceof XmlElement) {
                            if (parent instanceof XmlComment) {
                                return;
                            }
                            ResourceFolderRepository.this.setModificationCount(ourModificationCounter.incrementAndGet());
                        }
                    }
                }
                this.myIgnoreChildrenChanged = true;
            }
            finally {
                ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childReplaced " + ResourceFolderRepository.this.pathForLogging(event.getFile()) + " end"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean rescheduleScanIfRunning(@NotNull VirtualFile virtualFile) {
            Object object = ResourceFolderRepository.this.scanLock;
            synchronized (object) {
                if (ResourceFolderRepository.this.pendingScans.contains(virtualFile)) {
                    ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".rescheduleScanIfRunning " + ResourceFolderRepository.this.pathForLogging(virtualFile) + " scan is already pending"));
                    return true;
                }
                if (ResourceFolderRepository.this.runningScans.containsKey(virtualFile)) {
                    ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".rescheduleScanIfRunning " + ResourceFolderRepository.this.pathForLogging(virtualFile) + " rescheduling scan"));
                    ResourceFolderRepository.this.scheduleScan(virtualFile);
                    return true;
                }
            }
            return false;
        }

        private void handleValueXmlTextEdit(@Nullable PsiElement parent, @NotNull PsiFile psiFile) {
            XmlTag style;
            if (!(parent instanceof XmlTag)) {
                return;
            }
            XmlTag parentTag = (XmlTag)parent;
            String parentTagName = parentTag.getName();
            if (parentTagName.equals("resources")) {
                return;
            }
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (parentTagName.equals("item") && (style = parentTag.getParentTag()) != null && ResourceType.fromXmlTagName((String)style.getName()) != null) {
                ResourceFolderType folderType = IdeResourcesUtil.getFolderType(psiFile);
                assert (folderType != null);
                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                    return;
                }
                ResourceFolderRepository.this.scheduleUpdate(() -> {
                    if (!style.isValid()) {
                        ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                        return;
                    }
                    ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(style, psiFile);
                    if (item instanceof PsiResourceItem) {
                        boolean cleared = ((PsiResourceItem)item).recomputeValue();
                        if (cleared) {
                            ResourceFolderRepository.this.setModificationCount(ourModificationCounter.incrementAndGet());
                        }
                        ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".handleValueXmlTextEdit " + ResourceFolderRepository.this.pathForLogging(virtualFile) + " recomputed: " + item));
                    }
                });
                return;
            }
            XmlTag itemTag = ResourceFolderRepository.this.findItemElement(parentTag);
            if (itemTag != null) {
                ResourceFolderType folderType = IdeResourcesUtil.getFolderType(psiFile);
                assert (folderType != null);
                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                    return;
                }
                ResourceFolderRepository.this.scheduleUpdate(() -> {
                    if (!itemTag.isValid()) {
                        ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                        return;
                    }
                    ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(itemTag, psiFile);
                    if (item instanceof PsiResourceItem) {
                        boolean cleared = ((PsiResourceItem)item).recomputeValue();
                        if (cleared) {
                            ResourceFolderRepository.this.setModificationCount(ourModificationCounter.incrementAndGet());
                        }
                        ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".handleValueXmlTextEdit " + ResourceFolderRepository.this.pathForLogging(virtualFile) + " recomputed: " + item));
                    }
                });
            }
        }

        public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
            ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".beforeChildrenChange " + ResourceFolderRepository.this.pathForLogging(event.getFile())));
            this.myIgnoreChildrenChanged = false;
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            PsiElement firstChild;
            ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childrenChanged " + ResourceFolderRepository.this.pathForLogging(event.getFile())));
            PsiElement parent = event.getParent();
            if (this.myIgnoreChildrenChanged) {
                if (parent != event.getChild()) {
                    ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childrenChanged " + ResourceFolderRepository.this.pathForLogging(event.getFile()) + " event already processed"));
                    return;
                }
            } else if (event instanceof PsiTreeChangeEventImpl && ((PsiTreeChangeEventImpl)event).isGenericChange()) {
                ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childrenChanged " + ResourceFolderRepository.this.pathForLogging(event.getFile()) + " generic change"));
                return;
            }
            PsiElement psiElement = firstChild = parent != null && !(parent instanceof PsiFile) ? parent.getFirstChild() : null;
            if (firstChild instanceof PsiWhiteSpace && firstChild == parent.getLastChild()) {
                ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childrenChanged " + ResourceFolderRepository.this.pathForLogging(event.getFile()) + " white space"));
                return;
            }
            PsiFile psiFile = event.getFile();
            if (psiFile != null && FileRelevanceKt.isRelevantFile(psiFile)) {
                ResourceFolderType folderType;
                VirtualFile virtualFile = psiFile.getVirtualFile();
                if (virtualFile != null && (folderType = IdeResourcesUtil.getFolderType(psiFile)) != null && ResourceFolderRepository.this.isResourceFile(psiFile)) {
                    ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                }
            } else if (LOG.isDebugEnabled()) {
                Throwable throwable = new Throwable();
                throwable.fillInStackTrace();
                LOG.debug("Received unexpected childrenChanged event for inter-file operations", throwable);
            }
            ResourceUpdateTracer.log((Function0<String>)((Function0)() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childrenChanged " + ResourceFolderRepository.this.pathForLogging(event.getFile()) + " end"));
        }
    }

    static class Loader
    extends RepositoryLoader<ResourceFolderRepository> {
        @NotNull
        private final ResourceFolderRepository myRepository;
        @NotNull
        private final VirtualFile myResourceDir;
        @NotNull
        private final PsiManager myPsiManager;
        @Nullable
        private final ResourceFolderRepositoryCachingData myCachingData;
        @NotNull
        private final Map<ResourceType, ListMultimap<String, ResourceItem>> myResources = new EnumMap<ResourceType, ListMultimap<String, ResourceItem>>(ResourceType.class);
        @NotNull
        private final Map<VirtualFile, ResourceItemSource<BasicResourceItem>> mySources = new HashMap<VirtualFile, ResourceItemSource<BasicResourceItem>>();
        @NotNull
        private final Map<VirtualFile, BasicFileResourceItem> myFileResources = new HashMap<VirtualFile, BasicFileResourceItem>();
        @Nullable
        private VirtualFile myLastVirtualFile;
        @Nullable
        private PathString myLastPathString;
        @NotNull
        Set<VirtualFile> myFilesToReparseAsPsi = new HashSet<VirtualFile>();
        private final FileDocumentManager myFileDocumentManager;
        private volatile boolean myLoaded = false;
        private final List<Runnable> initializers = ImmutableList.of((Object)new RunOnceInitializer(this::loadFromPersistentCache), (Object)new RunOnceWithReadLockInitializer(this::getPsiDirsForListener), (Object)new RunOnceInitializer(this::scanResFolder), (Object)new RunOnceInitializer(this::populateRepository), (Object)new RunOnceWithReadLockInitializer(this::scanQueuedPsiResources), (Object)new RunOnceInitializer(this::createCacheFileIfNeeded));

        Loader(@NotNull ResourceFolderRepository repository2, @Nullable ResourceFolderRepositoryCachingData cachingData) {
            super(VfsUtilCore.virtualToIoFile((VirtualFile)repository2.myResourceDir).toPath(), null, repository2.getNamespace());
            this.myRepository = repository2;
            this.myResourceDir = repository2.myResourceDir;
            this.myPsiManager = repository2.myPsiManager;
            this.myCachingData = cachingData;
            this.myDefaultVisibility = ResourceVisibility.UNDEFINED;
            this.myFileDocumentManager = FileDocumentManager.getInstance();
        }

        public void ensureLoaded() {
            if (this.myLoaded) {
                return;
            }
            if (!this.myResourceDir.isValid()) {
                this.myLoaded = true;
                return;
            }
            for (Runnable initializer : this.initializers) {
                initializer.run();
            }
            this.myLoaded = true;
        }

        private void loadFromPersistentCache() {
            if (this.myCachingData == null) {
                return;
            }
            byte[] fileHeader = this.getCacheFileHeader(this.myCachingData);
            try (Base128InputStream stream2 = new Base128InputStream(this.myCachingData.getCacheFile());){
                if (!stream2.validateContents(fileHeader)) {
                    return;
                }
                ResourceSerializationUtil.readResourcesFromStream((Base128InputStream)stream2, (Map)Maps.newHashMapWithExpectedSize((int)1000), null, (LoadableResourceRepository)this.myRepository, item -> this.addResourceItem((BasicResourceItem)item, this.myRepository));
            }
            catch (NoSuchFileException stream2) {
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                this.mySources.clear();
                this.myFileResources.clear();
                LOG.warn("Failed to load resources from cache file " + this.myCachingData.getCacheFile(), e);
            }
        }

        private void createCacheFileIfNeeded() {
            Executor executor;
            if (this.myCachingData != null && !this.myRepository.hasFreshFileCache() && (executor = this.myCachingData.getCacheCreationExecutor()) != null) {
                executor.execute(this::createCacheFile);
            }
        }

        private byte[] getCacheFileHeader(@NotNull ResourceFolderRepositoryCachingData cachingData) {
            return ResourceSerializationUtil.getCacheFileHeader(stream -> {
                stream.write(CACHE_FILE_HEADER);
                stream.writeString(ResourceFolderRepository.CACHE_FILE_FORMAT_VERSION);
                stream.writeString(this.myResourceDir.getPath());
                stream.writeString(cachingData.getCodeVersion());
            });
        }

        private void createCacheFile() {
            assert (this.myCachingData != null);
            byte[] header = this.getCacheFileHeader(this.myCachingData);
            try {
                ResourceSerializationUtil.createPersistentCache((Path)this.myCachingData.getCacheFile(), (byte[])header, stream -> ResourceSerializationUtil.writeResourcesToStream(this.myResources, (Base128OutputStream)stream, config -> true));
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void scanResFolder() {
            try {
                void var3_8;
                VirtualFile[] virtualFileArray = this.myResourceDir.getChildren();
                int n = virtualFileArray.length;
                boolean bl = false;
                while (var3_8 < n) {
                    String folderName;
                    RepositoryLoader.FolderInfo folderInfo;
                    VirtualFile subDir = virtualFileArray[var3_8];
                    if (subDir.isValid() && subDir.isDirectory() && (folderInfo = RepositoryLoader.FolderInfo.create((String)(folderName = subDir.getName()), (Map)this.myFolderConfigCache)) != null) {
                        RepositoryConfiguration configuration2 = this.getConfiguration(this.myRepository, folderInfo.configuration);
                        for (VirtualFile file2 : subDir.getChildren()) {
                            if (file2.getName().startsWith(".")) continue;
                            if (this.myFileDocumentManager.isFileModified(file2)) {
                                this.myFilesToReparseAsPsi.add(file2);
                                continue;
                            }
                            if (folderInfo.folderType == ResourceFolderType.VALUES ? this.mySources.containsKey(file2) : this.myFileResources.containsKey(file2)) {
                                if (!Loader.isParsableFile(file2, folderInfo)) continue;
                                this.countCacheHit();
                                continue;
                            }
                            PathString pathString = FileExtensions.toPathString(file2);
                            this.myLastVirtualFile = file2;
                            this.myLastPathString = pathString;
                            try {
                                this.loadResourceFile(pathString, folderInfo, configuration2);
                                if (!Loader.isParsableFile(file2, folderInfo)) continue;
                                this.countCacheMiss();
                            }
                            catch (ParsingException e) {
                                this.myFilesToReparseAsPsi.add(file2);
                            }
                        }
                    }
                    ++var3_8;
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Failed to load resources from " + this.myResourceDirectoryOrFile, (Throwable)e);
            }
            super.finishLoading((LoadableResourceRepository)this.myRepository);
            for (Map.Entry<VirtualFile, BasicFileResourceItem> entry : this.myFileResources.entrySet()) {
                VirtualFile virtualFile = entry.getKey();
                BasicFileResourceItem item = entry.getValue();
                ResourceItemSource source2 = this.mySources.computeIfAbsent(virtualFile, file -> new VfsResourceFile((VirtualFile)file, item.getRepositoryConfiguration()));
                source2.addItem(item);
            }
            ArrayList<ResourceItemSource<BasicResourceItem>> sortedSources = new ArrayList<ResourceItemSource<BasicResourceItem>>(this.mySources.values());
            sortedSources.sort(SOURCE_COMPARATOR);
            for (ResourceItemSource resourceItemSource : sortedSources) {
                for (ResourceItem item : resourceItemSource) {
                    this.getOrCreateMap(item.getType()).put((Object)item.getName(), (Object)item);
                }
            }
        }

        private void loadResourceFile(@NotNull PathString file, @NotNull RepositoryLoader.FolderInfo folderInfo, @NotNull RepositoryConfiguration configuration2) {
            if (folderInfo.resourceType == null) {
                if (Loader.isXmlFile((PathString)file)) {
                    this.parseValueResourceFile(file, configuration2);
                }
            } else if (this.myRepository.checkResourceFilename(file, folderInfo.folderType)) {
                if (Loader.isXmlFile((PathString)file) && folderInfo.isIdGenerating) {
                    this.parseIdGeneratingResourceFile(file, configuration2);
                }
                BasicFileResourceItem item = this.createFileResourceItem(file, folderInfo.resourceType, configuration2, folderInfo.isIdGenerating);
                this.addResourceItem((BasicResourceItem)item, (ResourceFolderRepository)item.getRepository());
            }
        }

        private static boolean isParsableFile(@NotNull VirtualFile file, @NotNull RepositoryLoader.FolderInfo folderInfo) {
            return (folderInfo.folderType == ResourceFolderType.VALUES || folderInfo.isIdGenerating) && Loader.isXmlFile((String)file.getName());
        }

        private void populateRepository() {
            this.myRepository.mySources.putAll(this.mySources);
            this.myRepository.commitToRepositoryWithoutLock(this.myResources);
        }

        @NotNull
        private ListMultimap<String, ResourceItem> getOrCreateMap(@NotNull ResourceType resourceType) {
            return this.myResources.computeIfAbsent(resourceType, type -> LinkedListMultimap.create());
        }

        @NotNull
        protected InputStream getInputStream(@NotNull PathString file) throws IOException {
            VirtualFile virtualFile = this.getVirtualFile(file);
            if (virtualFile == null) {
                throw new NoSuchFileException(file.getNativePath());
            }
            return virtualFile.getInputStream();
        }

        @Nullable
        private VirtualFile getVirtualFile(@NotNull PathString file) {
            return file.equals((Object)this.myLastPathString) ? this.myLastVirtualFile : FileExtensions.toVirtualFile(file);
        }

        private void getPsiDirsForListener() {
            PsiDirectory resourceDirPsi = this.myPsiManager.findDirectory(this.myResourceDir);
            if (resourceDirPsi != null) {
                resourceDirPsi.getSubdirectories();
            }
        }

        protected void addResourceItem(@NotNull BasicResourceItem item, @NotNull ResourceFolderRepository repository2) {
            if (item instanceof BasicValueResourceItemBase) {
                VfsResourceFile sourceFile = (VfsResourceFile)((BasicValueResourceItemBase)item).getSourceFile();
                VirtualFile virtualFile = sourceFile.getVirtualFile();
                if (virtualFile != null && virtualFile.isValid() && !virtualFile.isDirectory()) {
                    sourceFile.addItem(item);
                    this.mySources.put(virtualFile, sourceFile);
                }
            } else if (item instanceof VfsFileResourceItem) {
                VfsFileResourceItem fileResourceItem = (VfsFileResourceItem)item;
                VirtualFile virtualFile = fileResourceItem.getVirtualFile();
                if (virtualFile != null && virtualFile.isValid() && !virtualFile.isDirectory()) {
                    this.myFileResources.put(virtualFile, fileResourceItem);
                }
            } else if (item instanceof BasicFileResourceItem) {
                BasicFileResourceItem fileResourceItem = (BasicFileResourceItem)item;
                VirtualFile virtualFile = this.getVirtualFile(fileResourceItem.getSource());
                if (virtualFile != null && virtualFile.isValid() && !virtualFile.isDirectory()) {
                    this.myFileResources.put(virtualFile, fileResourceItem);
                }
            } else {
                throw new IllegalArgumentException("Unexpected type: " + item.getClass().getName());
            }
        }

        @NotNull
        private BasicFileResourceItem createFileResourceItem(@NotNull PathString file, @NotNull ResourceType resourceType, @NotNull RepositoryConfiguration configuration2, boolean idGenerating) {
            DensityQualifier densityQualifier;
            String resourceName = SdkUtils.fileNameToResourceName((String)file.getFileName());
            ResourceVisibility visibility = this.getVisibility(resourceType, resourceName);
            Density density = null;
            if (DensityBasedResourceValue.isDensityBasedResourceType((ResourceType)resourceType) && (densityQualifier = configuration2.getFolderConfiguration().getDensityQualifier()) != null) {
                density = densityQualifier.getValue();
            }
            return this.createFileResourceItem(file, resourceType, resourceName, configuration2, visibility, density, idGenerating);
        }

        @NotNull
        protected ResourceSourceFile createResourceSourceFile(@NotNull PathString file, @NotNull RepositoryConfiguration configuration2) {
            VirtualFile virtualFile = this.getVirtualFile(file);
            return new VfsResourceFile(virtualFile, configuration2);
        }

        @NotNull
        private BasicFileResourceItem createFileResourceItem(@NotNull PathString file, @NotNull ResourceType type, @NotNull String name2, @NotNull RepositoryConfiguration configuration2, @NotNull ResourceVisibility visibility, @Nullable Density density, boolean idGenerating) {
            if (!idGenerating) {
                return super.createFileResourceItem(file, type, name2, configuration2, visibility, density);
            }
            VirtualFile virtualFile = this.getVirtualFile(file);
            String relativePath = this.getResRelativePath(file);
            return density == null ? new VfsFileResourceItem(type, name2, configuration2, visibility, relativePath, virtualFile) : new VfsDensityBasedFileResourceItem(type, name2, configuration2, visibility, relativePath, virtualFile, density);
        }

        protected void handleParsingError(@NotNull PathString file, @NotNull Exception e) {
            throw new ParsingException(e);
        }

        private void scanQueuedPsiResources() {
            for (VirtualFile file : this.myFilesToReparseAsPsi) {
                this.myRepository.scan(file);
            }
        }

        private void countCacheHit() {
            ++this.myRepository.myNumXmlFilesLoadedInitially;
        }

        private void countCacheMiss() {
            ++this.myRepository.myNumXmlFilesLoadedInitially;
            ++this.myRepository.myNumXmlFilesLoadedInitiallyFromSources;
        }
    }

    private static class ParsingException
    extends RuntimeException {
        ParsingException(Throwable cause) {
            super(cause);
        }
    }

    @VisibleForTesting
    static class RunOnceWithReadLockInitializer
    implements Runnable {
        private final Supplier<Void> myInitializer = Suppliers.memoize(() -> {
            initializer.run();
            this.myIsInitialized = true;
            return null;
        });
        private volatile boolean myIsInitialized = false;

        public RunOnceWithReadLockInitializer(Runnable initializer) {
        }

        @Override
        public void run() {
            if (this.myIsInitialized) {
                return;
            }
            ReadAction.nonBlocking(this.myInitializer::get).executeSynchronously();
        }
    }

    @VisibleForTesting
    static class RunOnceInitializer
    implements Runnable {
        private final Supplier<Void> myInitializer = Suppliers.memoize(() -> {
            initializer.run();
            return null;
        });

        public RunOnceInitializer(Runnable initializer) {
        }

        @Override
        public void run() {
            this.myInitializer.get();
        }
    }
}

