/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepositoryCachingData;
import com.android.tools.idea.res.ResourceFolderRepositoryFileCache;
import com.android.tools.idea.res.ResourceFolderRepositoryFileCacheService;
import com.android.tools.res.CodeVersionAdapter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceFolderRepositoryFileCacheImpl
implements ResourceFolderRepositoryFileCache {
    private static final String CACHE_DIRECTORY = "caches/project_resources";
    private static final String INVALIDATION_MARKER_FILE = "invalidated.txt";
    @NotNull
    private final Path myRootDir;

    public ResourceFolderRepositoryFileCacheImpl() {
        this.myRootDir = Paths.get(PathManager.getSystemPath(), new String[0]).resolve(CACHE_DIRECTORY);
    }

    ResourceFolderRepositoryFileCacheImpl(@NotNull Path rootDirParent) {
        this.myRootDir = rootDirParent.resolve(CACHE_DIRECTORY);
    }

    private static Logger getLogger() {
        return Logger.getInstance(ResourceFolderRepositoryFileCacheImpl.class);
    }

    @Override
    @Nullable
    public ResourceFolderRepositoryCachingData getCachingData(@NotNull Project project, @NotNull VirtualFile resourceDir, @Nullable Executor cacheCreationExecutor) {
        String codeVersion = CodeVersionAdapter.getCodeVersion();
        if (codeVersion == null) {
            return null;
        }
        Path cacheFile = this.getCacheFile(project, resourceDir);
        if (cacheFile == null) {
            return null;
        }
        return new ResourceFolderRepositoryCachingData(cacheFile, this.isValid(), codeVersion, cacheCreationExecutor);
    }

    @Override
    public void createDirForProject(@NotNull Project project) throws IOException {
        Path dir = this.getProjectDir(project);
        if (dir == null) {
            throw new IOException();
        }
        FileUtil.ensureExists((File)dir.toFile());
    }

    @Nullable
    private Path getCacheFile(@NotNull Project project, @NotNull VirtualFile resourceDir) {
        if (!this.isValid()) {
            return null;
        }
        Path projectComponent = this.getProjectDir(project);
        if (projectComponent == null) {
            return null;
        }
        String dirComponent = FileUtil.sanitizeFileName((String)resourceDir.getParent().getName()) + "_" + Integer.toHexString(resourceDir.hashCode()) + ".dat";
        return projectComponent.resolve(dirComponent);
    }

    @VisibleForTesting
    @Nullable
    Path getRootDir() {
        if (!Files.isDirectory(this.myRootDir, LinkOption.NOFOLLOW_LINKS)) {
            try {
                Files.createDirectories(this.myRootDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to create cache root directory " + this.myRootDir, (Throwable)e);
                return null;
            }
        }
        return this.myRootDir;
    }

    @VisibleForTesting
    @Nullable
    Path getProjectDir(@NotNull Project project) {
        Path rootDir = this.getRootDir();
        if (rootDir == null) {
            return null;
        }
        return ProjectUtil.getProjectCachePath((Project)project, (Path)rootDir);
    }

    @Override
    public void invalidate() {
        if (!this.isValid()) {
            return;
        }
        Path rootDir = this.getRootDir();
        if (rootDir == null) {
            return;
        }
        Path stampFile = rootDir.resolve(INVALIDATION_MARKER_FILE);
        try {
            Files.createFile(stampFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to write cache invalidating stamp file " + stampFile, (Throwable)e);
        }
    }

    @VisibleForTesting
    void clear() {
        Path rootDir = this.getRootDir();
        if (rootDir == null) {
            return;
        }
        boolean[] errorDeletingDirectories = new boolean[1];
        try (Stream<Path> stream2 = Files.list(rootDir);){
            stream2.forEach(subCache -> {
                if (!subCache.getFileName().toString().equals(INVALIDATION_MARKER_FILE)) {
                    try {
                        FileUtil.delete((Path)subCache);
                    }
                    catch (IOException e) {
                        ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to delete " + subCache + " directory", (Throwable)e);
                        errorDeletingDirectories[0] = true;
                    }
                }
            });
        }
        catch (IOException stream2) {
            // empty catch block
        }
        if (!errorDeletingDirectories[0]) {
            Path invalidationMarker = rootDir.resolve(INVALIDATION_MARKER_FILE);
            try {
                FileUtil.delete((Path)invalidationMarker);
            }
            catch (IOException e) {
                ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to delete " + invalidationMarker + " file", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    boolean isValid() {
        Path rootDir = this.getRootDir();
        if (rootDir == null) {
            return false;
        }
        Path stampFile = rootDir.resolve(INVALIDATION_MARKER_FILE);
        return Files.notExists(stampFile, new LinkOption[0]);
    }

    @NotNull
    private static ResourceFolderRepositoryFileCacheImpl getCache() {
        return (ResourceFolderRepositoryFileCacheImpl)ResourceFolderRepositoryFileCacheService.get();
    }

    public static class PopulateCachesActivity
    implements StartupActivity.RequiredForSmartMode {
        public void runActivity(@NotNull Project project) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            ResourceFolderRegistry.PopulateCachesTask task2 = new ResourceFolderRegistry.PopulateCachesTask(project);
            ProgressIndicator indicator = Objects.requireNonNullElseGet(ProgressManager.getGlobalProgressIndicator(), EmptyProgressIndicator::new);
            ResourceFolderRepositoryFileCacheImpl.getLogger().assertTrue(DumbService.isDumb((Project)project));
            task2.performInDumbMode(indicator);
        }
    }

    public static class MaintenanceActivity
    implements StartupActivity.DumbAware {
        public void runActivity(@NotNull Project project) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            PruneTask pruneTask = new PruneTask(project);
            pruneTask.queue(project);
            ManageLruProjectFilesTask manageProjectsTask = new ManageLruProjectFilesTask(project);
            manageProjectsTask.queue(project);
        }
    }

    public static class CacheInvalidator
    extends CachesInvalidator {
        public void invalidateCaches() {
            ResourceFolderRepositoryFileCacheService.get().invalidate();
        }
    }

    static class PruneTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;

        PruneTask(@NotNull Project project) {
            this.myProject = project;
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            if (this.myProject.isDisposed()) {
                return;
            }
            ResourceFolderRepositoryFileCacheImpl cache = ResourceFolderRepositoryFileCacheImpl.getCache();
            Path projectCacheBase = cache.getProjectDir(this.myProject);
            if (projectCacheBase == null || !Files.exists(projectCacheBase, new LinkOption[0])) {
                return;
            }
            List facets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
            Map<VirtualFile, AndroidFacet> resDirectories = IdeResourcesUtil.getResourceDirectoriesForFacets(facets);
            HashSet<Path> usedCacheDirectories = new HashSet<Path>();
            for (VirtualFile resourceDir : resDirectories.keySet()) {
                Path dir = cache.getCacheFile(this.myProject, resourceDir);
                if (dir == null) continue;
                usedCacheDirectories.add(dir);
            }
            try (Stream<Path> stream = Files.list(projectCacheBase);){
                stream.forEach(file -> {
                    if (!usedCacheDirectories.contains(file) && !FileUtil.delete((File)file.toFile())) {
                        ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to delete " + file);
                    }
                });
            }
            catch (IOException e) {
                ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to prune cache files from " + projectCacheBase);
            }
        }

        @Nullable
        public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
            if (taskFromQueue instanceof PruneTask && ((PruneTask)taskFromQueue).myProject.equals(this.myProject)) {
                return this;
            }
            return null;
        }
    }

    static class ManageLruProjectFilesTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;
        private static final Object PROJECT_LRU_LOCK = new Object();
        private static final String LRU_FILE = "project_lru_list.txt";
        private static final int MAX_PROJECT_CACHES = 12;

        ManageLruProjectFilesTask(@NotNull Project project) {
            this.myProject = project;
        }

        @Nullable
        public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
            if (taskFromQueue instanceof ManageLruProjectFilesTask && ((ManageLruProjectFilesTask)taskFromQueue).myProject.equals(this.myProject)) {
                return this;
            }
            return null;
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.maintainLruCache(12);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        void maintainLruCache(int maxProjectCaches) {
            assert (maxProjectCaches > 0);
            ResourceFolderRepositoryFileCacheImpl cache = ResourceFolderRepositoryFileCacheImpl.getCache();
            Path cacheRootDir = cache.getRootDir();
            if (cacheRootDir == null) {
                return;
            }
            if (!cache.isValid()) {
                cache.clear();
                return;
            }
            Object object = PROJECT_LRU_LOCK;
            synchronized (object) {
                try {
                    List<String> projectsList = ManageLruProjectFilesTask.loadListOfProjectCaches(cacheRootDir);
                    List<String> projectsToRemove = ManageLruProjectFilesTask.updateLruList(this.myProject, projectsList, maxProjectCaches);
                    ManageLruProjectFilesTask.pruneOldProjects(cacheRootDir, projectsToRemove);
                    ManageLruProjectFilesTask.writeListOfProjectCaches(cacheRootDir, projectsList);
                }
                catch (IOException e) {
                    ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to maintain projects LRU cache for dir " + cacheRootDir, (Throwable)e);
                }
            }
        }

        @VisibleForTesting
        @NotNull
        static List<String> loadListOfProjectCaches(@NotNull Path cacheRootDir) throws IOException {
            Path lruFile = cacheRootDir.resolve(LRU_FILE);
            try {
                return Files.readAllLines(lruFile).stream().map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            }
            catch (NoSuchFileException e) {
                return new ArrayList<String>();
            }
        }

        @VisibleForTesting
        static void writeListOfProjectCaches(@NotNull Path cacheRootDir, @NotNull List<String> projectsList) throws IOException {
            Path lruFile = cacheRootDir.resolve(LRU_FILE);
            Files.write(lruFile, projectsList, new OpenOption[0]);
        }

        @VisibleForTesting
        static List<String> updateLruList(@NotNull Project currentProject, @NotNull List<String> projectsList, int maxProjectCaches) {
            ArrayList<String> projectsToRemove = new ArrayList<String>();
            Path currentProjectPath = ResourceFolderRepositoryFileCacheImpl.getCache().getProjectDir(currentProject);
            if (currentProjectPath == null) {
                return projectsToRemove;
            }
            String currentProjectDir = currentProjectPath.getFileName().toString();
            projectsList.remove(currentProjectDir);
            projectsList.add(0, currentProjectDir);
            int i = projectsList.size();
            while (--i >= maxProjectCaches) {
                projectsToRemove.add(projectsList.remove(i));
            }
            return projectsToRemove;
        }

        private static void pruneOldProjects(@NotNull Path cacheRootDir, @NotNull List<String> childNames) {
            for (String child : childNames) {
                Preconditions.checkArgument((!child.isEmpty() ? 1 : 0) != 0);
                Path path = cacheRootDir.resolve(child);
                if (FileUtil.delete((File)path.toFile()) || !Files.exists(path, new LinkOption[0])) continue;
                ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to prune directory " + path);
            }
        }
    }
}

