/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.util.PathString;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.ResourceUpdateTraceSettings;
import com.android.tools.idea.res.ResourceUpdateTracerKt;
import com.android.tools.idea.util.FileExtensions;
import com.android.utils.FlightRecorder;
import com.android.utils.TraceUtils;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ApplicationKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012H\u0002J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0017J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0019J\u001c\u0010\u001b\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001d2\u0006\u0010\u0018\u001a\u00020\u0019R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/res/ResourceUpdateTracer;", "", "<init>", "()V", "value", "", "isTracingActive", "()Z", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "startTracing", "", "stopTracing", "dumpTrace", "message", "", "logImpl", "lazyRecord", "Lkotlin/Function0;", "logDirectImpl", "pathForLogging", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/android/ide/common/util/PathString;", "pathsForLogging", "files", "", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nResourceUpdateTracer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceUpdateTracer.kt\ncom/android/tools/idea/res/ResourceUpdateTracer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n25#2:126\n1863#3,2:127\n1#4:129\n*S KotlinDebug\n*F\n+ 1 ResourceUpdateTracer.kt\ncom/android/tools/idea/res/ResourceUpdateTracer\n*L\n63#1:126\n91#1:127,2\n*E\n"})
public final class ResourceUpdateTracer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isTracingActive;
    @NotNull
    private final Logger logger;

    public ResourceUpdateTracer() {
        ResourceUpdateTracer $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ResourceUpdateTracer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        if (ResourceUpdateTraceSettings.Companion.getInstance().getEnabled()) {
            this.startTracing();
        }
    }

    public final boolean isTracingActive() {
        return this.isTracingActive;
    }

    public final void startTracing() {
        Object t = StudioFlags.RESOURCE_REPOSITORY_TRACE_SIZE.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        FlightRecorder.initialize((int)((Number)t).intValue());
        this.isTracingActive = true;
    }

    public final void stopTracing() {
        this.isTracingActive = false;
    }

    public final void dumpTrace(@Nullable String message) {
        StringBuilder stringBuilder;
        List trace = FlightRecorder.getAndClear();
        if (trace.isEmpty()) {
            if (message == null) {
                this.logger.info("No resource updates recorded");
            } else {
                this.logger.info(message + " - no resource updates recorded");
            }
            return;
        }
        StringBuilder $this$dumpTrace_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        CharSequence charSequence = message;
        if (!(charSequence == null || charSequence.length() == 0)) {
            $this$dumpTrace_u24lambda_u241.append(message).append('\n');
        }
        $this$dumpTrace_u24lambda_u241.append("--- Resource update trace: ---").append('\n');
        Intrinsics.checkNotNull((Object)trace);
        Iterable $this$forEach$iv = trace;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl2 = false;
            $this$dumpTrace_u24lambda_u241.append(it).append('\n');
        }
        String log = stringBuilder.toString();
        this.logger.info(log);
    }

    private final void logImpl(Function0<String> lazyRecord) {
        if (this.isTracingActive) {
            FlightRecorder.log(() -> ResourceUpdateTracer.logImpl$lambda$2(lazyRecord));
        }
    }

    private final void logDirectImpl(Function0<String> lazyRecord) {
        if (this.isTracingActive) {
            String message = (String)lazyRecord.invoke();
            FlightRecorder.log(() -> ResourceUpdateTracer.logDirectImpl$lambda$3(message));
            this.logger.info(message);
        }
    }

    @NotNull
    public final String pathForLogging(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ResourceUpdateTracerKt.access$truncatedPathString(FileExtensions.toPathString(file), 6);
    }

    @Nullable
    public final String pathForLogging(@Nullable PsiFile file) {
        String string;
        PsiFile psiFile = file;
        if (psiFile != null) {
            PsiFile it = psiFile;
            boolean bl = false;
            VirtualFile virtualFile = it.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            string = this.pathForLogging(virtualFile);
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final String pathForLogging(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.pathForLogging(FileExtensions.toPathString(file), project);
    }

    @NotNull
    public final String pathForLogging(@NotNull PathString file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = FileExtensions.toPathString(object)) == null || (object = object.relativize(file)) == null || (object = object.getNativePath()) == null) {
            object = ResourceUpdateTracerKt.access$truncatedPathString(file, 4);
        }
        return object;
    }

    @NotNull
    public final String pathsForLogging(@NotNull Collection<? extends VirtualFile> files2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.joinToString$default((Iterable)files2, (CharSequence)", ", null, null, (int)0, null, arg_0 -> ResourceUpdateTracer.pathsForLogging$lambda$5(this, project, arg_0), (int)30, null);
    }

    private static final Object logImpl$lambda$2(Function0 $lazyRecord) {
        return TraceUtils.getCurrentTime() + " " + $lazyRecord.invoke();
    }

    private static final Object logDirectImpl$lambda$3(String $message) {
        return TraceUtils.getCurrentTime() + " " + $message;
    }

    private static final CharSequence pathsForLogging$lambda$5(ResourceUpdateTracer this$0, Project $project, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.pathForLogging(it, $project);
    }

    @JvmStatic
    @NotNull
    public static final ResourceUpdateTracer getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    public static final void log(@NotNull Function0<String> lazyRecord) {
        Companion.log(lazyRecord);
    }

    @JvmStatic
    public static final void logDirect(@NotNull Function0<String> lazyRecord) {
        Companion.logDirect(lazyRecord);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J\u0016\u0010\u000b\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/res/ResourceUpdateTracer$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/res/ResourceUpdateTracer;", "log", "", "lazyRecord", "Lkotlin/Function0;", "", "logDirect", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nResourceUpdateTracer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceUpdateTracer.kt\ncom/android/tools/idea/res/ResourceUpdateTracer$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,125:1\n31#2,2:126\n*S KotlinDebug\n*F\n+ 1 ResourceUpdateTracer.kt\ncom/android/tools/idea/res/ResourceUpdateTracer$Companion\n*L\n47#1:126,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ResourceUpdateTracer getInstance() {
            ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
            boolean $i$f$service = false;
            Class<ResourceUpdateTracer> serviceClass$iv = ResourceUpdateTracer.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ResourceUpdateTracer)object;
        }

        @JvmStatic
        public final void log(@NotNull Function0<String> lazyRecord) {
            Intrinsics.checkNotNullParameter(lazyRecord, (String)"lazyRecord");
            this.getInstance().logImpl((Function0<String>)lazyRecord);
        }

        @JvmStatic
        public final void logDirect(@NotNull Function0<String> lazyRecord) {
            Intrinsics.checkNotNullParameter(lazyRecord, (String)"lazyRecord");
            this.getInstance().logDirectImpl((Function0<String>)lazyRecord);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

