/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations;

import com.android.tools.idea.projectsystem.TestArtifactSearchScopes;
import com.android.tools.idea.room.migrations.generators.JavaMigrationClassGenerator;
import com.android.tools.idea.room.migrations.generators.JavaMigrationTestGenerator;
import com.android.tools.idea.room.migrations.json.SchemaBundle;
import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizard;
import com.android.tools.idea.room.migrations.update.DatabaseUpdate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/room/migrations/GenerateRoomMigrationAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getMigrationDefaultTargetDirectory", "Lcom/intellij/psi/PsiDirectory;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "getTestDefaultTargetDirectory", "getDefaultTargetPackage", "Lcom/intellij/psi/PsiPackage;", "databaseFullyQualifiedName", "", "getDatabaseClassFullyQualifiedName", "schemaJsonFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.android.room"})
@SourceDebugExtension(value={"SMAP\nGenerateMigrationAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateMigrationAction.kt\ncom/android/tools/idea/room/migrations/GenerateRoomMigrationAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n6180#2,2:132\n1#3:134\n*S KotlinDebug\n*F\n+ 1 GenerateMigrationAction.kt\ncom/android/tools/idea/room/migrations/GenerateRoomMigrationAction\n*L\n51#1:132,2\n*E\n"})
public final class GenerateRoomMigrationAction
extends AnAction {
    public GenerateRoomMigrationAction() {
        super("Generate a Room migration");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object[] objectArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (objectArray == null) {
            return;
        }
        Object[] files2 = objectArray;
        if (files2.length == 2) {
            Object[] $this$sortBy$iv = files2;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.length > 1) {
                ArraysKt.sortWith((Object[])$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        VirtualFile it = (VirtualFile)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getNameWithoutExtension());
                        it = (VirtualFile)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getNameWithoutExtension())));
                    }
                });
            }
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)files2[0], (Project)project2);
            if (module == null) {
                return;
            }
            Module module2 = module;
            Object object = files2[0];
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            String string = this.getDatabaseClassFullyQualifiedName(project2, module2, (VirtualFile)object);
            if (string == null) {
                return;
            }
            String databaseClassQualifiedName = string;
            PsiPackage psiPackage = this.getDefaultTargetPackage(databaseClassQualifiedName, project2);
            if (psiPackage == null) {
                return;
            }
            PsiPackage targetPackage = psiPackage;
            PsiDirectory psiDirectory = this.getMigrationDefaultTargetDirectory(project2, module2);
            if (psiDirectory == null) {
                return;
            }
            PsiDirectory migrationClassDirectory = psiDirectory;
            PsiDirectory psiDirectory2 = this.getTestDefaultTargetDirectory(project2, module2);
            if (psiDirectory2 == null) {
                return;
            }
            PsiDirectory migrationTestDirectory = psiDirectory2;
            SchemaBundle schemaBundle = SchemaBundle.deserialize(files2[0].getInputStream());
            if (schemaBundle == null) {
                return;
            }
            SchemaBundle oldSchema = schemaBundle;
            SchemaBundle schemaBundle2 = SchemaBundle.deserialize(files2[1].getInputStream());
            if (schemaBundle2 == null) {
                return;
            }
            SchemaBundle newSchema = schemaBundle2;
            DatabaseUpdate databaseUpdate = new DatabaseUpdate(oldSchema.getDatabase(), newSchema.getDatabase());
            GenerateMigrationWizard migrationWizard = new GenerateMigrationWizard(project2, targetPackage, migrationClassDirectory, migrationTestDirectory, databaseUpdate);
            if (!ApplicationManager.getApplication().isUnitTestMode() && !migrationWizard.showAndGet()) {
                return;
            }
            WriteCommandAction.runWriteCommandAction((Project)project2, () -> GenerateRoomMigrationAction.actionPerformed$lambda$1(project2, migrationWizard, databaseClassQualifiedName, databaseUpdate));
        }
    }

    private final PsiDirectory getMigrationDefaultTargetDirectory(Project project, Module module) {
        PsiDirectory psiDirectory;
        ContentEntry[] contentEntryArray = ProjectUtil.getRootManager((Module)module).getContentEntries();
        Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"getContentEntries(...)");
        VirtualFile virtualFile = (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])contentEntryArray), GenerateRoomMigrationAction::getMigrationDefaultTargetDirectory$lambda$2), GenerateRoomMigrationAction::getMigrationDefaultTargetDirectory$lambda$3), GenerateRoomMigrationAction::getMigrationDefaultTargetDirectory$lambda$4));
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            psiDirectory = PsiManager.getInstance((Project)project).findDirectory(it);
        } else {
            psiDirectory = null;
        }
        return psiDirectory;
    }

    private final PsiDirectory getTestDefaultTargetDirectory(Project project, Module module) {
        PsiDirectory psiDirectory;
        TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.Companion.getInstance(module);
        ContentEntry[] contentEntryArray = ProjectUtil.getRootManager((Module)module).getContentEntries();
        Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"getContentEntries(...)");
        VirtualFile virtualFile = (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])contentEntryArray), GenerateRoomMigrationAction::getTestDefaultTargetDirectory$lambda$6), GenerateRoomMigrationAction::getTestDefaultTargetDirectory$lambda$7), GenerateRoomMigrationAction::getTestDefaultTargetDirectory$lambda$8), arg_0 -> GenerateRoomMigrationAction.getTestDefaultTargetDirectory$lambda$9(testScopes, arg_0)));
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            psiDirectory = PsiManager.getInstance((Project)project).findDirectory(it);
        } else {
            psiDirectory = null;
        }
        return psiDirectory;
    }

    private final PsiPackage getDefaultTargetPackage(String databaseFullyQualifiedName, Project project) {
        String string = StringUtil.getPackageName((String)databaseFullyQualifiedName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
        String packageName = string;
        return JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
    }

    private final String getDatabaseClassFullyQualifiedName(Project project, Module module, VirtualFile schemaJsonFile) {
        if (!schemaJsonFile.getParent().isDirectory()) {
            return null;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(schemaJsonFile.getParent().getName(), module.getModuleWithDependenciesAndLibrariesScope(false));
        if (psiClass == null) {
            return null;
        }
        PsiClass databaseClass = psiClass;
        return databaseClass.getQualifiedName();
    }

    private static final void actionPerformed$lambda$1(Project $project, GenerateMigrationWizard $migrationWizard, String $databaseClassQualifiedName, DatabaseUpdate $databaseUpdate) {
        try {
            JavaMigrationClassGenerator javaMigrationClassGenerator = new JavaMigrationClassGenerator($project);
            PsiClass psiClass = javaMigrationClassGenerator.createMigrationClass($migrationWizard.getTargetPackage(), $migrationWizard.getMigrationClassDirectory(), $migrationWizard.getUserReviewedDatabaseUpdate());
            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"createMigrationClass(...)");
            PsiClass migrationClass = psiClass;
            CharSequence charSequence = migrationClass.getQualifiedName();
            if (!(charSequence == null || charSequence.length() == 0)) {
                JavaMigrationTestGenerator javaMigrationTestGenerator = new JavaMigrationTestGenerator($project);
                PsiPackage psiPackage = $migrationWizard.getTargetPackage();
                PsiDirectory psiDirectory = $migrationWizard.getMigrationTestDirectory();
                String string = migrationClass.getQualifiedName();
                Intrinsics.checkNotNull((Object)string);
                javaMigrationTestGenerator.createMigrationTest(psiPackage, psiDirectory, $databaseClassQualifiedName, string, $databaseUpdate.getPreviousVersion(), $databaseUpdate.getCurrentVersion());
            }
        }
        catch (Exception e) {
            Messages.showInfoMessage((Project)$project, (String)e.getMessage(), (String)"Failed to generate a migration");
        }
    }

    private static final Sequence getMigrationDefaultTargetDirectory$lambda$2(ContentEntry it) {
        List list = it.getSourceFolders((JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceFolders(...)");
        return CollectionsKt.asSequence((Iterable)list);
    }

    private static final boolean getMigrationDefaultTargetDirectory$lambda$3(SourceFolder it) {
        return JavaProjectRootsUtil.isForGeneratedSources((SourceFolder)it);
    }

    private static final VirtualFile getMigrationDefaultTargetDirectory$lambda$4(SourceFolder it) {
        return it.getFile();
    }

    private static final Sequence getTestDefaultTargetDirectory$lambda$6(ContentEntry it) {
        List list = it.getSourceFolders((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceFolders(...)");
        return CollectionsKt.asSequence((Iterable)list);
    }

    private static final boolean getTestDefaultTargetDirectory$lambda$7(SourceFolder it) {
        return JavaProjectRootsUtil.isForGeneratedSources((SourceFolder)it);
    }

    private static final VirtualFile getTestDefaultTargetDirectory$lambda$8(SourceFolder it) {
        return it.getFile();
    }

    private static final boolean getTestDefaultTargetDirectory$lambda$9(TestArtifactSearchScopes $testScopes, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TestArtifactSearchScopes testArtifactSearchScopes = $testScopes;
        return testArtifactSearchScopes != null ? testArtifactSearchScopes.isAndroidTestSource(it) : true;
    }
}

