/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit.desugaring;

import com.android.tools.idea.run.deployment.liveedit.LiveEditLogger;
import com.android.tools.idea.run.deployment.liveedit.desugaring.R8Utils;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.origin.ArchiveEntryOrigin;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.zipflinger.ZipMap;
import com.android.zipflinger.ZipRepo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001eH\u0016J\u0014\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010\"\u001a\u00020\u001c2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/run/deployment/liveedit/desugaring/JarResourceCacheEntry;", "Lcom/android/tools/r8/ClassFileResourceProvider;", "path", "Ljava/nio/file/Path;", "logger", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditLogger;", "<init>", "(Ljava/nio/file/Path;Lcom/android/tools/idea/run/deployment/liveedit/LiveEditLogger;)V", "getPath", "()Ljava/nio/file/Path;", "getLogger", "()Lcom/android/tools/idea/run/deployment/liveedit/LiveEditLogger;", "origin", "Lcom/android/tools/r8/origin/PathOrigin;", "descriptorNames", "", "", "zipMap", "Lcom/android/zipflinger/ZipMap;", "kotlin.jvm.PlatformType", "repo", "Lcom/android/zipflinger/ZipRepo;", "lastModified", "Ljava/nio/file/attribute/FileTime;", "isMapValid", "", "isMapValid$intellij_android_core", "ensureOpen", "", "getClassDescriptors", "", "getProgramResource", "Lcom/android/tools/r8/ProgramResource;", "descriptor", "finished", "handler", "Lcom/android/tools/r8/DiagnosticsHandler;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nJarResourceCacheEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JarResourceCacheEntry.kt\ncom/android/tools/idea/run/deployment/liveedit/desugaring/JarResourceCacheEntry\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,86:1\n216#2,2:87\n*S KotlinDebug\n*F\n+ 1 JarResourceCacheEntry.kt\ncom/android/tools/idea/run/deployment/liveedit/desugaring/JarResourceCacheEntry\n*L\n45#1:87,2\n*E\n"})
public final class JarResourceCacheEntry
implements ClassFileResourceProvider {
    @NotNull
    private final Path path;
    @NotNull
    private final LiveEditLogger logger;
    @NotNull
    private final PathOrigin origin;
    @NotNull
    private final Map<String, String> descriptorNames;
    private final ZipMap zipMap;
    @NotNull
    private ZipRepo repo;
    @NotNull
    private final FileTime lastModified;

    public JarResourceCacheEntry(@NotNull Path path, @NotNull LiveEditLogger logger) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.path = path;
        this.logger = logger;
        this.origin = new PathOrigin(this.path);
        this.descriptorNames = new LinkedHashMap();
        this.zipMap = ZipMap.from((Path)this.path);
        this.repo = new ZipRepo(this.zipMap);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        FileTime fileTime = Files.getLastModifiedTime(this.path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
        this.lastModified = fileTime;
        Map map2 = this.zipMap.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEntries(...)");
        Map $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNull(k);
            String name2 = (String)k;
            if (!R8Utils.INSTANCE.isClassFile$intellij_android_core(name2)) continue;
            this.descriptorNames.put(R8Utils.INSTANCE.guessTypeDescriptor$intellij_android_core(name2), name2);
        }
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final LiveEditLogger getLogger() {
        return this.logger;
    }

    public final boolean isMapValid$intellij_android_core() {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        FileTime fileTime = Files.getLastModifiedTime(this.path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
        return Intrinsics.areEqual((Object)this.lastModified, (Object)fileTime);
    }

    private final void ensureOpen() {
        if (this.repo.isOpen()) {
            return;
        }
        this.repo = new ZipRepo(this.zipMap);
    }

    @NotNull
    public Set<String> getClassDescriptors() {
        this.ensureOpen();
        return this.descriptorNames.keySet();
    }

    @Nullable
    public ProgramResource getProgramResource(@Nullable String descriptor2) {
        if (!this.descriptorNames.containsKey(descriptor2)) {
            return null;
        }
        this.ensureOpen();
        String string = this.descriptorNames.get(descriptor2);
        Intrinsics.checkNotNull((Object)string);
        String name2 = string;
        byte[] bytes = this.repo.getContent(name2).array();
        return ProgramResource.fromBytes((Origin)((Origin)new ArchiveEntryOrigin(name2, (Origin)this.origin)), (ProgramResource.Kind)ProgramResource.Kind.CF, (byte[])bytes, (Set)SetsKt.setOf((Object)descriptor2));
    }

    public void finished(@Nullable DiagnosticsHandler handler2) {
        super.finished(handler2);
        this.repo.close();
    }
}

