/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.run.editor.AndroidTestExtraParam;
import com.android.tools.idea.run.editor.AndroidTestExtraParamKt;
import com.android.tools.idea.run.editor.AndroidTestExtraParamSource;
import com.android.tools.idea.run.editor.AndroidTestExtraParamsTable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTestExtraParamsDialog
extends DialogWrapper {
    private JPanel myContentPanel;
    private JPanel myUserExtraParamsTablePanel;
    private JPanel myGradleExtraParamsTablePanel;
    private final AndroidTestExtraParamsTable myUserParamsTable;
    private final AndroidTestExtraParamsTable myGradleParamsTable;
    private final ListenerManager myListenerManager = new ListenerManager();

    public AndroidTestExtraParamsDialog(@NotNull Project project, @Nullable AndroidFacet androidFacet, @NotNull String instrumentationExtraParams) {
        super(project);
        this.setupUI();
        this.init();
        this.setTitle("Instrumentation Extra Params");
        Collection<AndroidTestExtraParam> params2 = AndroidTestExtraParamKt.merge(AndroidTestExtraParamKt.getAndroidTestExtraParams(androidFacet), AndroidTestExtraParam.parseFromString(instrumentationExtraParams));
        this.myUserParamsTable = new AndroidTestExtraParamsTable(true, false);
        this.myUserParamsTable.setValues(params2.stream().filter(p -> p.getORIGINAL_VALUE_SOURCE() == AndroidTestExtraParamSource.NONE).collect(Collectors.toList()));
        this.myUserExtraParamsTablePanel.add(this.myUserParamsTable.getComponent());
        this.myGradleParamsTable = new AndroidTestExtraParamsTable(false, true);
        this.myGradleParamsTable.setValues(params2.stream().filter(p -> p.getORIGINAL_VALUE_SOURCE() == AndroidTestExtraParamSource.GRADLE).collect(Collectors.toList()));
        this.myGradleExtraParamsTablePanel.add(this.myGradleParamsTable.getComponent());
        this.myGradleParamsTable.setEnabled();
    }

    protected void dispose() {
        super.dispose();
        this.myListenerManager.releaseAll();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    public String getInstrumentationExtraParams() {
        return AndroidTestExtraParamKt.merge((Sequence<AndroidTestExtraParam>)SequencesKt.asSequence(this.myGradleParamsTable.getTableView().getItems().iterator()), (Sequence<AndroidTestExtraParam>)SequencesKt.asSequence(this.myUserParamsTable.getTableView().getItems().iterator())).stream().filter(p -> !p.getNAME().isEmpty()).map(p -> String.format("-e %s %s", p.getNAME(), p.getVALUE())).collect(Collectors.joining(" "));
    }

    public String getUserModifiedInstrumentationExtraParams() {
        return AndroidTestExtraParamKt.merge((Sequence<AndroidTestExtraParam>)SequencesKt.asSequence(this.myGradleParamsTable.getTableView().getItems().iterator()), (Sequence<AndroidTestExtraParam>)SequencesKt.asSequence(this.myUserParamsTable.getTableView().getItems().iterator())).stream().filter(p -> {
            if (p.getNAME().isEmpty()) {
                return false;
            }
            if (p.getORIGINAL_VALUE_SOURCE() == AndroidTestExtraParamSource.NONE) {
                return true;
            }
            return !Objects.equals(p.getVALUE(), p.getORIGINAL_VALUE());
        }).map(p -> String.format("-e %s %s", p.getNAME(), p.getVALUE())).collect(Collectors.joining(" "));
    }

    private void setupUI() {
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myContentPanel.add((Component)panel1, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setHorizontalTextPosition(11);
        jBLabel1.setText("Instrumentation Extra Params:");
        panel1.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        this.myUserExtraParamsTablePanel = new JPanel();
        this.myUserExtraParamsTablePanel.setLayout(new BorderLayout(0, 0));
        panel1.add((Component)this.myUserExtraParamsTablePanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myGradleExtraParamsTablePanel = new JPanel();
        this.myGradleExtraParamsTablePanel.setLayout(new BorderLayout(0, 0));
        this.myContentPanel.add((Component)this.myGradleExtraParamsTablePanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
    }
}

