/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.adblib.AdbSession;
import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.IDevice;
import com.android.ide.common.build.BaselineProfileDetails;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstaller;
import com.android.tools.deployer.ChangeType;
import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DeployerOption;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.MetricsRecorder;
import com.android.tools.deployer.UIService;
import com.android.tools.deployer.model.App;
import com.android.tools.deployer.model.BaselineProfile;
import com.android.tools.deployer.model.component.ApkParserException;
import com.android.tools.deployer.tasks.Canceller;
import com.android.tools.idea.adblib.AdbLibService;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.DeploymentService;
import com.android.tools.idea.run.IdeService;
import com.android.tools.idea.util.LocalInstallerPathManager;
import com.android.utils.ILogger;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ApplyChangesAgentError;
import com.google.wireless.android.sdk.stats.LaunchTaskDetail;
import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDeployTask {
    public static final int MIN_API_VERSION = 26;
    public static final Logger LOG = Logger.getInstance(AbstractDeployTask.class);
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Deploy");
    private static final Map<StudioFlags.OptimisticInstallSupportLevel, EnumSet<ChangeType>> OPTIMISTIC_INSTALL_SUPPORT = ImmutableMap.of((Object)StudioFlags.OptimisticInstallSupportLevel.DISABLED, EnumSet.noneOf(ChangeType.class), (Object)StudioFlags.OptimisticInstallSupportLevel.DEX, EnumSet.of(ChangeType.DEX), (Object)StudioFlags.OptimisticInstallSupportLevel.DEX_AND_NATIVE, EnumSet.of(ChangeType.DEX, ChangeType.NATIVE_LIBRARY), (Object)StudioFlags.OptimisticInstallSupportLevel.DEX_AND_NATIVE_AND_RESOURCES, EnumSet.of(ChangeType.DEX, ChangeType.NATIVE_LIBRARY, ChangeType.RESOURCE));
    protected final boolean myRerunOnSwapFailure;
    protected final boolean myAlwaysInstallWithPm;
    protected final boolean myAllowAssumeVerified;
    protected final boolean myHasMakeBeforeRun;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Collection<ApkInfo> myPackages;
    @NotNull
    protected List<LaunchTaskDetail> mySubTaskDetails;

    public AbstractDeployTask(@NotNull Project project, @NotNull Collection<ApkInfo> packages, boolean rerunOnSwapFailure, boolean alwaysInstallWithPm, boolean allowAssumeVerified, boolean hasMakeBeforeRun) {
        this.myProject = project;
        this.myPackages = packages;
        this.myRerunOnSwapFailure = rerunOnSwapFailure;
        this.myAlwaysInstallWithPm = alwaysInstallWithPm;
        this.myAllowAssumeVerified = allowAssumeVerified;
        this.myHasMakeBeforeRun = hasMakeBeforeRun;
        this.mySubTaskDetails = new ArrayList<LaunchTaskDetail>();
    }

    public List<Deployer.Result> run(@NotNull IDevice device2, final ProgressIndicator indicator) throws DeployerException {
        Canceller canceller = new Canceller(){

            public boolean cancelled() {
                return indicator.isCanceled();
            }
        };
        LogWrapper logger = new LogWrapper(LOG);
        Stopwatch stopwatch = Stopwatch.createStarted();
        MetricsRecorder metrics = new MetricsRecorder();
        long vmClockStartNs = System.nanoTime();
        long wallClockStartMs = System.currentTimeMillis();
        AdbSession adbSession = null;
        if (((Boolean)StudioFlags.INSTALL_WITH_ADBLIB.get()).booleanValue()) {
            adbSession = AdbLibService.getSession(this.myProject);
        }
        AdbClient adb = new AdbClient(device2, (ILogger)logger, adbSession);
        AdbHelper.setAbbExecAllowed((boolean)((Boolean)StudioFlags.DDMLIB_ABB_EXEC_INSTALL_ENABLE.get()));
        AdbInstaller.Mode adbInstallerMode = AdbInstaller.Mode.DAEMON;
        if (!((Boolean)StudioFlags.APPLY_CHANGES_KEEP_CONNECTION_ALIVE.get()).booleanValue()) {
            adbInstallerMode = AdbInstaller.Mode.ONE_SHOT;
        }
        AdbInstaller installer = new AdbInstaller(LocalInstallerPathManager.getLocalInstaller(), adb, (Collection)metrics.getDeployMetrics(), (ILogger)logger, adbInstallerMode);
        DeploymentService service = DeploymentService.getInstance();
        IdeService ideService = new IdeService(this.myProject);
        EnumSet<ChangeType> optimisticInstallSupport = EnumSet.noneOf(ChangeType.class);
        if (!this.myAlwaysInstallWithPm) {
            optimisticInstallSupport = OPTIMISTIC_INSTALL_SUPPORT.getOrDefault(StudioFlags.OPTIMISTIC_INSTALL_SUPPORT_LEVEL.get(), EnumSet.noneOf(ChangeType.class));
        }
        DeployerOption option = new DeployerOption.Builder().setUseOptimisticSwap(((Boolean)StudioFlags.APPLY_CHANGES_OPTIMISTIC_SWAP.get()).booleanValue()).setUseOptimisticResourceSwap(((Boolean)StudioFlags.APPLY_CHANGES_OPTIMISTIC_RESOURCE_SWAP.get()).booleanValue()).setOptimisticInstallSupport(optimisticInstallSupport).setAllowAssumeVerified(this.myAllowAssumeVerified).setUseStructuralRedefinition(((Boolean)StudioFlags.APPLY_CHANGES_STRUCTURAL_DEFINITION.get()).booleanValue()).setUseVariableReinitialization(((Boolean)StudioFlags.APPLY_CHANGES_VARIABLE_REINITIALIZATION.get()).booleanValue()).setFastRestartOnSwapFail(this.getFastRerunOnSwapFailure()).enableCoroutineDebugger(((Boolean)StudioFlags.COROUTINE_DEBUGGER_ENABLE.get()).booleanValue()).setMaxDeltaInstallPatchSize(((Integer)StudioFlags.DELTA_INSTALL_CUSTOM_MAX_PATCH_SIZE.get()).intValue()).build();
        Deployer deployer = new Deployer(adb, service.getDeploymentCacheDatabase(), service.getDexDatabase(), service.getTaskRunner(), (Installer)installer, (UIService)ideService, metrics, (ILogger)logger, option);
        ArrayList<String> idsSkippedInstall = new ArrayList<String>();
        ArrayList<Deployer.Result> results2 = new ArrayList<Deployer.Result>();
        for (ApkInfo apkInfo : this.myPackages) {
            Deployer.Result result2 = this.perform(device2, deployer, apkInfo, canceller);
            if (result2.skippedInstall) {
                idsSkippedInstall.add(apkInfo.getApplicationId());
            }
            results2.add(result2);
        }
        this.addSubTaskDetails(metrics.getDeployMetrics(), vmClockStartNs, wallClockStartMs);
        this.logAgentFailures(metrics.getAgentFailures());
        stopwatch.stop();
        long duration = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        String informMake = this.myHasMakeBeforeRun ? "" : " with no build tasks before launch";
        Notification notification = null;
        if (idsSkippedInstall.isEmpty()) {
            String content2 = String.format("%s successfully finished in %s%s", this.getDescription(), StringUtil.formatDuration((long)duration), informMake);
            notification = NOTIFICATION_GROUP.createNotification(content2, this.myHasMakeBeforeRun ? NotificationType.INFORMATION : NotificationType.WARNING);
        } else {
            String title2 = String.format("%s successfully finished in %s%s", this.getDescription(), StringUtil.formatDuration((long)duration), informMake);
            String content3 = this.createSkippedApkInstallMessage(idsSkippedInstall, idsSkippedInstall.size() == this.myPackages.size());
            notification = NOTIFICATION_GROUP.createNotification(title2, content3, this.myHasMakeBeforeRun ? NotificationType.INFORMATION : NotificationType.WARNING);
        }
        if (!this.myHasMakeBeforeRun) {
            notification.addAction((AnAction)new BrowseNotificationAction("Learn more about missing build tasks", "https://d.android.com/r/studio-ui/run-no-gradle-make"));
        }
        notification.notify(this.myProject);
        return results2;
    }

    protected abstract String getDescription();

    protected abstract Deployer.Result perform(IDevice var1, Deployer var2, @NotNull ApkInfo var3, @NotNull Canceller var4) throws DeployerException;

    @NotNull
    protected Project getProject() {
        return this.myProject;
    }

    final boolean getFastRerunOnSwapFailure() {
        return this.myRerunOnSwapFailure;
    }

    private void addSubTaskDetails(@NotNull Collection<DeployMetric> metrics, long startNanoTime, long startWallClockMs) {
        for (DeployMetric metric : metrics) {
            if (metric.getName().isEmpty()) continue;
            LaunchTaskDetail.Builder detail = LaunchTaskDetail.newBuilder();
            long startOffsetMs = TimeUnit.NANOSECONDS.toMillis(metric.getStartTimeNs() - startNanoTime);
            long endOffsetMs = TimeUnit.NANOSECONDS.toMillis(metric.getEndTimeNs() - startNanoTime);
            detail.setId(this.getId() + "." + metric.getName()).setStartTimestampMs(startWallClockMs + startOffsetMs).setEndTimestampMs(startWallClockMs + endOffsetMs).setTid((int)metric.getThreadId());
            if (metric.hasStatus()) {
                detail.setStatus(metric.getStatus());
            }
            this.mySubTaskDetails.add(detail.build());
        }
    }

    public abstract String getId();

    private void logAgentFailures(List<Deploy.AgentExceptionLog> agentExceptionLogs) {
        for (Deploy.AgentExceptionLog log : agentExceptionLogs) {
            UsageTracker.log((AndroidStudioEvent.Builder)AbstractDeployTask.toStudioEvent(log));
        }
    }

    @NotNull
    public Collection<LaunchTaskDetail> getSubTaskDetails() {
        return this.mySubTaskDetails;
    }

    protected abstract String createSkippedApkInstallMessage(List<String> var1, boolean var2);

    @NotNull
    public Collection<ApkInfo> getApkInfos() {
        return this.myPackages;
    }

    public static App getAppToInstall(@NotNull ApkInfo apkInfo) throws DeployerException {
        List paths = apkInfo.getFiles().stream().map(ApkFileUnit::getApkPath).collect(Collectors.toList());
        List<BaselineProfile> baselineProfiles = AbstractDeployTask.convertBaseLinesProfiles(apkInfo.getBaselineProfiles());
        try {
            return App.fromPaths((String)apkInfo.getApplicationId(), paths, baselineProfiles);
        }
        catch (ApkParserException e) {
            throw DeployerException.parseFailed((String)e.getMessage());
        }
    }

    private static List<BaselineProfile> convertBaseLinesProfiles(List<BaselineProfileDetails> profiles2) {
        return profiles2.stream().map(p -> new BaselineProfile(p.getMinApi(), p.getMaxApi(), p.getBaselineProfileFiles().stream().map(File::toPath).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    private static AndroidStudioEvent.Builder toStudioEvent(Deploy.AgentExceptionLog log) {
        ApplyChangesAgentError.AgentPurpose purpose = ApplyChangesAgentError.AgentPurpose.forNumber((int)log.getAgentPurposeValue());
        ApplyChangesAgentError.Builder builder = ApplyChangesAgentError.newBuilder().setEventTimeMs(TimeUnit.MILLISECONDS.convert(log.getEventTimeNs(), TimeUnit.NANOSECONDS)).setAgentAttachTimeMs(TimeUnit.MILLISECONDS.convert(log.getAgentAttachTimeNs(), TimeUnit.NANOSECONDS)).setAgentAttachCount(log.getAgentAttachCount()).setAgentPurpose(purpose);
        log.getFailedClassesList().stream().map(ApplyChangesAgentError.TargetClass::valueOf).forEach(arg_0 -> ((ApplyChangesAgentError.Builder)builder).addTargetClasses(arg_0));
        return AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.DEPLOYMENT).setKind(AndroidStudioEvent.EventKind.APPLY_CHANGES_AGENT_ERROR).setApplyChangesAgentError(builder);
    }
}

