/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.tools.idea.io.FilePaths;
import com.android.tools.sdk.SdkPaths;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectSdkDialog
extends DialogWrapper {
    private JPanel myPanel;
    private TextFieldWithBrowseButton myJdkTextFieldWithButton;
    private TextFieldWithBrowseButton mySdkTextFieldWithButton;
    private JBLabel mySelectSdkDescriptionLabel;
    private HyperlinkLabel mySdkHyperlinkLabel;
    private JBLabel mySelectSdkLabel;
    private JBLabel mySelectJdkDescriptionLabel;
    private HyperlinkLabel myJdkHyperlinkLabel;
    private JBLabel mySelectJdkLabel;
    private JBLabel mySpacer;
    private String myJdkHome = "";
    private String mySdkHome = "";

    public SelectSdkDialog(@Nullable String jdkPath, @Nullable String sdkPath) {
        super(false);
        String err;
        this.setupUI();
        this.init();
        this.setTitle("Select SDKs");
        if (jdkPath != null && (err = SelectSdkDialog.validateJdkPath(jdkPath)) != null) {
            jdkPath = null;
        }
        if (sdkPath != null && (err = SelectSdkDialog.validateAndroidSdkPath(sdkPath)) != null) {
            sdkPath = null;
        }
        this.mySelectJdkLabel.setLabelFor((Component)this.myJdkTextFieldWithButton.getTextField());
        this.mySelectSdkDescriptionLabel.setText("Please provide the path to the Android SDK.");
        this.mySdkHyperlinkLabel.setHyperlinkTarget("http://d.android.com/sdk");
        this.mySdkHyperlinkLabel.setHyperlinkText("If you do not have the Android SDK, you can obtain it from ", "d.android.com/sdk", ".");
        this.mySelectJdkDescriptionLabel.setText("Please provide the path to a Java Development Kit (JDK) installation.");
        this.myJdkHyperlinkLabel.setHyperlinkTarget("http://www.oracle.com/technetwork/java/javase/downloads/index.html");
        this.myJdkHyperlinkLabel.setHyperlinkText("If you do not have a JDK installed, you can obtain one ", "here", ".");
        if (jdkPath == null && sdkPath == null) {
            this.mySpacer.setVisible(true);
        } else if (jdkPath == null) {
            this.mySpacer.setVisible(false);
            this.mySelectSdkDescriptionLabel.setVisible(false);
            this.mySdkHyperlinkLabel.setVisible(false);
            this.mySelectSdkLabel.setVisible(false);
            this.mySdkTextFieldWithButton.setVisible(false);
        } else {
            this.mySpacer.setVisible(false);
            this.mySelectJdkDescriptionLabel.setVisible(false);
            this.myJdkHyperlinkLabel.setVisible(false);
            this.mySelectJdkLabel.setVisible(false);
            this.myJdkTextFieldWithButton.setVisible(false);
        }
        this.myJdkTextFieldWithButton.setTextFieldPreferredWidth(50);
        this.mySdkTextFieldWithButton.setTextFieldPreferredWidth(50);
        if (jdkPath != null) {
            this.myJdkTextFieldWithButton.setText(jdkPath);
        }
        if (sdkPath != null) {
            this.mySdkTextFieldWithButton.setText(sdkPath);
        }
        FileChooserDescriptor descriptor2 = JavaSdk.getInstance().getHomeChooserDescriptor();
        BrowseFolderListener listener2 = new BrowseFolderListener("Select JDK Home", (ComponentWithBrowseButton<JTextField>)this.myJdkTextFieldWithButton, descriptor2, jdkPath);
        this.myJdkTextFieldWithButton.addActionListener((ActionListener)((Object)listener2));
        descriptor2 = AndroidSdkType.getInstance().getHomeChooserDescriptor();
        listener2 = new BrowseFolderListener("Select Android SDK Home", (ComponentWithBrowseButton<JTextField>)this.mySdkTextFieldWithButton, descriptor2, sdkPath);
        this.mySdkTextFieldWithButton.addActionListener((ActionListener)((Object)listener2));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String jdkHome = this.myJdkTextFieldWithButton.getText().trim();
        String jdkError = SelectSdkDialog.validateJdkPath(jdkHome);
        if (jdkError != null) {
            return new ValidationInfo(jdkError, (JComponent)this.myJdkTextFieldWithButton.getTextField());
        }
        String androidHome = this.mySdkTextFieldWithButton.getText().trim();
        String sdkError = SelectSdkDialog.validateAndroidSdkPath(androidHome);
        if (sdkError != null) {
            return new ValidationInfo(sdkError, (JComponent)this.mySdkTextFieldWithButton.getTextField());
        }
        return null;
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.mySelectSdkLabel = new JBLabel();
        this.mySelectSdkLabel.setText("Select Android SDK:");
        this.myPanel.add((Component)this.mySelectSdkLabel, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.mySdkTextFieldWithButton = new TextFieldWithBrowseButton();
        this.myPanel.add((Component)this.mySdkTextFieldWithButton, new GridConstraints(2, 1, 1, 1, 0, 1, 4, 0, new Dimension(300, -1), null, null, 0, false));
        this.mySelectSdkDescriptionLabel = new JBLabel();
        this.mySelectSdkDescriptionLabel.setText("");
        this.myPanel.add((Component)this.mySelectSdkDescriptionLabel, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 0, null, null, null, 0, false));
        this.mySdkHyperlinkLabel = new HyperlinkLabel();
        this.myPanel.add((Component)this.mySdkHyperlinkLabel, new GridConstraints(1, 0, 1, 2, 0, 1, 0, 0, null, null, null, 0, false));
        this.mySelectJdkLabel = new JBLabel();
        this.mySelectJdkLabel.setText("Select Java JDK:");
        this.myPanel.add((Component)this.mySelectJdkLabel, new GridConstraints(6, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.myJdkTextFieldWithButton = new TextFieldWithBrowseButton();
        this.myPanel.add((Component)this.myJdkTextFieldWithButton, new GridConstraints(6, 1, 1, 1, 0, 1, 4, 0, new Dimension(300, -1), null, null, 0, false));
        this.mySelectJdkDescriptionLabel = new JBLabel();
        this.myPanel.add((Component)this.mySelectJdkDescriptionLabel, new GridConstraints(4, 0, 1, 2, 0, 1, 0, 0, null, null, null, 0, false));
        this.myJdkHyperlinkLabel = new HyperlinkLabel();
        this.myPanel.add((Component)this.myJdkHyperlinkLabel, new GridConstraints(5, 0, 1, 2, 0, 1, 0, 0, null, null, null, 0, false));
        this.mySpacer = new JBLabel();
        this.mySpacer.setText(" ");
        this.myPanel.add((Component)this.mySpacer, new GridConstraints(3, 0, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
    }

    public JComponent getRootComponent() {
        return this.myPanel;
    }

    @Nullable
    private static String validateJdkPath(@Nullable String path) {
        if (StringUtil.isEmpty((String)path) || !JavaSdk.getInstance().isValidSdkHome(path)) {
            return "Invalid JDK path.";
        }
        return null;
    }

    @Nullable
    private static String validateAndroidSdkPath(@Nullable String path) {
        if (StringUtil.isEmpty((String)path)) {
            return "Android SDK path not specified.";
        }
        SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidSdk(FilePaths.stringToFile((String)path), false);
        if (!validationResult.success) {
            return String.format("Invalid Android SDK path:<br>%1$s", validationResult.message);
        }
        return null;
    }

    protected void doOKAction() {
        this.myJdkHome = this.myJdkTextFieldWithButton.getText();
        this.mySdkHome = this.mySdkTextFieldWithButton.getText();
        super.doOKAction();
    }

    @NotNull
    public String getJdkHome() {
        return this.myJdkHome;
    }

    @NotNull
    public String getAndroidHome() {
        return this.mySdkHome;
    }

    private static class BrowseFolderListener
    extends ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> {
        private final String myDefaultPath;

        public BrowseFolderListener(@Nullable String title2, ComponentWithBrowseButton<JTextField> textField2, FileChooserDescriptor fileChooserDescriptor, @Nullable String defaultPath) {
            super(title2, null, textField2, null, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
            this.myDefaultPath = defaultPath;
        }

        @Nullable
        protected VirtualFile getInitialFile() {
            String dir = super.getComponentText();
            if (!dir.isEmpty()) {
                return super.getInitialFile();
            }
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            return fileSystem.findFileByPath(FileUtil.toSystemIndependentName((String)(this.myDefaultPath == null ? PathManager.getHomePath() : this.myDefaultPath)));
        }
    }
}

