/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.sources;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidApiLevel;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.editors.AttachAndroidSdkSourcesNotificationProvider;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.SdkInstallListener;
import com.android.tools.idea.sdk.sources.SdkSourceFinderForApiLevelKt;
import com.intellij.debugger.SourcePosition;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.util.messages.MessageBus;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0011H\u0002J\b\u0010\u001b\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/sdk/sources/SdkSourceFinderForApiLevel;", "", "project", "Lcom/intellij/openapi/project/Project;", "apiLevel", "Lcom/android/sdklib/AndroidApiLevel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/sdklib/AndroidApiLevel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "missingSourcesFile", "Lcom/intellij/psi/PsiFile;", "getMissingSourcesFile", "()Lcom/intellij/psi/PsiFile;", "missingSourcesFile$delegate", "Lkotlin/Lazy;", "getSourcePosition", "Lcom/intellij/debugger/SourcePosition;", "file", "lineNumber", "", "getSourceFileForApiLevel", "getRelPathForJavaSource", "", "createSourcePackageForApiLevel", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPositionForMissingSources", "createMissingSourcesFile", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nSdkSourceFinderForApiLevel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkSourceFinderForApiLevel.kt\ncom/android/tools/idea/sdk/sources/SdkSourceFinderForApiLevel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n25#2:198\n25#2:199\n25#2:200\n25#2:201\n1#3:202\n*S KotlinDebug\n*F\n+ 1 SdkSourceFinderForApiLevel.kt\ncom/android/tools/idea/sdk/sources/SdkSourceFinderForApiLevel\n*L\n76#1:198\n84#1:199\n107#1:200\n140#1:201\n*E\n"})
public final class SdkSourceFinderForApiLevel {
    @NotNull
    private final Project project;
    @NotNull
    private final AndroidApiLevel apiLevel;
    @NotNull
    private final Lazy missingSourcesFile$delegate;

    public SdkSourceFinderForApiLevel(@NotNull Project project, @NotNull AndroidApiLevel apiLevel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)apiLevel, (String)"apiLevel");
        this.project = project;
        this.apiLevel = apiLevel;
        this.missingSourcesFile$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, () -> SdkSourceFinderForApiLevel.missingSourcesFile_delegate$lambda$0(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final PsiFile getMissingSourcesFile() {
        Lazy lazy = this.missingSourcesFile$delegate;
        return (PsiFile)lazy.getValue();
    }

    @NotNull
    public final SourcePosition getSourcePosition(@NotNull PsiFile file, int lineNumber) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        SourcePosition sourcePosition = this.getSourceFileForApiLevel(file, lineNumber);
        if (sourcePosition == null) {
            sourcePosition = this.getPositionForMissingSources();
        }
        return sourcePosition;
    }

    private final SourcePosition getSourceFileForApiLevel(PsiFile file, int lineNumber) {
        String relPath = this.getRelPathForJavaSource(file);
        if (relPath == null) {
            SdkSourceFinderForApiLevel $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SdkSourceFinderForApiLevel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("getApiSpecificPsi returned null because relPath is null for file: " + file.getName());
            return null;
        }
        VirtualFile virtualFile = this.createSourcePackageForApiLevel();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile sourceFolder = virtualFile;
        VirtualFile virtualFile2 = sourceFolder.findFileByRelativePath(relPath);
        if (virtualFile2 == null) {
            SdkSourceFinderForApiLevel $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SdkSourceFinderForApiLevel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("getSourceForApiLevel returned null because " + relPath + " is not present in " + sourceFolder);
            return null;
        }
        PsiFile psiFile = (PsiFile)ActionsKt.runReadAction(() -> SdkSourceFinderForApiLevel.getSourceFileForApiLevel$lambda$1(this, virtualFile2));
        if (psiFile == null) {
            return null;
        }
        PsiFile apiSpecificSourceFile = psiFile;
        return SourcePosition.createFromLine((PsiFile)apiSpecificSourceFile, (int)lineNumber);
    }

    private final String getRelPathForJavaSource(PsiFile file) {
        String string;
        FileType fileType = file.getFileType();
        if (Intrinsics.areEqual((Object)fileType, (Object)JavaFileType.INSTANCE)) {
            VirtualFile sourceRoot = (VirtualFile)ActionsKt.runReadAction(() -> SdkSourceFinderForApiLevel.getRelPathForJavaSource$lambda$2(this, file));
            if (sourceRoot == null) {
                SdkSourceFinderForApiLevel $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(SdkSourceFinderForApiLevel.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Could not determine source root for file: " + file.getVirtualFile().getPath());
                string = null;
            } else {
                string = VfsUtilCore.getRelativePath((VirtualFile)file.getVirtualFile(), (VirtualFile)sourceRoot);
            }
        } else if (Intrinsics.areEqual((Object)fileType, (Object)JavaClassFileType.INSTANCE)) {
            String relativeClassPath;
            VirtualFile virtualFile = file.getVirtualFile();
            String string2 = relativeClassPath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)VfsUtilCore.getRootFile((VirtualFile)virtualFile));
            string = string2 != null ? SdkSourceFinderForApiLevelKt.changeClassExtensionToJava(string2) : null;
        } else {
            string = null;
        }
        return string;
    }

    private final VirtualFile createSourcePackageForApiLevel() {
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"tryToChooseSdkHandler(...)");
        AndroidSdkHandler sdkHandler = androidSdkHandler;
        RepoManager sdkManager = sdkHandler.getRepoManagerAndLoadSynchronously((ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
        for (LocalPackage sourcePackage : sdkManager.getPackages().getLocalPackagesForPrefix("sources")) {
            VirtualFile sourceFolder;
            TypeDetails typeDetails = sourcePackage.getTypeDetails();
            if (!(typeDetails instanceof DetailsTypes.ApiDetailsType)) {
                SdkSourceFinderForApiLevel $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(SdkSourceFinderForApiLevel.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Unable to get type details for source package @ " + sourcePackage.getLocation());
                continue;
            }
            if (!Intrinsics.areEqual((Object)this.apiLevel, (Object)((DetailsTypes.ApiDetailsType)typeDetails).getAndroidVersion().getAndroidApiLevel())) continue;
            VirtualFile virtualFile = sourceFolder = VfsUtil.findFile((Path)sourcePackage.getLocation(), (boolean)true);
            boolean bl = virtualFile != null ? virtualFile.isValid() : false;
            if (!bl) continue;
            return sourceFolder;
        }
        return null;
    }

    private final SourcePosition getPositionForMissingSources() {
        SourcePosition sourcePosition = SourcePosition.createFromLine((PsiFile)this.getMissingSourcesFile(), (int)-1);
        Intrinsics.checkNotNullExpressionValue((Object)sourcePosition, (String)"createFromLine(...)");
        return sourcePosition;
    }

    private final PsiFile createMissingSourcesFile() {
        Object object = Locale.getDefault();
        Object[] objectArray = SdkSourceFinderForApiLevelKt.access$getMissingSourcesFileContentsFormat$p();
        Object object2 = new Object[]{this.apiLevel};
        String string = String.format((Locale)object, (String)objectArray, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        String content2 = string;
        object = "android-%s/UnavailableSource";
        objectArray = new Object[]{this.apiLevel};
        String string2 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String name2 = string2;
        PsiFile psiFile = (PsiFile)ActionsKt.runReadAction(() -> SdkSourceFinderForApiLevel.createMissingSourcesFile$lambda$3(this, name2, content2));
        VirtualFile file = psiFile.getVirtualFile();
        object2 = this;
        try {
            SdkSourceFinderForApiLevel $this$createMissingSourcesFile_u24lambda_u244 = (SdkSourceFinderForApiLevel)object2;
            boolean bl = false;
            file.setWritable(false);
            Object object3 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        MessageBus messageBus = this.project.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        MessageBus messageBus2 = messageBus;
        messageBus2.connect((Disposable)messageBus2).subscribe(SdkInstallListener.TOPIC, (arg_0, arg_1) -> SdkSourceFinderForApiLevel.createMissingSourcesFile$lambda$7(this, file, arg_0, arg_1));
        file.putUserData(AttachAndroidSdkSourcesNotificationProvider.REQUIRED_SOURCES_KEY, (Object)this.apiLevel);
        Intrinsics.checkNotNull((Object)psiFile);
        return psiFile;
    }

    private static final PsiFile missingSourcesFile_delegate$lambda$0(SdkSourceFinderForApiLevel this$0) {
        return this$0.createMissingSourcesFile();
    }

    private static final PsiFile getSourceFileForApiLevel$lambda$1(SdkSourceFinderForApiLevel this$0, VirtualFile $virtualFile) {
        return PsiManager.getInstance((Project)this$0.project).findFile($virtualFile);
    }

    private static final VirtualFile getRelPathForJavaSource$lambda$2(SdkSourceFinderForApiLevel this$0, PsiFile $file) {
        return ProjectFileIndex.getInstance((Project)this$0.project).getSourceRootForFile($file.getVirtualFile());
    }

    private static final PsiFile createMissingSourcesFile$lambda$3(SdkSourceFinderForApiLevel this$0, String $name, String $content) {
        return PsiFileFactory.getInstance((Project)this$0.project).createFileFromText($name, (Language)JavaLanguage.INSTANCE, (CharSequence)$content, true, true);
    }

    private static final Unit createMissingSourcesFile$lambda$7$lambda$6(SdkSourceFinderForApiLevel this$0, VirtualFile $file) {
        FileEditorManager.getInstance((Project)this$0.project).closeFile($file);
        return Unit.INSTANCE;
    }

    private static final void createMissingSourcesFile$lambda$7(SdkSourceFinderForApiLevel this$0, VirtualFile $file, Collection installed, Collection collection2) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)installed, (String)"installed");
            Intrinsics.checkNotNullParameter((Object)collection2, (String)"<unused var>");
            String path = DetailsTypes.getSourcesPath((AndroidVersion)new AndroidVersion(this$0.apiLevel));
            Iterable iterable = installed;
            for (Object t : iterable) {
                UpdatablePackage it = (UpdatablePackage)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPath(), (Object)path)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if (v0 != null && $file.isValid()) {
            ActionsKt.runInEdt$default(null, () -> SdkSourceFinderForApiLevel.createMissingSourcesFile$lambda$7$lambda$6(this$0, $file), (int)1, null);
        }
    }
}

