/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard.legacy;

import com.android.repository.api.Downloader;
import com.android.repository.api.License;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.wizard.AndroidSdkLicenseTemporaryData;
import com.android.tools.idea.welcome.wizard.FirstRunWizardTracker;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithDescription;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.wireless.android.sdk.stats.SetupWizardEvent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.treeStructure.Tree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class LicenseAgreementStep
extends DynamicWizardStepWithDescription {
    private final JTextPane myLicenseTextField;
    private final Tree myChangeTree;
    private final JRadioButton myDeclineRadioButton;
    private final JRadioButton myAcceptRadioButton;
    private DefaultTreeModel myTreeModel = new DefaultTreeModel(null);
    private final Map<String, Boolean> myAcceptances = Maps.newHashMap();
    private final Set<String> myVisibleLicenses = Sets.newHashSet();
    private String myCurrentLicense;
    private final Set<License> myLicenses = Sets.newHashSet();
    private final Supplier<List<String>> myInstallRequestsProvider;
    private final Supplier<AndroidSdkHandler> mySdkHandlerSupplier;
    @NotNull
    private final FirstRunWizardTracker myTracker;

    public LicenseAgreementStep(@NotNull Disposable parentDisposable, @NotNull Supplier<List<String>> installRequestsProvider, @NotNull Supplier<AndroidSdkHandler> sdkHandlerSupplier, @NotNull FirstRunWizardTracker tracker) {
        super(parentDisposable);
        this.myInstallRequestsProvider = installRequestsProvider;
        this.mySdkHandlerSupplier = sdkHandlerSupplier;
        this.myTracker = tracker;
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setHonorComponentsMinimumSize(true);
        this.myChangeTree = new Tree();
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myChangeTree));
        this.myLicenseTextField = new JTextPane();
        splitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myLicenseTextField));
        this.myDeclineRadioButton = new JBRadioButton("Decline");
        this.myAcceptRadioButton = new JBRadioButton("Accept");
        ButtonGroup optionsGroup = new ButtonGroup();
        optionsGroup.add(this.myDeclineRadioButton);
        optionsGroup.add(this.myAcceptRadioButton);
        JPanel optionsPanel = new JPanel(new FlowLayout(4));
        optionsPanel.add(this.myDeclineRadioButton);
        optionsPanel.add(this.myAcceptRadioButton);
        JPanel mainPanel2 = new JPanel(new BorderLayout());
        mainPanel2.add((Component)splitter, "Center");
        mainPanel2.add((Component)optionsPanel, "South");
        this.setBodyComponent(mainPanel2);
        this.initUI();
    }

    private void initUI() {
        this.myChangeTree.setModel((TreeModel)this.myTreeModel);
        this.myChangeTree.setShowsRootHandles(false);
        this.myLicenseTextField.setEditable(false);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.myDeclineRadioButton);
        group2.add(this.myAcceptRadioButton);
        this.myDeclineRadioButton.addActionListener(e -> {
            this.myAcceptances.put(this.myCurrentLicense, Boolean.FALSE);
            this.invokeUpdate(null);
            this.myChangeTree.repaint();
        });
        this.myAcceptRadioButton.addActionListener(e -> {
            this.myAcceptances.put(this.myCurrentLicense, Boolean.TRUE);
            this.invokeUpdate(null);
            this.myChangeTree.repaint();
        });
        this.myChangeTree.addTreeSelectionListener(e -> {
            DefaultMutableTreeNode selected = (DefaultMutableTreeNode)this.myChangeTree.getLastSelectedPathComponent();
            if (selected != null && selected.isRoot()) {
                return;
            }
            if (selected != null && !selected.isLeaf()) {
                License license = (License)selected.getUserObject();
                this.myLicenseTextField.setText(license.getValue());
                this.myCurrentLicense = license.getId();
            } else if (selected != null && !selected.isRoot()) {
                Change change = (Change)selected.getUserObject();
                this.myLicenseTextField.setText(change.license.getValue());
                this.myCurrentLicense = change.license.getId();
            }
            if (this.myAcceptances.get(this.myCurrentLicense).booleanValue()) {
                this.myAcceptRadioButton.setSelected(true);
            } else {
                this.myDeclineRadioButton.setSelected(true);
            }
            this.myLicenseTextField.setCaretPosition(0);
        });
        this.myChangeTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (row == 0) {
                    this.append("Licenses", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
                if (!leaf) {
                    License license = (License)node.getUserObject();
                    this.appendLicenseText(license, license.getId());
                } else {
                    Change change = (Change)node.getUserObject();
                    if (change == null) {
                        return;
                    }
                    this.appendLicenseText(change.license, change.toString());
                    this.setIcon(change.getIcon());
                }
            }

            private void appendLicenseText(@Nullable License license, String text2) {
                boolean notAccepted;
                boolean bl = notAccepted = license != null && LicenseAgreementStep.this.myAcceptances.get(license.getId()) == false;
                if (notAccepted) {
                    this.append("*", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    this.append(text2, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                } else {
                    this.append(text2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        });
        this.setChanges(this.createChangesList());
    }

    @Override
    public boolean isStepVisible() {
        return !this.myVisibleLicenses.isEmpty();
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        this.myTracker.trackStepShowing(SetupWizardEvent.WizardStep.WizardStepKind.LICENSE_AGREEMENT);
    }

    @Override
    public boolean validate() {
        for (String licenseRef : this.myVisibleLicenses) {
            if (this.myAcceptances.get(licenseRef).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String getStepName() {
        return "License Agreement";
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        return "License Agreement";
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return "Read and agree to the licenses for the components which will be installed";
    }

    private void expandTree() {
        for (int i = 0; i < this.myChangeTree.getRowCount(); ++i) {
            this.myChangeTree.expandRow(i);
        }
    }

    private List<Change> createChangesList() {
        this.myLicenses.clear();
        StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager sdkManager = this.mySdkHandlerSupplier.get().getRepoManager((ProgressIndicator)progress2);
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, null, null, (ProgressRunner)new StudioProgressRunner(false, "Finding Available SDK Components", null), (Downloader)new StudioDownloader(), StudioSettingsController.getInstance());
        Map remotePackages = sdkManager.getPackages().getRemotePackages();
        ArrayList<Change> toReturn = new ArrayList<Change>();
        List<String> requestedPackages = this.myInstallRequestsProvider.get();
        if (requestedPackages != null) {
            Path sdkRoot = this.mySdkHandlerSupplier.get().getLocation();
            for (String path : requestedPackages) {
                RemotePackage p = (RemotePackage)remotePackages.get(path);
                License license = p.getLicense();
                if (license == null) {
                    license = AndroidSdkLicenseTemporaryData.INSTANCE.getLicense(p.getTypeDetails() instanceof DetailsTypes.ApiDetailsType && ((DetailsTypes.ApiDetailsType)p.getTypeDetails()).getAndroidVersion().isPreview());
                }
                this.myLicenses.add(license);
                if (license.checkAccepted(sdkRoot)) continue;
                toReturn.add(new Change(ChangeType.INSTALL, (RepoPackage)p, license));
            }
        }
        return toReturn;
    }

    private void setChanges(List<Change> changes) {
        HashMap licenseNodeMap = Maps.newHashMap();
        this.myVisibleLicenses.clear();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultMutableTreeNode firstChild = null;
        for (Change change : changes) {
            String licenseRef = change.license.getId();
            this.myVisibleLicenses.add(licenseRef);
            if (!licenseNodeMap.containsKey(licenseRef)) {
                DefaultMutableTreeNode n = new DefaultMutableTreeNode(change.license);
                if (firstChild == null) {
                    firstChild = n;
                }
                licenseNodeMap.put(licenseRef, n);
                Boolean accept2 = Boolean.FALSE;
                if (((Boolean)StudioFlags.NPW_ACCEPT_ALL_LICENSES.get()).booleanValue()) {
                    accept2 = Boolean.TRUE;
                }
                this.myAcceptances.put(licenseRef, accept2);
                root.add(n);
            }
            ((DefaultMutableTreeNode)licenseNodeMap.get(licenseRef)).add(new DefaultMutableTreeNode(change));
        }
        this.myTreeModel = new DefaultTreeModel(root);
        this.myChangeTree.setModel((TreeModel)this.myTreeModel);
        this.expandTree();
        if (firstChild != null) {
            this.myChangeTree.setSelectionPath(new TreePath(firstChild.getPath()));
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myChangeTree;
    }

    public void performFinishingActions() {
        Path sdkRoot = this.mySdkHandlerSupplier.get().getLocation();
        for (License license : this.myLicenses) {
            license.setAccepted(sdkRoot);
        }
    }

    public void reload() {
        this.setChanges(this.createChangesList());
    }

    protected static class Change {
        public ChangeType myType;
        public RepoPackage myPackage;
        public License license;

        public Change(@NotNull ChangeType type, @NotNull RepoPackage packageDescription, @NotNull License license) {
            this.myType = type;
            this.myPackage = packageDescription;
            this.license = license;
        }

        public String toString() {
            return this.myPackage.getDisplayName();
        }

        public Icon getIcon() {
            switch (this.myType) {
                case INSTALL: {
                    return AllIcons.Actions.Download;
                }
                case UPDATE: {
                    return AllIcons.Actions.Refresh;
                }
                case REMOVE: {
                    return AllIcons.Actions.Cancel;
                }
            }
            return null;
        }
    }

    protected static enum ChangeType {
        INSTALL,
        UPDATE,
        REMOVE;

    }
}

