/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.serverflags;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.idea.serverflags.ServerFlagValueData;
import com.android.tools.idea.serverflags.protos.Brand;
import com.android.tools.idea.serverflags.protos.FlagValue;
import com.android.tools.idea.serverflags.protos.OSType;
import com.android.tools.idea.serverflags.protos.ServerFlag;
import com.android.tools.idea.serverflags.protos.ServerFlagData;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001aB\u0010\u0000\u001a\u0016\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u0001*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001c\u0010\u000b\u001a\u00020\n*\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a*\u0010\u0010\u001a\u0004\u0018\u00010\u0004*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0012H\u0002\u001a\u0016\u0010\u0013\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0005H\u0002\u001a\u0014\u0010\u0016\u001a\u00020\n*\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0014\u0010\u0017\u001a\u00020\n*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u001bH\u0002\u001a\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0002H\u0002\u001a\n\u0010\u001e\u001a\u00020\u0015*\u00020\u001f\u00a8\u0006 "}, d2={"getOverriddenFlags", "", "", "kotlin.jvm.PlatformType", "Lcom/android/tools/idea/serverflags/ServerFlagValueData;", "", "Lcom/android/tools/idea/serverflags/protos/ServerFlagData;", "overriddenFlags", "", "useMultiValueFlag", "", "isEnabled", "osType", "Lcom/android/tools/idea/serverflags/protos/OSType;", "brand", "Lcom/android/tools/idea/serverflags/protos/Brand;", "getEnabledValue", "hashFunction", "Lkotlin/Function1;", "areAllValuesTheSameType", "flags", "Lcom/android/tools/idea/serverflags/protos/FlagValue;", "isOSEnabled", "isBrandEnabled", "getOsType", "osName", "getBrand", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$IdeBrand;", "hash", "key", "toSingleFlagValue", "Lcom/android/tools/idea/serverflags/protos/ServerFlag;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nServerFlagInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerFlagInitializer.kt\ncom/android/tools/idea/serverflags/ServerFlagInitializerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionsUtils.kt\ncom/android/utils/CollectionsUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n774#2:241\n865#2,2:242\n1611#2,9:245\n1863#2:254\n1864#2:256\n1620#2:257\n1734#2,3:258\n47#3:244\n1#4:255\n*S KotlinDebug\n*F\n+ 1 ServerFlagInitializer.kt\ncom/android/tools/idea/serverflags/ServerFlagInitializerKt\n*L\n103#1:241\n103#1:242,2\n104#1:245,9\n104#1:254\n104#1:256\n104#1:257\n184#1:258,3\n104#1:244\n104#1:255\n*E\n"})
public final class ServerFlagInitializerKt {
    /*
     * WARNING - void declaration
     */
    private static final Map<String, ServerFlagValueData> getOverriddenFlags(List<ServerFlagData> $this$getOverriddenFlags, Map<String, Integer> overriddenFlags, boolean useMultiValueFlag) {
        void $this$mapNotNullTo$iv$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$getOverriddenFlags;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ServerFlagData it = (ServerFlagData)element$iv$iv;
            boolean bl = false;
            if (!overriddenFlags.containsKey(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$associateNotNull = false;
        Iterable $this$mapNotNull$iv$iv = $this$associateNotNull$iv;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$filterTo22 = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            block10: {
                Object element$iv$iv$iv$iv;
                Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Object it$iv = element$iv$iv$iv;
                boolean bl2 = false;
                ServerFlagData it = (ServerFlagData)it$iv;
                boolean bl3 = false;
                if (useMultiValueFlag) {
                    Integer n = overriddenFlags.get(it.getName());
                    Intrinsics.checkNotNull((Object)n);
                    int flagValueIndex = ((Number)n).intValue();
                    if (it.hasMultiValueServerFlag()) {
                        FlagValue flagValue;
                        try {
                            flagValue = (FlagValue)it.getMultiValueServerFlag().getFlagValuesList().get(flagValueIndex);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            Logger.getInstance((String)"ServerFlagInitializer").warn("Index " + flagValueIndex + " is out of bounds for flag " + it.getName());
                            pair = null;
                            break block10;
                        }
                        FlagValue flagValue2 = flagValue;
                        String string = it.getName();
                        Intrinsics.checkNotNull((Object)flagValue2);
                        pair = TuplesKt.to((Object)string, (Object)new ServerFlagValueData(flagValueIndex, flagValue2));
                    } else {
                        Logger.getInstance((String)"ServerFlagInitializer").warn("Expected MultiValueServerFlag to be set for overridden flag " + it.getName());
                        pair = null;
                    }
                } else if (it.hasServerFlag()) {
                    String string = it.getName();
                    ServerFlag serverFlag = it.getServerFlag();
                    Intrinsics.checkNotNullExpressionValue((Object)serverFlag, (String)"getServerFlag(...)");
                    pair = TuplesKt.to((Object)string, (Object)new ServerFlagValueData(0, ServerFlagInitializerKt.toSingleFlagValue(serverFlag)));
                } else {
                    Logger.getInstance((String)"ServerFlagInitializer").warn("Expected ServerFlag to be set for overridden flag " + it.getName());
                    pair = null;
                }
            }
            if (pair == null) continue;
            Pair it$iv$iv$iv = pair;
            boolean bl = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv$iv));
    }

    private static final boolean isEnabled(ServerFlagData $this$isEnabled, OSType osType, Brand brand) {
        return ServerFlagInitializerKt.isOSEnabled($this$isEnabled, osType) && ServerFlagInitializerKt.isBrandEnabled($this$isEnabled, brand);
    }

    private static final ServerFlagValueData getEnabledValue(ServerFlagData $this$getEnabledValue, boolean useMultiValueFlag, Function1<? super String, Integer> hashFunction) {
        String key = AnalyticsSettings.getUserId() + $this$getEnabledValue.getName();
        int hash = ((Number)hashFunction.invoke((Object)key)).intValue();
        if (useMultiValueFlag) {
            if (!$this$getEnabledValue.hasMultiValueServerFlag()) {
                Logger.getInstance((String)"ServerFlagInitializer").warn("Server flag " + $this$getEnabledValue.getName() + " does not have MultiValueServerFlag field set.");
                return null;
            }
            List list = $this$getEnabledValue.getMultiValueServerFlag().getFlagValuesList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFlagValuesList(...)");
            if (!ServerFlagInitializerKt.areAllValuesTheSameType(list)) {
                Logger.getInstance((String)"ServerFlagInitializer").warn("Server flag " + $this$getEnabledValue.getName() + " have flag values of different types.");
                return null;
            }
            int acc = 0;
            List list2 = $this$getEnabledValue.getMultiValueServerFlag().getFlagValuesList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getFlagValuesList(...)");
            for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)list2)) {
                if (acc <= hash && hash < acc + ((FlagValue)indexedValue.getValue()).getPercentEnabled()) {
                    int n = indexedValue.getIndex();
                    Object object = indexedValue.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
                    return new ServerFlagValueData(n, (FlagValue)object);
                }
                acc += ((FlagValue)indexedValue.getValue()).getPercentEnabled();
            }
            return null;
        }
        if (!$this$getEnabledValue.hasServerFlag()) {
            Logger.getInstance((String)"ServerFlagInitializer").warn("Server flag " + $this$getEnabledValue.getName() + " does not have ServerFlag field set.");
            return null;
        }
        if (hash < $this$getEnabledValue.getServerFlag().getPercentEnabled()) {
            ServerFlag serverFlag = $this$getEnabledValue.getServerFlag();
            Intrinsics.checkNotNullExpressionValue((Object)serverFlag, (String)"getServerFlag(...)");
            return new ServerFlagValueData(0, ServerFlagInitializerKt.toSingleFlagValue(serverFlag));
        }
        return null;
    }

    private static final boolean areAllValuesTheSameType(List<FlagValue> flags) {
        boolean bl;
        block4: {
            FlagValue flagValue = (FlagValue)CollectionsKt.firstOrNull(flags);
            if (flagValue == null) {
                return true;
            }
            FlagValue firstValue = flagValue;
            Iterable $this$all$iv = flags;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FlagValue it = (FlagValue)element$iv;
                    boolean bl2 = false;
                    if (it.getValuesCase() == firstValue.getValuesCase()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean isOSEnabled(ServerFlagData $this$isOSEnabled, OSType osType) {
        return $this$isOSEnabled.getServerFlag().getOsTypeCount() == 0 || $this$isOSEnabled.getServerFlag().getOsTypeList().contains(osType);
    }

    private static final boolean isBrandEnabled(ServerFlagData $this$isBrandEnabled, Brand brand) {
        return $this$isBrandEnabled.getServerFlag().getBrandCount() == 0 || $this$isBrandEnabled.getServerFlag().getBrandList().contains(brand);
    }

    private static final OSType getOsType(String osName) {
        if (StringsKt.startsWith$default((String)osName, (String)"freebsd", (boolean)false, (int)2, null)) {
            return OSType.OS_TYPE_FREE_BSD;
        }
        return switch (osName) {
            case "linux" -> OSType.OS_TYPE_LINUX;
            case "chromium" -> OSType.OS_TYPE_CHROMIUM;
            case "windows" -> OSType.OS_TYPE_WIN;
            case "macosx" -> OSType.OS_TYPE_MAC;
            default -> OSType.OS_TYPE_UNKNOWN;
        };
    }

    private static final Brand getBrand(AndroidStudioEvent.IdeBrand brand) {
        return switch (WhenMappings.$EnumSwitchMapping$0[brand.ordinal()]) {
            case 1 -> Brand.BRAND_ANDROID_STUDIO;
            case 2 -> Brand.BRAND_ANDROID_STUDIO_WITH_BLAZE;
            default -> Brand.BRAND_UNKNOWN;
        };
    }

    private static final int hash(String key) {
        HashCode hash = Hashing.farmHashFingerprint64().hashString((CharSequence)key, Charsets.UTF_8);
        return (int)(Math.abs(hash.asLong()) % (long)100);
    }

    @NotNull
    public static final FlagValue toSingleFlagValue(@NotNull ServerFlag $this$toSingleFlagValue) {
        FlagValue.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$toSingleFlagValue, (String)"<this>");
        FlagValue.Builder $this$toSingleFlagValue_u24lambda_u243 = builder = FlagValue.newBuilder();
        boolean bl = false;
        $this$toSingleFlagValue_u24lambda_u243.setPercentEnabled($this$toSingleFlagValue.getPercentEnabled());
        ServerFlag.ValuesCase valuesCase = $this$toSingleFlagValue.getValuesCase();
        switch (valuesCase == null ? -1 : WhenMappings.$EnumSwitchMapping$1[valuesCase.ordinal()]) {
            case 1: {
                $this$toSingleFlagValue_u24lambda_u243.setIntValue($this$toSingleFlagValue.getIntValue());
                break;
            }
            case 2: {
                $this$toSingleFlagValue_u24lambda_u243.setFloatValue($this$toSingleFlagValue.getFloatValue());
                break;
            }
            case 3: {
                $this$toSingleFlagValue_u24lambda_u243.setStringValue($this$toSingleFlagValue.getStringValue());
                break;
            }
            case 4: {
                $this$toSingleFlagValue_u24lambda_u243.setBooleanValue($this$toSingleFlagValue.getBooleanValue());
                break;
            }
            case 5: {
                $this$toSingleFlagValue_u24lambda_u243.setProtoValue($this$toSingleFlagValue.getProtoValue());
                break;
            }
            default: {
                Logger.getInstance($this$toSingleFlagValue_u24lambda_u243.getClass()).warn("Unexpected server flag value type: " + $this$toSingleFlagValue.getValuesCase());
            }
        }
        FlagValue flagValue = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)flagValue, (String)"build(...)");
        return flagValue;
    }

    public static final /* synthetic */ OSType access$getOsType(String osName) {
        return ServerFlagInitializerKt.getOsType(osName);
    }

    public static final /* synthetic */ Brand access$getBrand(AndroidStudioEvent.IdeBrand brand) {
        return ServerFlagInitializerKt.getBrand(brand);
    }

    public static final /* synthetic */ Map access$getOverriddenFlags(List $receiver, Map overriddenFlags, boolean useMultiValueFlag) {
        return ServerFlagInitializerKt.getOverriddenFlags($receiver, overriddenFlags, useMultiValueFlag);
    }

    public static final /* synthetic */ int access$hash(String key) {
        return ServerFlagInitializerKt.hash(key);
    }

    public static final /* synthetic */ boolean access$isEnabled(ServerFlagData $receiver, OSType osType, Brand brand) {
        return ServerFlagInitializerKt.isEnabled($receiver, osType, brand);
    }

    public static final /* synthetic */ ServerFlagValueData access$getEnabledValue(ServerFlagData $receiver, boolean useMultiValueFlag, Function1 hashFunction) {
        return ServerFlagInitializerKt.getEnabledValue($receiver, useMultiValueFlag, (Function1<? super String, Integer>)hashFunction);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AndroidStudioEvent.IdeBrand.values().length];
            try {
                nArray[AndroidStudioEvent.IdeBrand.ANDROID_STUDIO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidStudioEvent.IdeBrand.ANDROID_STUDIO_WITH_BLAZE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ServerFlag.ValuesCase.values().length];
            try {
                nArray[ServerFlag.ValuesCase.INT_VALUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerFlag.ValuesCase.FLOAT_VALUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerFlag.ValuesCase.STRING_VALUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerFlag.ValuesCase.BOOLEAN_VALUE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerFlag.ValuesCase.PROTO_VALUE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

