/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.databaseConnection.jdbc;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.sqlite.databaseConnection.SqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.JdbcUtilsKt;
import com.android.tools.idea.sqlite.model.ResultSetSqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteAffinity;
import com.android.tools.idea.sqlite.model.SqliteColumnValue;
import com.android.tools.idea.sqlite.model.SqliteQueryResult;
import com.android.tools.idea.sqlite.model.SqliteRow;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.model.SqliteValue;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013H&J*\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00130\u001bH\u0004J<\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010\u0006\u001a\u00020\u00072$\u0010\u001a\u001a \u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u000e0\u001dH\u0004J\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001c2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0005J\b\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/jdbc/JdbcSqliteResultSet;", "Lcom/android/tools/idea/sqlite/databaseConnection/SqliteResultSet;", "taskExecutor", "Ljava/util/concurrent/Executor;", "connection", "Ljava/sql/Connection;", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "<init>", "(Ljava/util/concurrent/Executor;Ljava/sql/Connection;Lcom/android/tools/idea/sqlite/model/SqliteStatement;)V", "isDisposed", "", "columns", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "Lcom/android/tools/idea/sqlite/model/ResultSetSqliteColumn;", "getColumns", "()Lcom/google/common/util/concurrent/ListenableFuture;", "totalRowCount", "", "getTotalRowCount", "getRowBatch", "Lcom/android/tools/idea/sqlite/model/SqliteQueryResult;", "rowOffset", "rowBatchSize", "getRowCount", "handleResponse", "Lkotlin/Function1;", "Ljava/sql/ResultSet;", "Lkotlin/Function2;", "Lcom/android/tools/idea/sqlite/model/SqliteRow;", "createCurrentRow", "resultSet", "dispose", "", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nJdbcSqliteResultSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcSqliteResultSet.kt\ncom/android/tools/idea/sqlite/databaseConnection/jdbc/JdbcSqliteResultSet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1567#2:124\n1598#2,4:125\n1557#2:129\n1628#2,3:130\n1#3:133\n*S KotlinDebug\n*F\n+ 1 JdbcSqliteResultSet.kt\ncom/android/tools/idea/sqlite/databaseConnection/jdbc/JdbcSqliteResultSet\n*L\n113#1:124\n113#1:125,4\n50#1:129\n50#1:130,3\n*E\n"})
public abstract class JdbcSqliteResultSet
implements SqliteResultSet {
    @NotNull
    private final Executor taskExecutor;
    @NotNull
    private final Connection connection;
    @NotNull
    private final SqliteStatement sqliteStatement;
    private boolean isDisposed;

    public JdbcSqliteResultSet(@NotNull Executor taskExecutor, @NotNull Connection connection2, @NotNull SqliteStatement sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        this.taskExecutor = taskExecutor;
        this.connection = connection2;
        this.sqliteStatement = sqliteStatement;
    }

    @Override
    @NotNull
    public ListenableFuture<List<ResultSetSqliteColumn>> getColumns() {
        return FutureUtils.cancelOnDispose((ListenableFuture)FutureUtils.executeAsync((Executor)this.taskExecutor, () -> JdbcSqliteResultSet._get_columns_$lambda$3(this)), (Disposable)this);
    }

    @Override
    @NotNull
    public abstract ListenableFuture<Integer> getTotalRowCount();

    @Override
    @NotNull
    public abstract ListenableFuture<SqliteQueryResult> getRowBatch(int var1, int var2);

    @NotNull
    protected final ListenableFuture<Integer> getRowCount(@NotNull SqliteStatement sqliteStatement, @NotNull Function1<? super ResultSet, Integer> handleResponse) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        Intrinsics.checkNotNullParameter(handleResponse, (String)"handleResponse");
        return FutureUtils.cancelOnDispose((ListenableFuture)FutureUtils.executeAsync((Executor)this.taskExecutor, () -> JdbcSqliteResultSet.getRowCount$lambda$8(this, sqliteStatement, handleResponse)), (Disposable)this);
    }

    @NotNull
    protected final ListenableFuture<SqliteQueryResult> getRowBatch(@NotNull SqliteStatement sqliteStatement, @NotNull Function2<? super ResultSet, ? super List<ResultSetSqliteColumn>, ? extends List<SqliteRow>> handleResponse) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        Intrinsics.checkNotNullParameter(handleResponse, (String)"handleResponse");
        return FutureUtils.cancelOnDispose((ListenableFuture)FutureUtils.transform(this.getColumns(), (Executor)this.taskExecutor, arg_0 -> JdbcSqliteResultSet.getRowBatch$lambda$13(this, sqliteStatement, handleResponse, arg_0)), (Disposable)this);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @NotNull
    protected final SqliteRow createCurrentRow(@NotNull ResultSet resultSet, @NotNull List<ResultSetSqliteColumn> columns2) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        Iterable $this$mapIndexed$iv = columns2;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void column2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ResultSetSqliteColumn resultSetSqliteColumn = (ResultSetSqliteColumn)item$iv$iv;
            int n2 = n;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new SqliteColumnValue(column2.getName(), SqliteValue.Companion.fromAny(resultSet.getObject((int)(i + true)))));
        }
        List list = (List)destination$iv$iv;
        return new SqliteRow(list);
    }

    public void dispose() {
        this.isDisposed = true;
    }

    @Override
    @NotNull
    public SqliteStatement toRowCountStatement(@NotNull SqliteStatement $this$toRowCountStatement) {
        return SqliteResultSet.super.toRowCountStatement($this$toRowCountStatement);
    }

    @Override
    @NotNull
    public SqliteStatement toSelectLimitOffset(@NotNull SqliteStatement $this$toSelectLimitOffset, int rowOffset, int rowBatchSize) {
        return SqliteResultSet.super.toSelectLimitOffset($this$toSelectLimitOffset, rowOffset, rowBatchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final List _get_columns_$lambda$3(JdbcSqliteResultSet this$0) {
        List list;
        AutoCloseable autoCloseable = JdbcUtilsKt.resolvePreparedStatement(this$0.connection, this$0.sqliteStatement);
        Throwable throwable = null;
        try {
            List list2;
            PreparedStatement preparedStatement = (PreparedStatement)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = preparedStatement.executeQuery();
            Throwable throwable2 = null;
            try {
                void $this$mapTo$iv$iv;
                ResultSet it = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                ResultSetMetaData metaData = it.getMetaData();
                Iterable $this$map$iv = (Iterable)new IntRange(1, metaData.getColumnCount());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void i;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    String tableName = metaData.getTableName((int)i);
                    String columnName = metaData.getColumnName((int)i);
                    Connection connection2 = this$0.connection;
                    Intrinsics.checkNotNull((Object)tableName);
                    List<String> keyColumnsNames = JdbcUtilsKt.getColumnNamesInPrimaryKey(connection2, tableName);
                    String string = metaData.getColumnName((int)i);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getColumnName(...)");
                    JDBCType jDBCType = JDBCType.valueOf(metaData.getColumnType((int)i));
                    Intrinsics.checkNotNullExpressionValue((Object)jDBCType, (String)"valueOf(...)");
                    collection2.add(new ResultSetSqliteColumn(string, SqliteAffinity.Companion.fromJDBCType(jDBCType), metaData.isNullable((int)i) == 1, keyColumnsNames.contains(columnName)));
                }
                list2 = (List)destination$iv$iv;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            list = list2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int getRowCount$lambda$8(JdbcSqliteResultSet this$0, SqliteStatement $sqliteStatement, Function1 $handleResponse) {
        int n;
        if (!(!this$0.isDisposed)) {
            boolean $i$a$-check-JdbcSqliteResultSet$getRowCount$1$32 = false;
            String $i$a$-check-JdbcSqliteResultSet$getRowCount$1$32 = "ResultSet has already been closed.";
            throw new IllegalStateException($i$a$-check-JdbcSqliteResultSet$getRowCount$1$32.toString());
        }
        if (!(!this$0.connection.isClosed())) {
            boolean bl = false;
            String string = "The connection has been closed.";
            throw new IllegalStateException(string.toString());
        }
        AutoCloseable autoCloseable = JdbcUtilsKt.resolvePreparedStatement(this$0.connection, $sqliteStatement);
        Throwable throwable = null;
        try {
            int n2;
            PreparedStatement preparedStatement = (PreparedStatement)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = preparedStatement.executeQuery();
            Throwable throwable2 = null;
            try {
                ResultSet it = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                n2 = ((Number)$handleResponse.invoke((Object)it)).intValue();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            n = n2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SqliteQueryResult getRowBatch$lambda$13(JdbcSqliteResultSet this$0, SqliteStatement $sqliteStatement, Function2 $handleResponse, List columns2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)columns2, (String)"columns");
        if (!(!this$0.isDisposed)) {
            boolean $i$a$-check-JdbcSqliteResultSet$getRowBatch$1$32 = false;
            String $i$a$-check-JdbcSqliteResultSet$getRowBatch$1$32 = "ResultSet has already been closed.";
            throw new IllegalStateException($i$a$-check-JdbcSqliteResultSet$getRowBatch$1$32.toString());
        }
        if (!(!this$0.connection.isClosed())) {
            boolean bl = false;
            String string = "The connection has been closed.";
            throw new IllegalStateException(string.toString());
        }
        AutoCloseable autoCloseable = JdbcUtilsKt.resolvePreparedStatement(this$0.connection, $sqliteStatement);
        Throwable throwable = null;
        try {
            List list2;
            PreparedStatement preparedStatement = (PreparedStatement)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = preparedStatement.executeQuery();
            Throwable throwable2 = null;
            try {
                ResultSet it = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                list2 = (List)$handleResponse.invoke((Object)it, (Object)columns2);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            list = list2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        List rows = list;
        return new SqliteQueryResult(rows, false, 2, null);
    }
}

