/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.ui.exportToFile;

import com.android.tools.idea.io.IdeFileUtils;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J\n\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/sqlite/ui/exportToFile/IOUtils;", "", "<init>", "()V", "pathFromText", "Ljava/nio/file/Path;", "text", "", "isValidDestinationFilePath", "", "path", "endsWithSeparatorChar", "resolveHomeDir", "getHomeDir", "getDefaultBaseDir", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nExportToFileDialogViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportToFileDialogViewImpl.kt\ncom/android/tools/idea/sqlite/ui/exportToFile/IOUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,456:1\n1797#2,3:457\n*S KotlinDebug\n*F\n+ 1 ExportToFileDialogViewImpl.kt\ncom/android/tools/idea/sqlite/ui/exportToFile/IOUtils\n*L\n449#1:457,3\n*E\n"})
final class IOUtils {
    @NotNull
    public static final IOUtils INSTANCE = new IOUtils();

    private IOUtils() {
    }

    @Nullable
    public final Path pathFromText(@NotNull String text2) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (StringsKt.isBlank((CharSequence)text2)) {
            return null;
        }
        try {
            Path rawPath = Paths.get(text2, new String[0]);
            Intrinsics.checkNotNull((Object)rawPath);
            path = this.resolveHomeDir(rawPath);
        }
        catch (Exception ignored) {
            path = null;
        }
        return path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValidDestinationFilePath(@Nullable Path path) {
        if (path == null) return false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        if (path.getParent() == null) return false;
        Path path2 = path.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
        Path path3 = path2;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isDirectory(path3, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) return false;
        Path path4 = path.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"getParent(...)");
        path3 = path4;
        linkOptionArray2 = new LinkOption[]{};
        if (!Files.exists(path3, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) return false;
        return true;
    }

    public final boolean endsWithSeparatorChar(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.endsWith$default((CharSequence)((Object)StringsKt.trimEnd((CharSequence)path)).toString(), (char)File.separatorChar, (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Path resolveHomeDir(Path path) {
        void $this$fold$iv;
        List dirs = CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)path, IOUtils::resolveHomeDir$lambda$0)));
        Path path2 = (Path)CollectionsKt.firstOrNull((List)dirs);
        if (!Intrinsics.areEqual((Object)(path2 != null ? ((Object)path2).toString() : null), (Object)"~")) {
            return path;
        }
        Path path3 = this.getHomeDir();
        if (path3 == null) {
            return path;
        }
        Path homeDir = path3;
        Iterable iterable = CollectionsKt.drop((Iterable)dirs, (int)1);
        Path initial$iv = homeDir;
        boolean $i$f$fold = false;
        Path accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void next;
            Path path4 = (Path)element$iv;
            Path acc = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)acc.resolve(next.getFileName()), (String)"resolve(...)");
        }
        return accumulator$iv;
    }

    private final Path getHomeDir() {
        VirtualFile virtualFile = VfsUtil.getUserHomeDir();
        return virtualFile != null ? virtualFile.toNioPath() : null;
    }

    @Nullable
    public final Path getDefaultBaseDir() {
        Path path = IdeFileUtils.getDesktopDirectory();
        if (path == null) {
            path = this.getHomeDir();
        }
        return path;
    }

    private static final Path resolveHomeDir$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }
}

